/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.util.Name;

public class SymbolTest
extends NextGenTestCase {
    public SymbolTest(String name) {
        super(name);
    }

    public void testTypeSymbolToString() {
        Symbol.TypeSymbol test = new Symbol.TypeSymbol(0, Name.fromString("test"), null, null);
        SymbolTest.assertEquals((String)"Symbol.TypeSymbol is not printed properly.", (String)"type variable test", (String)test.toString());
    }

    public void testTypeSymbolMembers() {
        Symbol.TypeSymbol test = new Symbol.TypeSymbol(0, null, null, null);
        SymbolTest.assertEquals((String)"Symbol.TypeSymbol members() call should return null.", null, (Object)test.members());
    }

    public void testTypeSymbolRank() {
        Symbol.TypeSymbol test = new Symbol.TypeSymbol(0, null, null, null);
        try {
            test.rank();
            SymbolTest.fail((String)"rank() on TypeSymbols should throw an InternalError.");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    public void testTypeSymbolPrecedes() {
        Symbol.TypeSymbol test = new Symbol.TypeSymbol(0, null, null, null);
        try {
            test.precedes(test);
            SymbolTest.fail((String)"precedes() on TypeSymbols should throw an InternalError.");
        }
        catch (InternalError internalError) {
            // empty catch block
        }
    }

    public void testTypeSymbolExists() {
        Symbol.TypeSymbol test = new Symbol.TypeSymbol(0, null, null, null);
        SymbolTest.assertTrue((String)"exists() should return true for all TypeSymbols", (boolean)test.exists());
    }

    public void testPackageSymbolToString() {
        Symbol.PackageSymbol test = new Symbol.PackageSymbol(Name.fromString("test"), null, null);
        SymbolTest.assertEquals((String)"Symbol.PackageSymbol is not printed properly.", (String)"package test", (String)test.toString());
    }

    public void testPackageSymbolFullName() {
        Symbol.PackageSymbol owner = new Symbol.PackageSymbol(Name.fromString("owner"), null, null);
        Symbol.PackageSymbol test = new Symbol.PackageSymbol(Name.fromString("test"), null, owner);
        SymbolTest.assertEquals((String)"Symbol.PackageSymbol fullName() does not return correct value.", (String)"owner.test", (String)test.fullName().toString());
    }

    public void testPackageSymbolMembers() {
        Symbol.PackageSymbol test = new Symbol.PackageSymbol(Name.fromString("test"), null, null);
        SymbolTest.assertEquals((String)"Symbol.PackageSymbol members() should be initialized to null.", null, (Object)test.members());
    }

    public void testPackageSymbolFlags() {
        Symbol.PackageSymbol test = new Symbol.PackageSymbol(null, null, null);
        SymbolTest.assertEquals((String)"Symbol.PackageSymbol flags() should return 0", (int)0, (int)test.flags());
    }

    public void testPackageSymbolExists() {
        Symbol.PackageSymbol test = new Symbol.PackageSymbol(null, null, null);
        test.members_field = new Scope(test);
        SymbolTest.assertFalse((String)"PackageSymbol exists() should return true iff the corresponding package exists", (boolean)test.exists());
    }

    public void testClassSymbolMembersField() {
        SymbolTest.assertEquals((String)"A ClassSymbol's members_field should be initialized to null.", null, (Object)SymbolTest.CLASS_SYMBOL.members_field);
    }
}

