/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.UnboundTypeVarException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type
implements Flags,
Kinds,
TypeTags {
    public static boolean moreInfo = false;
    public static final String COMMA = "$$C";
    public static final String RIGHT_PAREN = "$$R";
    public static final String right_PAREN = "$$r";
    public static final String LEFT_PAREN = "$$L";
    public static final String left_PAREN = "$$l";
    public static final String DOT = "$$D";
    public static final String ARRAY_PRE = "$$A";
    public static final String SEMICOLON = "$$S";
    public static final String LEFT_BRACK = "{";
    public static final String RIGHT_BRACK = "}";
    public static final String BASE = "B";
    public static final String SNIP_ENV = "$$ENV";
    public static final char LEFT_BRACK_CHAR = '<';
    public static final char RIGHT_BRACK_CHAR = '>';
    public int tag;
    public Symbol.TypeSymbol typeSymbol;
    public Object constantValue = null;
    public static final List<Type> EMPTY_LIST = new Empty<Type>();
    public static final Type[] TYPES_OF_TAGS = new Type[19];
    public static final Name[] BOXED_NAME = new Name[19];
    public static final Type NO_TYPE = new Type(17, null);
    public static final Type BYTE_TYPE = new Type(1, null);
    public static final Type CHAR_TYPE = new Type(2, null);
    public static final Type SHORT_TYPE = new Type(3, null);
    public static final Type INT_TYPE = new Type(4, null);
    public static final Type LONG_TYPE = new Type(5, null);
    public static final Type FLOAT_TYPE = new Type(6, null);
    public static final Type DOUBLE_TYPE = new Type(7, null);
    public static final Type BOOLEAN_TYPE = new Type(8, null);
    public static final Type VOID_TYPE = new Type(9, null);
    public static final Type ALL_TYPE = new Type(16, null);
    public static final Type ERROR_TYPE = new ErrorType(null);
    public static int count = 0;

    public Type(int tag, Symbol.TypeSymbol tsym) {
        this.tag = tag;
        this.typeSymbol = tsym;
    }

    public boolean equals(Object o) {
        return o != null && this.getClass() == o.getClass() && this.tag == ((Type)o).tag && this.typeSymbol.equals(((Type)o).typeSymbol);
    }

    public Type constType(Object constValue) {
        Asserter._assert(this.tag <= 8);
        Type t = new Type(this.tag, this.typeSymbol);
        t.constantValue = constValue;
        return t;
    }

    public List<Type> getTypeParams() {
        return EMPTY_LIST;
    }

    public Type enclosingType() {
        return null;
    }

    public Type elementType() {
        return null;
    }

    public List<Type> argTypes() {
        return EMPTY_LIST;
    }

    public Type returnType() {
        return null;
    }

    public List<Symbol.ClassSymbol> thrown() {
        return Symbol.ClassSymbol.EMPTY_LIST;
    }

    public Type bound() {
        return null;
    }

    public Symbol symbol() {
        return this.typeSymbol;
    }

    public Name name() {
        return this.typeSymbol.name;
    }

    public String toMethodString() {
        return Type.elimBrack(Type.dotToDOT(this.toString()));
    }

    public String toString() {
        String s;
        String string = s = this.typeSymbol == null || this.typeSymbol.name == null ? "null" : this.typeSymbol.name.toString();
        if (moreInfo && this.tag == 14) {
            s = new StringBuffer().append(s).append(this.hashCode()).toString();
        }
        return s;
    }

    public String mangledName() {
        Name fn = this.typeSymbol.fullName();
        return Type.dotToDOT(fn);
    }

    private static String dotToDOT(Name n) {
        return Type.dotToDOT(n.toString());
    }

    private static String dotToDOT(String s) {
        StringBuffer newS = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '.') {
                newS.append(DOT);
                continue;
            }
            newS.append(c);
        }
        return newS.toString();
    }

    public static String elimBrack(String s) {
        StringBuffer newS = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '[') {
                newS.append("$array");
                continue;
            }
            if (c == '<' || c == '>' || c == ']') {
                newS.append('$');
                continue;
            }
            newS.append(c);
        }
        return newS.toString();
    }

    public Tree.Ident toIdent(int pos) {
        return new Tree.Ident(pos, this, this.name(), this.symbol());
    }

    public Tree.Ident toIdent() {
        return this.toIdent(0);
    }

    public boolean isClassType() {
        return this.tag == 10;
    }

    public boolean isArrayType() {
        return this.tag == 11;
    }

    public final boolean isTypeVar() {
        return this.tag == 14;
    }

    public final boolean isErrorType() {
        return this.tag == 18;
    }

    public final boolean isInterface() {
        return this.typeSymbol.isInterface();
    }

    public final boolean isFinal() {
        return this.typeSymbol.isFinal();
    }

    public final boolean isAbstract() {
        return this.typeSymbol.isAbstract();
    }

    public boolean isForAll() {
        return this.tag == 15;
    }

    public Type getSuperType() {
        return null;
    }

    public List<Type> getInterfaces() {
        return EMPTY_LIST;
    }

    public List<Type> allParams() {
        return EMPTY_LIST;
    }

    public Type asSuper(Symbol sym) {
        return null;
    }

    public Type asOuterSuper(Symbol sym) {
        return null;
    }

    public Type asSub(Symbol sym) {
        return null;
    }

    public Type memberType(Symbol sym) {
        return sym.type;
    }

    public Type substitute(List<Type> from, List<Type> to) {
        return this;
    }

    public static List<Type> substitute(List<Type> these, List<Type> from, List<Type> to) {
        if (these.nonEmpty()) {
            Type head1 = these.getFirst().substitute(from, to);
            List<Type> tail1 = Type.substitute(these.getRest(), from, to);
            if (head1 != these.getFirst() || tail1 != these.getRest()) {
                return tail1.cons(head1);
            }
        }
        return these;
    }

    public boolean isErroneous() {
        return false;
    }

    public static boolean isErroneous(List<Type> ts) {
        ListBox<Type> l = new ListBox<Type>(ts);
        while (l.nonEmpty()) {
            if (l.getFirst().isErroneous()) {
                return true;
            }
            l.remove();
        }
        return false;
    }

    public boolean isRaw() {
        return false;
    }

    public boolean isParameterized() {
        return false;
    }

    public boolean isFlattenedParameterized() {
        return false;
    }

    public boolean isGround() {
        return Type.isGround(this.allParams());
    }

    public static boolean isGround(List<Type> these) {
        return these.isEmpty() || these.getFirst().isGround() && Type.isGround(these.getRest());
    }

    public Type erasure() {
        return this;
    }

    public static List<Type> erasure(List<Type> these) {
        if (these.nonEmpty()) {
            List<Type> tail1 = Type.erasure(these.getRest());
            Type head1 = these.getFirst().erasure();
            if (tail1 != these.getRest() || head1 != these.getFirst()) {
                return tail1.cons(head1);
            }
        }
        return these;
    }

    public Type flatten() {
        return this.flatten(Name.EMPTY_LIST);
    }

    public Type flatten(List<Name> boundTypeNames) {
        return this;
    }

    public static List<Type> flatten(List<Type> these, List<Name> boundTypeNames) {
        if (these.nonEmpty()) {
            List<Type> tail1 = Type.flatten(these.getRest(), boundTypeNames);
            Type head1 = these.getFirst().flatten(boundTypeNames);
            if (tail1 != these.getRest() || head1 != these.getFirst()) {
                return tail1.cons(head1);
            }
        }
        return these;
    }

    protected Symbol getInterfaceOwner() {
        return this.typeSymbol.owner;
    }

    public Type genInterface(List<Name> boundTypeNames, Type objectType) {
        Name flatName = this.flatten(boundTypeNames).typeSymbol.name;
        Name interfaceName = Name.fromString(new StringBuffer().append(flatName.toString()).append("$").toString());
        Symbol.ClassSymbol iSym = new Symbol.ClassSymbol(this.typeSymbol.flags() | 0x200, interfaceName, null, this.getInterfaceOwner());
        List<Type> interfaces = this.getInterfaces();
        if (interfaces == null) {
            interfaces = EMPTY_LIST;
        }
        List<Type> flatInterfaces = Type.flatten(interfaces, boundTypeNames);
        ClassType iSupertype = (ClassType)this.getSuperType();
        if (iSupertype.isParameterized()) {
            flatInterfaces = flatInterfaces.cons(iSupertype.genInterface(boundTypeNames, objectType));
        }
        ClassType iType = new ClassType(NO_TYPE, EMPTY_LIST, iSym, objectType, flatInterfaces);
        iSym.type = iType;
        return iType;
    }

    public int occurrencesCount(Type elem) {
        if (elem == this) {
            return 1;
        }
        if (this.tag == 10 && this.isParameterized()) {
            return this.enclosingType().occurrencesCount(elem) + Type.occurrencesCount(this.getTypeParams(), elem);
        }
        if (this.tag == 11) {
            return this.elementType().occurrencesCount(elem);
        }
        return 0;
    }

    public static int occurrencesCount(List<Type> these, Type elem) {
        int count = 0;
        ListBox<Type> l = new ListBox<Type>(these);
        while (l.nonEmpty()) {
            count += l.getFirst().occurrencesCount(elem);
            l.remove();
        }
        return count;
    }

    public boolean isSameType(Type that) {
        if (this == that || that.tag == 18) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 16: 
            case 17: {
                return this.tag == that.tag;
            }
            case 14: {
                return false;
            }
        }
        throw new InternalError();
    }

    public static boolean sameTypes(List<Type> these, List<Type> those) {
        while (these.nonEmpty() && those.nonEmpty() && these.getFirst().isSameType(those.getFirst())) {
            these = these.getRest();
            those = those.getRest();
        }
        return these.isEmpty() && those.isEmpty();
    }

    public boolean genType(Type that) {
        return this.isSameType(that) || this.tag == 16 && this.isSubType(that);
    }

    public static boolean genTypes(List<Type> these, List<Type> those) {
        while (these.nonEmpty() && those.nonEmpty() && these.getFirst().genType(those.getFirst())) {
            these = these.getRest();
            those = those.getRest();
        }
        return these.isEmpty() && those.isEmpty();
    }

    public boolean isSubType(Type that) {
        if (this == that || that.tag == 18) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: {
                return this.tag == that.tag || this.tag + 2 <= that.tag && that.tag <= 7;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return this.tag <= that.tag && that.tag <= 7;
            }
            case 8: 
            case 9: {
                return this.tag == that.tag;
            }
            case 14: {
                return this.bound().isSubType(that);
            }
            case 16: {
                return that.tag == 16 || that.tag == 10 || that.tag == 11 || that.tag == 14;
            }
        }
        throw new InternalError(new StringBuffer().append("subType ").append(this.tag).toString());
    }

    public static boolean subTypes(List<Type> these, List<Type> those) {
        while (these.nonEmpty() && those.nonEmpty() && these.getFirst().isSubType(those.getFirst())) {
            these = these.getRest();
            those = those.getRest();
        }
        return these.isEmpty() && those.isEmpty();
    }

    public boolean isCoerceableTo(Type that) {
        if (this.tag <= 4 && this.constantValue != null) {
            int value = ((Number)this.constantValue).intValue();
            switch (that.tag) {
                case 1: {
                    if (-128 > value || value > 127) break;
                    return true;
                }
                case 2: {
                    if (0 > value || value > 65535) break;
                    return true;
                }
                case 3: {
                    if (Short.MIN_VALUE > value || value > Short.MAX_VALUE) break;
                    return true;
                }
                case 4: {
                    return true;
                }
            }
        }
        return this.isSubType(that);
    }

    public boolean erasedIsCastableTo(Type that) {
        if (that.isErrorType()) {
            return true;
        }
        switch (this.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return that.tag <= 7;
            }
            case 8: {
                return that.tag == 8;
            }
            case 9: {
                return false;
            }
            case 14: {
                return this.bound().erasedIsCastableTo(that);
            }
            case 16: {
                return true;
            }
        }
        throw new InternalError(new StringBuffer().append("castableTo(Type that) invoked on class ").append(this.getClass()).toString());
    }

    public boolean isCastableTo(Type that) {
        return this.erasedIsCastableTo(that);
    }

    public MethodType methodType() {
        throw new InternalError(new StringBuffer().append("methodType() invoked on class ").append(this.getClass()).toString());
    }

    public boolean sameArgs(Type that) {
        throw new InternalError(new StringBuffer().append("sameArgs(Type that) invoked on class ").append(this.getClass()).toString());
    }

    public void loadReferencedClasses() {
    }

    static void initType(Type type, String name) {
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(1, Name.fromString(name), type, Symbol.EMPTY_PACKAGE_SYMBOL);
        type.typeSymbol = c;
        Type.TYPES_OF_TAGS[type.tag] = type;
    }

    static void initType(Type type, String name, String bname) {
        Type.initType(type, name);
        Type.BOXED_NAME[type.tag] = Name.fromString(new StringBuffer().append("java.lang.").append(bname).toString());
    }

    static void init() {
        Type.initType(BYTE_TYPE, "byte", "Byte");
        Type.initType(SHORT_TYPE, "short", "Short");
        Type.initType(CHAR_TYPE, "char", "Character");
        Type.initType(INT_TYPE, "int", "Integer");
        Type.initType(LONG_TYPE, "long", "Long");
        Type.initType(FLOAT_TYPE, "float", "Float");
        Type.initType(DOUBLE_TYPE, "double", "Double");
        Type.initType(BOOLEAN_TYPE, "boolean", "Boolean");
        Type.initType(VOID_TYPE, "void", "Void");
        Type.initType(ALL_TYPE, "<null>");
        Type.ERROR_TYPE.typeSymbol = Symbol.ERROR_SYMBOL;
    }

    public static class ErrorType
    extends Type {
        public ErrorType(Symbol.TypeSymbol tsym) {
            super(18, tsym);
        }

        public Type constType(Object constValue) {
            return this;
        }

        public Type enclosingType() {
            return this;
        }

        public Type elementType() {
            return this;
        }

        public Type returnType() {
            return this;
        }

        public Type bound() {
            return this;
        }

        public Type asSuper(Symbol sym) {
            return this;
        }

        public Type asOuterSuper(Symbol sym) {
            return this;
        }

        public Type asSub(Symbol sym) {
            return this;
        }

        public Type memberType(Symbol sym) {
            return this;
        }

        public boolean isErroneous() {
            return true;
        }

        public boolean isSameType(Type that) {
            return true;
        }

        public boolean isSubType(Type that) {
            return true;
        }

        public boolean erasedIsCastableTo(Type that) {
            return true;
        }

        public boolean sameArgs(Type that) {
            return false;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForAll
    extends Type {
        public List<Type> typeParams;
        public MethodType quantifiedType;

        public ForAll(List<Type> tvars, MethodType qtype) {
            super(15, qtype.typeSymbol);
            this.typeParams = tvars;
            this.quantifiedType = qtype;
        }

        @Override
        public String toString() {
            return this.quantifiedType.toString();
        }

        @Override
        public List<Type> getTypeParams() {
            return this.typeParams;
        }

        @Override
        public Type enclosingType() {
            return this.quantifiedType.enclosingType();
        }

        @Override
        public Type elementType() {
            return this.quantifiedType.elementType();
        }

        @Override
        public List<Type> argTypes() {
            return this.quantifiedType.argTypes();
        }

        @Override
        public Type returnType() {
            return this.quantifiedType.returnType();
        }

        @Override
        public List<Symbol.ClassSymbol> thrown() {
            return this.quantifiedType.thrown();
        }

        @Override
        public Type getSuperType() {
            return this.quantifiedType.getSuperType();
        }

        @Override
        public List<Type> getInterfaces() {
            return this.quantifiedType.getInterfaces();
        }

        @Override
        public List<Type> allParams() {
            return this.quantifiedType.allParams();
        }

        @Override
        public Type bound() {
            return this.quantifiedType.bound();
        }

        @Override
        public Type substitute(List<Type> from, List<Type> to) {
            MethodType qtype1 = (MethodType)this.quantifiedType.substitute(from, to);
            if (qtype1 == this.quantifiedType) {
                return this;
            }
            return new ForAll(this.typeParams, qtype1);
        }

        @Override
        public boolean isErroneous() {
            return ForAll.isErroneous(this.typeParams) || this.quantifiedType.isErroneous();
        }

        @Override
        public Type erasure() {
            return this.quantifiedType.erasure();
        }

        @Override
        public Type flatten() {
            throw new InternalError(new StringBuffer().append("Attempt to flatten quantified type ").append(this).toString());
        }

        @Override
        public MethodType methodType() {
            return this.quantifiedType.methodType();
        }

        @Override
        public boolean sameArgs(Type that) {
            return that.tag == 15 && this.quantifiedType.sameArgs(((ForAll)that).quantifiedType.substitute(((ForAll)that).typeParams, this.typeParams));
        }

        @Override
        public void loadReferencedClasses() {
            List<Type> l = this.typeParams;
            while (l.nonEmpty()) {
                l.getFirst().bound().loadReferencedClasses();
                l = l.getRest();
            }
            this.quantifiedType.loadReferencedClasses();
        }

        public ClassType genSnippetEnv(Symbol.MethodSymbol methodSymbol, Type objectType) {
            Symbol.ClassSymbol methodOwner = (Symbol.ClassSymbol)methodSymbol.owner;
            Symbol newClassOwner = methodOwner.owner;
            Name newClassName = Name.fromString(new StringBuffer().append(methodSymbol.name.toString()).append(Type.left_PAREN).append(this.quantifiedType.paramTypes.toString(Type.COMMA)).append(Type.right_PAREN).append(Type.SNIP_ENV).toString());
            int flags = 65537;
            if (newClassOwner instanceof Symbol.ClassSymbol) {
                flags |= 8;
            }
            Symbol.ClassSymbol newClassSymbol = new Symbol.ClassSymbol(flags, newClassName, null, newClassOwner);
            ClassType newClassType = new ClassType(methodOwner.type.enclosingType(), this.typeParams, newClassSymbol, objectType, EMPTY_LIST);
            newClassSymbol.type = newClassType;
            return newClassType;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeVar
    extends Type {
        public Type bound;

        public TypeVar(Type bound, Symbol.TypeSymbol tsym) {
            super(14, tsym);
            this.bound = bound;
        }

        public TypeVar(Type bound, Name name, Symbol owner) {
            this(bound, null);
            this.typeSymbol = new Symbol.TypeSymbol(0, name, this, owner);
        }

        @Override
        public Type bound() {
            return this.bound;
        }

        @Override
        public Type getSuperType() {
            if ((this.bound.typeSymbol.flags() & 0x200) == 0) {
                return this.bound;
            }
            return null;
        }

        public Type interfaceBound() {
            if ((this.bound.typeSymbol.flags() & 0x200) != 0) {
                return this.bound;
            }
            return null;
        }

        @Override
        public List<Type> getInterfaces() {
            if ((this.bound.typeSymbol.flags() & 0x200) != 0) {
                return EMPTY_LIST.cons(this.bound);
            }
            return null;
        }

        public Tree.TypeParameter toTypeParameter() {
            return new Tree.TypeParameter(0, this, this.name(), this.getSuperType().toIdent(), this.interfaceBound().toIdent());
        }

        @Override
        public Type asSuper(Symbol sym) {
            return this.bound.asSuper(sym);
        }

        @Override
        public Type asOuterSuper(Symbol sym) {
            return this.bound.asOuterSuper(sym);
        }

        @Override
        public Type asSub(Symbol sym) {
            return this.bound.asSub(sym);
        }

        @Override
        public Type memberType(Symbol sym) {
            return this.bound.memberType(sym);
        }

        @Override
        public Type substitute(List<Type> from, List<Type> to) {
            while (from.nonEmpty() && to.nonEmpty()) {
                if (this == from.getFirst()) {
                    return to.getFirst();
                }
                from = from.getRest();
                to = to.getRest();
            }
            return this;
        }

        @Override
        public boolean isErroneous() {
            return this.bound != null && this.bound.isErroneous();
        }

        @Override
        public boolean isGround() {
            return false;
        }

        @Override
        public Type erasure() {
            return this.bound.erasure();
        }

        @Override
        public Type flatten(List<Name> boundTypeNames) {
            return this.flattenTypeVar(boundTypeNames, Type.LEFT_BRACK, Type.RIGHT_BRACK);
        }

        public Type flattenTypeVar(List<Name> boundTypeNames, String prefix, String suffix) {
            int i = boundTypeNames.index(this.typeSymbol.name);
            if (i < 0) {
                throw new UnboundTypeVarException(this, "Unbound type variable");
            }
            Symbol.ClassSymbol csym = new Symbol.ClassSymbol(this.typeSymbol.flags(), Name.fromString(new StringBuffer().append(prefix).append(i).append(suffix).toString()), null, Symbol.EMPTY_PACKAGE_SYMBOL);
            ClassType ctype = new ClassType(NO_TYPE, EMPTY_LIST, csym, this.getSuperType(), EMPTY_LIST);
            csym.type = ctype;
            return ctype;
        }

        @Override
        protected Symbol getInterfaceOwner() {
            return Symbol.EMPTY_PACKAGE_SYMBOL;
        }

        public Type genBaseType(List<Name> boundTypeNames) {
            return this.flattenTypeVar(boundTypeNames, Type.LEFT_BRACK, "}B");
        }
    }

    public static class PackageType
    extends Type {
        public PackageType(Symbol.TypeSymbol tsym) {
            super(13, tsym);
        }

        public String toString() {
            return this.typeSymbol.fullName().toString();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodType
    extends Type {
        public List<Type> paramTypes;
        public Type returnType;
        public List<Symbol.ClassSymbol> thrown;
        private static Symbol.ClassSymbol methodClass = new Symbol.ClassSymbol(1, Name.fromString("Method"), Symbol.NO_SYMBOL);

        public MethodType(List<Type> argtypes, Type restype, List<Symbol.ClassSymbol> thrown) {
            super(12, methodClass);
            this.paramTypes = argtypes;
            this.returnType = restype;
            this.thrown = thrown;
        }

        @Override
        public String toString() {
            return new StringBuffer().append(this.paramTypes.toString()).append("->").append(this.returnType).toString();
        }

        @Override
        public List<Type> argTypes() {
            return this.paramTypes;
        }

        @Override
        public Type returnType() {
            return this.returnType;
        }

        @Override
        public List<Symbol.ClassSymbol> thrown() {
            return this.thrown;
        }

        @Override
        public Type substitute(List<Type> from, List<Type> to) {
            List<Type> argtypes1 = MethodType.substitute(this.paramTypes, from, to);
            Type restype1 = this.returnType.substitute(from, to);
            if (argtypes1 == this.paramTypes && restype1 == this.returnType) {
                return this;
            }
            return new MethodType(argtypes1, restype1, this.thrown);
        }

        @Override
        public boolean isErroneous() {
            return MethodType.isErroneous(this.paramTypes) || this.returnType.isErroneous();
        }

        @Override
        public Type erasure() {
            List<Type> argtypes1 = MethodType.erasure(this.paramTypes);
            Type restype1 = this.returnType.erasure();
            if (argtypes1 == this.paramTypes && restype1 == this.returnType) {
                return this;
            }
            return new MethodType(argtypes1, restype1, this.thrown);
        }

        @Override
        public Type flatten(List<Name> boundTypeNames) {
            throw new InternalError(new StringBuffer().append("Attempt to flatten method type ").append(this).toString());
        }

        @Override
        public MethodType methodType() {
            return this;
        }

        @Override
        public boolean sameArgs(Type that) {
            return that.tag == 12 && MethodType.sameTypes(this.paramTypes, that.argTypes());
        }

        @Override
        public boolean isSameType(Type that) {
            return this.sameArgs(that) && this.returnType.isSameType(that.returnType());
        }

        @Override
        public void loadReferencedClasses() {
            List<Flags> l = this.paramTypes;
            while (l.nonEmpty()) {
                l.getFirst().loadReferencedClasses();
                l = l.getRest();
            }
            this.returnType.loadReferencedClasses();
            l = this.thrown;
            while (l.nonEmpty()) {
                ((Symbol.ClassSymbol)l.getFirst()).complete();
                l = l.getRest();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayType
    extends Type {
        public final Type elementType;
        public static Symbol.ClassSymbol arrayClass = new Symbol.ClassSymbol(1, Name.fromString("Array"), Symbol.NO_SYMBOL);

        public ArrayType(Type elemtype) {
            super(11, arrayClass);
            this.elementType = elemtype;
        }

        @Override
        public String toString() {
            return new StringBuffer().append(this.elementType).append("[]").toString();
        }

        @Override
        public String mangledName() {
            StringBuffer buf = new StringBuffer(Type.ARRAY_PRE);
            switch (this.elementType.tag) {
                case 1: {
                    buf.append(Type.BASE);
                    break;
                }
                case 2: {
                    buf.append("C");
                    break;
                }
                case 3: {
                    buf.append("S");
                    break;
                }
                case 4: {
                    buf.append("I");
                    break;
                }
                case 5: {
                    buf.append("J");
                    break;
                }
                case 6: {
                    buf.append("F");
                    break;
                }
                case 7: {
                    buf.append("D");
                    break;
                }
                case 8: {
                    buf.append("Z");
                    break;
                }
                case 10: {
                    buf.append("L");
                    buf.append(this.elementType.mangledName());
                    buf.append(Type.SEMICOLON);
                    break;
                }
                case 11: {
                    buf.append(this.elementType.mangledName());
                    break;
                }
                default: {
                    throw new InternalError(new StringBuffer().append("Attempt to get mangled name of illegal Array type ").append(this).toString());
                }
            }
            return buf.toString();
        }

        @Override
        public Type elementType() {
            return this.elementType;
        }

        @Override
        public List<Type> allParams() {
            if (this.elementType instanceof TypeVar) {
                return new Cons<Type>(this.elementType);
            }
            return this.elementType.allParams();
        }

        @Override
        public Type substitute(List<Type> from, List<Type> to) {
            Type elemtype1 = this.elementType.substitute(from, to);
            if (elemtype1 == this.elementType) {
                return this;
            }
            return new ArrayType(elemtype1);
        }

        @Override
        public boolean isErroneous() {
            return this.elementType.isErroneous();
        }

        @Override
        public boolean isRaw() {
            return this.elementType.isRaw();
        }

        @Override
        public boolean isParameterized() {
            return this.elementType.isParameterized();
        }

        @Override
        public Type erasure() {
            Type elemtype1 = this.elementType.erasure();
            if (elemtype1 == this.elementType) {
                return this;
            }
            return new ArrayType(elemtype1);
        }

        @Override
        public Type flatten(List<Name> boundTypeNames) {
            Type elemtype1 = this.elementType.flatten(boundTypeNames);
            if (elemtype1 == this.elementType) {
                return this;
            }
            return new ArrayType(elemtype1);
        }

        @Override
        public Type asSuper(Symbol sym) {
            return this.isSubType(sym.type) ? sym.type : null;
        }

        @Override
        public Type asOuterSuper(Symbol sym) {
            return this.isSubType(sym.type) ? sym.type : null;
        }

        @Override
        public boolean isSameType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            return that.tag == 11 && this.elementType.isSameType(that.elementType());
        }

        @Override
        public boolean genType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            return that.tag == 11 && this.elementType.genType(that.elementType());
        }

        @Override
        public Type genInterface(List<Name> boundTypeNames, Type objectType) {
            Type flatElemType = this.elementType.flatten(boundTypeNames);
            return new ArrayType(flatElemType);
        }

        @Override
        public boolean isSubType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            if (that.tag == 11) {
                if (this.elementType.tag <= 8) {
                    return this.elementType.isSameType(that.elementType());
                }
                return this.elementType.isSubType(that.elementType());
            }
            if (that.tag == 10) {
                Name thatname = that.typeSymbol.fullName();
                return thatname == Names.java_lang_Object || thatname == Names.java_lang_Cloneable;
            }
            return false;
        }

        @Override
        public boolean erasedIsCastableTo(Type that) {
            return that.tag == 18 || that.tag == 10 && this.isSubType(that) || that.tag == 11 && (this.elementType().tag <= 8 ? this.elementType().tag == that.elementType().tag : this.elementType().erasedIsCastableTo(that.elementType()));
        }

        @Override
        public void loadReferencedClasses() {
            this.elementType.loadReferencedClasses();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassType
    extends Type {
        public Type enclosingInstanceType;
        public List<Type> typeParams;
        public Type parentType;
        public List<Type> interfaces;
        public String stringRepresentation;

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym) {
            super(10, tsym);
            this.enclosingInstanceType = outer;
            this.typeParams = typarams;
            this.parentType = null;
            this.interfaces = null;
        }

        public ClassType(Type outer, List<Type> typarams, Symbol.TypeSymbol tsym, Type supertype, List<Type> interfaces) {
            super(10, tsym);
            this.enclosingInstanceType = outer;
            this.typeParams = typarams;
            this.parentType = supertype;
            this.interfaces = interfaces;
        }

        @Override
        public Type constType(Object constValue) {
            ClassType t = new ClassType(this.enclosingInstanceType, this.typeParams, this.typeSymbol);
            t.constantValue = constValue;
            return t;
        }

        @Override
        public String toString() {
            if (this.stringRepresentation == null) {
                StringBuffer buf = new StringBuffer();
                if (this.enclosingType().tag == 10) {
                    buf.append(this.enclosingType().toString());
                    buf.append(".");
                }
                buf.append(this.className(this.typeSymbol));
                if (this.getTypeParams().nonEmpty()) {
                    buf.append(this.getTypeParams().toString("<", ",", ">"));
                }
                this.stringRepresentation = buf.toString();
            }
            return this.stringRepresentation;
        }

        private void appendSelectors(StringBuffer buf, Symbol sym, Symbol limit) {
            if (sym != limit) {
                this.appendSelectors(buf, sym.owner, limit);
                buf.append('.');
                buf.append(this.className(sym));
            }
        }

        private String className(Symbol sym) {
            if (sym.name.length == 0) {
                return new StringBuffer().append("<anonymous ").append(sym.type.getInterfaces().nonEmpty() ? sym.type.getInterfaces().getFirst() : sym.type.getSuperType()).append(">").toString();
            }
            return sym.name.toString();
        }

        @Override
        public List<Type> getTypeParams() {
            if (this.typeParams == null) {
                this.typeSymbol.complete();
                this.typeParams = this.typeSymbol.type.getTypeParams();
            }
            return this.typeParams;
        }

        @Override
        public Type enclosingType() {
            if (this.enclosingInstanceType == null) {
                this.typeSymbol.complete();
                this.enclosingInstanceType = this.typeSymbol.type.enclosingType();
            }
            return this.enclosingInstanceType;
        }

        @Override
        public Type getSuperType() {
            if (this.parentType == null) {
                this.typeSymbol.complete();
                Type superType = ((ClassType)this.typeSymbol.type).parentType;
                this.parentType = superType == null ? NO_TYPE : (this == this.typeSymbol.type ? superType : (this.typeParams.isEmpty() ? superType.erasure() : superType.substitute(this.typeSymbol.type.getTypeParams(), this.typeParams)));
            }
            return this.parentType;
        }

        @Override
        public List<Type> getInterfaces() {
            if (this.interfaces == null) {
                this.typeSymbol.complete();
                List<Type> is = ((ClassType)this.typeSymbol.type).interfaces;
                this.interfaces = is == null ? EMPTY_LIST : (this == this.typeSymbol.type ? is : (this.typeParams.isEmpty() ? ClassType.erasure(is) : ClassType.substitute(is, this.typeSymbol.type.getTypeParams(), this.typeParams)));
            }
            return this.interfaces;
        }

        @Override
        public List<Type> allParams() {
            return this.getTypeParams().append(this.enclosingType().allParams());
        }

        @Override
        public Type asSuper(Symbol sym) {
            Type t;
            if (this.typeSymbol == sym) {
                return this;
            }
            Type superType = this.getSuperType();
            if (superType.tag == 10 && (t = superType.asSuper(sym)) != null) {
                return t;
            }
            if ((sym.flags() & 0x200) != 0) {
                List<Type> l = this.getInterfaces();
                while (l.nonEmpty()) {
                    Type t2 = l.getFirst().asSuper(sym);
                    if (t2 != null) {
                        return t2;
                    }
                    l = l.getRest();
                }
            }
            return null;
        }

        @Override
        public Type asOuterSuper(Symbol sym) {
            Type s = this.asSuper(sym);
            Type t = this.enclosingType();
            while (s == null && t.tag == 10) {
                s = t.asSuper(sym);
                t = t.enclosingType();
            }
            return s;
        }

        @Override
        public Type asSub(Symbol sym) {
            if (this.typeSymbol == sym) {
                return this;
            }
            Type base = sym.type.asSuper(this.typeSymbol);
            if (base == null) {
                return null;
            }
            Type res = sym.type.substitute(base.allParams(), this.allParams());
            if (!res.isSubType(this)) {
                return null;
            }
            List<Type> l = sym.type.allParams();
            while (l.nonEmpty()) {
                if (res.occurrencesCount(l.getFirst()) != 0) {
                    return res.erasure();
                }
                l = l.getRest();
            }
            return res;
        }

        @Override
        public Type memberType(Symbol sym) {
            Type base;
            Symbol owner = sym.owner;
            if ((!sym.isStatic() || sym.isInterface()) && owner.type.isParameterized() && (base = this.asSuper(owner)) != null) {
                List<Type> ownerParams = owner.type.allParams();
                List<Type> baseParams = base.allParams();
                if (ownerParams.nonEmpty()) {
                    if (baseParams.isEmpty()) {
                        return sym.type.erasure();
                    }
                    return sym.type.substitute(ownerParams, baseParams);
                }
            }
            return sym.type;
        }

        @Override
        public Type substitute(List<Type> from, List<Type> to) {
            Type outer = this.enclosingType();
            List<Type> typarams = this.getTypeParams();
            List<Type> typarams1 = ClassType.substitute(typarams, from, to);
            Type outer1 = outer.substitute(from, to);
            if (typarams1 == typarams && outer1 == outer) {
                return this;
            }
            return new ClassType(outer1, typarams1, this.typeSymbol);
        }

        @Override
        public boolean isErroneous() {
            return this.enclosingType().isErroneous() || ClassType.isErroneous(this.getTypeParams());
        }

        @Override
        public boolean isRaw() {
            return this.isParameterized() && (this.getTypeParams().isEmpty() && this.typeSymbol.type.getTypeParams().nonEmpty() || this.enclosingType().isRaw());
        }

        @Override
        public boolean isParameterized() {
            if (this.typeSymbol.completer != null) {
                this.typeSymbol.complete();
            }
            return this.typeParams.nonEmpty() || this.enclosingInstanceType.tag == 10 && this.enclosingInstanceType.isParameterized();
        }

        @Override
        public boolean isFlattenedParameterized() {
            return this.typeSymbol instanceof Symbol.ClassInstantiationSymbol;
        }

        @Override
        public Type erasure() {
            return this.typeSymbol.erasure();
        }

        protected Name formFlattenedName(Symbol prefix, List<Type> newParams) {
            StringBuffer buf = new StringBuffer(prefix.name.toString());
            buf.append(Type.LEFT_PAREN);
            buf.append(newParams.getFirst().mangledName());
            List<Type> l = newParams.getRest();
            while (l.nonEmpty()) {
                buf.append(Type.COMMA);
                buf.append(l.getFirst().mangledName());
                l = l.getRest();
            }
            buf.append(Type.RIGHT_PAREN);
            return Name.fromString(buf.toString());
        }

        @Override
        public Type flatten(List<Name> boundTypeNames) {
            List<Type> params = this.allParams();
            if (params.isEmpty()) {
                return this;
            }
            List<Type> newParams = ClassType.flatten(params, boundTypeNames);
            Name flatName = this.formFlattenedName(this.typeSymbol, newParams);
            Symbol.ClassInstantiationSymbol flatTSym = new Symbol.ClassInstantiationSymbol(this.typeSymbol.flags(), flatName, null, this.typeSymbol.owner, this);
            List newInterfaces = this.getInterfaces();
            if (null == newInterfaces) {
                newInterfaces = EMPTY_LIST;
            }
            Type outer = this.typeSymbol.type.enclosingType();
            ClassType flatType = new ClassType(outer, EMPTY_LIST, flatTSym, this, newInterfaces);
            flatTSym.type = flatType;
            return flatType;
        }

        @Override
        public boolean isSameType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            return this.typeSymbol == that.typeSymbol && this.enclosingType().isSameType(that.enclosingType()) && ClassType.sameTypes(this.getTypeParams(), that.getTypeParams());
        }

        @Override
        public boolean genType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            return this.typeSymbol == that.typeSymbol && this.enclosingType().genType(that.enclosingType()) && ClassType.genTypes(this.getTypeParams(), that.getTypeParams());
        }

        @Override
        public boolean isSubType(Type that) {
            if (this == that || that.tag == 18) {
                return true;
            }
            if (this.typeSymbol == that.typeSymbol) {
                return !that.isParameterized() || this.genType(that);
            }
            Type superType = this.getSuperType();
            if (superType.tag == 10 && superType.isSubType(that)) {
                return true;
            }
            if ((that.typeSymbol.flags() & 0x200) != 0) {
                List<Type> l = this.getInterfaces();
                while (l.nonEmpty()) {
                    if (l.getFirst().isSubType(that)) {
                        return true;
                    }
                    l = l.getRest();
                }
            }
            return false;
        }

        @Override
        public boolean erasedIsCastableTo(Type that) {
            List<Type> thatParams = that.allParams();
            if (that.isErrorType() || that.isTypeVar() && this.erasedIsCastableTo(((TypeVar)that).bound)) {
                return true;
            }
            if (that.isClassType() || that.isArrayType()) {
                Type erasedThat;
                Type erasedThis = this.erasure();
                return erasedThis.isSubType(erasedThat = that.erasure()) || erasedThat.isSubType(erasedThis) || erasedThat.isClassType() && erasedThat.isInterface() && erasedThis.isFinal() || erasedThis.isInterface() && erasedThat.isFinal();
            }
            return false;
        }

        @Override
        public boolean isCastableTo(Type that) {
            List<Type> thatParams = that.allParams();
            return that.tag == 18 || (that.tag == 10 || that.tag == 11) && (this.isSubType(that) || that.isSubType(this) && thatParams.subset(this.allParams()) || that.tag == 10 && thatParams.isEmpty() && ((that.typeSymbol.flags() & 0x200) != 0 && (this.typeSymbol.flags() & 0x10) == 0 || (this.typeSymbol.flags() & 0x200) != 0 && (that.typeSymbol.flags() & 0x10) == 0));
        }

        @Override
        public void loadReferencedClasses() {
            if (this.typeSymbol.completer != null) {
                this.typeSymbol.complete();
            }
        }
    }

    public static class NoType
    extends Type {
        public static final NoType ONLY = new NoType();

        private NoType() {
            super(17, Symbol.NO_SYMBOL);
        }

        public String toString() {
            return "NoType";
        }
    }
}

