/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class TypeTest
extends NextGenTestCase {
    private Type type;

    public TypeTest(String name) {
        super(name);
    }

    protected void setUp() {
    }

    protected void tearDown() {
        this.type = null;
    }

    public void testConstructor() {
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(0, Name.fromString("test"), null, null);
        Type type = new Type(0, symbol);
    }

    public void testEquals() {
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(0, Name.fromString("test"), null, null);
        Symbol.TypeSymbol anotherSymbol = new Symbol.TypeSymbol(0, Name.fromString("anotherTest"), null, null);
        Type type1 = new Type(0, symbol);
        Type type2 = new Type(0, symbol);
        Type type3 = new Type(1, symbol);
        Type type4 = new Type(0, anotherSymbol);
        TypeTest.assertEquals((String)"A type should be equal to itself.", (Object)type1, (Object)type1);
        TypeTest.assertEquals((String)"A type should be equal to a structurally identical type.", (Object)type1, (Object)type2);
        TypeTest.assertFalse((String)"Types with distinct tags should not be equal.", (boolean)type1.equals(type3));
        TypeTest.assertFalse((String)"Types with distinct symbols should not be equal.", (boolean)type1.equals(type4));
        TypeTest.assertFalse((String)"Types should not be equal to non-types.", (boolean)type1.equals(new Object()));
    }

    public void testConstType() {
        Object constantValue = new Object();
        Type test = INT_TYPE.constType(constantValue);
        TypeTest.assertEquals((String)"Type.constType should return a new type with the given constant value.", (Object)constantValue, (Object)test.constantValue);
    }

    public void testToMethodString() {
        TypeTest.assertEquals((String)"Type.toMethodString returned wrong value.", (String)"TYPE_SYMBOL", (String)INT_TYPE.toMethodString());
    }

    public void testToString() {
        TypeTest.assertEquals((String)"Type.toString returned wrong value.", (String)"TYPE_SYMBOL", (String)INT_TYPE.toString());
        TypeTest.assertEquals((String)"Type.toString returned wrong value for parametric type.", (String)"CLASS_SYMBOL<TYPE_SYMBOL>", (String)PARAM_CLASS_TYPE.toString());
    }

    public void testMangledName() {
        TypeTest.assertEquals((String)"Type.mangledName did not return the expected String.", (String)"CLASS_SYMBOL", (String)PARAM_CLASS_TYPE.mangledName());
    }

    public void testElimBrack() {
        TypeTest.assertEquals((String)"Type.testElimBrack returned wrong value.", (String)"C$arrayT$", (String)Type.elimBrack("C[T]"));
    }

    public void testToIdent() {
        TypeTest.assertEquals((String)"Type.testToIdent returned wrong value.", (String)new Tree.Ident(0, CLASS_TYPE, CLASS_TYPE.name(), CLASS_TYPE.symbol()).toString(), (String)CLASS_TYPE.toIdent(0).toString());
    }

    public void testSubstitute1() {
        TypeTest.assertEquals((String)"PARAM_CLASS_TYPE doesn't print properly.", (String)"CLASS_SYMBOL<TYPE_SYMBOL>", (String)PARAM_CLASS_TYPE.toString());
        TypeTest.assertEquals((String)"Type.substitute returned wrong value.", (String)"CLASS_SYMBOL<ANOTHER_TYPE_SYMBOL>", (String)PARAM_CLASS_TYPE.substitute(List.make(new Type[]{TYPE_VAR}), List.make(new Type[]{ANOTHER_TYPE_VAR})).toString());
    }

    public void testStaticSubstitute() {
        List<Type> these = List.make(new Type[]{PARAM_CLASS_TYPE});
        List<Type> from = List.make(new Type[]{TYPE_VAR});
        List<Type> to = List.make(new Type[]{ANOTHER_TYPE_VAR});
        List<Type> result = Type.substitute(these, from, to);
        String expected = "CLASS_SYMBOL<ANOTHER_TYPE_SYMBOL>";
        TypeTest.assertEquals((String)"Type.substitute returned list of wrong length.", (int)1, (int)result.length());
        TypeTest.assertEquals((String)"Type.substitute returned wrong value.", (String)expected, (String)result.getFirst().toString());
    }

    public void testErasure() {
        TypeTest.assertEquals((String)"Type.erasure returned wrong value.", (String)"CLASS_SYMBOL", (String)PARAM_CLASS_TYPE.erasure().toString());
    }

    public void testFlatten() {
        TypeTest.assertEquals((String)"Base types should flatten to themselves.", (String)"CLASS_SYMBOL", (String)CLASS_TYPE.flatten().toString());
        TypeTest.assertEquals((String)"Parametric types should convert params to DeBruijn indices in the given List of bound type vars.", (String)"CLASS_SYMBOL$$L{0}$$R", (String)PARAM_CLASS_TYPE.flatten(List.make(new Name[]{Name.fromString("TYPE_SYMBOL")})).toString());
        try {
            PARAM_CLASS_TYPE.flatten();
            TypeTest.fail((String)"Flattening parametric types with free type vars should fail.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testGenInterface() {
        try {
            CLASS_TYPE.genInterface(Name.EMPTY_LIST, CLASS_TYPE);
            TypeTest.fail((String)"Type.genInterface should fail when called on types that haven't been entered in a symbol table.");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testOccurrencesCount() {
        TypeTest.assertEquals((String)"A type should count as occurring once in itself.", (int)1, (int)CLASS_TYPE.occurrencesCount(CLASS_TYPE));
        TypeTest.assertEquals((String)"Type vars should count as occurrences in their enclosing types.", (int)1, (int)PARAM_CLASS_TYPE.occurrencesCount(TYPE_VAR));
    }

    public void testIsSameType() {
        TypeTest.assertTrue((String)"A class should count as the same type as itself.", (boolean)CLASS_TYPE.isSameType(CLASS_TYPE));
        TypeTest.assertFalse((String)"A parametric class is not the same type as its base class.", (boolean)CLASS_TYPE.isSameType(PARAM_CLASS_TYPE));
    }

    public void testIsSubType() {
        TypeTest.assertFalse((String)"A base type should never be a subtype of one of its instantiation types.", (boolean)CLASS_TYPE.isSubType(PARAM_CLASS_TYPE));
        TypeTest.assertTrue((String)"An instantiation type should be a subtype of its base type.", (boolean)PARAM_CLASS_TYPE.isSubType(CLASS_TYPE));
        TypeTest.assertTrue((String)"A type should be a subtype of itself.", (boolean)CLASS_TYPE.isSubType(CLASS_TYPE));
    }

    public void testIsCoerceableTo() {
        TypeTest.assertFalse((String)"A maximally large int should not be coerceable to a byte.", (boolean)MAX_INT_TYPE.isCoerceableTo(BYTE_TYPE));
        TypeTest.assertTrue((String)"An int should always be coerceable to an int.", (boolean)MAX_INT_TYPE.isCoerceableTo(INT_TYPE));
        TypeTest.assertFalse((String)"A base type should never be coerceable to one of its instantiation types.", (boolean)CLASS_TYPE.isSubType(PARAM_CLASS_TYPE));
        TypeTest.assertTrue((String)"An instantiation type should be coerceable to its base type.", (boolean)PARAM_CLASS_TYPE.isSubType(CLASS_TYPE));
        TypeTest.assertTrue((String)"A type should be coerceable to itself.", (boolean)CLASS_TYPE.isSubType(CLASS_TYPE));
    }

    public void testIsCastableTo() {
        TypeTest.assertTrue((String)"A base type should be castable to any of its instantiations.", (boolean)CLASS_TYPE.isCastableTo(PARAM_CLASS_TYPE));
        TypeTest.assertTrue((String)"An instantiation type should be castable to its base type.", (boolean)PARAM_CLASS_TYPE.isCastableTo(CLASS_TYPE));
        TypeTest.assertTrue((String)"A type should be castable to itself.", (boolean)CLASS_TYPE.isCastableTo(CLASS_TYPE));
        TypeTest.assertFalse((String)"Unrelated types should not be castable to one another.", (boolean)CLASS_TYPE.isCastableTo(INT_TYPE));
        TypeTest.assertFalse((String)"A ground type should not be castable to non-ground type.", (boolean)GROUND_CLASS_TYPE.isCastableTo(PARAM_CLASS_TYPE));
    }

    public void testErasedIsCastable() {
        TypeTest.assertTrue((String)"A base type should be castable to the erasure of any of its instantiations.", (boolean)CLASS_TYPE.erasedIsCastableTo(PARAM_CLASS_TYPE));
        TypeTest.assertTrue((String)"An erased instantiation type should be castable to its base type.", (boolean)PARAM_CLASS_TYPE.erasedIsCastableTo(CLASS_TYPE));
        TypeTest.assertTrue((String)"An erased type should be castable to itself.", (boolean)CLASS_TYPE.erasedIsCastableTo(CLASS_TYPE));
        TypeTest.assertFalse((String)"Unrelated types should not be castable to one another.", (boolean)CLASS_TYPE.erasedIsCastableTo(INT_TYPE));
        TypeTest.assertTrue((String)"An erased ground type should be castable to a corresponding, erased, non-ground type.", (boolean)GROUND_CLASS_TYPE.erasedIsCastableTo(PARAM_CLASS_TYPE));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(1.class$edu$rice$cs$nextgen$compiler$code$TypeTest == null ? (1.class$edu$rice$cs$nextgen$compiler$code$TypeTest = 1.class$("edu.rice.cs.nextgen.compiler.code.TypeTest")) : 1.class$edu$rice$cs$nextgen$compiler$code$TypeTest));
    }

    static class 1 {
        static /* synthetic */ Class class$edu$rice$cs$nextgen$compiler$code$TypeTest;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

