/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.ConstantPool;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.GenContext;
import edu.rice.cs.nextgen.compiler.comp.Items;
import edu.rice.cs.nextgen.compiler.comp.NameResolver;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeChecker;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.tree.PrettyPrinter;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.ListIterator;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeGenerator
extends Tree.Visitor<Items.Item, Environment<GenContext>>
implements Flags,
Kinds,
TypeTags,
ByteCodes {
    final ErrorLog errorLog;
    final SymbolTable symbolTable;
    final TypeChecker typeChecker;
    final NameResolver nameResolver;
    final TreeMaker treeMaker;
    final Items items;
    final CompilerOptions options;
    ConstantPool pool = new ConstantPool();
    Code code;
    Environment<AnalyzerContext> analyzerContextEnv;
    static Environment<GenContext> genContextEnv = new Environment<GenContext>(null, new GenContext());

    public CodeGenerator(ErrorLog errorLog, SymbolTable symbolTable, TypeChecker typeChecker, NameResolver nameResolver, TreeMaker treeMaker, Items items, CompilerOptions options) {
        this.errorLog = errorLog;
        this.symbolTable = symbolTable;
        this.typeChecker = typeChecker;
        this.nameResolver = nameResolver;
        this.treeMaker = treeMaker;
        this.items = items;
        this.options = options;
    }

    void loadIntConst(int n) {
        this.items.makeImmediateItem(Type.INT_TYPE, new Integer(n)).load();
    }

    public static int zero(int tc) {
        switch (tc) {
            case 0: 
            case 5: 
            case 6: 
            case 7: {
                return 3;
            }
            case 1: {
                return 9;
            }
            case 2: {
                return 11;
            }
            case 3: {
                return 14;
            }
        }
        throw new InternalError("zero");
    }

    public static int one(int tc) {
        return CodeGenerator.zero(tc) + 1;
    }

    void emitMinusOne(int tc) {
        if (tc == 1) {
            this.code.emitOp(9);
            this.code.emitOp(10);
            this.code.emitOp(101);
        } else {
            this.code.emitOp(2);
        }
    }

    int mkref(Type type) {
        return this.pool.put(type.tag == 10 ? type.typeSymbol : type);
    }

    Items.LocalItem makeTemp(Type type) {
        return (Items.LocalItem)this.items.makeLocalItem(type, this.code.newLocal(type));
    }

    void callFinalizer(Environment<GenContext> env) {
        if (this.code.codeGenerationEnabled) {
            this.code.pushStack(4);
            ((GenContext)env.context).continuingJumps = new Code.Chain(this.code.currentPc(), ((GenContext)env.context).continuingJumps, this.code.getStackSize());
            this.code.popStack(4);
            this.code.emitJump(((GenContext)env.context).continuingJumps, 168);
        }
    }

    Environment<GenContext> jumpto(Tree target, Environment<GenContext> env) {
        Environment<GenContext> env1 = env;
        while (env1 != null && env1.tree != target) {
            env1 = env1.enclosingEnv;
        }
        if (env1 != null) {
            Tree last = null;
            while (env != env1) {
                if (env.tree != last) {
                    if (env.tree.tag == 14 && ((Tree.Try)env.tree).finalizer != null || env.tree.tag == 13) {
                        this.callFinalizer(env);
                    }
                    last = env.tree;
                }
                env = env.enclosingEnv;
            }
        }
        return env1;
    }

    boolean hasFinalizers(Tree target, Environment<GenContext> env) {
        while (env.tree != target) {
            if (env.tree.tag == 14 && ((Tree.Try)env.tree).finalizer != null || env.tree.tag == 13) {
                return true;
            }
            env = env.enclosingEnv;
        }
        return false;
    }

    List<Tree> normalizeDefs(List<Tree> defs, Symbol.ClassSymbol c) {
        ListBox initCode = new ListBox();
        ListBox<Tree> clinitCode = new ListBox<Tree>();
        ListBox<Tree> methoddefs = new ListBox<Tree>();
        List<Tree> l = defs;
        while (l.nonEmpty()) {
            Tree def = l.getFirst();
            switch (def.tag) {
                case 6: {
                    Tree.Block block = (Tree.Block)def;
                    ((block.flags & 8) != 0 ? clinitCode : initCode).insertEnd(def);
                    break;
                }
                case 4: {
                    methoddefs.insertEnd(def);
                    break;
                }
                case 5: {
                    Tree.VarDef vdef = (Tree.VarDef)def;
                    if (vdef.initialization == null || vdef.varSymbol.constantValue != null) break;
                    ((vdef.flags & 8) != 0 ? clinitCode : initCode).insertEnd(this.treeMaker.at(vdef.sourcePosition).newAssignment(vdef.varSymbol, vdef.initialization));
                    break;
                }
                default: {
                    throw new InternalError();
                }
            }
            l = l.getRest();
        }
        if (initCode.length() != 0) {
            List<Tree> inits = initCode.toList();
            ListIterator i = methoddefs.iterator();
            while (i.hasNext()) {
                this.normalizeMethod((Tree.MethodDef)i.next(), inits);
            }
        }
        if (clinitCode.length() != 0) {
            Symbol.MethodSymbol clinit = new Symbol.MethodSymbol(8, Names.clinit, new Type.MethodType(Type.EMPTY_LIST, Type.VOID_TYPE, Symbol.ClassSymbol.EMPTY_LIST), c);
            c.members().addSymbol(clinit);
            List<Tree> clinitStats = clinitCode.toList();
            this.treeMaker.at(((Tree)clinitStats.getFirst()).sourcePosition);
            methoddefs.insertEnd(this.treeMaker.newMethodDef(clinit, this.treeMaker.newBlock(0, clinitStats)));
        }
        return methoddefs.toList();
    }

    void normalizeMethod(Tree.MethodDef md, List<Tree> initCode) {
        if (md.name == Names.init && TreeInspector.isInitialConstructor(md)) {
            List<Tree> stats = md.body.statements;
            ListBox<Tree> newstats = new ListBox<Tree>();
            newstats.insertEnd(stats.getFirst());
            stats = stats.getRest();
            while (stats.nonEmpty() && TreeInspector.isSyntheticInit(stats.getFirst())) {
                newstats.insertEnd(stats.getFirst());
                stats = stats.getRest();
            }
            newstats.insertEltsEnd(initCode);
            while (stats.nonEmpty()) {
                newstats.insertEnd(stats.getFirst());
                stats = stats.getRest();
            }
            md.body.statements = newstats.toList();
        }
    }

    public void genStatement(Tree tree, Environment<GenContext> env) {
        try {
            this.code.markStatementBeginning(tree.sourcePosition);
            tree.accept(this, env);
        }
        catch (Symbol.CompletionFailure ex) {
            this.typeChecker.completionError(tree.sourcePosition, ex);
        }
    }

    public void genStatements(List<Tree> trees, Environment<GenContext> env) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.genStatement(l.getFirst(), env);
            l = l.getRest();
        }
    }

    public Items.Item genExpression(Tree tree, Type expectedType) {
        try {
            Items.Item result;
            if (tree.type.constantValue != null) {
                result = this.items.makeImmediateItem(tree.type, tree.type.constantValue);
            } else {
                ((GenContext)CodeGenerator.genContextEnv.context).expectedType = expectedType;
                result = tree.accept(this, genContextEnv);
            }
            return result.coerce(expectedType);
        }
        catch (Symbol.CompletionFailure ex) {
            this.typeChecker.completionError(tree.sourcePosition, ex);
            return this.items.makeStackItem(expectedType);
        }
    }

    public void genArgs(List<Tree> trees, List<Type> expectedTypes) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.genExpression(l.getFirst(), expectedTypes.getFirst()).load();
            expectedTypes = expectedTypes.getRest();
            l = l.getRest();
        }
    }

    @Override
    public Items.Item _case(Tree.MethodDef tree, Environment<GenContext> env) {
        Environment<GenContext> localEnv = env.spawn(tree);
        localEnv.enclosingMethod = tree;
        ((GenContext)localEnv.context).expectedType = tree.methodSymbol.erasure().returnType();
        this.genMethod(tree, localEnv, false);
        return null;
    }

    void genMethod(Tree.MethodDef tree, Environment<GenContext> env, boolean fatcode) {
        Symbol.MethodSymbol meth = tree.methodSymbol;
        if (tree.body != null) {
            meth.byteCodes = this.code = new Code(fatcode, this.options.debugInfo());
            this.items.setCode(this.code);
            if ((tree.flags & 8) == 0) {
                this.code.newLocal(meth.owner.erasure());
            }
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                this.code.newLocal(l.getFirst().varSymbol);
                l = l.getRest();
            }
            this.genStatement(tree.body, env);
            Asserter._assert(this.code.getStackSize() == 0);
            if (this.code.codeGenerationEnabled) {
                if (tree.body.statements.isEmpty()) {
                    this.code.markStatementBeginning(tree.body.sourcePosition);
                }
                this.code.emitOp(177);
                this.code.endScopes(0);
                if (!fatcode && this.code.longJumpsAllowed) {
                    this.genMethod(tree, env, true);
                }
            }
        }
    }

    @Override
    public Items.Item _case(Tree.VarDef tree, Environment<GenContext> env) {
        Symbol.VarSymbol v = tree.varSymbol;
        this.code.newLocal(v);
        if (tree.initialization != null && v.constantValue == null) {
            this.genExpression(tree.initialization, v.erasure()).load();
            this.items.makeLocalItem(v).store();
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Block tree, Environment<GenContext> env) {
        if (this.code.codeGenerationEnabled) {
            int limit = this.code.nextVarAddress;
            this.genStatements(tree.statements, env);
            this.code.endScopes(limit);
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.DoLoop tree, Environment<GenContext> env) {
        int startpc = this.code.currentPc();
        Environment<GenContext> loopEnv = env.spawn(tree, ((GenContext)env.context).copy());
        this.genStatement(tree.body, loopEnv);
        this.code.resolve(((GenContext)loopEnv.context).continuingJumps);
        this.code.markStatementBeginning(tree.cond.sourcePosition);
        Items.CondItem c = this.genExpression(tree.cond, Type.BOOLEAN_TYPE).mkCond();
        this.code.resolve(c.jumpTrue(), startpc);
        this.code.resolve(c.falseJumps);
        this.code.resolve(((GenContext)loopEnv.context).exitingJumps);
        return null;
    }

    @Override
    public Items.Item _case(Tree.WhileLoop tree, Environment<GenContext> env) {
        int startpc = this.code.currentPc();
        Items.CondItem c = this.genExpression(tree.condition, Type.BOOLEAN_TYPE).mkCond();
        Environment<GenContext> loopEnv = env.spawn(tree, ((GenContext)env.context).copy());
        ((GenContext)loopEnv.context).exitingJumps = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            this.genStatement(tree.body, loopEnv);
            this.code.resolve(((GenContext)loopEnv.context).continuingJumps);
            this.code.resolve(this.code.branch(167), startpc);
        }
        this.code.resolve(((GenContext)loopEnv.context).exitingJumps);
        return null;
    }

    @Override
    public Items.Item _case(Tree.ForLoop tree, Environment<GenContext> env) {
        Items.CondItem c;
        this.genStatements(tree.initializations, env);
        int startpc = this.code.currentPc();
        if (tree.conditions != null) {
            this.code.markStatementBeginning(tree.conditions.sourcePosition);
            c = this.genExpression(tree.conditions, Type.BOOLEAN_TYPE).mkCond();
        } else {
            c = this.items.makeCondItem(167);
        }
        Environment<GenContext> loopEnv = env.spawn(tree, ((GenContext)env.context).copy());
        ((GenContext)loopEnv.context).exitingJumps = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            this.genStatement(tree.body, loopEnv);
            this.code.resolve(((GenContext)loopEnv.context).continuingJumps);
            this.genStatements(tree.incrementations, loopEnv);
            this.code.resolve(this.code.branch(167), startpc);
        }
        this.code.resolve(((GenContext)loopEnv.context).exitingJumps);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Labelled tree, Environment<GenContext> env) {
        Environment<GenContext> localEnv = env.spawn(tree.body, ((GenContext)env.context).copy());
        this.genStatement(tree.body, localEnv);
        this.code.resolve(((GenContext)localEnv.context).exitingJumps);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Switch tree, Environment<GenContext> env) {
        block22: {
            int i;
            int opcode;
            List<Tree.Case> cases;
            Items.Item sel;
            block23: {
                block21: {
                    sel = this.genExpression(tree.selector, Type.INT_TYPE);
                    cases = tree.cases;
                    if (!cases.isEmpty()) break block21;
                    sel.load().drop();
                    break block22;
                }
                if (!cases.getRest().isEmpty() || cases.getFirst().pattern != null) break block23;
                sel.drop();
                this.genStatements(cases.getFirst().statements, env);
                break block22;
            }
            sel.load();
            Environment<GenContext> switchEnv = env.spawn(tree, ((GenContext)env.context).copy());
            int lo = Integer.MAX_VALUE;
            int hi = Integer.MIN_VALUE;
            int ntags = 0;
            int[] tags = new int[cases.length()];
            int[] labels = null;
            int defaultIndex = -1;
            List<Tree.Case> l = cases;
            for (int i2 = 0; i2 < tags.length; ++i2) {
                if (l.getFirst().pattern != null) {
                    int val;
                    tags[i2] = val = ((Number)l.getFirst().pattern.type.constantValue).intValue();
                    if (val < lo) {
                        lo = val;
                    }
                    if (hi < val) {
                        hi = val;
                    }
                    ++ntags;
                } else {
                    Asserter._assert(defaultIndex == -1);
                    defaultIndex = i2;
                }
                l = l.getRest();
            }
            long table_space_cost = 4L + (long)(hi - lo + 1);
            long table_time_cost = 3L;
            long lookup_space_cost = 3L + (long)(2 * ntags);
            long lookup_time_cost = ntags;
            int n = opcode = table_space_cost + 3L * table_time_cost <= lookup_space_cost + 3L * lookup_time_cost ? 170 : 171;
            if (!this.code.codeGenerationEnabled) break block22;
            int startpc = this.code.currentPc();
            this.code.emitOp(opcode);
            this.code.align(4);
            int tableBase = this.code.currentPc();
            this.code.emitFourBytes(-1);
            if (opcode == 170) {
                this.code.emitFourBytes(lo);
                this.code.emitFourBytes(hi);
                for (i = lo; i <= hi; ++i) {
                    this.code.emitFourBytes(-1);
                }
            } else {
                this.code.emitFourBytes(ntags);
                for (i = 0; i < ntags; ++i) {
                    this.code.emitFourBytes(-1);
                    this.code.emitFourBytes(-1);
                }
                labels = new int[tags.length];
            }
            this.code.codeGenerationEnabled = false;
            l = cases;
            for (i = 0; i < tags.length; ++i) {
                Tree.Case c = l.getFirst();
                l = l.getRest();
                if (i != defaultIndex) {
                    if (opcode == 170) {
                        this.code.putFourBytes(tableBase + 4 * (tags[i] - lo + 3), this.code.currentPc() - startpc);
                    } else {
                        labels[i] = this.code.currentPc() - startpc;
                    }
                } else {
                    this.code.putFourBytes(tableBase, this.code.currentPc() - startpc);
                }
                this.code.codeGenerationEnabled = true;
                this.genStatements(c.statements, switchEnv);
                if (!this.options.switchCheck() || !this.code.codeGenerationEnabled || !c.statements.nonEmpty() || i >= tags.length - 1) continue;
                this.errorLog.warning(c.sourcePosition, "possible fall-through from case");
            }
            this.code.resolve(((GenContext)switchEnv.context).exitingJumps);
            if (this.code.getFourBytes(tableBase) == -1) {
                this.code.putFourBytes(tableBase, this.code.currentPc() - startpc);
                this.code.codeGenerationEnabled = true;
            }
            if (opcode == 170) {
                int defaultOffset = this.code.getFourBytes(tableBase);
                for (int i3 = lo; i3 <= hi; ++i3) {
                    if (this.code.getFourBytes(tableBase + 4 * (i3 - lo + 3)) != -1) continue;
                    this.code.putFourBytes(tableBase + 4 * (i3 - lo + 3), defaultOffset);
                }
            } else {
                if (defaultIndex >= 0) {
                    for (i = defaultIndex; i < tags.length - 1; ++i) {
                        tags[i] = tags[i + 1];
                        labels[i] = labels[i + 1];
                    }
                }
                CodeGenerator.qsort2(tags, labels, 0, ntags - 1);
                for (i = 0; i < ntags; ++i) {
                    int caseidx = tableBase + 8 * (i + 1);
                    this.code.putFourBytes(caseidx, tags[i]);
                    this.code.putFourBytes(caseidx + 4, labels[i]);
                }
            }
        }
        return null;
    }

    static void qsort2(int[] keys, int[] values, int lo, int hi) {
        int i = lo;
        int j = hi;
        int pivot = keys[(i + j) / 2];
        while (true) {
            if (keys[i] < pivot) {
                ++i;
                continue;
            }
            while (pivot < keys[j]) {
                --j;
            }
            if (i <= j) {
                int temp1 = keys[i];
                keys[i] = keys[j];
                keys[j] = temp1;
                int temp2 = values[i];
                values[i] = values[j];
                values[j] = temp2;
                ++i;
                --j;
            }
            if (i > j) break;
        }
        if (lo < j) {
            CodeGenerator.qsort2(keys, values, lo, j);
        }
        if (i < hi) {
            CodeGenerator.qsort2(keys, values, i, hi);
        }
    }

    @Override
    public Items.Item _case(Tree.Synchronized tree, Environment<GenContext> env) {
        final Items.LocalItem lockVar = this.makeTemp(this.symbolTable.OBJECT_TYPE);
        this.genExpression(tree.lockedObject, tree.lockedObject.type).load();
        ((Items.Item)lockVar).store();
        ((Items.Item)lockVar).load();
        this.code.emitOp(194);
        Environment<GenContext> syncEnv = env.spawn(tree, ((GenContext)env.context).copy());
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FinalizeSync
        extends GenFinal {
            FinalizeSync() {
            }

            @Override
            void gen() {
                lockVar.load();
                CodeGenerator.this.code.emitOp(195);
            }
        }
        this.genTry(tree.body, Tree.Catch.emptyList, new FinalizeSync(), syncEnv);
        this.code.resolve(((GenContext)syncEnv.context).exitingJumps);
        return null;
    }

    @Override
    public Items.Item _case(final Tree.Try tree, final Environment<GenContext> env) {
        Environment<GenContext> tryEnv = env.spawn(tree, ((GenContext)env.context).copy());
        /*
         * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class FinalizeTry
        extends GenFinal {
            FinalizeTry() {
            }

            @Override
            void gen() {
                CodeGenerator.this.genStatement(tree.finalizer, env);
            }
        }
        this.genTry(tree.body, tree.catchers, tree.finalizer == null ? null : new FinalizeTry(), tryEnv);
        this.code.resolve(((GenContext)tryEnv.context).exitingJumps);
        return null;
    }

    void genTry(Tree body, List<Tree.Catch> catchers, GenFinal genfinal, Environment<GenContext> env) {
        int limit = this.code.nextVarAddress;
        int startpc = this.code.currentPc();
        this.genStatement(body, env);
        int endpc = this.code.currentPc();
        if (genfinal != null) {
            this.callFinalizer(env);
        }
        Code.Chain exitChain = this.code.branch(167);
        if (startpc != endpc) {
            List<Tree.Catch> l = catchers;
            while (l.nonEmpty()) {
                this.code.codeGenerationEnabled = true;
                this.code.clearStack();
                this.code.pushStack(4);
                this.genCatch(l.getFirst(), env, startpc, endpc);
                if (genfinal != null) {
                    this.callFinalizer(env);
                }
                exitChain = Code.mergeChains(exitChain, this.code.branch(167));
                l = l.getRest();
            }
        }
        if (genfinal != null) {
            this.code.codeGenerationEnabled = true;
            this.registerCatch(body.sourcePosition, startpc, this.code.currentPc(), this.code.currentPc(), 0);
            this.code.newRegSegment();
            this.code.clearStack();
            this.code.pushStack(4);
            Items.LocalItem excVar = this.makeTemp(this.symbolTable.THROWABLE_TYPE);
            ((Items.Item)excVar).store();
            this.callFinalizer(env);
            ((Items.Item)excVar).load();
            this.code.emitOp(191);
            this.code.codeGenerationEnabled = true;
            this.code.clearStack();
            this.code.pushStack(4);
            this.code.resolve(((GenContext)env.context).continuingJumps);
            Items.LocalItem retVar = this.makeTemp(this.symbolTable.THROWABLE_TYPE);
            retVar.store();
            genfinal.gen();
            this.code.emitOpOneByteAndWiden(169, this.code.regOf(retVar.adr));
            this.code.codeGenerationEnabled = false;
        }
        this.code.resolve(exitChain);
        this.code.endScopes(limit);
    }

    void genCatch(Tree.Catch tree, Environment<GenContext> env, int startpc, int endpc) {
        if (startpc != endpc) {
            this.registerCatch(tree.sourcePosition, startpc, endpc, this.code.currentPc(), this.mkref(tree.param.type));
            this.code.newLocal(tree.param.varSymbol);
            this.items.makeLocalItem(tree.param.varSymbol).store();
            this.genStatement(tree.body, env);
        }
    }

    void registerCatch(int pos, int start_pc, int end_pc, int handler_pc, int catch_type) {
        if (start_pc != end_pc) {
            char start_pc1 = (char)start_pc;
            char end_pc1 = (char)end_pc;
            char handler_pc1 = (char)handler_pc;
            if (start_pc1 == start_pc && end_pc1 == end_pc && handler_pc1 == handler_pc) {
                this.code.addCatch(start_pc1, end_pc1, handler_pc1, (char)catch_type);
            } else {
                this.errorLog.error(pos, "code too large for try statement");
            }
        }
    }

    @Override
    public Items.Item _case(Tree.Conditional tree, Environment<GenContext> env) {
        Type pt = ((GenContext)env.context).expectedType;
        Code.Chain thenExit = null;
        Items.CondItem c = this.genExpression(tree.condition, Type.BOOLEAN_TYPE).mkCond();
        Code.Chain elseChain = c.jumpFalse();
        if (c.trueJumps != null || c.opcode != 168) {
            this.code.resolve(c.trueJumps);
            if (tree.tag == 17) {
                this.genStatement(tree.thenClause, env);
            } else {
                this.genExpression(tree.thenClause, pt).load();
            }
            thenExit = this.code.branch(167);
        }
        if (tree.elseClause != null && elseChain != null) {
            this.code.resolve(elseChain);
            if (tree.tag == 17) {
                this.genStatement(tree.elseClause, env);
            } else {
                this.genExpression(tree.elseClause, pt).load();
            }
            this.code.resolve(thenExit);
        } else {
            this.code.resolve(thenExit);
            this.code.resolve(elseChain);
        }
        if (tree.tag == 17) {
            return null;
        }
        return this.items.makeStackItem(pt);
    }

    @Override
    public Items.Item _case(Tree.ExpressionStatement tree, Environment<GenContext> env) {
        if (tree.expression.tag == 44) {
            tree.expression.tag = 42;
        } else if (tree.expression.tag == 45) {
            tree.expression.tag = 43;
        }
        this.genExpression(tree.expression, tree.expression.type).drop();
        return null;
    }

    @Override
    public Items.Item _case(Tree.Break tree, Environment<GenContext> env) {
        Environment<GenContext> targetEnv = this.jumpto(tree.target, env);
        if (targetEnv != null) {
            ((GenContext)targetEnv.context).addExitingJump(this.code.branch(167));
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Continue tree, Environment<GenContext> env) {
        ((GenContext)this.jumpto((Tree)tree.target, env).context).addContinuingJump(this.code.branch(167));
        return null;
    }

    @Override
    public Items.Item _case(Tree.Return tree, Environment<GenContext> env) {
        if (tree.expression != null) {
            Items.Item r = this.genExpression(tree.expression, ((GenContext)env.context).expectedType);
            if (this.hasFinalizers(env.enclosingMethod, env)) {
                r.load();
                r = this.makeTemp(((GenContext)env.context).expectedType);
                r.store();
            }
            this.jumpto(env.enclosingMethod, env);
            r.load();
            this.code.emitOp(172 + Code.truncate(Code.typecode(((GenContext)env.context).expectedType)));
        } else {
            this.jumpto(env.enclosingMethod, env);
            this.code.emitOp(177);
        }
        return null;
    }

    @Override
    public Items.Item _case(Tree.Throw tree, Environment<GenContext> env) {
        this.genExpression(tree.expression, tree.expression.type).load();
        this.code.emitOp(191);
        return null;
    }

    @Override
    public Items.Item _case(Tree.Apply tree, Environment<GenContext> env) {
        Items.Item method = this.genExpression(tree.method, new Type.MethodType(null, null, null));
        if (tree.args.length() != TreeInspector.symbol(tree.method).externalType().argTypes().length()) {
            new PrettyPrinter().printExprs(tree.args);
        }
        this.genArgs(tree.args, TreeInspector.symbol(tree.method).externalType().argTypes());
        return method.invoke();
    }

    @Override
    public Items.Item _case(Tree.NewInstance tree, Environment<GenContext> env) {
        Asserter._assert(tree.enclosingClassPrefix == null && tree.anonymousClassDef == null);
        int ref = this.mkref(tree.type);
        this.code.emitOpTwoBytes(187, ref);
        this.code.emitOp(89);
        this.genArgs(tree.args, tree.constructor.externalType().argTypes());
        this.items.makeMemberItem(tree.constructor, true).invoke();
        return this.items.makeStackItem(tree.type);
    }

    @Override
    public Items.Item _case(Tree.NewArray tree, Environment<GenContext> env) {
        if (tree.elements != null) {
            Type elemtype = tree.type.elementType();
            this.loadIntConst(tree.elements.length());
            Items.Item arr = this.makeNewArray(tree.type, 1);
            int i = 0;
            List<Tree> l = tree.elements;
            while (l.nonEmpty()) {
                arr.duplicate();
                this.loadIntConst(i);
                ++i;
                this.genExpression(l.getFirst(), elemtype).load();
                this.items.makeIndexedItem(elemtype).store();
                l = l.getRest();
            }
            return arr;
        }
        List<Tree> l = tree.dimensions;
        while (l.nonEmpty()) {
            this.genExpression(l.getFirst(), Type.INT_TYPE).load();
            l = l.getRest();
        }
        return this.makeNewArray(tree.type, tree.dimensions.length());
    }

    Items.Item makeNewArray(Type type, int ndims) {
        Type elemtype = type.elementType();
        int elemcode = Code.arrayCode(elemtype);
        if (elemcode == 0 || elemcode == 1 && ndims == 1) {
            this.code.emitOpTwoBytes(189, this.mkref(elemtype));
        } else if (elemcode == 1) {
            this.code.emitOp(197, 1 - ndims);
            this.code.emitTwoBytes(this.mkref(type));
            this.code.emitOneByte(ndims);
        } else {
            this.code.emitOpByte(188, elemcode);
        }
        return this.items.makeStackItem(type);
    }

    @Override
    public Items.Item _case(Tree.Assign tree, Environment<GenContext> env) {
        Items.Item l = this.genExpression(tree.lhs, tree.lhs.type);
        if (l instanceof Items.StackItem) {
            throw new InternalError();
        }
        this.genExpression(tree.rhs, tree.lhs.type).load();
        return this.items.makeAssignItem(l);
    }

    @Override
    public Items.Item _case(Tree.AssignOp tree, Environment<GenContext> env) {
        Items.Item l = this.genExpression(tree.lhs, tree.lhs.type);
        if ((tree.tag == 60 || tree.tag == 61) && l instanceof Items.LocalItem && tree.lhs.type.tag <= 4 && tree.rhs.type.tag <= 4 && tree.rhs.type.constantValue != null) {
            int ival = ((Number)tree.rhs.type.constantValue).intValue();
            if (tree.tag == 61) {
                ival = -ival;
            }
            if (-128 <= ival && ival <= 127) {
                ((Items.LocalItem)l).incr(ival);
                return l;
            }
        }
        l.duplicate();
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        l.coerce(operator.type.argTypes().getFirst()).load();
        this.completeBinop(tree.lhs, tree.rhs, operator).coerce(tree.lhs.type);
        return this.items.makeAssignItem(l);
    }

    @Override
    public Items.Item _case(Tree.Operation tree, Environment<GenContext> env) {
        Symbol.OperatorSymbol operator = (Symbol.OperatorSymbol)tree.operator;
        Items.Item od = this.genExpression(tree.args.getFirst(), operator.type.argTypes().getFirst());
        switch (tree.tag) {
            case 38: {
                return od.load();
            }
            case 39: {
                od = od.load();
                this.code.emitOp(operator.opcode);
                return od;
            }
            case 40: {
                return od.mkCond().negate();
            }
            case 41: {
                od = od.load();
                this.emitMinusOne(od.typecode);
                this.code.emitOp(operator.opcode);
                return od;
            }
            case 42: 
            case 43: {
                od.duplicate();
                if (od instanceof Items.LocalItem && operator.opcode == 96) {
                    ((Items.LocalItem)od).incr(tree.tag == 42 ? 1 : 255);
                    return od;
                }
                od.load();
                this.code.emitOp(CodeGenerator.one(od.typecode));
                this.code.emitOp(operator.opcode);
                return this.items.makeAssignItem(od);
            }
            case 44: 
            case 45: {
                od.duplicate();
                if (od instanceof Items.LocalItem && operator.opcode == 96) {
                    Items.Item res = od.load();
                    ((Items.LocalItem)od).incr(tree.tag == 44 ? 1 : 255);
                    return res;
                }
                Items.Item res = od.load();
                od.stash(od.typecode);
                this.code.emitOp(CodeGenerator.one(od.typecode));
                this.code.emitOp(operator.opcode);
                od.store();
                return res;
            }
            case 46: {
                Items.CondItem lcond = od.mkCond();
                if (lcond.falseJumps != null || lcond.opcode != 167) {
                    Code.Chain trueJumps = lcond.jumpTrue();
                    this.code.resolve(lcond.falseJumps);
                    Items.CondItem rcond = this.genExpression(tree.args.getRest().getFirst(), tree.args.getRest().getFirst().type).mkCond();
                    return this.items.makeCondItem(rcond.opcode, Code.mergeChains(trueJumps, rcond.trueJumps), rcond.falseJumps);
                }
                return lcond;
            }
            case 47: {
                Items.CondItem lcond = od.mkCond();
                if (lcond.trueJumps != null || lcond.opcode != 168) {
                    Code.Chain falseJumps = lcond.jumpFalse();
                    this.code.resolve(lcond.trueJumps);
                    Items.CondItem rcond = this.genExpression(tree.args.getRest().getFirst(), tree.args.getRest().getFirst().type).mkCond();
                    return this.items.makeCondItem(rcond.opcode, rcond.trueJumps, Code.mergeChains(falseJumps, rcond.falseJumps));
                }
                return lcond;
            }
        }
        od.load();
        return this.completeBinop(tree.args.getFirst(), tree.args.getRest().getFirst(), operator);
    }

    Items.Item mkString(int pos, Type argtype) {
        Symbol valueOfSym = this.nameResolver.resolveQualifiedMethod(pos, this.analyzerContextEnv, this.symbolTable.STRING_TYPE, Names.valueOf, new ListBox<Type>(), Type.EMPTY_LIST.cons(argtype));
        if (valueOfSym.kind == 16) {
            return this.items.makeStaticItem(valueOfSym).invoke();
        }
        return this.items.makeStackItem(this.symbolTable.STRING_TYPE);
    }

    Items.Item completeBinop(Tree lhs, Tree rhs, Symbol.OperatorSymbol operator) {
        Type.MethodType optype = (Type.MethodType)operator.type;
        int opcode = operator.opcode;
        if (opcode == 256) {
            this.mkString(lhs.sourcePosition, lhs.type);
            this.genExpression(rhs, rhs.type).load();
            this.mkString(rhs.sourcePosition, rhs.type);
            Symbol concatSym = this.nameResolver.resolveQualifiedMethod(lhs.sourcePosition, this.analyzerContextEnv, this.symbolTable.STRING_TYPE, Names.concat, new ListBox<Type>(), Type.EMPTY_LIST.cons(this.symbolTable.STRING_TYPE));
            if (concatSym.kind == 16) {
                return this.items.makeMemberItem(concatSym, false).invoke();
            }
            return this.items.makeStackItem(this.symbolTable.STRING_TYPE);
        }
        Type rtype = operator.erasure().argTypes().getRest().getFirst();
        if (opcode >= 270 && opcode <= 275) {
            opcode += -150;
            rtype = Type.INT_TYPE;
        }
        this.genExpression(rhs, rtype).load();
        if (opcode >= 512) {
            this.code.emitOp(opcode >> 9);
            opcode &= 0xFF;
        }
        if (opcode >= 153 && opcode <= 166) {
            return this.items.makeCondItem(opcode);
        }
        this.code.emitOp(opcode);
        return this.items.makeStackItem(optype.returnType);
    }

    @Override
    public Items.Item _case(Tree.TypeCast tree, Environment<GenContext> env) {
        Items.Item result = this.genExpression(tree.expression, tree.castType.type).load();
        if (tree.castType.type.tag > 8 && tree.expression.type.asSuper(tree.castType.type.typeSymbol) == null) {
            this.code.emitOpTwoBytes(192, this.mkref(tree.castType.type));
        }
        return result;
    }

    @Override
    public Items.Item _case(Tree.InstanceofTest tree, Environment<GenContext> env) {
        this.genExpression(tree.expression, tree.expression.type).load();
        this.code.emitOpTwoBytes(193, this.mkref(tree.testedType.type));
        return this.items.makeStackItem(Type.BOOLEAN_TYPE);
    }

    @Override
    public Items.Item _case(Tree.IndexedArrayElement tree, Environment<GenContext> env) {
        this.genExpression(tree.indexedArray, tree.indexedArray.type).load();
        this.genExpression(tree.index, Type.INT_TYPE).load();
        return this.items.makeIndexedItem(tree.type);
    }

    @Override
    public Items.Item _case(Tree.Select tree, Environment<GenContext> env) {
        Symbol sym = tree.symbol;
        if (tree.name == Names._class) {
            return this.genClassOf(tree.sourcePosition, tree.selected.type);
        }
        if ((sym.flags() & 8) != 0) {
            return this.items.makeStaticItem(sym);
        }
        Symbol ssym = TreeInspector.symbol(tree.selected);
        boolean selectSuper = ssym != null && (ssym.kind == 2 || ssym.name == Names._super);
        Items.Item base = selectSuper ? this.items.makeSuperItem() : this.genExpression(tree.selected, tree.selected.type);
        base.load();
        if (sym == this.symbolTable.lengthField) {
            this.code.emitOp(190);
            return this.items.makeStackItem(Type.INT_TYPE);
        }
        return this.items.makeMemberItem(sym, (sym.flags() & 2) != 0 || selectSuper);
    }

    Items.Item genClassOf(int pos, Type type) {
        switch (type.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Name bname = Type.BOXED_NAME[type.tag];
                System.err.println(new StringBuffer().append("genClassOf ").append(bname).toString());
                Symbol.ClassSymbol c = this.symbolTable.classReader.enterClass(bname);
                Symbol typeSym = this.nameResolver.access(this.nameResolver.findIdentInType(this.analyzerContextEnv, c.type, Names.TYPE, 4), pos, c.type, Names.TYPE);
                if (typeSym.kind != 4) break;
                return this.items.makeStaticItem(typeSym);
            }
            case 10: 
            case 11: {
                this.items.makeImmediateItem(this.symbolTable.STRING_TYPE, this.symbolTable.classWriter.getExternalClassName(type).toString().replace('/', '.')).load();
                Symbol forNameSym = this.nameResolver.resolveQualifiedMethod(pos, this.analyzerContextEnv, this.symbolTable.CLASS_TYPE, Names.forName, new ListBox<Type>(), Type.EMPTY_LIST.cons(this.symbolTable.STRING_TYPE));
                if (forNameSym.kind != 16) break;
                return this.items.makeStaticItem(forNameSym).invoke();
            }
        }
        this.code.emitOp(1);
        return this.items.makeStackItem(this.symbolTable.CLASS_TYPE);
    }

    @Override
    public Items.Item _case(Tree.Ident tree, Environment<GenContext> env) {
        Symbol sym = tree.symbol;
        if (tree.name == Names._this || tree.name == Names._super) {
            Items.Item res;
            Items.Item item = res = tree.name == Names._this ? this.items.makeThisItem() : this.items.makeSuperItem();
            if (sym.kind == 16) {
                res.load();
                res = this.items.makeMemberItem(sym, true);
            }
            return res;
        }
        if (tree.name == Names._null) {
            this.code.emitOp(1);
            return this.items.makeStackItem(tree.type);
        }
        if (sym.kind == 4 && sym.owner.kind == 16) {
            Asserter._assert(((Symbol.VarSymbol)sym).address >= 0, new StringBuffer().append(sym).append(" ").append(sym.owner).append(" ").append(sym.owner.enclClass()).toString());
            return this.items.makeLocalItem((Symbol.VarSymbol)sym);
        }
        if ((sym.flags() & 8) != 0) {
            return this.items.makeStaticItem(sym);
        }
        this.items.makeThisItem().load();
        return this.items.makeMemberItem(sym, (sym.flags() & 2) != 0);
    }

    @Override
    public Items.Item _case(Tree.Literal tree, Environment<GenContext> env) {
        return this.items.makeImmediateItem(tree.type, tree.value);
    }

    public Items.Item _case(Tree tree) {
        throw new InternalError();
    }

    public void genClass(Environment<AnalyzerContext> env, Tree.ClassDef classDef) {
        this.analyzerContextEnv = env;
        Symbol.ClassSymbol classSymbol = classDef.classSymbol;
        classDef.members = this.normalizeDefs(classDef.members, classSymbol);
        classSymbol.constantPool = this.pool;
        this.pool.reset();
        this.items.setPool(this.pool);
        Environment<GenContext> localEnv = new Environment<GenContext>(classDef, new GenContext());
        localEnv.topLevel = env.topLevel;
        localEnv.enclosingClass = classDef;
        List<Tree> l = classDef.members;
        while (l.nonEmpty()) {
            l.getFirst().accept(this, localEnv);
            l = l.getRest();
        }
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Environment<GenContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    abstract class GenFinal
    implements ByteCodes {
        GenFinal() {
        }

        abstract void gen();
    }
}

