/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ConstantFolder
implements TypeTags,
ByteCodes {
    ErrorLog errorLog;
    SymbolTable symbolTable;
    static Integer minusOne = new Integer(-1);
    static Integer zero = new Integer(0);
    static Integer one = new Integer(1);

    ConstantFolder(ErrorLog log, SymbolTable syms) {
        this.errorLog = log;
        this.symbolTable = syms;
    }

    private static Integer b2i(boolean b) {
        return b ? one : zero;
    }

    private static int intValue(Object x) {
        return ((Number)x).intValue();
    }

    private static long longValue(Object x) {
        return ((Number)x).longValue();
    }

    private static float floatValue(Object x) {
        return ((Number)x).floatValue();
    }

    private static double doubleValue(Object x) {
        return ((Number)x).doubleValue();
    }

    Type fold(int pos, int opcode, List<Type> argtypes) {
        int argCount = argtypes.length();
        if (argCount == 1) {
            return this.fold1(pos, opcode, argtypes.getFirst());
        }
        if (argCount == 2) {
            return this.fold2(pos, opcode, argtypes.getFirst(), argtypes.getRest().getFirst());
        }
        throw new InternalError();
    }

    Type fold1(int pos, int opcode, Type operand) {
        try {
            Object od = operand.constantValue;
            switch (opcode) {
                case 0: {
                    return operand;
                }
                case 116: {
                    return Type.INT_TYPE.constType(new Integer(-ConstantFolder.intValue(od)));
                }
                case 130: {
                    return Type.INT_TYPE.constType(new Integer(~ConstantFolder.intValue(od)));
                }
                case 257: {
                    return Type.BOOLEAN_TYPE.constType(new Integer(~ConstantFolder.intValue(od) & 1));
                }
                case 153: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) == 0));
                }
                case 154: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) != 0));
                }
                case 155: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) < 0));
                }
                case 157: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) > 0));
                }
                case 158: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) <= 0));
                }
                case 156: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(od) >= 0));
                }
                case 117: {
                    return Type.LONG_TYPE.constType(new Long(-ConstantFolder.longValue(od)));
                }
                case 131: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(od) ^ 0xFFFFFFFFFFFFFFFFL));
                }
                case 118: {
                    return Type.FLOAT_TYPE.constType(new Float(-ConstantFolder.floatValue(od)));
                }
                case 119: {
                    return Type.DOUBLE_TYPE.constType(new Double(-ConstantFolder.doubleValue(od)));
                }
            }
            return null;
        }
        catch (ArithmeticException e) {
            this.errorLog.error(pos, e.toString());
            return Type.ERROR_TYPE;
        }
    }

    Type fold2(int pos, int opcode, Type left, Type right) {
        try {
            if (opcode > 511) {
                Type t1 = this.fold2(pos, opcode >> 9, left, right);
                return t1.constantValue == null ? t1 : this.fold1(pos, opcode & 0x1FF, t1);
            }
            Object l = left.constantValue;
            Object r = right.constantValue;
            switch (opcode) {
                case 96: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) + ConstantFolder.intValue(r)));
                }
                case 100: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) - ConstantFolder.intValue(r)));
                }
                case 104: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) * ConstantFolder.intValue(r)));
                }
                case 108: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) / ConstantFolder.intValue(r)));
                }
                case 112: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) % ConstantFolder.intValue(r)));
                }
                case 126: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) & ConstantFolder.intValue(r)));
                }
                case 258: {
                    return Type.BOOLEAN_TYPE.constType(new Integer(ConstantFolder.intValue(l) & ConstantFolder.intValue(r)));
                }
                case 128: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) | ConstantFolder.intValue(r)));
                }
                case 259: {
                    return Type.BOOLEAN_TYPE.constType(new Integer(ConstantFolder.intValue(l) | ConstantFolder.intValue(r)));
                }
                case 130: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) ^ ConstantFolder.intValue(r)));
                }
                case 120: 
                case 270: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) << ConstantFolder.intValue(r)));
                }
                case 122: 
                case 272: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) >> ConstantFolder.intValue(r)));
                }
                case 124: 
                case 274: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(l) >>> ConstantFolder.intValue(r)));
                }
                case 159: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) == ConstantFolder.intValue(r)));
                }
                case 160: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) != ConstantFolder.intValue(r)));
                }
                case 161: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) < ConstantFolder.intValue(r)));
                }
                case 163: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) > ConstantFolder.intValue(r)));
                }
                case 164: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) <= ConstantFolder.intValue(r)));
                }
                case 162: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(ConstantFolder.intValue(l) >= ConstantFolder.intValue(r)));
                }
                case 97: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) + ConstantFolder.longValue(r)));
                }
                case 101: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) - ConstantFolder.longValue(r)));
                }
                case 105: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) * ConstantFolder.longValue(r)));
                }
                case 109: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) / ConstantFolder.longValue(r)));
                }
                case 113: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) % ConstantFolder.longValue(r)));
                }
                case 127: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) & ConstantFolder.longValue(r)));
                }
                case 129: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) | ConstantFolder.longValue(r)));
                }
                case 131: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) ^ ConstantFolder.longValue(r)));
                }
                case 121: 
                case 271: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) << ConstantFolder.intValue(r)));
                }
                case 123: 
                case 273: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) >> ConstantFolder.intValue(r)));
                }
                case 125: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(l) >>> ConstantFolder.intValue(r)));
                }
                case 148: {
                    if (ConstantFolder.longValue(l) < ConstantFolder.longValue(r)) {
                        return Type.INT_TYPE.constType(minusOne);
                    }
                    if (ConstantFolder.longValue(l) > ConstantFolder.longValue(r)) {
                        return Type.INT_TYPE.constType(one);
                    }
                    return Type.INT_TYPE.constType(zero);
                }
                case 98: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(l) + ConstantFolder.floatValue(r)));
                }
                case 102: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(l) - ConstantFolder.floatValue(r)));
                }
                case 106: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(l) * ConstantFolder.floatValue(r)));
                }
                case 110: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(l) / ConstantFolder.floatValue(r)));
                }
                case 114: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(l) % ConstantFolder.floatValue(r)));
                }
                case 149: 
                case 150: {
                    if (ConstantFolder.floatValue(l) < ConstantFolder.floatValue(r)) {
                        return Type.INT_TYPE.constType(minusOne);
                    }
                    if (ConstantFolder.floatValue(l) > ConstantFolder.floatValue(r)) {
                        return Type.INT_TYPE.constType(one);
                    }
                    if (ConstantFolder.floatValue(l) == ConstantFolder.floatValue(r)) {
                        return Type.INT_TYPE.constType(zero);
                    }
                    if (opcode == 150) {
                        return Type.INT_TYPE.constType(one);
                    }
                    return Type.INT_TYPE.constType(minusOne);
                }
                case 99: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(l) + ConstantFolder.doubleValue(r)));
                }
                case 103: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(l) - ConstantFolder.doubleValue(r)));
                }
                case 107: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(l) * ConstantFolder.doubleValue(r)));
                }
                case 111: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(l) / ConstantFolder.doubleValue(r)));
                }
                case 115: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(l) % ConstantFolder.doubleValue(r)));
                }
                case 151: 
                case 152: {
                    if (ConstantFolder.doubleValue(l) < ConstantFolder.doubleValue(r)) {
                        return Type.INT_TYPE.constType(minusOne);
                    }
                    if (ConstantFolder.doubleValue(l) > ConstantFolder.doubleValue(r)) {
                        return Type.INT_TYPE.constType(one);
                    }
                    if (ConstantFolder.doubleValue(l) == ConstantFolder.doubleValue(r)) {
                        return Type.INT_TYPE.constType(zero);
                    }
                    if (opcode == 152) {
                        return Type.INT_TYPE.constType(one);
                    }
                    return Type.INT_TYPE.constType(minusOne);
                }
                case 165: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(l.equals(r)));
                }
                case 166: {
                    return Type.BOOLEAN_TYPE.constType(ConstantFolder.b2i(!l.equals(r)));
                }
                case 256: {
                    return this.symbolTable.STRING_TYPE.constType(new StringBuffer().append(left.constantValue.toString()).append(right.constantValue.toString()).toString());
                }
            }
            return null;
        }
        catch (ArithmeticException e) {
            this.errorLog.error(pos, e.toString());
            return Type.ERROR_TYPE;
        }
    }

    Type coerce(Type etype, Type ttype) {
        if (etype.tag == ttype.tag) {
            return etype;
        }
        if (etype.tag <= 7) {
            Object n = etype.constantValue;
            switch (ttype.tag) {
                case 1: {
                    return Type.BYTE_TYPE.constType(new Integer((byte)ConstantFolder.intValue(n)));
                }
                case 2: {
                    return Type.CHAR_TYPE.constType(new Integer((char)ConstantFolder.intValue(n)));
                }
                case 3: {
                    return Type.SHORT_TYPE.constType(new Integer((short)ConstantFolder.intValue(n)));
                }
                case 4: {
                    return Type.INT_TYPE.constType(new Integer(ConstantFolder.intValue(n)));
                }
                case 5: {
                    return Type.LONG_TYPE.constType(new Long(ConstantFolder.longValue(n)));
                }
                case 6: {
                    return Type.FLOAT_TYPE.constType(new Float(ConstantFolder.floatValue(n)));
                }
                case 7: {
                    return Type.DOUBLE_TYPE.constType(new Double(ConstantFolder.doubleValue(n)));
                }
            }
        }
        return ttype;
    }
}

