/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.tree.Tree;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Environment<A extends PrintableObject>
extends PrintableObject {
    public static int count = 0;
    public final A context;
    public Environment<A> enclosingEnv = null;
    public Tree tree;
    public Tree.TopLevel topLevel;
    public Environment<A> enclosingClassEnv = null;
    public Tree.ClassDef enclosingClass;
    public Tree.MethodDef enclosingMethod;

    public Environment(Tree tree, A context) {
        this.tree = tree;
        this.topLevel = null;
        this.enclosingClass = null;
        this.enclosingMethod = null;
        this.context = context;
    }

    public Environment<A> spawn(Tree tree, A info) {
        Environment<A> that = new Environment<A>(tree, info);
        that.enclosingEnv = this;
        that.enclosingClassEnv = this.enclosingClassEnv;
        that.topLevel = this.topLevel;
        that.enclosingClass = this.enclosingClass;
        that.enclosingMethod = this.enclosingMethod;
        return that;
    }

    public Environment<A> spawn(Tree tree) {
        return this.spawn(tree, this.context);
    }

    public Environment<A> enclosing(int tag) {
        Environment<A> env1 = this;
        while (env1 != null && env1.tree.tag != tag) {
            env1 = env1.enclosingEnv;
        }
        return env1;
    }

    @Override
    public void print() {
        Environment.leftBracket();
        Environment.print("Environment ");
        Environment.newline();
        Environment.include(this.context);
        Environment.newline();
        Environment.include(this.tree);
        Environment.rightBracket();
        if (this.enclosingEnv != null) {
            Environment.newline();
            Environment.include(this.enclosingEnv);
        }
    }
}

