/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.NameResolver;
import edu.rice.cs.nextgen.compiler.comp.StaticAnalyzer;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeChecker;
import edu.rice.cs.nextgen.compiler.comp.VoidContext;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Set;
import java.io.File;
import java.io.IOException;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymbolEnterer
extends Tree.Visitor<Type, Environment<AnalyzerContext>>
implements Flags,
Kinds,
TypeTags {
    private final ErrorLog errorLog;
    private final SymbolTable symbolTable;
    private final NameResolver nameResolver;
    private final TypeChecker typeChecker;
    private final TreeMaker treeMaker;
    private final MemberEnterer phase2;
    private final ListBox<Environment<AnalyzerContext>> toDo = new ListBox();
    private final ListBox<Environment<AnalyzerContext>> halfcompleted = new ListBox();
    private final Tree.ClassDef predefClassDef;
    private final CompilerOptions options;
    private ListBox<Symbol.ClassSymbol> uncompleted;
    final Hashtable<Symbol.ClassSymbol, Environment<AnalyzerContext>> classEnvs = new Hashtable();
    Set<Name> compiled;
    StaticAnalyzer staticAnalyzer;
    private boolean completionEnabled = true;

    public SymbolEnterer(ErrorLog log, SymbolTable syms, NameResolver rs, TypeChecker chk, TreeMaker make, StaticAnalyzer attr, CompilerOptions options) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.nameResolver = rs;
        this.typeChecker = chk;
        this.treeMaker = make;
        this.staticAnalyzer = attr;
        if (attr != null) {
            attr.symbolEnterer = this;
        }
        this.phase2 = new MemberEnterer();
        this.predefClassDef = new Tree.ClassDef(1, syms.predefinedSymbolOwner.name, null, null, null, null, syms.predefinedSymbolOwner);
        this.options = options;
    }

    private static boolean classNameMatchesFileName(Symbol.ClassSymbol c, Environment<AnalyzerContext> env) {
        String fname = env.topLevel.sourcefile.toString();
        String cname = new StringBuffer().append(c.name).append(".java").toString();
        try {
            return SymbolEnterer.endsWith(fname, cname) || SymbolEnterer.endsWith(new File(fname).getCanonicalPath(), cname);
        }
        catch (IOException ex) {
            return false;
        }
    }

    private static boolean endsWith(String pathname, String filename) {
        return pathname.endsWith(filename) && (pathname.length() == filename.length() || pathname.charAt(pathname.length() - filename.length() - 1) == File.separatorChar);
    }

    static Tree SuperCall(TreeMaker make, List<Tree.VarDef> params, boolean based) {
        Tree meth;
        if (based) {
            meth = make.newSelect(make.newIdent(params.getFirst()), Names._super);
            params = params.getRest();
        } else {
            meth = make.newIdent(Names._super);
        }
        return make.newExpressionStatement(make.newApply(meth, make.newIdents(params)));
    }

    Tree DefaultConstructor(TreeMaker treeMaker, Symbol.ClassSymbol classSymbol, List<Type> argtypes, boolean based) {
        List<Tree.VarDef> params = treeMaker.newVarDefs(argtypes, Symbol.NO_SYMBOL);
        List<Tree> body = Tree.EMPTY_LIST;
        if (classSymbol.type != this.symbolTable.OBJECT_TYPE) {
            body = body.cons(SymbolEnterer.SuperCall(treeMaker, params, based));
        }
        return treeMaker.newMethodDef(classSymbol.flags() & 5, Names.init, null, Tree.TypeParameter.emptyList, params, Tree.EMPTY_LIST, treeMaker.newBlock(0, body));
    }

    private void duplicateError(int pos, Symbol sym) {
        this.errorLog.error(pos, new StringBuffer().append(sym).append(" is already defined").append(sym.location()).toString());
    }

    private boolean checkUnique(int pos, Symbol sym, Scope s) {
        Scope.Entry e = s.lookup(sym.name);
        while (e.scope == s) {
            if (sym != e.symbol && sym.kind == e.symbol.kind && sym.name != Names.error && (sym.kind != 16 || sym.type.sameArgs(e.symbol.type))) {
                this.duplicateError(pos, e.symbol);
                return false;
            }
            e = e.next();
        }
        return true;
    }

    private void checkTransparentVar(int pos, Symbol.VarSymbol v, Scope s) {
        if (s.nextScope != null) {
            Scope.Entry e = s.nextScope.lookup(v.name);
            while (e.scope != null && e.symbol.owner == v.owner) {
                if (e.symbol.kind == 4 && e.symbol.owner.kind == 16 && v.name != Names.error) {
                    this.duplicateError(pos, e.symbol);
                    return;
                }
                e = e.next();
            }
        }
    }

    private boolean checkUniqueClassName(int pos, Name name, Scope s) {
        Scope.Entry e = s.lookup(name);
        while (e.scope == s) {
            if (e.symbol.kind == 2 && e.symbol.name != Names.error) {
                this.duplicateError(pos, e.symbol);
                return false;
            }
            e = e.next();
        }
        Symbol sym = s.owningSymbol;
        while (sym != null) {
            if (sym.kind == 2 && sym.name == name && sym.name != Names.error) {
                this.duplicateError(pos, sym);
                return true;
            }
            sym = sym.owner;
        }
        return true;
    }

    private boolean checkDisjoint(int pos, int flags, int set1, int set2) {
        if ((flags & set1) != 0 && (flags & set2) != 0) {
            this.errorLog.error(pos, new StringBuffer().append("illegal combination of modifiers: ").append(TreeInspector.flagNames(TreeInspector.firstFlag(flags & set1))).append(" and ").append(TreeInspector.flagNames(TreeInspector.firstFlag(flags & set2))).toString());
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private int checkFlags(int pos, int flags, Symbol sym) {
        void var4_5;
        int implicit = 0;
        switch (sym.kind) {
            case 4: {
                int mask;
                if (sym.owner.kind != 2) {
                    mask = 16;
                    break;
                }
                if ((sym.owner.flags() & 0x200) != 0) {
                    implicit = 25;
                    mask = 25;
                    break;
                }
                mask = 223;
                break;
            }
            case 16: {
                int mask;
                if (sym.name == Names.init) {
                    mask = 7;
                } else if ((sym.owner.flags() & 0x200) != 0) {
                    implicit = 1025;
                    mask = 1025;
                } else {
                    mask = 3391;
                }
                implicit |= sym.owner.flags_field & 0x800;
                break;
            }
            case 2: {
                int mask;
                if (sym.isLocal()) {
                    mask = 3600;
                    if (sym.name.length == 0) {
                        mask |= 8;
                    }
                } else if (sym.owner.kind == 2) {
                    mask = 3607;
                    if (sym.owner.owner.kind == 1 || (sym.owner.flags_field & 8) != 0) {
                        mask |= 8;
                    }
                    if ((flags & 0x200) != 0) {
                        implicit = 8;
                    }
                } else {
                    mask = 3601;
                }
                if ((flags & 0x200) != 0) {
                    implicit |= 0x400;
                }
                implicit |= sym.owner.flags_field & 0x800;
                break;
            }
            default: {
                throw new InternalError();
            }
        }
        int illegal = flags & 0x7FF & ~var4_5;
        if (illegal != 0) {
            this.errorLog.error(pos, new StringBuffer().append("modifier ").append(TreeInspector.flagNames(illegal)).append(" not allowed here").toString());
        } else if (sym.kind != 2 && !this.checkDisjoint(pos, flags, 1024, 10) || !this.checkDisjoint(pos, flags, 1536, 304) || !this.checkDisjoint(pos, flags, 1, 6) || !this.checkDisjoint(pos, flags, 2, 5) || !this.checkDisjoint(pos, flags, 16, 64) || sym.kind == 2 || this.checkDisjoint(pos, flags, 1280, 2048)) {
            // empty if block
        }
        return flags & (var4_5 | 0xFFFFF800) | implicit;
    }

    Environment<AnalyzerContext> methodEnv(Tree.MethodDef tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> localEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy(((AnalyzerContext)env.context).scope.extend()));
        localEnv.enclosingMethod = tree;
        ((AnalyzerContext)localEnv.context).scope.owningSymbol = tree.methodSymbol;
        if ((tree.flags & 8) != 0) {
            ++((AnalyzerContext)localEnv.context).staticLevel;
        }
        return localEnv;
    }

    Environment<AnalyzerContext> classEnv(Tree.ClassDef tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> localEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy(new Scope(tree.classSymbol)));
        localEnv.enclosingClass = tree;
        localEnv.enclosingClassEnv = env;
        return localEnv;
    }

    Environment<AnalyzerContext> topLevelEnv(Tree.TopLevel tree) {
        Environment<AnalyzerContext> localEnv = new Environment<AnalyzerContext>(tree, new AnalyzerContext());
        localEnv.topLevel = tree;
        localEnv.enclosingClass = this.predefClassDef;
        tree.namedImportScope = new Scope(tree.packageSymbol);
        tree.starImportScope = new Scope(tree.packageSymbol);
        ((AnalyzerContext)localEnv.context).scope = tree.namedImportScope;
        return localEnv;
    }

    Environment<AnalyzerContext> initEnv(Tree.VarDef tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> localEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy());
        if (tree.varSymbol.owner.kind == 2) {
            ((AnalyzerContext)localEnv.context).scope = ((AnalyzerContext)env.context).scope.extend();
            ((AnalyzerContext)localEnv.context).scope.owningSymbol = tree.varSymbol;
        }
        if ((tree.flags & 8) != 0 || (env.enclosingClass.classSymbol.flags() & 0x200) != 0) {
            ++((AnalyzerContext)localEnv.context).staticLevel;
        }
        return localEnv;
    }

    Scope enterScope(Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> env1 = env;
        while (true) {
            switch (env1.tree.tag) {
                case 1: {
                    return ((Tree.TopLevel)env1.tree).namedImportScope;
                }
                case 3: {
                    return ((Tree.ClassDef)env1.tree).classSymbol.members_field;
                }
                case 4: 
                case 6: 
                case 11: 
                case 15: {
                    return ((AnalyzerContext)env.context).scope;
                }
            }
            env1 = env1.enclosingEnv;
        }
    }

    Type classEnter(Tree tree, Environment<AnalyzerContext> env) {
        try {
            return tree.accept(this, env);
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeChecker.completionError(tree.sourcePosition, ex);
        }
    }

    <T extends Tree> List<Type> classEnter(List<T> trees, Environment<AnalyzerContext> env) {
        ListBox<Type> types = new ListBox<Type>();
        List<T> l = trees;
        while (l.nonEmpty()) {
            types.insertEnd(this.classEnter((Tree)l.getFirst(), env));
            l = l.getRest();
        }
        return types.toList();
    }

    void memberEnter(Tree tree, Environment<AnalyzerContext> env) {
        try {
            tree.accept(this.phase2, env);
        }
        catch (Symbol.CompletionFailure ex) {
            this.typeChecker.completionError(tree.sourcePosition, ex);
        }
    }

    <T extends Tree> void memberEnter(List<T> trees, Environment<AnalyzerContext> env) {
        List<T> l = trees;
        while (l.nonEmpty()) {
            this.memberEnter((Tree)l.getFirst(), env);
            l = l.getRest();
        }
    }

    @Override
    public Type _case(Tree.TopLevel tree, Environment<AnalyzerContext> env) {
        Name prev = this.errorLog.useSource(tree.sourcefile);
        tree.packageSymbol = tree.packageId != null ? this.symbolTable.classReader.enterPackage(TreeInspector.fullName(tree.packageId)) : Symbol.EMPTY_PACKAGE_SYMBOL;
        tree.packageSymbol.complete();
        this.classEnter(tree.members, this.topLevelEnv(tree));
        this.errorLog.useSource(prev);
        return null;
    }

    @Override
    public Type _case(Tree.ClassDef tree, Environment<AnalyzerContext> env) {
        Symbol.ClassSymbol c;
        Symbol owner = ((AnalyzerContext)env.context).scope.owningSymbol;
        Scope enclScope = this.enterScope(env);
        if (owner.kind == 1) {
            Symbol.PackageSymbol packge = (Symbol.PackageSymbol)owner;
            c = this.symbolTable.classReader.enterClass(tree.name, packge);
            packge.members().addSymbolIfAbsent(c);
            if ((tree.flags & 1) != 0 && !SymbolEnterer.classNameMatchesFileName(c, env)) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("class ").append(tree.name).append(" is public, should be declared in a file named ").append(tree.name).append(".java").toString());
            }
            if (this.compiled.contains(c.fullname)) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("duplicate class: ").append(c.fullname).toString());
                return null;
            }
            this.compiled.put(c.fullname);
        } else {
            if (tree.name.length != 0 && !this.checkUniqueClassName(tree.sourcePosition, tree.name, enclScope)) {
                return null;
            }
            if (owner.kind == 2) {
                c = this.symbolTable.classReader.enterClass(tree.name, (Symbol.TypeSymbol)owner);
                if ((owner.flags_field & 0x200) != 0) {
                    tree.flags |= 9;
                }
            } else {
                c = this.symbolTable.classReader.defineClass(tree.name, owner);
                c.flatname = this.localClassName(c, env);
            }
        }
        enclScope.addSymbol(c);
        tree.classSymbol = c;
        Environment<AnalyzerContext> localEnv = this.classEnv(tree, env);
        c.completer = new CompleteEnter(localEnv);
        c.flags_field = this.checkFlags(tree.sourcePosition, tree.flags, c);
        c.sourcefile = env.topLevel.sourcefile;
        c.members_field = new Scope(c);
        Type.ClassType ct = (Type.ClassType)c.type;
        ct.typeParams = this.classEnter(tree.typeParams, localEnv);
        if (owner.kind != 1 && (c.flags_field & 8) == 0) {
            Environment<AnalyzerContext> env1 = env;
            Symbol owner1 = owner;
            while ((owner1.kind & 0x14) != 0 && (owner1.flags() & 8) != 0) {
                env1 = env1.enclosingClassEnv;
                owner1 = ((AnalyzerContext)env1.context).scope.owningSymbol;
            }
            if (owner1.kind != 1) {
                ct.enclosingInstanceType = owner.enclClass().type;
            }
        }
        if (!c.isLocal() && this.uncompleted != null) {
            this.uncompleted.insertEnd(c);
        }
        this.classEnter(tree.members, localEnv);
        return c.type;
    }

    Name localClassName(Symbol.ClassSymbol c, Environment<AnalyzerContext> env) {
        int suffix = ((AnalyzerContext)env.context).getLocalClassCount();
        ((AnalyzerContext)env.context).incrementLocalClassCount();
        return Name.fromString(new StringBuffer().append(c.outermostClass().fullName()).append("$").append(suffix).append(c.name.length == 0 ? "" : new StringBuffer().append("$").append(c.name).toString()).toString());
    }

    @Override
    public Type _case(Tree.TypeParameter tree, Environment<AnalyzerContext> env) {
        Type.TypeVar a = new Type.TypeVar(null, tree.name, ((AnalyzerContext)env.context).scope.owningSymbol);
        tree.type = a;
        if (this.checkUnique(tree.sourcePosition, a.typeSymbol, ((AnalyzerContext)env.context).scope)) {
            ((AnalyzerContext)env.context).scope.addSymbol(a.typeSymbol);
        }
        return a;
    }

    @Override
    public Type _case(Tree tree, Environment<AnalyzerContext> env) {
        return null;
    }

    public List<Environment<AnalyzerContext>> enterClasses(List<Tree> trees) {
        ListBox<Symbol.ClassSymbol> prevUncompleted = this.uncompleted;
        this.compiled = Set.make();
        this.uncompleted = new ListBox();
        this.classEnter(trees, null);
        List<Symbol.ClassSymbol> tocomplete = this.uncompleted.toList();
        if (this.completionEnabled) {
            List<Symbol.ClassSymbol> l = tocomplete;
            while (l.nonEmpty()) {
                l.getFirst().complete();
                l = l.getRest();
            }
        }
        this.uncompleted = prevUncompleted;
        return this.toDo.toList();
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class EnvAttrContextBox {
        Environment<AnalyzerContext> env;

        EnvAttrContextBox(Environment<AnalyzerContext> env) {
            this.env = env;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class CompleteEnter
    implements Symbol.Completer,
    Kinds,
    Flags,
    TypeTags {
        Environment<AnalyzerContext> env;

        CompleteEnter(Environment<AnalyzerContext> env) {
            this.env = env;
        }

        @Override
        public void complete(Symbol sym) throws Symbol.CompletionFailure {
            if (!SymbolEnterer.this.completionEnabled) {
                sym.completer = this;
                return;
            }
            Name prev = SymbolEnterer.this.errorLog.useSource(this.env.topLevel.sourcefile);
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
            Type.ClassType ct = (Type.ClassType)c.type;
            Tree.ClassDef tree = (Tree.ClassDef)this.env.tree;
            boolean isOutermost = SymbolEnterer.this.halfcompleted.isEmpty();
            try {
                SymbolEnterer.this.halfcompleted.insertEnd(this.env);
                SymbolEnterer.this.classEnvs.put(c, this.env);
                SymbolEnterer.this.memberEnter(this.env.topLevel, this.env.enclosing(1));
                c.flags_field |= 0x600000;
                if (c.owner.kind == 2) {
                    c.owner.complete();
                } else if (c.owner.kind == 1) {
                    SymbolEnterer.this.toDo.insertEnd(this.env);
                }
                ct.parentType = c.fullname == Names.java_lang_Object ? Type.NO_TYPE : (tree.extendedClass == null ? ((SymbolEnterer)SymbolEnterer.this).symbolTable.OBJECT_TYPE : this.attribBase(tree.extendedClass, this.env, 0));
                ListBox<Type> interfaces = new ListBox<Type>();
                Set interfaceSet = Set.make();
                List<Tree> l = tree.implementedInterfaces;
                while (l.nonEmpty()) {
                    Type i = this.attribBase(l.getFirst(), this.env, 512);
                    if (i.tag == 10) {
                        interfaces.insertEnd(i);
                        if (interfaceSet.contains(i)) {
                            SymbolEnterer.this.errorLog.error(l.getFirst().sourcePosition, "repeated interface");
                        } else {
                            interfaceSet.put(i);
                        }
                    }
                    l = l.getRest();
                }
                ct.interfaces = interfaces.toList();
                c.flags_field &= 0xFFDFFFFF;
                SymbolEnterer.this.staticAnalyzer.attributeStatements(tree.typeParams, this.env);
                if ((c.flags() & 0x200) == 0 && !TreeInspector.hasConstructors(tree.members)) {
                    List<Type> argtypes = Type.EMPTY_LIST;
                    boolean based = false;
                    if (c.name.length == 0) {
                        Tree.NewInstance nc = (Tree.NewInstance)this.env.enclosingEnv.tree;
                        if (nc.constructor != null) {
                            argtypes = c.type.memberType(nc.constructor).argTypes();
                            if (nc.enclosingClassPrefix != null) {
                                argtypes = argtypes.cons(nc.enclosingClassPrefix.type);
                                based = true;
                            }
                        }
                    }
                    Tree constrDef = SymbolEnterer.this.DefaultConstructor(SymbolEnterer.this.treeMaker.at(tree.sourcePosition), c, argtypes, based);
                    tree.members = tree.members.cons(constrDef);
                }
            }
            catch (Symbol.CompletionFailure ex) {
                SymbolEnterer.this.typeChecker.completionError(tree.sourcePosition, ex);
            }
            SymbolEnterer.this.errorLog.useSource(prev);
            if (isOutermost) {
                while (SymbolEnterer.this.halfcompleted.nonEmpty()) {
                    this.finish((Environment)SymbolEnterer.this.halfcompleted.getFirst());
                    SymbolEnterer.this.halfcompleted.remove();
                }
            }
        }

        private void finish(Environment<AnalyzerContext> env) {
            Name prev = SymbolEnterer.this.errorLog.useSource(env.topLevel.sourcefile);
            Tree.ClassDef tree = (Tree.ClassDef)env.tree;
            Symbol.ClassSymbol c = tree.classSymbol;
            SymbolEnterer.this.memberEnter(tree.members, env);
            SymbolEnterer.this.errorLog.useSource(prev);
        }

        private Type attribBase(Tree tree, Environment<AnalyzerContext> env, int interfaceFlag) {
            Type t = SymbolEnterer.this.staticAnalyzer.attributeBaseType(tree, env, interfaceFlag);
            if ((t.typeSymbol.flags() & 0x200000) != 0 && (t.typeSymbol.flags() & 0x200) == (env.enclosingClass.classSymbol.flags() & 0x200)) {
                SymbolEnterer.this.errorLog.error(tree.sourcePosition, new StringBuffer().append("cyclic inheritance involving ").append(t.typeSymbol).toString());
                return Type.ERROR_TYPE;
            }
            return t;
        }

        List<Type> argTypes(List<Tree> trees) {
            ListBox<Type> tps = new ListBox<Type>();
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                tps.insertEnd(l.getFirst().type.tag == 16 ? ((SymbolEnterer)SymbolEnterer.this).symbolTable.OBJECT_TYPE : l.getFirst().type);
                l = l.getRest();
            }
            return tps.toList();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MemberEnterer
    extends Tree.Visitor<VoidContext, Environment<AnalyzerContext>>
    implements Kinds,
    Flags,
    TypeTags {
        MemberEnterer() {
        }

        private boolean included(Symbol c, Scope scope) {
            Scope.Entry e = scope.lookup(c.name);
            while (e.scope == scope) {
                if (e.symbol.kind == c.kind && e.symbol.fullName() == c.fullName()) {
                    return true;
                }
                e = e.next();
            }
            return false;
        }

        private void importAll(int pos, Symbol.TypeSymbol tsym, Scope scope) {
            if (tsym.kind == 1 && !tsym.exists()) {
                SymbolEnterer.this.errorLog.error(pos, new StringBuffer().append(tsym).append(" does not exist").toString());
            }
            Scope.Entry e = tsym.members().entries;
            while (e != null) {
                if (e.symbol.kind == 2 && !this.included(e.symbol, scope)) {
                    scope.addSymbol(e.symbol);
                }
                e = e.sibling;
            }
        }

        private void importNamed(int pos, Symbol tsym, Scope scope) {
            if (tsym.kind == 2 && SymbolEnterer.this.checkUnique(pos, tsym, scope)) {
                scope.addSymbol(tsym);
            }
        }

        Type signature(List<Tree.TypeParameter> typarams, List<Tree.VarDef> params, Tree res, List<Tree> thrown, Environment<AnalyzerContext> env) {
            List<Type> tvars = SymbolEnterer.this.classEnter(typarams, env);
            SymbolEnterer.this.staticAnalyzer.attributeStatements(typarams, env);
            ListBox<Type> argbuf = new ListBox<Type>();
            List<Tree.VarDef> l = params;
            while (l.nonEmpty()) {
                argbuf.insertEnd(SymbolEnterer.this.staticAnalyzer.attributeType(l.getFirst().varType, env));
                l = l.getRest();
            }
            Type restype = res == null ? Type.VOID_TYPE : SymbolEnterer.this.staticAnalyzer.attributeType(res, env);
            ListBox<Symbol.ClassSymbol> thrownbuf = new ListBox<Symbol.ClassSymbol>();
            List<Tree> l2 = thrown;
            while (l2.nonEmpty()) {
                thrownbuf.insertEnd((Symbol.ClassSymbol)SymbolEnterer.this.staticAnalyzer.attributeType((Tree)l2.getFirst(), env).typeSymbol);
                l2 = l2.getRest();
            }
            Type.MethodType mtype = new Type.MethodType(argbuf.toList(), restype, thrownbuf.toList());
            return tvars.isEmpty() ? mtype : new Type.ForAll(tvars, mtype);
        }

        @Override
        public VoidContext _case(Tree.TopLevel tree, Environment<AnalyzerContext> env) {
            this.importAll(tree.sourcePosition, ((SymbolEnterer)SymbolEnterer.this).symbolTable.classReader.enterPackage(Names.java_lang), env.topLevel.starImportScope);
            SymbolEnterer.this.memberEnter(tree.members, env);
            return null;
        }

        @Override
        public VoidContext _case(Tree.Import tree, Environment<AnalyzerContext> env) {
            Tree imp = tree.importedClass;
            Name name = TreeInspector.name(imp);
            SymbolEnterer.this.completionEnabled = false;
            if (imp.tag == 30) {
                Symbol.TypeSymbol p = SymbolEnterer.this.staticAnalyzer.attributeTerm((Tree)((Tree.Select)imp).selected, env, (int)3, (Type)Type.NO_TYPE).typeSymbol;
                if (name == Names.star) {
                    this.importAll(tree.sourcePosition, p, env.topLevel.starImportScope);
                } else {
                    Symbol.TypeSymbol c = SymbolEnterer.this.staticAnalyzer.attributeType((Tree)imp, env).typeSymbol;
                    this.importNamed(tree.sourcePosition, c, env.topLevel.namedImportScope);
                }
            } else {
                this.importNamed(tree.sourcePosition, SymbolEnterer.this.nameResolver.access(SymbolEnterer.this.nameResolver.findIdentInPackage(env, Symbol.EMPTY_PACKAGE_SYMBOL, name, 2), tree.sourcePosition, env.enclosingClass.classSymbol.type, name), env.topLevel.namedImportScope);
            }
            SymbolEnterer.this.completionEnabled = true;
            return null;
        }

        @Override
        public VoidContext _case(Tree.MethodDef tree, Environment<AnalyzerContext> env) {
            Scope enclScope = SymbolEnterer.this.enterScope(env);
            Symbol.MethodSymbol m = new Symbol.MethodSymbol(0, tree.name, null, enclScope.owningSymbol);
            if (SymbolEnterer.this.options.retrofitMode() && m.name != Names.init) {
                tree.flags |= 0x400;
            }
            m.flags_field = SymbolEnterer.this.checkFlags(tree.sourcePosition, tree.flags, m);
            tree.methodSymbol = m;
            Environment<AnalyzerContext> localEnv = SymbolEnterer.this.methodEnv(tree, env);
            m.type = this.signature(tree.typeParams, tree.params, tree.returnType, tree.thrown, localEnv);
            ((AnalyzerContext)localEnv.context).scope.leave();
            if (SymbolEnterer.this.checkUnique(tree.sourcePosition, m, enclScope)) {
                enclScope.addSymbol(m);
            }
            return null;
        }

        @Override
        public VoidContext _case(Tree.VarDef tree, Environment<AnalyzerContext> env) {
            SymbolEnterer.this.staticAnalyzer.attributeType(tree.varType, env);
            Scope enclScope = SymbolEnterer.this.enterScope(env);
            Symbol.VarSymbol v = new Symbol.VarSymbol(0, tree.name, tree.varType.type, enclScope.owningSymbol);
            v.flags_field = SymbolEnterer.this.checkFlags(tree.sourcePosition, tree.flags, v);
            tree.varSymbol = v;
            if ((v.flags_field & 0x10) != 0 && tree.initialization != null) {
                v.constantValue = new EnvAttrContextBox(SymbolEnterer.this.initEnv(tree, env));
            }
            if (SymbolEnterer.this.checkUnique(tree.sourcePosition, v, enclScope)) {
                SymbolEnterer.this.checkTransparentVar(tree.sourcePosition, v, enclScope);
                enclScope.addSymbol(v);
            }
            v.position = tree.sourcePosition;
            return null;
        }

        @Override
        public VoidContext _case(Tree tree, Environment<AnalyzerContext> env) {
            return null;
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object x1) {
            return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
            return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
            return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
            return super._case(x0, (Environment)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
            return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
            return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
        }
    }
}

