/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.ClassWriter;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

public class SymbolTable
extends PrintableObject
implements Flags,
ByteCodes {
    public final ClassReader classReader;
    public final ClassWriter classWriter;
    public final Type OBJECT_TYPE;
    public final Type CLASS_TYPE;
    public final Type STRING_TYPE;
    public final Type CLONEABLE_TYPE;
    public final Type THROWABLE_TYPE;
    public final Type ERROR_TYPE;
    public final Type EXCEPTION_TYPE;
    public final Type RUNTIME_EXCEPTION_TYPE;
    public final Symbol.VarSymbol NULL_SYMBOL;
    public final Symbol.VarSymbol TRUE_SYMBOL;
    public final Symbol.VarSymbol FALSE_SYMBOL;
    public final Symbol.VarSymbol lengthField;
    public final Symbol.ClassSymbol predefinedSymbolOwner = new Symbol.ClassSymbol(1, Names.empty, Symbol.EMPTY_PACKAGE_SYMBOL);

    private Symbol.VarSymbol enterConstant(String name, Type type) {
        Symbol.VarSymbol c = new Symbol.VarSymbol(25, Name.fromString(name), type, this.predefinedSymbolOwner);
        c.constantValue = type.constantValue;
        this.predefinedSymbolOwner.members().addSymbol(c);
        return c;
    }

    private void enterBinaryOp(String name, Type left, Type right, Type res, int opcode) {
        this.predefinedSymbolOwner.members().addSymbol(new Symbol.OperatorSymbol(Name.fromString(name), new Type.MethodType(new Cons<Type>(right).cons(left), res, Symbol.ClassSymbol.EMPTY_LIST), opcode, (Symbol)this.predefinedSymbolOwner));
    }

    private void enterBinop(String name, Type left, Type right, Type res, int opcode1, int opcode2) {
        this.enterBinaryOp(name, left, right, res, opcode1 << 9 | opcode2);
    }

    private void enterUnop(String name, Type arg, Type res, int opcode) {
        this.predefinedSymbolOwner.members().addSymbol(new Symbol.OperatorSymbol(Name.fromString(name), new Type.MethodType(new Cons<Type>(arg), res, Symbol.ClassSymbol.EMPTY_LIST), opcode, (Symbol)this.predefinedSymbolOwner));
    }

    private Type enterClass(String s) {
        return this.classReader.enterClass((Name)Name.fromString((String)s)).type;
    }

    public SymbolTable(CompilerOptions options) throws Symbol.CompletionFailure {
        Scope scope;
        this.predefinedSymbolOwner.members_field = scope = new Scope(this.predefinedSymbolOwner);
        this.classReader = new ClassReader(options);
        this.classWriter = new ClassWriter(options);
        this.classReader.classes.put(this.predefinedSymbolOwner.fullname, this.predefinedSymbolOwner);
        scope.addSymbol(Type.BYTE_TYPE.typeSymbol);
        scope.addSymbol(Type.SHORT_TYPE.typeSymbol);
        scope.addSymbol(Type.CHAR_TYPE.typeSymbol);
        scope.addSymbol(Type.INT_TYPE.typeSymbol);
        scope.addSymbol(Type.LONG_TYPE.typeSymbol);
        scope.addSymbol(Type.FLOAT_TYPE.typeSymbol);
        scope.addSymbol(Type.DOUBLE_TYPE.typeSymbol);
        scope.addSymbol(Type.BOOLEAN_TYPE.typeSymbol);
        scope.addSymbol(Type.ERROR_TYPE.typeSymbol);
        this.OBJECT_TYPE = this.enterClass("java.lang.Object");
        this.CLASS_TYPE = this.enterClass("java.lang.Class");
        this.STRING_TYPE = this.enterClass("java.lang.String");
        this.CLONEABLE_TYPE = this.enterClass("java.lang.Cloneable");
        this.THROWABLE_TYPE = this.enterClass("java.lang.Throwable");
        this.ERROR_TYPE = this.enterClass("java.lang.Error");
        this.EXCEPTION_TYPE = this.enterClass("java.lang.Exception");
        this.RUNTIME_EXCEPTION_TYPE = this.enterClass("java.lang.RuntimeException");
        Type.ClassType arrayClassType = (Type.ClassType)Type.ArrayType.arrayClass.type;
        arrayClassType.parentType = this.OBJECT_TYPE;
        arrayClassType.interfaces = new Cons<Type>(this.CLONEABLE_TYPE);
        Type.ArrayType.arrayClass.members_field = new Scope(Type.ArrayType.arrayClass);
        this.lengthField = new Symbol.VarSymbol(17, Name.fromString("length"), Type.INT_TYPE, Type.ArrayType.arrayClass);
        Type.ArrayType.arrayClass.members().addSymbol(this.lengthField);
        Symbol.MethodSymbol cloneMethod = new Symbol.MethodSymbol(1, Name.fromString("clone"), new Type.MethodType(Type.EMPTY_LIST, this.OBJECT_TYPE, Symbol.ClassSymbol.EMPTY_LIST), this.OBJECT_TYPE.typeSymbol);
        Type.ArrayType.arrayClass.members().addSymbol(cloneMethod);
        this.NULL_SYMBOL = this.enterConstant("null", Type.ALL_TYPE);
        this.TRUE_SYMBOL = this.enterConstant("true", Type.BOOLEAN_TYPE.constType(new Integer(1)));
        this.FALSE_SYMBOL = this.enterConstant("false", Type.BOOLEAN_TYPE.constType(new Integer(0)));
        this.enterUnop("+", Type.INT_TYPE, Type.INT_TYPE, 0);
        this.enterUnop("+", Type.LONG_TYPE, Type.LONG_TYPE, 0);
        this.enterUnop("+", Type.FLOAT_TYPE, Type.FLOAT_TYPE, 0);
        this.enterUnop("+", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 0);
        this.enterUnop("-", Type.INT_TYPE, Type.INT_TYPE, 116);
        this.enterUnop("-", Type.LONG_TYPE, Type.LONG_TYPE, 117);
        this.enterUnop("-", Type.FLOAT_TYPE, Type.FLOAT_TYPE, 118);
        this.enterUnop("-", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 119);
        this.enterUnop("~", Type.INT_TYPE, Type.INT_TYPE, 130);
        this.enterUnop("~", Type.LONG_TYPE, Type.LONG_TYPE, 131);
        this.enterUnop("++", Type.BYTE_TYPE, Type.BYTE_TYPE, 96);
        this.enterUnop("++", Type.SHORT_TYPE, Type.SHORT_TYPE, 96);
        this.enterUnop("++", Type.CHAR_TYPE, Type.CHAR_TYPE, 96);
        this.enterUnop("++", Type.INT_TYPE, Type.INT_TYPE, 96);
        this.enterUnop("++", Type.LONG_TYPE, Type.LONG_TYPE, 97);
        this.enterUnop("++", Type.FLOAT_TYPE, Type.FLOAT_TYPE, 98);
        this.enterUnop("++", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 99);
        this.enterUnop("--", Type.BYTE_TYPE, Type.BYTE_TYPE, 100);
        this.enterUnop("--", Type.SHORT_TYPE, Type.SHORT_TYPE, 100);
        this.enterUnop("--", Type.CHAR_TYPE, Type.CHAR_TYPE, 100);
        this.enterUnop("--", Type.INT_TYPE, Type.INT_TYPE, 100);
        this.enterUnop("--", Type.LONG_TYPE, Type.LONG_TYPE, 101);
        this.enterUnop("--", Type.FLOAT_TYPE, Type.FLOAT_TYPE, 102);
        this.enterUnop("--", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 103);
        this.enterUnop("!", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 257);
        this.enterBinaryOp("+", this.STRING_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, Type.INT_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, Type.LONG_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, Type.FLOAT_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, Type.DOUBLE_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, Type.BOOLEAN_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.STRING_TYPE, this.OBJECT_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.INT_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.LONG_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.FLOAT_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.DOUBLE_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.BOOLEAN_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", this.OBJECT_TYPE, this.STRING_TYPE, this.STRING_TYPE, 256);
        this.enterBinaryOp("+", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 96);
        this.enterBinaryOp("+", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 97);
        this.enterBinaryOp("+", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 98);
        this.enterBinaryOp("+", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 99);
        this.enterBinaryOp("-", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 100);
        this.enterBinaryOp("-", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 101);
        this.enterBinaryOp("-", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 102);
        this.enterBinaryOp("-", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 103);
        this.enterBinaryOp("*", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 104);
        this.enterBinaryOp("*", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 105);
        this.enterBinaryOp("*", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 106);
        this.enterBinaryOp("*", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 107);
        this.enterBinaryOp("/", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 108);
        this.enterBinaryOp("/", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 109);
        this.enterBinaryOp("/", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 110);
        this.enterBinaryOp("/", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 111);
        this.enterBinaryOp("%", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 112);
        this.enterBinaryOp("%", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 113);
        this.enterBinaryOp("%", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.FLOAT_TYPE, 114);
        this.enterBinaryOp("%", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, 115);
        this.enterBinaryOp("&", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 126);
        this.enterBinaryOp("&", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 127);
        this.enterBinaryOp("&", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 126);
        this.enterBinaryOp("|", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 128);
        this.enterBinaryOp("|", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 129);
        this.enterBinaryOp("|", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 128);
        this.enterBinaryOp("^", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 130);
        this.enterBinaryOp("^", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 131);
        this.enterBinaryOp("^", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 130);
        this.enterBinaryOp("<<", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 120);
        this.enterBinaryOp("<<", Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 121);
        this.enterBinaryOp("<<", Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, 270);
        this.enterBinaryOp("<<", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 271);
        this.enterBinaryOp(">>", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 122);
        this.enterBinaryOp(">>", Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 123);
        this.enterBinaryOp(">>", Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, 272);
        this.enterBinaryOp(">>", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 273);
        this.enterBinaryOp(">>>", Type.INT_TYPE, Type.INT_TYPE, Type.INT_TYPE, 124);
        this.enterBinaryOp(">>>", Type.LONG_TYPE, Type.INT_TYPE, Type.LONG_TYPE, 125);
        this.enterBinaryOp(">>>", Type.INT_TYPE, Type.LONG_TYPE, Type.INT_TYPE, 274);
        this.enterBinaryOp(">>>", Type.LONG_TYPE, Type.LONG_TYPE, Type.LONG_TYPE, 275);
        this.enterBinaryOp("<", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 161);
        this.enterBinop("<", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 155);
        this.enterBinop("<", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 150, 155);
        this.enterBinop("<", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 152, 155);
        this.enterBinaryOp(">", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 163);
        this.enterBinop(">", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 157);
        this.enterBinop(">", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 149, 157);
        this.enterBinop(">", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 151, 157);
        this.enterBinaryOp("<=", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 164);
        this.enterBinop("<=", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 158);
        this.enterBinop("<=", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 150, 158);
        this.enterBinop("<=", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 152, 158);
        this.enterBinaryOp(">=", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 162);
        this.enterBinop(">=", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 156);
        this.enterBinop(">=", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 149, 156);
        this.enterBinop(">=", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 151, 156);
        this.enterBinaryOp("==", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 159);
        this.enterBinop("==", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 153);
        this.enterBinop("==", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 149, 153);
        this.enterBinop("==", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 151, 153);
        this.enterBinaryOp("==", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 159);
        this.enterBinaryOp("==", this.OBJECT_TYPE, this.OBJECT_TYPE, Type.BOOLEAN_TYPE, 165);
        this.enterBinaryOp("!=", Type.INT_TYPE, Type.INT_TYPE, Type.BOOLEAN_TYPE, 160);
        this.enterBinop("!=", Type.LONG_TYPE, Type.LONG_TYPE, Type.BOOLEAN_TYPE, 148, 154);
        this.enterBinop("!=", Type.FLOAT_TYPE, Type.FLOAT_TYPE, Type.BOOLEAN_TYPE, 149, 154);
        this.enterBinop("!=", Type.DOUBLE_TYPE, Type.DOUBLE_TYPE, Type.BOOLEAN_TYPE, 151, 154);
        this.enterBinaryOp("!=", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 160);
        this.enterBinaryOp("!=", this.OBJECT_TYPE, this.OBJECT_TYPE, Type.BOOLEAN_TYPE, 166);
        this.enterBinaryOp("&&", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 258);
        this.enterBinaryOp("||", Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, Type.BOOLEAN_TYPE, 259);
    }

    public void print() {
        SymbolTable.leftBracket();
        SymbolTable.print("SymbolTable");
        SymbolTable.newline();
        this.classReader.print();
        SymbolTable.rightBracket();
        SymbolTable.newline();
    }
}

