/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.VoidContext;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.util.AbortError;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeChecker
implements Kinds,
Flags,
TypeTags {
    private final ErrorLog errorLog;
    private final SymbolTable symbolTable;
    private final CompilerOptions compilerOptions;
    private Validator validator = new Validator();

    public TypeChecker(ErrorLog log, SymbolTable syms, CompilerOptions options) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.compilerOptions = options;
    }

    public boolean isUnchecked() {
        return this.compilerOptions.isUnchecked();
    }

    Type completionError(int pos, Symbol.CompletionFailure ex) {
        this.errorLog.error(pos, new StringBuffer().append("cannot access ").append(ex.sym).append("; ").append(ex.errmsg).toString());
        if (ex instanceof ClassReader.LoadError) {
            throw new AbortError();
        }
        return Type.ERROR_TYPE;
    }

    Type typeError(int pos, String problem, Type found, Type req) {
        this.errorLog.error(pos, new StringBuffer().append(problem).append("\n found   : ").append(found).append("\n required: ").append(req).toString());
        return Type.ERROR_TYPE;
    }

    Type typeTagError(int pos, String required, Type found) {
        this.errorLog.error(pos, new StringBuffer().append(required).append(" type required, but ").append(found).append(" found").toString());
        return Type.ERROR_TYPE;
    }

    void earlyRefError(int pos, Symbol sym) {
        this.errorLog.error(pos, new StringBuffer().append("cannot reference ").append(sym.name).append(" before supertype constructor has been called").toString());
    }

    Type checkType(int position, Type foundType, Type requiredType) {
        if (requiredType.tag == 18) {
            return requiredType;
        }
        if (foundType.isCoerceableTo(requiredType)) {
            return foundType;
        }
        if (foundType.isRaw() && requiredType.asSub(foundType.typeSymbol) != null) {
            if (!this.compilerOptions.isUnchecked()) {
                this.errorLog.warning(position, new StringBuffer().append("unchecked assignment: ").append(foundType).append(" to ").append(requiredType).toString());
            }
            return requiredType;
        }
        String problem = foundType.tag <= 7 && requiredType.tag <= 7 ? "possible loss of precision" : "incompatible types";
        return this.typeError(position, problem, foundType, requiredType);
    }

    Type checkCastable(int position, Type foundType, Type requiredType) {
        if (foundType.erasedIsCastableTo(requiredType)) {
            return requiredType;
        }
        return this.typeError(position, "inconvertible types", foundType, requiredType);
    }

    Type checkNonVoid(int position, Type type) {
        if (type.tag == 9) {
            this.errorLog.error(position, "'void' type not allowed here");
            return Type.ERROR_TYPE;
        }
        return type;
    }

    Type checkClassType(int position, Type type) {
        if (type.tag != 10 && type.tag != 11 && type.tag != 18) {
            return this.typeTagError(position, "class", type);
        }
        return type;
    }

    Type checkClassOrArrayType(int pos, Type t) {
        if (t.tag != 10 && t.tag != 11 && t.tag != 18) {
            return this.typeTagError(pos, "class or array", t);
        }
        return t;
    }

    Type checkRefType(int pos, Type t) {
        if (t.tag != 10 && t.tag != 11 && t.tag != 14 && t.tag != 18) {
            return this.typeTagError(pos, "reference", t);
        }
        return t;
    }

    void validate(Tree tree) {
        try {
            if (tree != null) {
                tree.accept(this.validator, null);
            }
        }
        catch (Symbol.CompletionFailure ex) {
            this.completionError(tree.sourcePosition, ex);
        }
    }

    void validate(List<Tree> trees) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            this.validate(l.getFirst());
            l = l.getRest();
        }
    }

    void validateTypeParams(List<Tree.TypeParameter> trees) {
        List<Tree.TypeParameter> l = trees;
        while (l.nonEmpty()) {
            this.validate(l.getFirst());
            l = l.getRest();
        }
    }

    static boolean instanceofSome(Symbol.ClassSymbol classSymbol, List<Symbol.ClassSymbol> symbolList) {
        List<Symbol.ClassSymbol> l = symbolList;
        while (l.nonEmpty()) {
            if (classSymbol.subclass(l.getFirst())) {
                return true;
            }
            l = l.getRest();
        }
        return false;
    }

    static boolean intersects(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        List<Symbol.ClassSymbol> l = cs;
        while (l.nonEmpty()) {
            if (c.subclass(l.getFirst()) || l.getFirst().subclass(c)) {
                return true;
            }
            l = l.getRest();
        }
        return false;
    }

    static List<Symbol.ClassSymbol> includeIn(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        return TypeChecker.instanceofSome(c, cs) ? cs : TypeChecker.excludeFrom(c, cs).cons(c);
    }

    static List<Symbol.ClassSymbol> excludeFrom(Symbol.ClassSymbol c, List<Symbol.ClassSymbol> cs) {
        if (cs.isEmpty()) {
            return cs;
        }
        List<Symbol.ClassSymbol> cs1 = TypeChecker.excludeFrom(c, cs.getRest());
        if (cs.getFirst().subclass(c)) {
            return cs1;
        }
        if (cs1 == cs.getRest()) {
            return cs;
        }
        return cs1.cons(cs.getFirst());
    }

    static List<Symbol.ClassSymbol> union(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = cs1;
        List<Symbol.ClassSymbol> l = cs2;
        while (l.nonEmpty()) {
            cs = TypeChecker.includeIn(l.getFirst(), cs);
            l = l.getRest();
        }
        return cs;
    }

    static List<Symbol.ClassSymbol> difference(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = cs1;
        List<Symbol.ClassSymbol> l = cs2;
        while (l.nonEmpty()) {
            cs = TypeChecker.excludeFrom(l.getFirst(), cs);
            l = l.getRest();
        }
        return cs;
    }

    static List<Symbol.ClassSymbol> intersect(List<Symbol.ClassSymbol> cs1, List<Symbol.ClassSymbol> cs2) {
        List<Symbol.ClassSymbol> cs = Symbol.ClassSymbol.EMPTY_LIST;
        List<Symbol.ClassSymbol> l = cs1;
        while (l.nonEmpty()) {
            if (TypeChecker.instanceofSome(l.getFirst(), cs2)) {
                cs = TypeChecker.includeIn(l.getFirst(), cs);
            }
            l = l.getRest();
        }
        l = cs2;
        while (l.nonEmpty()) {
            if (TypeChecker.instanceofSome(l.getFirst(), cs1)) {
                cs = TypeChecker.includeIn(l.getFirst(), cs);
            }
            l = l.getRest();
        }
        return cs;
    }

    boolean isUnchecked(Symbol.ClassSymbol exc) {
        return exc == Type.ERROR_TYPE.typeSymbol || exc.subclass(this.symbolTable.ERROR_TYPE.typeSymbol) || exc.subclass(this.symbolTable.RUNTIME_EXCEPTION_TYPE.typeSymbol);
    }

    boolean isHandled(Symbol.ClassSymbol exc, List<Symbol.ClassSymbol> handled) {
        return this.isUnchecked(exc) || TypeChecker.instanceofSome(exc, handled);
    }

    List<Symbol.ClassSymbol> unHandled(List<Symbol.ClassSymbol> thrown, List<Symbol.ClassSymbol> handled) {
        List<Symbol.ClassSymbol> unhandled = Symbol.ClassSymbol.EMPTY_LIST;
        List<Symbol.ClassSymbol> l = thrown;
        while (l.nonEmpty()) {
            if (!this.isHandled(l.getFirst(), handled)) {
                unhandled = unhandled.cons(l.getFirst());
            }
            l = l.getRest();
        }
        return unhandled;
    }

    void checkHandled(int pos, Symbol.ClassSymbol exc, List<Symbol.ClassSymbol> reported) {
        if (!this.isHandled(exc, reported)) {
            this.errorLog.error(pos, new StringBuffer().append("unreported exception: ").append(exc.type).append("; must be caught or declared to be thrown").toString());
        }
    }

    void checkHandled(int pos, List<Symbol.ClassSymbol> thrown, List<Symbol.ClassSymbol> reported) {
        List<Symbol.ClassSymbol> unhandled = this.unHandled(thrown, reported);
        if (unhandled.nonEmpty()) {
            this.checkHandled(pos, unhandled.getFirst(), reported);
        }
    }

    private static int protection(int flags) {
        switch (flags & 7) {
            case 2: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return 2;
    }

    private static String protectionString(int flags) {
        int flags1 = flags & 7;
        return flags1 == 0 ? "package" : TreeInspector.flagNames(flags1);
    }

    static String cannotOverride(Symbol.MethodSymbol m, Symbol.MethodSymbol other) {
        String rel = (other.flags() & 0x100000 | other.owner.flags() & 0x200) == 0 ? " cannot override " : ((m.flags() & 0x100000 | m.owner.flags() & 0x200) == 0 ? " cannot implement " : " clashes with ");
        return new StringBuffer().append(m).append(m.location()).append(rel).append(other).append(other.location()).toString();
    }

    void checkOverride(int pos, Symbol.MethodSymbol m, Symbol.MethodSymbol other, Symbol.ClassSymbol origin) {
        if ((other.flags() & 0x10000) == 0) {
            if ((m.flags() & 8) != 0 && (other.flags() & 8) == 0) {
                this.errorLog.error(pos, new StringBuffer().append("static ").append(TypeChecker.cannotOverride(m, other)).toString());
            } else if ((other.flags() & 0x10) != 0 || (m.flags() & 8) == 0 && (other.flags() & 8) != 0) {
                this.errorLog.error(pos, new StringBuffer().append(TypeChecker.cannotOverride(m, other)).append("; overridden method is ").append(TreeInspector.flagNames(other.flags() & 0x18)).toString());
            } else if ((origin.flags() & 0x200) == 0 && TypeChecker.protection(m.flags()) > TypeChecker.protection(other.flags())) {
                this.errorLog.error(pos, new StringBuffer().append(TypeChecker.cannotOverride(m, other)).append(" with weaker access privileges; was ").append(TypeChecker.protectionString(other.flags())).toString());
            } else {
                List<Symbol.ClassSymbol> unhandled;
                Type mt = origin.type.memberType(m);
                Type ot = origin.type.memberType(other);
                List<Type> mtvars = mt.getTypeParams();
                List<Type> otvars = ot.getTypeParams();
                if (!mt.returnType().isSubType(ot.returnType().substitute(otvars, mtvars))) {
                    this.typeError(pos, new StringBuffer().append(TypeChecker.cannotOverride(m, other)).append(" with incompatible return type").toString(), mt.returnType(), ot.returnType().substitute(otvars, mtvars));
                } else if ((origin.flags() & 0x200) == 0 && (unhandled = this.unHandled(mt.thrown(), ot.thrown())).nonEmpty()) {
                    if ((m.flags() & 0x100000) != 0) {
                        ((Type.MethodType)mt).thrown = mt.thrown().append(unhandled);
                    } else {
                        this.errorLog.error(pos, new StringBuffer().append(TypeChecker.cannotOverride(m, other)).append("; overridden method does not throw ").append(unhandled.getFirst()).toString());
                    }
                }
            }
        }
    }

    void checkOverride(int pos, Symbol.MethodSymbol m) {
        Symbol.ClassSymbol origin = (Symbol.ClassSymbol)m.owner;
        Type t = origin.type.getSuperType();
        while (t.tag == 10) {
            Symbol.TypeSymbol c = t.typeSymbol;
            Scope.Entry e = c.members().lookup(m.name);
            while (e.scope != null) {
                if (m.overrides(e.symbol, origin)) {
                    this.checkOverride(pos, m, (Symbol.MethodSymbol)e.symbol, origin);
                    return;
                }
                e = e.next();
            }
            t = t.getSuperType();
        }
    }

    void checkAllDefined(int pos, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = this.firstUndefined(c, c);
        if (undef != null) {
            Symbol.MethodSymbol undef1 = new Symbol.MethodSymbol(undef.flags(), undef.name, c.type.memberType(undef), undef.owner);
            this.errorLog.error(pos, new StringBuffer().append(c).append(" should be declared abstract; it does not define ").append(undef1).append(undef1.location()).toString());
        }
    }

    private Symbol.MethodSymbol firstUndefined(Symbol.ClassSymbol impl, Symbol.ClassSymbol c) {
        Symbol.MethodSymbol undef = null;
        if (c == impl || (c.flags() & 0x600) != 0) {
            Scope s = c.members();
            Scope.Entry e = s.entries;
            while (undef == null && e != null) {
                Symbol.MethodSymbol absmeth;
                Symbol.MethodSymbol implmeth;
                if (!(e.symbol.kind != 16 || (e.symbol.flags() & 0x400) == 0 || (implmeth = (absmeth = (Symbol.MethodSymbol)e.symbol).implementation(impl)) != null && implmeth != absmeth || absmeth.isSnippet())) {
                    undef = absmeth;
                }
                e = e.sibling;
            }
            if (undef == null) {
                Type superType = c.type.getSuperType();
                if (superType.tag == 10) {
                    undef = this.firstUndefined(impl, (Symbol.ClassSymbol)superType.typeSymbol);
                }
            }
            List<Type> l = c.type.getInterfaces();
            while (undef == null && l.nonEmpty()) {
                undef = this.firstUndefined(impl, (Symbol.ClassSymbol)l.getFirst().typeSymbol);
                l = l.getRest();
            }
        }
        return undef;
    }

    void checkImplementations(int pos, Symbol.ClassSymbol origin) {
        List<Type> l = origin.type.getInterfaces();
        while (l.nonEmpty()) {
            this.checkImplementations(pos, origin, (Symbol.ClassSymbol)l.getFirst().typeSymbol);
            l = l.getRest();
        }
    }

    void checkImplementations(int pos, Symbol.ClassSymbol origin, Symbol.ClassSymbol ic) {
        Scope.Entry e = ic.members().entries;
        while (e != null) {
            Symbol.MethodSymbol absmeth;
            Symbol.MethodSymbol implmeth;
            if (e.symbol.kind == 16 && (e.symbol.flags() & 8) == 0 && (implmeth = (absmeth = (Symbol.MethodSymbol)e.symbol).implementation(origin)) != null) {
                this.checkOverride(pos, implmeth, absmeth, origin);
            }
            e = e.sibling;
        }
        List<Type> l = ic.type.getInterfaces();
        while (l.nonEmpty()) {
            this.checkImplementations(pos, origin, (Symbol.ClassSymbol)l.getFirst().typeSymbol);
            l = l.getRest();
        }
    }

    void checkClassBounds(int pos, Symbol.ClassSymbol c) {
        this.checkClassBounds(pos, new Hashtable<Symbol.TypeSymbol, Type>(), c.type);
    }

    void checkClassBounds(int pos, Hashtable<Symbol.TypeSymbol, Type> seensofar, Type ctype) {
        List<Type> l = ctype.getInterfaces();
        while (l.nonEmpty()) {
            List<Type> newparams;
            List<Type> oldparams;
            Type it = l.getFirst();
            Type oldit = seensofar.put(it.typeSymbol, it);
            if (oldit != null && !Type.sameTypes(oldparams = oldit.allParams(), newparams = it.allParams())) {
                this.errorLog.error(pos, new StringBuffer().append(it.typeSymbol).append(" cannot be inherited with different arguments: <").append(oldparams).append("> and <").append(newparams).append(">").toString());
            }
            this.checkClassBounds(pos, seensofar, it);
            l = l.getRest();
        }
        Type superType = ctype.getSuperType();
        if (superType != null) {
            this.checkClassBounds(pos, seensofar, superType);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Validator
    extends Tree.Visitor<VoidContext, VoidContext>
    implements TypeTags {
        Validator() {
        }

        @Override
        public VoidContext _case(Tree.ArrayTypeExpression tree, VoidContext arg) {
            TypeChecker.this.validate(tree.elementType);
            return null;
        }

        @Override
        public VoidContext _case(Tree.TypeApply tree, VoidContext arg) {
            if (tree.type.tag == 10) {
                List<Type> formals = tree.type.typeSymbol.type.getTypeParams();
                List<Type> actuals = tree.type.getTypeParams();
                List<Tree> l = tree.arguments;
                while (l.nonEmpty()) {
                    TypeChecker.this.validate(l.getFirst());
                    Type bound = formals.getFirst().bound().substitute(formals, actuals);
                    if (!l.getFirst().type.isSubType(bound)) {
                        TypeChecker.this.errorLog.error(l.getFirst().sourcePosition, new StringBuffer().append("type parameter ").append(l.getFirst().type).append(" is not within bound ").append(bound).toString());
                    }
                    l = l.getRest();
                }
            }
            return null;
        }

        @Override
        public VoidContext _case(Tree.TypeParameter tree, VoidContext arg) {
            TypeChecker.this.validate(tree.extendsBound);
            TypeChecker.this.validate(tree.implementsBound);
            return null;
        }

        @Override
        public VoidContext _case(Tree.Select tree, VoidContext arg) {
            if (tree.type.tag == 10) {
                if (tree.type.enclosingType().tag == 10) {
                    TypeChecker.this.validate(tree.selected);
                }
                if (tree.type.isRaw() && tree.type.allParams().nonEmpty()) {
                    TypeChecker.this.errorLog.error(tree.sourcePosition, "improperly formed type, some parameters are missing");
                }
            }
            return null;
        }

        @Override
        public VoidContext _case(Tree tree, VoidContext arg) {
            return null;
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
            return super._case(x0, (VoidContext)x1);
        }
    }
}

