/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeEraser
extends TreeTranslator<Type>
implements Flags,
Kinds,
TypeTags {
    final ErrorLog errorLog;
    private final SymbolTable symbolTable;
    private final TreeMaker treeMaker;
    private final Hashtable<Symbol.MethodSymbol, Symbol.MethodSymbol> overridden = new Hashtable();

    public TypeEraser(ErrorLog log, SymbolTable syms, TreeMaker make) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.treeMaker = make;
    }

    Tree cast(Tree tree, Type target) {
        this.treeMaker.at(tree.sourcePosition);
        if (tree.type.isSameType(target)) {
            return tree;
        }
        return this.treeMaker.newTypeCast(this.treeMaker.newType(target), tree).setType(target);
    }

    Tree coerce(Tree tree, Type target) {
        return tree.type.isCoerceableTo(target) ? tree : this.cast(tree, target);
    }

    Tree retype(Tree tree, Type erasedType, Type target) {
        if (erasedType.tag > 8) {
            tree.type = erasedType;
            if (target != null && target.constantValue == null) {
                return this.coerce(tree, target);
            }
        }
        return tree;
    }

    List<Tree> translateArgs(List<Tree> trees, List<Type> targets) {
        ListBox<Tree> result = new ListBox<Tree>();
        ListBox<Type> _targets = new ListBox<Type>(targets);
        ListBox<Tree> iter = new ListBox<Tree>(trees);
        while (!iter.isEmpty()) {
            result.insertEnd(this.translate(iter.getFirst(), (Object)_targets.getFirst()));
            _targets.remove();
            iter.remove();
        }
        return result.toList();
    }

    boolean sameMethType(Type t1, Type t2) {
        return Type.sameTypes(t1.argTypes(), t2.argTypes()) && t1.returnType().isSameType(t2.returnType());
    }

    boolean erasedOverrides(Symbol meth, Symbol other) {
        Type mt = meth.erasure();
        Type ot = other.erasure();
        return meth.name != Names.init && other.kind == 16 && (other.flags() & 2) == 0 && this.sameMethType(mt, ot);
    }

    public Symbol.MethodSymbol erasedImplementation(Symbol meth, Symbol.ClassSymbol origin) {
        Symbol.TypeSymbol c = origin;
        while (c != null) {
            Scope.Entry e = ((Symbol.TypeSymbol)c).members().lookup(meth.name);
            while (e.scope != null) {
                if (this.erasedOverrides(meth, e.symbol)) {
                    return (Symbol.MethodSymbol)e.symbol;
                }
                e = e.next();
            }
            c = c.type.getSuperType().typeSymbol;
        }
        return null;
    }

    void addBridge(Symbol.MethodSymbol meth, Symbol.MethodSymbol impl, Symbol.ClassSymbol origin, ListBox<Tree> bridges) {
        Type polyType = origin.type.memberType(meth);
        Type monoType = meth.erasure();
        Type polyErasure = polyType.erasure();
        Symbol.MethodSymbol bridge = new Symbol.MethodSymbol(meth.flags() & 7 | 0x10000, meth.name, monoType, origin);
        Tree receiver = impl.owner == origin ? this.treeMaker.newThis(origin.erasure()) : this.treeMaker.newSuper(origin.type.getSuperType().typeSymbol.erasure());
        List<Tree.VarDef> params = this.treeMaker.newVarDefs(monoType.argTypes(), bridge);
        Type calltype = impl.type.returnType().erasure();
        Tree call = this.treeMaker.newApply(this.treeMaker.newSelect(receiver, impl).setType(calltype), this.translateArgs(this.treeMaker.newIdents(params), polyErasure.argTypes())).setType(calltype);
        Tree.ExpressionStatement stat = polyErasure.returnType().tag == 9 ? this.treeMaker.newExpressionStatement(call) : this.treeMaker.newReturn(this.coerce(call, monoType.returnType()));
        Tree.MethodDef def = this.treeMaker.newMethodDef(bridge.flags(), bridge.name, this.treeMaker.newType(monoType.returnType()), Tree.TypeParameter.emptyList, params, this.treeMaker.newClasses(monoType.thrown()), this.treeMaker.newBlock(0, new Cons<Tree>(stat)));
        def.methodSymbol = bridge;
        def.type = monoType;
        bridges.insertEnd(def);
        origin.members().addSymbol(bridge);
        this.overridden.put(bridge, meth);
    }

    void addBridgeIfNeeded(Symbol sym, Symbol.ClassSymbol origin, ListBox<Tree> bridges) {
        if (sym.kind == 16 && sym.name != Names.init && (sym.flags() & 0x1000A) == 0) {
            Symbol.MethodSymbol meth = (Symbol.MethodSymbol)sym;
            Symbol.MethodSymbol bridge = this.erasedImplementation(meth, origin);
            if (bridge == null || bridge == meth) {
                Symbol.MethodSymbol impl = meth.implementation(origin);
                if (!this.sameMethType(origin.type.memberType(meth).erasure(), meth.erasure()) || impl != meth && !impl.erasure().returnType().isSameType(meth.erasure().returnType())) {
                    this.addBridge(meth, impl, origin, bridges);
                }
            } else if ((bridge.flags() & 0x10000) == 0 && !bridge.overrides(meth, origin)) {
                Symbol other = this.overridden.get(bridge);
                if (other == null) {
                    other = bridge;
                }
                System.err.println(new StringBuffer().append("addBridgeIfNeeded called on args ").append(sym).append(", ").append(origin).append(", ").append(bridges).toString());
                this.errorLog.error(this.treeMaker.pos, new StringBuffer().append("name clash: ").append(other).append(other.location()).append(" and ").append(meth).append(meth.location()).append(" have the same erasure, yet none overrides the other").toString());
            }
        }
    }

    void addClassBridges(Symbol.TypeSymbol c, Symbol.ClassSymbol origin, ListBox<Tree> bridges) {
        while (c.type.isParameterized()) {
            Scope.Entry e = c.members().entries;
            while (e != null) {
                this.addBridgeIfNeeded(e.symbol, origin, bridges);
                e = e.sibling;
            }
            c = c.type.getSuperType().typeSymbol;
        }
    }

    void addInterfaceBridges(Symbol.TypeSymbol i, Symbol.ClassSymbol origin, ListBox<Tree> bridges) {
        if (i.type.isParameterized()) {
            Scope.Entry e = i.members().entries;
            while (e != null) {
                this.addBridgeIfNeeded(e.symbol, origin, bridges);
                e = e.sibling;
            }
            List<Type> l = i.type.getInterfaces();
            while (l.nonEmpty()) {
                this.addInterfaceBridges(l.getFirst().typeSymbol, origin, bridges);
                l = l.getRest();
            }
        }
    }

    boolean isSpecialization(Type t) {
        return t.getTypeParams().length() != 0 && !Type.sameTypes(Type.erasure(t.getTypeParams()), Type.erasure(t.typeSymbol.type.getTypeParams()));
    }

    void addBridges(Symbol.ClassSymbol origin, ListBox<Tree> bridges) {
        Type superType = origin.type.getSuperType();
        if (superType.tag == 10) {
            this.addClassBridges(superType.typeSymbol, origin, bridges);
        }
        List<Type> l = origin.type.getInterfaces();
        while (l.nonEmpty()) {
            this.addInterfaceBridges(l.getFirst().typeSymbol, origin, bridges);
            l = l.getRest();
        }
    }

    @Override
    public Tree _case(Tree.ClassDef tree, Type pt) {
        tree.typeParams = Tree.TypeParameter.emptyList;
        super._case(tree, (Object)null);
        this.treeMaker.at(tree.sourcePosition);
        ListBox<Tree> bridges = new ListBox<Tree>();
        if (tree.classSymbol.kind == 2 && (tree.classSymbol.flags() & 0x200) == 0) {
            this.addBridges(tree.classSymbol, bridges);
        }
        tree.members = bridges.toList().append(tree.members);
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.MethodDef tree, Type pt) {
        tree.returnType = this.translate(tree.returnType, (Object)null);
        tree.typeParams = Tree.TypeParameter.emptyList;
        tree.params = this.translateVarDefs((List)tree.params, (Object)null);
        tree.thrown = this.translate((List)tree.thrown, (Object)null);
        tree.body = (Tree.Block)this.translate((Tree)tree.body, (Object)tree.methodSymbol.erasure().returnType());
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.VarDef tree, Type pt) {
        tree.varType = this.translate(tree.varType, (Object)null);
        tree.initialization = this.translate(tree.initialization, (Object)tree.varSymbol.erasure());
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.DoLoop tree, Type pt) {
        tree.body = this.translate(tree.body, (Object)pt);
        tree.cond = this.translate(tree.cond, (Object)null);
        return tree;
    }

    @Override
    public Tree _case(Tree.WhileLoop tree, Type pt) {
        tree.condition = this.translate(tree.condition, (Object)null);
        tree.body = this.translate(tree.body, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.ForLoop tree, Type pt) {
        tree.initializations = this.translate((List)tree.initializations, (Object)null);
        tree.conditions = this.translate(tree.conditions, (Object)null);
        tree.incrementations = this.translate((List)tree.incrementations, (Object)null);
        tree.body = this.translate(tree.body, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.Switch tree, Type pt) {
        tree.selector = this.translate(tree.selector, (Object)null);
        tree.cases = this.translateCases((List)tree.cases, pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.Case tree, Type pt) {
        tree.pattern = this.translate(tree.pattern, (Object)null);
        tree.statements = this.translate((List)tree.statements, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.Synchronized tree, Type pt) {
        tree.lockedObject = this.translate(tree.lockedObject, (Object)null);
        tree.body = this.translate(tree.body, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.Conditional tree, Type pt) {
        tree.condition = this.translate(tree.condition, (Object)null);
        tree.thenClause = this.translate(tree.thenClause, (Object)pt);
        tree.elseClause = this.translate(tree.elseClause, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.ExpressionStatement tree, Type pt) {
        tree.expression = this.translate(tree.expression, (Object)null);
        return tree;
    }

    @Override
    public Tree _case(Tree.Return tree, Type pt) {
        tree.expression = this.translate(tree.expression, (Object)pt);
        return tree;
    }

    @Override
    public Tree _case(Tree.Throw tree, Type pt) {
        tree.expression = this.translate(tree.expression, (Object)tree.expression.type.erasure());
        return tree;
    }

    @Override
    public Tree _case(Tree.Apply tree, Type pt) {
        tree.method = this.translate(tree.method, (Object)null);
        Type mt = TreeInspector.symbol(tree.method).erasure();
        tree.args = this.translateArgs(tree.args, mt.argTypes());
        return this.retype(tree, mt.returnType(), pt);
    }

    @Override
    public Tree _case(Tree.NewInstance tree, Type pt) {
        if (tree.enclosingClassPrefix != null) {
            tree.enclosingClassPrefix = this.translate(tree.enclosingClassPrefix, (Object)tree.enclosingClassPrefix.type.erasure());
        }
        tree._class = this.translate(tree._class, (Object)null);
        tree.args = this.translateArgs(tree.args, tree.constructor.erasure().argTypes());
        tree.anonymousClassDef = (Tree.ClassDef)this.translate((Tree)tree.anonymousClassDef, (Object)null);
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.NewArray tree, Type pt) {
        tree.elementType = this.translate(tree.elementType, (Object)null);
        tree.dimensions = this.translate((List)tree.dimensions, (Object)null);
        tree.elements = this.translate((List)tree.elements, (Object)tree.type.elementType().erasure());
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.Assign tree, Type pt) {
        tree.lhs = this.translate(tree.lhs, (Object)null);
        tree.rhs = this.translate(tree.rhs, (Object)tree.lhs.type.erasure());
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.AssignOp tree, Type pt) {
        tree.lhs = this.translate(tree.lhs, (Object)null);
        tree.rhs = this.translate(tree.rhs, (Object)tree.lhs.type.erasure());
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.Operation tree, Type pt) {
        tree.args = this.translateArgs(tree.args, tree.operator.type.argTypes());
        return tree;
    }

    @Override
    public Tree _case(Tree.TypeCast tree, Type pt) {
        tree.castType = this.translate(tree.castType, (Object)null);
        tree.expression = this.translate(tree.expression, (Object)null);
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.InstanceofTest tree, Type pt) {
        tree.expression = this.translate(tree.expression, (Object)null);
        tree.testedType = this.translate(tree.testedType, (Object)null);
        return tree;
    }

    @Override
    public Tree _case(Tree.IndexedArrayElement tree, Type pt) {
        tree.indexedArray = this.translate(tree.indexedArray, (Object)tree.indexedArray.type.erasure());
        tree.index = this.translate(tree.index, (Object)null);
        return this.retype(tree, tree.indexedArray.type.elementType(), pt);
    }

    @Override
    public Tree _case(Tree.Select tree, Type pt) {
        tree.selected = this.translate(tree.selected, (Object)tree.selected.type.erasure());
        if (tree.symbol.kind == 4) {
            return this.retype(tree, tree.symbol.erasure(), pt);
        }
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.Ident tree, Type pt) {
        Type erasedType = tree.symbol.erasure();
        if (tree.symbol.kind == 2 && tree.symbol.type.tag == 14) {
            return this.treeMaker.at(tree.sourcePosition).newType(erasedType);
        }
        if (tree.symbol.kind == 4) {
            return this.retype(tree, erasedType, pt);
        }
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.ArrayTypeExpression tree, Type pt) {
        tree.elementType = this.translate(tree.elementType, (Object)null);
        tree.type = tree.type.erasure();
        return tree;
    }

    @Override
    public Tree _case(Tree.TypeApply tree, Type pt) {
        return this.translate(tree._class, (Object)null);
    }

    public Tree translateTopLevelClass(Tree cdef) {
        return this.translate(cdef, (Object)null);
    }

    @Override
    public /* synthetic */ Tree _case(Tree x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeApply x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ArrayTypeExpression x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Literal x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Continue x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Break x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Try x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Case x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Labelled x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Block x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Object)((Type)x1));
    }

    @Override
    public /* synthetic */ List translateCatchers(List x0, Object x1) {
        return super.translateCatchers(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ List translateCases(List x0, Object x1) {
        return super.translateCases(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ List translateTypeParams(List x0, Object x1) {
        return super.translateTypeParams(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ List translateVarDefs(List x0, Object x1) {
        return super.translateVarDefs(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ List translate(List x0, Object x1) {
        return super.translate(x0, (Type)x1);
    }

    @Override
    public /* synthetic */ Tree translate(Tree x0, Object x1) {
        return super.translate(x0, (Type)x1);
    }
}

