/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.UnboundTypeVarException;

public class SnippetClosure
implements Flags {
    public static final List<SnippetClosure> EMPTY_LIST = new Empty<SnippetClosure>();
    public Tree.Snippetable expression;
    public final ErrorLog errorLog;
    public final Symbol.MethodSymbol abstractSnippetSymbol;
    public final Type returnType;
    public final ClassVisitorEnv env;

    public SnippetClosure(Tree.Snippetable expr, ErrorLog log, Symbol.MethodSymbol abstractSnippetSymbol, Type returnType, ClassVisitorEnv env) {
        this.expression = expr;
        this.errorLog = log;
        this.abstractSnippetSymbol = abstractSnippetSymbol;
        this.returnType = returnType;
        this.env = env;
    }

    public void setExpr(Tree.Snippetable e) {
        this.expression = e;
    }

    public SnippetClosure copy() {
        return new SnippetClosure(this.expression, this.errorLog, this.abstractSnippetSymbol, this.returnType, this.env);
    }

    public Tree.MethodDef genSnippet(Symbol.ClassSymbol snippetOwner) {
        Tree flatExpr;
        ListBox<Tree.Ident> argBuf = new ListBox<Tree.Ident>();
        ListBox<Tree.VarDef> varDefBuf = new ListBox<Tree.VarDef>();
        List<Tree> tail = this.expression.getArgs();
        while (!tail.isEmpty()) {
            Tree.Ident ident = (Tree.Ident)tail.getFirst();
            Name identName = ident.name;
            Type identType = ident.type;
            Symbol.VarSymbol newVarSymbol = new Symbol.VarSymbol(16, identName, identType, null);
            Tree.Ident newIdent = new Tree.Ident(0, identType, identName, newVarSymbol);
            argBuf.insertEnd(newIdent);
            varDefBuf.insertEnd(new Tree.VarDef(0, identType, 0, identName, newIdent, null, newVarSymbol));
            tail = tail.getRest();
        }
        List<Tree> newArgs = argBuf.toList();
        List<Tree.VarDef> newVarDefs = varDefBuf.toList();
        Name snippetName = this.abstractSnippetSymbol.name;
        Type snippetType = this.abstractSnippetSymbol.type;
        Symbol.MethodSymbol snippetSymbol = Symbol.MethodSymbol.makeSnippetSymbol(65552, snippetName, snippetType, snippetOwner);
        List<Tree.VarDef> tail2 = newVarDefs;
        while (!tail2.isEmpty()) {
            ((Tree.VarDef)tail2.getFirst()).varSymbol.owner = snippetSymbol;
            tail2 = tail2.getRest();
        }
        snippetOwner.members().addSymbol(snippetSymbol);
        this.expression.setArgs(newArgs);
        try {
            flatExpr = this.expression.accept(this.env.getFlattenVisitor());
        }
        catch (UnboundTypeVarException e) {
            this.errorLog.error(this.expression.getPos(), "Polymorphic method body depends on the method type variable " + e.getTypeVar() + " which is not supported by this compiler.");
            flatExpr = (Tree)((Object)this.expression);
        }
        Tree.Block snippetBody = new Tree.Block(0, this.returnType, 0, new Cons<Tree>(new Tree.Return(flatExpr.sourcePosition, null, flatExpr)));
        Tree.MethodDef snippet = new Tree.MethodDef(flatExpr.sourcePosition, snippetType, 4, snippetName, this.returnType.toIdent(flatExpr.sourcePosition), Tree.TypeParameter.emptyList, newVarDefs, Tree.EMPTY_LIST, snippetBody, snippetSymbol);
        snippet.setType(snippetType);
        return snippet;
    }
}

