/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.flatten.ClassVisitorEnv;
import edu.rice.cs.nextgen.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen.compiler.flatten.StaticPolyMethodVisitorEnv;
import edu.rice.cs.nextgen.compiler.flatten.VisitorEnv;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeFlattener
extends Tree.Visitor<Tree, VisitorEnv>
implements Flags {
    static final List<Tree.Case> emptyCases = new Empty<Tree.Case>();
    static final List<Tree.Catch> emptyCatches = new Empty<Tree.Catch>();
    static final List<Tree.MethodDef> emptyMethodDefs = new Empty<Tree.MethodDef>();
    static final List<Name> emptyNames = new Empty<Name>();
    static final List<Tree> emptyTrees = Tree.EMPTY_LIST;
    static final List<Type> emptyTypes = new Empty<Type>();
    static final List<Tree.TypeParameter> emptyTypeParameters = new Empty<Tree.TypeParameter>();
    static final List<Tree.VarDef> emptyVarDefs = new Empty<Tree.VarDef>();
    static final List<Tree.ClassDef> emptyClassDefs = new Empty<Tree.ClassDef>();
    static final List<Symbol.ClassSymbol> emptyClassSymbols = new Empty<Symbol.ClassSymbol>();
    private static final Tree.TypeIdent BOOL_IDENT = new Tree.TypeIdent(0, Type.BOOLEAN_TYPE, 8);
    private ErrorLog errorLog;
    private SymbolTable symbolTable;
    private ListBox<Tree.ClassDef> parametricClasses;
    private ListBox<Tree.ClassDef> unflattenedClasses;

    public TypeFlattener(ErrorLog l, SymbolTable s) {
        this.errorLog = l;
        this.symbolTable = s;
        this.parametricClasses = new ListBox();
        this.unflattenedClasses = new ListBox();
    }

    public ListBox<Tree.ClassDef> getParamClasses() {
        return this.parametricClasses;
    }

    public ListBox<Tree.ClassDef> getUnflattenedClasses() {
        return this.unflattenedClasses;
    }

    public static List<Type> argTypes(List<Tree> args) {
        ListBox<Type> argTypes = new ListBox<Type>();
        List<Tree> tail = args;
        while (!tail.isEmpty()) {
            argTypes.insertEnd(tail.getFirst().type);
            tail = tail.getRest();
        }
        return argTypes.toList();
    }

    public static List<Tree> typeTrees(List<Type> params) {
        ListBox<Tree.Ident> typeTrees = new ListBox<Tree.Ident>();
        List<Type> tail = params;
        while (!tail.isEmpty()) {
            typeTrees.insertEnd(tail.getFirst().toIdent());
            tail = tail.getRest();
        }
        return typeTrees.toList();
    }

    public static List<Tree.TypeParameter> typeParams(List<Type> params) {
        ListBox<Tree.TypeParameter> typeParams = new ListBox<Tree.TypeParameter>();
        List<Type> tail = params;
        while (!tail.isEmpty()) {
            Type.TypeVar nextTypeVar = (Type.TypeVar)tail.getFirst();
            typeParams.insertEnd(nextTypeVar.toTypeParameter());
            tail = tail.getRest();
        }
        return typeParams.toList();
    }

    public static List<Tree> reversedTypeTrees(List<Type> types) {
        List<Tree> typeIdents = emptyTrees;
        List<Type> tail = types;
        while (!tail.isEmpty()) {
            typeIdents = typeIdents.cons(tail.getFirst().toIdent());
            tail = tail.getRest();
        }
        return typeIdents;
    }

    public static List<Name> typeNames(List<Type> types) {
        ListBox<Name> typeNames = new ListBox<Name>();
        List<Type> tail = types;
        while (!tail.isEmpty()) {
            typeNames.insertEnd(tail.getFirst().name());
            tail = tail.getRest();
        }
        return typeNames.toList();
    }

    public static List<Name> reversedTypeNames(List<Type> types) {
        List<Name> typeNames = emptyNames;
        List<Type> tail = types;
        while (!tail.isEmpty()) {
            typeNames = typeNames.cons(tail.getFirst().name());
            tail = tail.getRest();
        }
        return typeNames;
    }

    public static Tree.Apply genSnippet(Tree.Snippetable replacedExp, List<Tree> args, List<Type> argTypes, Tree resType, Type returnType, VisitorEnv vstEnv) {
        Symbol.MethodSymbol snippetSymbol = vstEnv.getCachedSnippet(replacedExp);
        if (snippetSymbol == null) {
            snippetSymbol = vstEnv.constructSnippet(replacedExp, args, argTypes, returnType, resType);
        }
        Name snippetName = snippetSymbol.name;
        Tree.Ident snippetIdent = new Tree.Ident(((Tree)((Object)replacedExp)).sourcePosition, returnType, snippetName, snippetSymbol);
        return new Tree.Apply(((Tree)((Object)replacedExp)).sourcePosition, returnType, snippetIdent, args);
    }

    public Tree visitIfNotNull(Tree that, VisitorEnv vstEnv) {
        if (that == null) {
            return null;
        }
        return that.accept(this, vstEnv);
    }

    public String interfaceFromClass(String classNameString) {
        return new StringBuffer().append("$").append(classNameString).toString();
    }

    @Override
    public Tree _case(Tree.Import tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree.ClassDef tree, VisitorEnv vstEnv) {
        Type.ClassType classType = (Type.ClassType)tree.type;
        Type.ClassType supertype = (Type.ClassType)classType.getSuperType();
        if (supertype.isParameterized() && supertype.isGround()) {
            this.unflattenedClasses.insertEnd(tree);
        }
        if (!classType.isParameterized()) {
            ClassVisitorEnv newVstEnv = vstEnv.newClassVisitorEnv(tree.classSymbol, Symbol.ERROR_SYMBOL);
            List<Tree> flattenedDefs = Tree.mapAccept(tree.members, this, newVstEnv);
            Tree.ClassDef newClassDef = new Tree.ClassDef(tree.sourcePosition, classType, tree.flags, tree.name, tree.typeParams, tree.extendedClass, tree.implementedInterfaces, flattenedDefs.append(newVstEnv.newDefs().toList()), tree.classSymbol);
            return newClassDef;
        }
        Symbol.ClassSymbol classSym = (Symbol.ClassSymbol)classType.symbol();
        this.parametricClasses.insertEnd(tree);
        List<Type> allTyparams = classType.allParams();
        List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTyparams);
        Type.ClassType templateClassType = (Type.ClassType)classType.flatten(allParamNames);
        Type.ClassType templateInterfaceType = (Type.ClassType)classType.genInterface(allParamNames, this.symbolTable.OBJECT_TYPE);
        templateClassType.interfaces = new Cons<Type.ClassType>(templateInterfaceType);
        templateClassType.enclosingInstanceType = classType.enclosingInstanceType;
        templateClassType.typeParams = emptyTypes;
        templateInterfaceType.typeParams = emptyTypes;
        Symbol.ClassSymbol templateClassSymbol = (Symbol.ClassSymbol)templateClassType.symbol();
        Symbol.TypeSymbol templateClassOwner = (Symbol.TypeSymbol)templateClassSymbol.owner;
        Symbol.ClassSymbol templateInterfaceSymbol = (Symbol.ClassSymbol)templateInterfaceType.symbol();
        Symbol.TypeSymbol templateInterfaceOwner = (Symbol.TypeSymbol)templateInterfaceSymbol.owner;
        templateClassSymbol.members_field = new Scope(templateClassSymbol);
        templateClassSymbol.members_field.nextScope = templateClassOwner.members();
        templateClassSymbol.sourcefile = tree.classSymbol.sourcefile;
        templateInterfaceSymbol.members_field = new Scope(templateInterfaceSymbol);
        templateInterfaceSymbol.members_field.nextScope = templateInterfaceOwner.members();
        templateInterfaceSymbol.sourcefile = tree.classSymbol.sourcefile;
        templateClassOwner.members().addSymbol(templateClassSymbol);
        templateInterfaceOwner.members().addSymbol(templateInterfaceSymbol);
        ClassVisitorEnv newVstEnv = vstEnv.newClassVisitorEnv(tree.classSymbol, templateClassSymbol);
        List<Tree> templateClassImplementing = TypeFlattener.reversedTypeTrees(templateClassType.getInterfaces());
        List<Tree> templateInterfaceImplementing = TypeFlattener.reversedTypeTrees(templateInterfaceType.getInterfaces());
        List<Tree> flatDefs = Tree.mapAccept(tree.members, this, newVstEnv);
        newVstEnv.newDefs().insertEltsEnd(flatDefs);
        List<Tree> newDefs = newVstEnv.newDefs().toList();
        Tree.TypeIdent superIdent = new Tree.TypeIdent(tree.sourcePosition, tree.type, 10);
        List<SnippetClosure> snipClosures = newVstEnv.getSnipClosures().toList();
        classSym.setNewSnipClosures(snipClosures);
        List<Tree> templateTreeDefs = newVstEnv.getConstructors().toList();
        Tree.ClassDef templateClass = new Tree.ClassDef(tree.sourcePosition, templateClassType, tree.flags, templateClassSymbol.name, Tree.TypeParameter.emptyList, superIdent, templateClassImplementing, templateTreeDefs, templateClassSymbol);
        classSym.setTemplateClass(templateClass);
        vstEnv.newDefs().insertEnd(templateClass);
        Tree.ClassDef templateInterface = new Tree.ClassDef(tree.sourcePosition, templateInterfaceType, tree.flags | 0x200, templateInterfaceSymbol.name, Tree.TypeParameter.emptyList, null, templateInterfaceImplementing, Tree.EMPTY_LIST, templateInterfaceSymbol);
        vstEnv.newDefs().insertEnd(templateInterface);
        int newFlags = (tree.flags | 0x400) & 0xFFFFFFEF;
        tree.classSymbol.setFlags(newFlags);
        Tree.ClassDef newClassDef = new Tree.ClassDef(tree.sourcePosition, tree.type, newFlags, tree.name, tree.typeParams, tree.extendedClass, tree.implementedInterfaces, newDefs, tree.classSymbol);
        return newClassDef;
    }

    @Override
    public Tree _case(Tree.MethodDef tree, VisitorEnv vstEnv) {
        Tree.Ident superIdent;
        Symbol.ClassSymbol owner = vstEnv.enclClass();
        Type ownerType = owner.type;
        Type ownerSupertype = ownerType.getSuperType();
        Symbol.MethodSymbol methodSymbol = tree.methodSymbol;
        Type methodType = methodSymbol.type;
        if (methodType.isForAll() && methodSymbol.isStatic()) {
            Type.ClassType snipEnvClassType = ((Type.ForAll)methodType).genSnippetEnv(methodSymbol, this.symbolTable.OBJECT_TYPE);
            Symbol.ClassSymbol snipEnvSymbol = (Symbol.ClassSymbol)snipEnvClassType.symbol();
            Symbol.TypeSymbol snipEnvClassOwner = (Symbol.TypeSymbol)snipEnvSymbol.owner;
            snipEnvClassOwner.members().addSymbol(snipEnvSymbol);
            StaticPolyMethodVisitorEnv newVstEnv = vstEnv.newStaticPolyMethodVisitorEnv(vstEnv.enclClass(), methodSymbol, snipEnvSymbol);
            Tree.Block newMethodBody = (Tree.Block)this.visitIfNotNull(tree.body, newVstEnv);
            if (!newVstEnv.snippets().isEmpty()) {
                methodSymbol.setTemplateClass(snipEnvSymbol);
                Tree.ClassDef templateClass = new Tree.ClassDef(tree.sourcePosition, snipEnvClassType, 65561, snipEnvSymbol.name, TypeFlattener.typeParams(methodType.allParams()), this.symbolTable.OBJECT_TYPE.toIdent(), Tree.EMPTY_LIST, newVstEnv.getDefs(), snipEnvSymbol);
                vstEnv.newDefs().insertEnd(templateClass);
                return new Tree.MethodDef(0, tree.type, tree.flags, tree.name, tree.returnType, tree.typeParams, tree.params, tree.thrown, newMethodBody, tree.methodSymbol);
            }
        }
        Tree.Block newMethodBody = (Tree.Block)this.visitIfNotNull(tree.body, vstEnv);
        if (methodSymbol.name == Names.init && ownerType.isParameterized()) {
            Type.MethodType newConstructorType = new Type.MethodType(methodType.argTypes(), methodType.returnType(), methodType.thrown());
            int newConstructorFlags = methodSymbol.flags();
            methodSymbol.setFlags(newConstructorFlags & 0xFFFFFFFD);
            Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(newConstructorFlags, Names.init, newConstructorType, vstEnv.template());
            vstEnv.template().members().addSymbol(newConstructorSymbol);
            superIdent = new Tree.Ident(tree.sourcePosition, Type.VOID_TYPE, Names._super, methodSymbol);
            List<Tree.VarDef> params = tree.params;
            ListBox<Tree.Ident> args = new ListBox<Tree.Ident>();
            ListBox<Tree.VarDef> newParams = new ListBox<Tree.VarDef>();
            List<Tree.VarDef> tail = params;
            while (!tail.isEmpty()) {
                Tree.VarDef baseVarDef = tail.getFirst();
                Symbol.VarSymbol baseVarSymbol = baseVarDef.varSymbol;
                Symbol.VarSymbol newVarSymbol = new Symbol.VarSymbol(baseVarSymbol.flags(), baseVarDef.name, baseVarSymbol.type, newConstructorSymbol);
                Tree.Ident newIdent = new Tree.Ident(tree.sourcePosition, baseVarSymbol.type, baseVarDef.name, newVarSymbol);
                Tree.VarDef newVarDef = new Tree.VarDef(baseVarDef.sourcePosition, baseVarDef.type, baseVarDef.flags, baseVarDef.name, newIdent, null, newVarSymbol);
                newParams.insertEnd(newVarDef);
                args.insertEnd(newIdent);
                tail = tail.getRest();
            }
            Tree.Block newConstructorBody = new Tree.Block(tree.sourcePosition, Type.VOID_TYPE, 0, new Cons<Tree>(new Tree.ExpressionStatement(tree.sourcePosition, Type.VOID_TYPE, new Tree.Apply(tree.sourcePosition, Type.VOID_TYPE, superIdent, args.toList()))));
            Tree.MethodDef templateConstructor = new Tree.MethodDef(tree.sourcePosition, tree.type, tree.flags, tree.name, tree.returnType, tree.typeParams, newParams.toList(), tree.thrown, newConstructorBody, newConstructorSymbol);
            ((ClassVisitorEnv)vstEnv).getConstructors().insertEnd(templateConstructor);
        }
        if (tree.methodSymbol.name == Names.init && ownerSupertype.isParameterized() && ownerSupertype.isGround()) {
            List<Tree> stats = newMethodBody.statements;
            Tree.ExpressionStatement supercall = (Tree.ExpressionStatement)stats.getFirst();
            Tree.Apply supercallBody = (Tree.Apply)supercall.expression;
            superIdent = (Tree.Ident)supercallBody.method;
            Symbol.MethodSymbol constructorSymbol = (Symbol.MethodSymbol)superIdent.symbol;
            Type.MethodType constructorType = (Type.MethodType)constructorSymbol.type;
            Symbol.ClassSymbol newClassSymbol = (Symbol.ClassSymbol)ownerSupertype.flatten().symbol();
            Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(constructorSymbol.flags(), Names.init, constructorType, newClassSymbol);
            Tree.Ident newSuperIdent = new Tree.Ident(superIdent.sourcePosition, Type.VOID_TYPE, Names._super, newConstructorSymbol);
            supercallBody.method = newSuperIdent;
        }
        return new Tree.MethodDef(tree.sourcePosition, tree.type, tree.flags, tree.name, tree.returnType, tree.typeParams, tree.params, tree.thrown, newMethodBody, tree.methodSymbol);
    }

    @Override
    public Tree _case(Tree.VarDef tree, VisitorEnv vstEnv) {
        return new Tree.VarDef(tree.sourcePosition, tree.type, tree.flags, tree.name, tree.varType, this.visitIfNotNull(tree.initialization, vstEnv), tree.varSymbol);
    }

    @Override
    public Tree _case(Tree.Block tree, VisitorEnv vstEnv) {
        return new Tree.Block(tree.sourcePosition, tree.type, tree.flags, Tree.mapAccept(tree.statements, this, vstEnv));
    }

    @Override
    public Tree _case(Tree.DoLoop tree, VisitorEnv vstEnv) {
        return new Tree.DoLoop(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.body, vstEnv), this.visitIfNotNull(tree.cond, vstEnv));
    }

    @Override
    public Tree _case(Tree.WhileLoop tree, VisitorEnv vstEnv) {
        return new Tree.WhileLoop(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.condition, vstEnv), this.visitIfNotNull(tree.body, vstEnv));
    }

    @Override
    public Tree _case(Tree.ForLoop tree, VisitorEnv vstEnv) {
        return new Tree.ForLoop(tree.sourcePosition, tree.type, Tree.mapAccept(tree.initializations, this, vstEnv), this.visitIfNotNull(tree.conditions, vstEnv), Tree.mapAccept(tree.incrementations, this, vstEnv), this.visitIfNotNull(tree.body, vstEnv));
    }

    @Override
    public Tree _case(Tree.Labelled tree, VisitorEnv vstEnv) {
        return new Tree.Labelled(tree.sourcePosition, tree.type, tree.label, this.visitIfNotNull(tree.body, vstEnv));
    }

    @Override
    public Tree _case(Tree.Switch tree, VisitorEnv vstEnv) {
        List<Tree.Case> copiedCases = emptyCases;
        ListBox<Tree> cases = new ListBox<Tree>(Tree.mapAccept(tree.cases, this, vstEnv));
        while (!cases.isEmpty()) {
            copiedCases = copiedCases.cons((Tree.Case)cases.getFirst());
            cases.remove();
        }
        return new Tree.Switch(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.selector, vstEnv), copiedCases.reverse());
    }

    @Override
    public Tree _case(Tree.Case tree, VisitorEnv vstEnv) {
        return new Tree.Case(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.pattern, vstEnv), Tree.mapAccept(tree.statements, this, vstEnv));
    }

    @Override
    public Tree _case(Tree.Synchronized tree, VisitorEnv vstEnv) {
        return new Tree.Synchronized(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.lockedObject, vstEnv), this.visitIfNotNull(tree.body, vstEnv));
    }

    @Override
    public Tree _case(Tree.Try tree, VisitorEnv vstEnv) {
        List<Tree.Catch> copiedCatchers = emptyCatches;
        ListBox<Tree> catchers = new ListBox<Tree>(Tree.mapAccept(tree.catchers, this, vstEnv));
        while (!catchers.isEmpty()) {
            copiedCatchers = copiedCatchers.cons((Tree.Catch)catchers.getFirst());
            catchers.remove();
        }
        return new Tree.Try(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.body, vstEnv), copiedCatchers.reverse(), this.visitIfNotNull(tree.finalizer, vstEnv));
    }

    @Override
    public Tree _case(Tree.Catch tree, VisitorEnv vstEnv) {
        return new Tree.Catch(tree.sourcePosition, tree.type, tree.param, this.visitIfNotNull(tree.body, vstEnv));
    }

    @Override
    public Tree _case(Tree.Conditional tree, VisitorEnv vstEnv) {
        return new Tree.Conditional(tree.sourcePosition, tree.type, tree.tag, this.visitIfNotNull(tree.condition, vstEnv), this.visitIfNotNull(tree.thenClause, vstEnv), this.visitIfNotNull(tree.elseClause, vstEnv));
    }

    @Override
    public Tree _case(Tree.ExpressionStatement tree, VisitorEnv vstEnv) {
        return new Tree.ExpressionStatement(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.expression, vstEnv));
    }

    @Override
    public Tree _case(Tree.Break tree, VisitorEnv vstEnv) {
        return new Tree.Break(tree.sourcePosition, tree.type, tree.label, null);
    }

    @Override
    public Tree _case(Tree.Continue tree, VisitorEnv vstEnv) {
        return new Tree.Continue(tree.sourcePosition, tree.type, tree.label, null);
    }

    @Override
    public Tree _case(Tree.Return tree, VisitorEnv vstEnv) {
        return new Tree.Return(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.expression, vstEnv));
    }

    @Override
    public Tree _case(Tree.Throw tree, VisitorEnv vstEnv) {
        return new Tree.Throw(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.expression, vstEnv));
    }

    @Override
    public Tree _case(Tree.Apply tree, VisitorEnv vstEnv) {
        Tree meth = tree.method;
        Symbol.MethodSymbol methodSymbol = ((Tree.Polymorphic)((Object)meth)).getSymbol();
        Type methodType = methodSymbol.type;
        if (!methodSymbol.isStatic() || methodType.isForAll()) {
            // empty if block
        }
        return new Tree.Apply(tree.sourcePosition, tree.type, this.visitIfNotNull(meth, vstEnv), Tree.mapAccept(tree.args, this, vstEnv));
    }

    @Override
    public Tree _case(Tree.NewInstance tree, VisitorEnv vstEnv) {
        List<Tree> newArgs = Tree.mapAccept(tree.args, this, vstEnv);
        tree.setArgs(newArgs);
        if (tree.type.isGround()) {
            return tree.accept(vstEnv.getFlattenVisitor());
        }
        return TypeFlattener.genSnippet(tree, newArgs, TypeFlattener.argTypes(newArgs), tree._class, tree.type, vstEnv);
    }

    @Override
    public Tree _case(Tree.NewArray tree, VisitorEnv vstEnv) {
        List<Type> argTypes;
        List<Tree> args;
        List<Tree> newElems;
        List<Tree> newDims;
        if (tree.elements.isEmpty()) {
            newDims = Tree.mapAccept(tree.dimensions, this, vstEnv);
            tree.setArgs(newDims);
            newElems = Tree.EMPTY_LIST;
        } else {
            newElems = Tree.mapAccept(tree.elements, this, vstEnv);
            tree.setArgs(newElems);
            newDims = Tree.EMPTY_LIST;
        }
        Type aType = tree.type;
        Type eType = aType.elementType();
        if (!eType.isParameterized() && eType.isGround()) {
            return new Tree.NewArray(tree.sourcePosition, aType, tree.elementType, newDims, newElems);
        }
        if (eType.isGround()) {
            return tree.accept(vstEnv.getFlattenVisitor());
        }
        Type erasedEType = eType.erasure();
        if (newElems == null) {
            args = newDims;
            argTypes = List.make(newDims.length(), Type.INT_TYPE);
        } else {
            args = newElems;
            argTypes = List.make(newElems.length(), erasedEType);
        }
        return TypeFlattener.genSnippet(tree, args, argTypes, aType.toIdent(), aType, vstEnv);
    }

    @Override
    public Tree _case(Tree.Assign tree, VisitorEnv vstEnv) {
        return new Tree.Assign(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.lhs, vstEnv), this.visitIfNotNull(tree.rhs, vstEnv));
    }

    @Override
    public Tree _case(Tree.AssignOp tree, VisitorEnv vstEnv) {
        return new Tree.AssignOp(tree.sourcePosition, tree.type, tree.tag, this.visitIfNotNull(tree.lhs, vstEnv), this.visitIfNotNull(tree.rhs, vstEnv), tree.operator);
    }

    @Override
    public Tree _case(Tree.Operation tree, VisitorEnv vstEnv) {
        return new Tree.Operation(tree.sourcePosition, tree.type, tree.tag, Tree.mapAccept(tree.args, this, vstEnv), tree.operator);
    }

    @Override
    public Tree _case(Tree.TypeCast tree, VisitorEnv vstEnv) {
        Tree newExpr = tree.expression.accept(this, vstEnv);
        tree.setArgs(emptyTrees.cons(newExpr));
        Type castType = tree.castType.type;
        Type exprType = newExpr.type;
        if (!castType.isParameterized() && castType.isGround() || !(exprType instanceof Type.TypeVar) && exprType.isCastableTo(castType)) {
            return tree;
        }
        if (castType.isGround()) {
            return tree.accept(vstEnv.getFlattenVisitor());
        }
        return TypeFlattener.genSnippet(tree, emptyTrees.cons(newExpr), emptyTypes.cons(this.symbolTable.OBJECT_TYPE), tree.castType, castType.erasure(), vstEnv);
    }

    @Override
    public Tree _case(Tree.InstanceofTest tree, VisitorEnv vstEnv) {
        Tree newExpr = tree.expression.accept(this, vstEnv);
        tree.setArgs(emptyTrees.cons(newExpr));
        Type testType = tree.testedType.type;
        Type exprType = newExpr.type;
        if (!testType.isParameterized() && testType.isGround() || !(exprType instanceof Type.TypeVar) && exprType.isCastableTo(testType)) {
            return tree;
        }
        if (testType.isGround()) {
            return tree.accept(vstEnv.getFlattenVisitor());
        }
        return TypeFlattener.genSnippet(tree, emptyTrees.cons(newExpr), emptyTypes.cons(this.symbolTable.OBJECT_TYPE), BOOL_IDENT, Type.BOOLEAN_TYPE, vstEnv);
    }

    @Override
    public Tree _case(Tree.IndexedArrayElement tree, VisitorEnv vstEnv) {
        return new Tree.IndexedArrayElement(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.indexedArray, vstEnv), this.visitIfNotNull(tree.index, vstEnv));
    }

    @Override
    public Tree _case(Tree.Select tree, VisitorEnv vstEnv) {
        return new Tree.Select(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.selected, vstEnv), tree.name, tree.symbol);
    }

    @Override
    public Tree _case(Tree.Ident tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree.Literal tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree.TypeIdent tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree.ArrayTypeExpression tree, VisitorEnv vstEnv) {
        return new Tree.ArrayTypeExpression(tree.sourcePosition, tree.type, this.visitIfNotNull(tree.elementType, vstEnv));
    }

    @Override
    public Tree _case(Tree.TypeApply tree, VisitorEnv vstEnv) {
        Type apType = tree.type;
        if (!apType.isGround()) {
            return tree;
        }
        Type flatType = tree.type.flatten();
        return flatType.toIdent(tree.getSourcePosition());
    }

    @Override
    public Tree _case(Tree.TypeParameter tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree.Erroneous tree, VisitorEnv vstEnv) {
        return tree;
    }

    @Override
    public Tree _case(Tree tree, VisitorEnv vstEnv) {
        throw new InternalError(new StringBuffer().append("Flatten applied to illegal tree ").append(tree).toString());
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return this._case(x0, (VisitorEnv)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (VisitorEnv)x1);
    }
}

