/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisitorArgs {
    SymbolTable symbolTable;
    Symbol.ClassSymbol enclosingClass;
    Symbol.ClassSymbol enclosingClassTemplate;
    private ListBox<SnippetClosure> snippetClosures = new ListBox();
    private ListBox<Tree> constructors = new ListBox();
    private ListBox<Tree> abstractSnippets = new ListBox();
    private Hashtable<String, Symbol.MethodSymbol> snippetCache = new Hashtable();
    private Tree.SnippetableVisitor<Tree> snippetFlattener = new Tree.SnippetableVisitor<Tree>(){

        @Override
        public Tree forNewInstance(Tree.NewInstance tree) {
            Symbol constructorSymbol = tree.constructor;
            List<Type> allTypeParams = VisitorArgs.this.enclosingClass.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type flatType = tree.type.flatten(allParamNames);
            Symbol.TypeSymbol flatTypeSymbol = flatType.typeSymbol;
            Tree.Ident flatTypeIdent = new Tree.Ident(tree.sourcePosition, flatType, flatTypeSymbol.name, flatTypeSymbol);
            Symbol.MethodSymbol newConstructorSymbol = new Symbol.MethodSymbol(constructorSymbol.flags(), Names.init, constructorSymbol.type, flatType.typeSymbol);
            Tree.NewInstance newTree = new Tree.NewInstance(tree.sourcePosition, flatType, tree.enclosingClassPrefix, flatTypeIdent, tree.args, tree.anonymousClassDef, newConstructorSymbol);
            return newTree;
        }

        @Override
        public Tree forTypeCast(Tree.TypeCast tree) {
            Tree.TypeCast newTree;
            List<Type> allTypeParams = VisitorArgs.this.enclosingClass.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type castType = tree.castType.type;
            Type flatCastType = castType.genInterface(allParamNames, VisitorArgs.this.symbolTable.OBJECT_TYPE);
            Symbol.TypeSymbol flatSymbol = flatCastType.typeSymbol;
            Tree.Ident newIdent = new Tree.Ident(tree.sourcePosition, flatCastType, flatSymbol.name, flatSymbol);
            Tree.TypeCast innerTree = new Tree.TypeCast(tree.sourcePosition, flatCastType, newIdent, tree.expression);
            if (castType instanceof Type.TypeVar) {
                Type baseType = ((Type.TypeVar)castType).genBaseType(allParamNames);
                Symbol.TypeSymbol baseSymbol = baseType.typeSymbol;
                Tree.Ident baseIdent = new Tree.Ident(tree.sourcePosition, baseType, baseSymbol.name, baseSymbol);
                newTree = new Tree.TypeCast(tree.sourcePosition, baseType, baseIdent, innerTree);
            } else {
                newTree = new Tree.TypeCast(tree.sourcePosition, tree.type, tree.castType, innerTree);
            }
            return newTree;
        }

        @Override
        public Tree forInstanceofTest(Tree.InstanceofTest tree) {
            List<Type> allTypeParams = VisitorArgs.this.enclosingClass.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type testType = tree.testedType.type;
            Type newTestType = testType.genInterface(allParamNames, VisitorArgs.this.symbolTable.OBJECT_TYPE);
            Symbol.TypeSymbol newSymbol = newTestType.typeSymbol;
            Tree.Ident newIdent = new Tree.Ident(tree.sourcePosition, newTestType, newSymbol.name, newSymbol);
            Tree.InstanceofTest newTree = new Tree.InstanceofTest(tree.sourcePosition, tree.type, tree.expression, newIdent);
            return newTree;
        }

        @Override
        public Tree.NewArray forNewArray(Tree.NewArray tree) {
            List<Type> allTypeParams = VisitorArgs.this.enclosingClass.type.allParams();
            List<Name> allParamNames = TypeFlattener.reversedTypeNames(allTypeParams);
            Type aType = tree.type;
            Type eType = aType.elementType();
            Type flatEType = eType.flatten(allParamNames);
            Symbol.TypeSymbol flatETypeSymbol = flatEType.typeSymbol;
            Tree.Ident flatETypeIdent = new Tree.Ident(tree.sourcePosition, flatEType, flatETypeSymbol.name, flatETypeSymbol);
            Tree.NewArray newTree = new Tree.NewArray(tree.sourcePosition, new Type.ArrayType(flatEType), flatETypeIdent, tree.dimensions, tree.elements);
            return newTree;
        }

        @Override
        public /* synthetic */ Object forNewArray(Tree.NewArray x0) {
            return this.forNewArray(x0);
        }

        @Override
        public /* synthetic */ Object forInstanceofTest(Tree.InstanceofTest x0) {
            return this.forInstanceofTest(x0);
        }

        @Override
        public /* synthetic */ Object forTypeCast(Tree.TypeCast x0) {
            return this.forTypeCast(x0);
        }

        @Override
        public /* synthetic */ Object forNewInstance(Tree.NewInstance x0) {
            return this.forNewInstance(x0);
        }
    };

    private VisitorArgs(SymbolTable syms, Symbol.ClassSymbol owner, Symbol.ClassSymbol template) {
        this.symbolTable = syms;
        this.enclosingClass = owner;
        this.enclosingClassTemplate = template;
    }

    public VisitorArgs(SymbolTable syms, Symbol.ClassSymbol owner) {
        this(syms, owner, Symbol.ERROR_SYMBOL);
    }

    public ListBox<SnippetClosure> getSnipClosures() {
        return this.snippetClosures;
    }

    public ListBox<Tree> getConstructors() {
        return this.constructors;
    }

    public ListBox<Tree> getAbstractSnippets() {
        return this.abstractSnippets;
    }

    public Symbol.MethodSymbol getCachedSnippet(Tree.Snippetable expr) {
        return this.snippetCache.get(expr.toSnippetString());
    }

    public void putCachedSnippet(Tree.Snippetable expr, Symbol.MethodSymbol sym) {
        this.snippetCache.put(expr.toSnippetString(), sym);
    }

    public Tree.SnippetableVisitor<Tree> getFlattenVisitor() {
        return this.snippetFlattener;
    }

    public VisitorArgs newVisitorArgs(Symbol.ClassSymbol owner, Symbol.ClassSymbol template) {
        return new VisitorArgs(this.symbolTable, owner, template);
    }
}

