/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.instrument;

import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListIterator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Stack;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrintableObject {
    protected static PrintStream outputStream = System.out;
    protected static int lineLength = 200;
    protected static int tabLength = 2;
    protected static StringBuffer stringBuffer = new StringBuffer(lineLength);
    protected static Stack boxes = new Stack();
    protected static Stack breakHints = new Stack();

    public PrintableObject() {
        boxes.push(new Box(0));
    }

    public static <Item extends PrintableObject> void printItems(List<Item> items, boolean useNL, boolean flushEnd, String open, String separator, String close) {
        PrintableObject.print(open);
        ListIterator<Item> i = items.iterator();
        while (i.hasNext()) {
            ((PrintableObject)i.next()).print();
            if (!i.hasNext()) continue;
            PrintableObject.print(separator);
            if (useNL) {
                PrintableObject.newline();
                continue;
            }
            PrintableObject.breakHint();
        }
        PrintableObject.print(close);
        if (flushEnd) {
            PrintableObject.flush();
        }
    }

    public static <Item extends PrintableObject> void printItems(List<Item> items) {
        PrintableObject.printItems(items, true, true, "", "", "");
    }

    public static <Item extends PrintableObject> void printItemsNoFlush(List<Item> items) {
        PrintableObject.printItems(items, true, false, "", "", "");
    }

    public static <Item extends PrintableObject> void printItems(List<Item> items, String prefix, String separator, String suffix) {
        PrintableObject.printItems(items, false, false, prefix, separator, suffix);
    }

    public static <Item extends PrintableObject> String itemsToString(List<Item> items) {
        ByteArrayOutputStream characters = new ByteArrayOutputStream();
        PrintStream buffer = new PrintStream(characters);
        PrintStream oldW = outputStream;
        PrintableObject.setStream(buffer);
        PrintableObject.printItems(items);
        PrintableObject.setStream(oldW);
        return characters.toString();
    }

    protected static void flushLine(BreakHint bh) {
        int i;
        int upto = bh.position();
        String bufs = stringBuffer.toString();
        String out = bufs.substring(0, upto);
        outputStream.println(out);
        String keep = "";
        if (upto < bufs.length()) {
            keep = bufs.substring(upto, bufs.length());
            for (i = 0; i < keep.length() && (keep.charAt(i) == ' ' || keep.charAt(i) == '\t'); ++i) {
            }
            keep = keep.substring(i, keep.length());
        }
        stringBuffer.setLength(0);
        for (i = 0; i < bh.owner().indentation(); ++i) {
            stringBuffer.append(' ');
        }
        stringBuffer.append(keep);
    }

    protected static void breakLine() {
        if (!breakHints.empty()) {
            BreakHint bh = (BreakHint)breakHints.pop();
            breakHints.removeAllElements();
            PrintableObject.flushLine(bh);
        }
    }

    public static void flush() {
        PrintableObject.breakHint();
        PrintableObject.breakLine();
        outputStream.flush();
    }

    protected static void checkBreak(int addedLength) {
        if (stringBuffer.length() + addedLength > lineLength) {
            PrintableObject.breakLine();
        }
    }

    protected static void append(char c) {
        PrintableObject.checkBreak(1);
        stringBuffer.append(c);
    }

    protected static void append(String s) {
        PrintableObject.checkBreak(s.length());
        stringBuffer.append(s);
    }

    public static void openBox(int relativeIndent) {
        boxes.push(new Box(stringBuffer.length() + relativeIndent));
    }

    public static void closeBox() {
        if (boxes.empty()) {
            throw new RuntimeException("closeBox() with no matching openBox()");
        }
        Box box = (Box)boxes.pop();
        while (!breakHints.empty() && ((BreakHint)PrintableObject.breakHints.peek()).owner == box) {
            breakHints.pop();
        }
    }

    public static void breakHint() {
        breakHints.push(new BreakHint(stringBuffer.length(), (Box)boxes.peek()));
    }

    public static PrintStream getStream() {
        return outputStream;
    }

    public static void setStream(PrintStream w) {
        PrintableObject.flush();
        outputStream = w;
    }

    public static void leftParen() {
        PrintableObject.breakHint();
        PrintableObject.openBox(2);
        PrintableObject.append('(');
    }

    public static void rightParen() {
        PrintableObject.append(')');
        PrintableObject.closeBox();
    }

    public static void leftBrace() {
        PrintableObject.breakHint();
        PrintableObject.openBox(2);
        PrintableObject.append('{');
    }

    public static void rightBrace() {
        PrintableObject.append('}');
        PrintableObject.closeBox();
    }

    public static void leftBracket() {
        PrintableObject.breakHint();
        PrintableObject.openBox(2);
        PrintableObject.append('[');
    }

    public static void rightBracket() {
        PrintableObject.append(']');
        PrintableObject.closeBox();
    }

    public static void newline() {
        PrintableObject.breakHint();
        PrintableObject.breakLine();
    }

    public static void tab() {
        PrintableObject.breakHint();
        for (int i = 0; i < tabLength; ++i) {
            PrintableObject.append(' ');
        }
    }

    public static void space() {
        PrintableObject.breakHint();
        PrintableObject.append(' ');
    }

    public static void print(String s) {
        PrintableObject.append(s);
    }

    public static void braces(String s) {
        PrintableObject.leftParen();
        PrintableObject.append(s);
        PrintableObject.rightParen();
    }

    public static void include(String s, Object x, boolean useNL) {
        if (x instanceof PrintableObject) {
            PrintableObject.include(s, (PrintableObject)x, useNL);
        } else {
            if (x instanceof String) {
                x = new StringBuffer().append("\"").append(x).append("\"").toString();
            }
            PrintableObject.print(s);
            if (useNL) {
                PrintableObject.newline();
            }
            if (x != null) {
                PrintableObject.print(x.toString());
            } else {
                PrintableObject.print("null");
            }
        }
    }

    public static void include(String s, PrintableObject x, boolean useNL) {
        PrintableObject.print(s);
        if (useNL) {
            PrintableObject.newline();
        }
        if (x != null) {
            x.print();
        } else {
            PrintableObject.print("null");
        }
    }

    public static void include(PrintableObject x) {
        PrintableObject.include("", x, false);
    }

    public static void include(Object x) {
        PrintableObject.include("", x, false);
    }

    public static void include(String s, int x, boolean useNL) {
        PrintableObject.include(s, new Integer(x), useNL);
    }

    public void print() {
        PrintableObject.print(this.getClass().getName());
    }

    public void printToStream(PrintStream _w) {
        PrintStream oldW = outputStream;
        PrintableObject.setStream(_w);
        this.print();
        PrintableObject.setStream(oldW);
    }

    public String longString() {
        ByteArrayOutputStream characters = new ByteArrayOutputStream();
        PrintStream buffer = new PrintStream(characters);
        this.printToStream(buffer);
        return characters.toString();
    }

    public static void main(String[] args) {
        PrintablePoint ex1 = new PrintablePoint(10, 20);
        ex1.print();
        PrintableObject.flush();
    }

    protected static class PrintablePoint
    extends PrintableObject {
        protected int x;
        protected int y;

        public PrintablePoint(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void print() {
            PrintablePoint.leftParen();
            super.print();
            PrintablePoint.space();
            PrintablePoint.leftParen();
            PrintablePoint.print("A long bracketed string designed to force");
            PrintablePoint.breakHint();
            PrintablePoint.print(" a line wrap at some interior position");
            PrintablePoint.breakHint();
            PrintablePoint.print(" and moreover to have a couple of interior");
            PrintablePoint.breakHint();
            PrintablePoint.print(" line breaks");
            PrintablePoint.rightParen();
            PrintablePoint.space();
            PrintablePoint.braces("x: " + String.valueOf(this.x));
            PrintablePoint.space();
            PrintablePoint.braces("y: " + String.valueOf(this.y));
            PrintablePoint.rightParen();
        }
    }

    protected static class BreakHint {
        protected int pos;
        protected Box owner;

        public BreakHint(int pos, Box owner) {
            this.pos = pos;
            this.owner = owner;
        }

        public int position() {
            return this.pos;
        }

        public Box owner() {
            return this.owner;
        }
    }

    protected static class Box {
        protected int indentation;

        public Box(int indentation) {
            this.indentation = indentation;
        }

        public int indentation() {
            return this.indentation;
        }
    }
}

