/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.instrument.DebugLog;
import edu.rice.cs.nextgen.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen.compiler.main.Retrofitter;
import edu.rice.cs.nextgen.compiler.main.Win32;
import edu.rice.cs.nextgen.compiler.tree.PrettyPrinter;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.AbortError;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CompilerOptions {
    private static final String[][] POSSIBLE_OPTIONS = new String[][]{{"-classpath", "pathname", "use given classpath"}, {"-d", "filename", "redirect classfile output"}, {"-debug", "level", "debugging level: ALWAYS, SERIOUS, DEFAULT, INFO"}, {"-debuglog", "filename", "redirect debug log output"}, {"-experimental", "", "enable experimental features"}, {"-g", "", "include debug information"}, {"-1.1", "", "accept only standard Java 1.1 input"}, {"-moreinfo", "", "print extended information for type variables"}, {"-printtree", "", "print abstract syntax tree for internal debugging"}, {"-printsourcecode", "", "print source code for internal debugging"}, {"-printsymbols", "", "print the symbol table for internal debugging"}, {"-printsearch", "", "print information where classfiles are searched"}, {"-prompt", "", "stop after each error"}, {"-retrofit", "", "retrofit existing classfile with generic types"}, {"-s", "", "emit java sources instead of classfiles"}, {"-scramble", "", "scramble private identifiers in bytecode"}, {"-scrambleall", "", "scramble package visible identifiers in bytecode"}, {"-switchcheck", "", "warn about fall-through in switches"}, {"-unchecked", "", "suppress \"unchecked\" warnings"}, {"-verbose", "", "print detailed log"}, {"-version", "", "version information"}, {"-doc", "", "generate html documents"}};
    private final Hashtable<String, String> optionTable = new Hashtable();

    private final String getVersion() {
        return System.getProperty("java.version");
    }

    private final String getDate() {
        return "10-Nov-02";
    }

    private final String getGjVersion() {
        return "v0.6";
    }

    private final String getGjDate() {
        return "1-Jun-02";
    }

    final void bugMessage() {
        System.err.println(new StringBuffer().append("\n\nAn exception has occurred in the compiler. (").append(this.getVersion()).append(")").toString());
        System.err.println("Please file a bug report by sending your program and the following diagnostic to");
        System.err.println("javaplt@rice.edu.\n\n   Thank you.\n");
    }

    List<String> processArgs(String[] args) throws AbortError, IOException {
        ListBox<String> filenames = new ListBox<String>();
        if (args.length == 0) {
            CompilerOptions.help();
            throw new AbortError();
        }
        List<String> l = Win32.expand(args);
        while (l.nonEmpty()) {
            String arg = l.getFirst();
            l = l.getRest();
            if (arg.startsWith("-")) {
                int j;
                if (arg.equals("-version")) {
                    System.err.println(new StringBuffer().append("NGC ").append(this.getVersion()).append(", ").append(this.getDate()).append(", Robert Cartwright and Eric E. Allen\nderived from\n").append("GJC ").append(this.getGjVersion()).append(", ").append(this.getGjDate()).append(", Copyright (c) 1997,98 Martin Odersky.").toString());
                    continue;
                }
                for (j = 0; j < POSSIBLE_OPTIONS.length && !POSSIBLE_OPTIONS[j][0].equals(arg); ++j) {
                }
                if (j == POSSIBLE_OPTIONS.length) {
                    CompilerOptions.error(new StringBuffer().append("invalid flag: ").append(arg).toString());
                    throw new AbortError();
                }
                String operand = POSSIBLE_OPTIONS[j][1];
                if (operand.length() != 0) {
                    if (l.isEmpty()) {
                        CompilerOptions.error(new StringBuffer().append(arg).append(" requires argument").toString());
                        throw new AbortError();
                    }
                    operand = l.getFirst();
                    l = l.getRest();
                }
                if (arg.equals("-moreinfo")) {
                    Type.moreInfo = true;
                    continue;
                }
                this.optionTable.put(arg, operand);
                continue;
            }
            if (arg.endsWith(".java")) {
                filenames.insertEnd(arg);
                continue;
            }
            CompilerOptions.error(new StringBuffer().append("invalid argument: ").append(arg).toString());
            return null;
        }
        this.setupDebugLog();
        return filenames.toList();
    }

    public void printIfVerbose(String filename) {
        if (this.optionTable.get("-verbose") != null) {
            System.err.print(new StringBuffer().append("[parsing ").append(filename).append(" ").toString());
        }
    }

    private void setupDebugLog() {
        String lf = this.getDebugLog();
        String lv = this.debug();
        if (lf != null) {
            try {
                PrintStream out = new PrintStream(new FileOutputStream(lf));
                DebugLog.ONLY.setOut(out);
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
        }
        if (lv != null) {
            int level = 10;
            if (lv.equals("ALWAYS")) {
                level = 0;
            } else if (lv.equals("SERIOUS")) {
                level = 5;
            } else if (lv.equals("DEFAULT")) {
                level = 10;
            } else if (lv.equals("INFO")) {
                level = 15;
            } else {
                DebugLog.ONLY.println(0, new StringBuffer().append("illegal debug level ").append(lv).toString());
            }
            DebugLog.ONLY.setLevel(level);
        }
    }

    private static void help() throws AbortError {
        System.err.println("Usage: ngc [ possibleOptions ] file.java ... ");
        System.err.println("where possibleOptions include:");
        for (int i = 0; i < POSSIBLE_OPTIONS.length; ++i) {
            String s = new StringBuffer().append("  ").append(POSSIBLE_OPTIONS[i][0]).append(" ").append(POSSIBLE_OPTIONS[i][1]).toString();
            System.err.print(s);
            for (int j = s.length(); j < 28; ++j) {
                System.err.print(" ");
            }
            System.err.println(POSSIBLE_OPTIONS[i][2]);
        }
        System.err.println();
    }

    private static void error(String arg) {
        System.err.println(new StringBuffer().append("gjc: ").append(arg).toString());
        CompilerOptions.help();
    }

    private boolean shouldRetrofit() {
        return this.optionTable.get("-retrofit") != null;
    }

    private String getDebugLog() {
        return this.optionTable.get("-debuglog");
    }

    private String debug() {
        return this.optionTable.get("-debug");
    }

    public boolean shouldPromptOnError() {
        return this.optionTable.get("-promptOnError") != null;
    }

    public boolean isUnchecked() {
        return this.optionTable.get("-unchecked") != null;
    }

    public String getClassPath() {
        String result = this.optionTable.get("-classpath");
        if (result == null) {
            result = System.getProperty("java.class.path");
        }
        return new StringBuffer().append(result).append(File.pathSeparator).toString();
    }

    public boolean checkClassFile() {
        return this.optionTable.get("-checkclassfile") != null;
    }

    public File getOutputDirectory() {
        String od = this.optionTable.get("-d");
        if (od != null) {
            return new File(od);
        }
        return null;
    }

    public String getTargetVersion() {
        return this.optionTable.get("-target");
    }

    public boolean scramble() {
        return this.optionTable.get("-scramble") != null;
    }

    public boolean scrambleAll() {
        return this.optionTable.get("-scrambleAll") != null;
    }

    public boolean switchCheck() {
        return this.optionTable.get("-switchcheck") != null;
    }

    public boolean debugInfo() {
        return this.optionTable.get("-g") != null;
    }

    public boolean retrofitMode() {
        return this.optionTable.get("-retrofit") != null;
    }

    public void printIfPrintSymbols(SymbolTable symbolTable, String comment) {
        if (this.optionTable.get("-printsymbols") != null) {
            System.out.println(new StringBuffer().append(comment).append("\n").toString());
            SymbolTable.setStream(System.out);
            symbolTable.print();
            symbolTable.flush();
            System.out.print("\n\n");
            System.out.flush();
        }
    }

    public void printIfPrintTree(Tree tree, String comment) {
        if (this.optionTable.get("-printtree") != null) {
            System.out.println(new StringBuffer().append(comment).append("\n").toString());
            Tree.setStream(System.out);
            tree.print();
            tree.flush();
            System.out.print("\n\n");
            System.out.flush();
        }
    }

    public void printIfPrintSourceCode(Environment<AnalyzerContext> env, Tree.ClassDef classDef, String comment) {
        if (this.optionTable.get("-printsourcecode") != null) {
            new PrettyPrinter(System.out).printUnit(env.topLevel, classDef);
        }
    }

    public boolean outputSource() {
        return this.optionTable.get("-s") != null;
    }

    public boolean printSymbols() {
        return this.optionTable.get("-printsymbols") != null;
    }

    public void retrofitIfInstructed(JavaCompiler compiler, List<Symbol.ClassSymbol> classSymbols) {
        if (this.shouldRetrofit()) {
            Retrofitter retrofitter = new Retrofitter(compiler, this);
            while (classSymbols.nonEmpty()) {
                retrofitter.fit(classSymbols.getFirst());
                classSymbols = classSymbols.getRest();
            }
        }
    }
}

