/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import java.io.IOException;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class JavaCompilerTest
extends NextGenTestCase {
    private JavaCompiler _compiler;
    List<String> _fileNames;

    public JavaCompilerTest(String name) {
        super(name);
    }

    protected void setUp() throws IOException {
        String[] args = new String[]{"-classpath", System.getProperty("sun.boot.class.path"), "simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java"};
        CompilerOptions options = new CompilerOptions();
        this._fileNames = options.processArgs(args);
        this._compiler = new JavaCompiler(options);
    }

    protected void tearDown() {
        this._compiler = null;
    }

    public void testParseFiles() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        String expectedResult = "{TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: null starImportScope (except for java.lang): null namedImportScope: null ========== {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1   null   {MethodDef <> {TypeIdent null} is({VarDef {Ident Object} o}) throws  flags: 1     null     {Block {VarDef {TypeIdent null} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}            {Return {Ident ret}}}}}}";
        JavaCompilerTest.assertEquals((String)"Too many TopLevels", (int)1, (int)trees.length());
        JavaCompilerTest.assertEquals((String)"File not parsed properly.", (String)JavaCompilerTest.removeWhiteSpace(expectedResult), (String)JavaCompilerTest.removeWhiteSpace(trees.getFirst().longString()));
    }

    public void testTableEnterSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        String EXPECTED = "[SymbolTable  packages:     edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]    edu.rice => [PackageSymbol edu.rice]    edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]    edu.rice.cs => [PackageSymbol edu.rice.cs]    edu => [PackageSymbol edu]  classes:     edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                             flags: 4194305                                                             members (cyclic references have been filtered):                                                             [Scope: [MethodSymbol is]                                                                     [MethodSymbol <init>]]]]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages:     edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]    edu.rice => [PackageSymbol edu.rice]    edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]    edu.rice.cs => [PackageSymbol edu.rice.cs]    edu => [PackageSymbol edu]  classes:     edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                             flags: 4194305                                                             members (cyclic references have been filtered):                                                             [Scope: [MethodSymbol is]                                                                     [MethodSymbol <init>]]]]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public void testTreeEnterSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305      members (cyclic references have been filtered):      [Scope: [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent null} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305              members (cyclic references have been filtered):              [Scope: [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305        members (cyclic references have been filtered):        [Scope: [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent null} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Symbols not added into Tree properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305      members (cyclic references have been filtered):      [Scope: [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent null} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305              members (cyclic references have been filtered):              [Scope: [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 4194305        members (cyclic references have been filtered):        [Scope: [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent null} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testCheckTypes() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1      members (cyclic references have been filtered):      [Scope: [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1              members (cyclic references have been filtered):              [Scope: [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1        members (cyclic references have been filtered):        [Scope: [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Symbols not added into Tree properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1      members (cyclic references have been filtered):      [Scope: [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1              members (cyclic references have been filtered):              [Scope: [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1        members (cyclic references have been filtered):        [Scope: [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident o} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testCheckTypesSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        String EXPECTED = "[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public void testFlatten() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Tree not flattened properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testFlattenSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        String EXPECTED = "[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public void testPatchSnippets() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Snippets not patched properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testPatchSnippetsSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        String EXPECTED = "[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public void testEraseTypes() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Types not erased properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testEraseTypesSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        String EXPECTED = "[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is]                                                                            [MethodSymbol <init>]]]           ]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public void testFlattenGroundedSuperClasses() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        this._compiler.flattenGroundedSuperClasses();
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Grounded superclasses not flattened properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol <init>]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                          [MethodSymbol <init>]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is]                                      [MethodSymbol <init>]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is]              [MethodSymbol <init>]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is]                      [MethodSymbol <init>]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is]                                        [MethodSymbol <init>]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is]                [MethodSymbol <init>]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testGenerateByteCode() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        this._compiler.flattenGroundedSuperClasses();
        List<Symbol.ClassSymbol> classSyms = this._compiler.generateByteCode(envs);
        String EXPECTED = "[ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R  members (cyclic references have been filtered):  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T            [Code: aload_1; -63; nop; aconst_null; -84; ]]          [MethodSymbol <init>            [Code: aload_0; -73; nop; iconst_m1; -79; ]]    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513              members (cyclic references have been filtered):              [Scope:                 [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                        <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                        [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                          members (cyclic references have been filtered):                          [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                  [MethodSymbol is                                    [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                  [MethodSymbol <init>                                    [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R            <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]][ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513  members (cyclic references have been filtered):  [Scope:     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$            [ClassInstantiationSymbol              InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                        [Code: aload_1; -63; nop; aconst_null; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; iconst_m1; -79; ]]                [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                        <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                        [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                          members (cyclic references have been filtered):                          [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                  [MethodSymbol is                                    [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                  [MethodSymbol <init>                                    [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]            <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]][ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025  members (cyclic references have been filtered):  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]          [MethodSymbol is            [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]          [MethodSymbol <init>            [Code: aload_0; -73; nop; aconst_null; -79; ]]]]";
        JavaCompilerTest.assertEquals((String)"Grounded superclasses not flattened properly.", (String)JavaCompilerTest.removeWhiteSpace("[ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R  members (cyclic references have been filtered):  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T            [Code: aload_1; -63; nop; aconst_null; -84; ]]          [MethodSymbol <init>            [Code: aload_0; -73; nop; iconst_m1; -79; ]]    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513              members (cyclic references have been filtered):              [Scope:                 [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                        <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                        [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                          members (cyclic references have been filtered):                          [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                  [MethodSymbol is                                    [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                  [MethodSymbol <init>                                    [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R            <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]][ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513  members (cyclic references have been filtered):  [Scope:     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$            [ClassInstantiationSymbol              InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                        [Code: aload_1; -63; nop; aconst_null; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; iconst_m1; -79; ]]                [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                        <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                        [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                          members (cyclic references have been filtered):                          [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                  [MethodSymbol is                                    [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                  [MethodSymbol <init>                                    [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]            <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]][ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025  members (cyclic references have been filtered):  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]          [MethodSymbol is            [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]          [MethodSymbol <init>            [Code: aload_0; -73; nop; aconst_null; -79; ]]]]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(classSyms)));
    }

    public void testGenerateByteCodeTrees() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        this._compiler.flattenGroundedSuperClasses();
        List<Symbol.ClassSymbol> classSyms = this._compiler.generateByteCode(envs);
        String EXPECTED = "[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                [Code: aload_1; -63; nop; aconst_null; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; iconst_m1; -79; ]]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is                                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                      [MethodSymbol <init>                                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T        [Code: aload_1; -63; nop; aconst_null; -84; ]]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; iconst_m1; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                            [Code: aload_1; -63; nop; aconst_null; -84; ]]                          [MethodSymbol <init>                            [Code: aload_0; -73; nop; iconst_m1; -79; ]]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is                                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                      [MethodSymbol <init>                                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]";
        JavaCompilerTest.assertEquals((String)"Tree not flattened properly.", (String)JavaCompilerTest.removeWhiteSpace("[Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R<> extends {TypeIdent InstanceOfParameter<T>} implements (InstanceOfParameter$$L{0}$$R$) flags: 1    [ClassInstantiationSymbol InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                [Code: aload_1; -63; nop; aconst_null; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; iconst_m1; -79; ]]        [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513                  members (cyclic references have been filtered):                  [Scope:                     [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is                                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                      [MethodSymbol <init>                                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]                <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    {MethodDef <> {Ident boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident $x0} $x0}) throws  flags: 4      [MethodSymbol InstanceOfParameter$$instanceOf$T        [Code: aload_1; -63; nop; aconst_null; -84; ]]      {Block {Return {InstanceofTest {Ident $x0} instanceof {Ident {0}$}}}}}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; iconst_m1; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter$$L{0}$$R$<> extends null implements () flags: 513    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$ flags: 513      members (cyclic references have been filtered):      [Scope:         [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                [ClassInstantiationSymbol                  InstanceOfParameter$$L{0}$$R fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                  members (cyclic references have been filtered):                  [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T                            [Code: aload_1; -63; nop; aconst_null; -84; ]]                          [MethodSymbol <init>                            [Code: aload_0; -73; nop; iconst_m1; -79; ]]                    [Scope: <filtered entry>: interface edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R$                            <filtered entry>: class instantiation edu.rice.cs.nextgen.simpletests.InstanceOfParameter$$L{0}$$R                            [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                              members (cyclic references have been filtered):                              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                      [MethodSymbol is                                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                      [MethodSymbol <init>                                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]]                <filtered entry>: class edu.rice.cs.nextgen.simpletests.InstanceOfParameter]]]    }][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}][Environment   [AnalyzerContext  expectedType: null  expectedKind: 0    [Scope: [VarSymbol super]            [VarSymbol this]            [TypeSymbol T]]]  {ClassDef InstanceOfParameter<> extends null implements () flags: 1025    [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025      members (cyclic references have been filtered):      [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]              [MethodSymbol is                [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]              [MethodSymbol <init>                [Code: aload_0; -73; nop; aconst_null; -79; ]]]]    {MethodDef <> {TypeIdent boolean} InstanceOfParameter$$instanceOf$T({VarDef {Ident Object} $x0}) throws  flags: 1028      [MethodSymbol InstanceOfParameter$$instanceOf$T]      null}    {MethodDef <> null <init>() throws  flags: 1      [MethodSymbol <init>        [Code: aload_0; -73; nop; aconst_null; -79; ]]      {Block {ExpressionStatement {Apply {Ident super}()}}}}    {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1      [MethodSymbol is        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]      {Block {VarDef {TypeIdent boolean} ret = {Apply {Ident InstanceOfParameter$$instanceOf$T}({Ident o})}}             {Return {Ident ret}}}}}][Environment   [AnalyzerContext  expectedType: NoType  expectedKind: 0    [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025              members (cyclic references have been filtered):              [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                      [MethodSymbol is                        [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                      [MethodSymbol <init>                        [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]]  {TopLevel for simpletests/edu/rice/cs/nextgen/simpletests/InstanceOfParameter.java    packageId: {Select {Select {Select {Select {Ident edu}.rice}.cs}.nextgen}.simpletests} packageSymbol: [PackageSymbol edu.rice.cs.nextgen.simpletests]    starImportScope (except for java.lang): null    namedImportScope: [Scope: [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                members (cyclic references have been filtered):                                [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                        [MethodSymbol is                                          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                        [MethodSymbol <init>                                          [Code: aload_0; -73; nop; aconst_null; -79; ]]]]]    ==========    {ClassDef InstanceOfParameter<{TypeParameter T extends null implements null}> extends null implements () flags: 1      [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter  flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025        members (cyclic references have been filtered):        [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                [MethodSymbol is                  [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                [MethodSymbol <init>                  [Code: aload_0; -73; nop; aconst_null; -79; ]]]]      {MethodDef <> null <init>() throws  flags: 1        [MethodSymbol <init>          [Code: aload_0; -73; nop; aconst_null; -79; ]]        {Block {ExpressionStatement {Apply {Ident super}()}}}}      {MethodDef <> {TypeIdent boolean} is({VarDef {Ident Object} o}) throws  flags: 1        [MethodSymbol is          [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]        {Block {VarDef {TypeIdent boolean} ret = {InstanceofTest {Ident $x0} instanceof {Ident T}}}               {Return {Ident ret}}}}}}]"), (String)JavaCompilerTest.removeWhiteSpace(PrintableObject.itemsToString(envs)));
    }

    public void testGenerateByteCodeSymbols() throws Throwable {
        ListBox<Tree> trees = this._compiler.parseFiles(this._fileNames);
        List<Environment<AnalyzerContext>> envs = this._compiler.enterClasses(trees);
        this._compiler.checkTypes(envs);
        envs = this._compiler.flatten(envs);
        this._compiler.patchSnippets();
        this._compiler.eraseTypes(envs);
        this._compiler.flattenGroundedSuperClasses();
        List<Symbol.ClassSymbol> classSyms = this._compiler.generateByteCode(envs);
        String EXPECTED = "[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is                                                                              [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                                                            [MethodSymbol <init>                                                                              [Code: aload_0; -73; nop; aconst_null; -79; ]]]]           ]";
        JavaCompilerTest.assertEquals((String)"SymbolTable not modified properly.", (String)JavaCompilerTest.removeWhiteSpace("[SymbolTable  packages: edu.rice.cs.nextgen => [PackageSymbol edu.rice.cs.nextgen]            edu.rice => [PackageSymbol edu.rice]            edu.rice.cs.nextgen.simpletests => [PackageSymbol edu.rice.cs.nextgen.simpletests]            edu.rice.cs => [PackageSymbol edu.rice.cs]            edu => [PackageSymbol edu]              classes: edu.rice.cs.nextgen.simpletests.InstanceOfParameter => [ClassSymbol  fullname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter                                                                    flatname: edu.rice.cs.nextgen.simpletests.InstanceOfParameter flags: 1025                                                                    members (cyclic references have been filtered):                                                                    [Scope: [MethodSymbol InstanceOfParameter$$instanceOf$T]                                                                            [MethodSymbol is                                                                              [Code: aload_0; aload_1; -74; nop; iconst_m1; istore_2; iload_2; -84; ]]                                                                            [MethodSymbol <init>                                                                              [Code: aload_0; -73; nop; aconst_null; -79; ]]]]           ]"), (String)JavaCompilerTest.removeWhiteSpace(this._compiler.getSymbolTable().longString()));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(1.class$edu$rice$cs$nextgen$compiler$main$JavaCompilerTest == null ? (1.class$edu$rice$cs$nextgen$compiler$main$JavaCompilerTest = 1.class$("edu.rice.cs.nextgen.compiler.main.JavaCompilerTest")) : 1.class$edu$rice$cs$nextgen$compiler$main$JavaCompilerTest));
    }

    static class 1 {
        static /* synthetic */ Class class$edu$rice$cs$nextgen$compiler$main$JavaCompilerTest;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

