/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.main;

import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.main.JavaCompiler;
import edu.rice.cs.nextgen.compiler.main.Win32;
import edu.rice.cs.nextgen.compiler.tree.PrettyPrinter;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;

public class JavaPrettyPrinter {
    public static void main(String[] args) {
        try {
            List<String> filenames = Win32.expand(args);
            JavaCompiler comp = new JavaCompiler(new CompilerOptions());
            if (filenames != null && comp != null) {
                ListBox<Tree> trees = comp.parseFiles(filenames);
                List<Environment<AnalyzerContext>> envs = comp.enterClasses(trees);
                ListBox classSyms = new ListBox();
                comp.checkTypes(envs);
                PrettyPrinter prettyPrinter = new PrettyPrinter();
                Integer prettyPrinterArg = new Integer(0);
                while (envs.nonEmpty()) {
                    Tree.TopLevel next = envs.getFirst().topLevel;
                    System.out.println("pretty printing " + next.sourcefile + "...");
                    next.accept(prettyPrinter, new Integer(0));
                    envs = envs.getRest();
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

