/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.parser;

import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.parser.Parser;
import edu.rice.cs.nextgen.compiler.parser.Scanner;
import edu.rice.cs.nextgen.compiler.parser.Tokens;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ParserTest
extends NextGenTestCase
implements Tokens {
    InputStream inputStream;
    ErrorLog log;
    Scanner scanner;

    public ParserTest(String name) {
        super(name);
    }

    public void testCompilationUnit() {
        ErrorLog log = new ErrorLog();
        String CLASS_SOURCE = "public class C<T> { \n}                   \n";
        String EXPECTED = "{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef C<{TypeParameter T extends null implements null}> extends null implements () flags: 1    null    }}";
        Scanner s = new Scanner(new ByteArrayInputStream("public class C<T> { \n}                   \n".getBytes()), log);
        TreeMaker t = new TreeMaker();
        Parser p = new Parser(s, t, log);
        Tree.TopLevel result = p.compilationUnit();
        ParserTest.assertEquals((String)"parse contained errors.", (int)0, (int)log.errorCount());
        ParserTest.assertEquals((String)"parse contained warnings.", (int)0, (int)log.nwarnings);
        ParserTest.assertEquals((String)"AST structure wrong.", (String)ParserTest.removeWhiteSpace("{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef C<{TypeParameter T extends null implements null}> extends null implements () flags: 1    null    }}"), (String)ParserTest.removeWhiteSpace(result.longString()));
    }

    public void testInterfaces() {
        ErrorLog log = new ErrorLog();
        String CLASS_SOURCE = "public interface I { \n}                    \n";
        String EXPECTED = "{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef I<> extends null implements () flags: 513    null    }}";
        Scanner s = new Scanner(new ByteArrayInputStream("public interface I { \n}                    \n".getBytes()), log);
        TreeMaker t = new TreeMaker();
        Parser p = new Parser(s, t, log);
        Tree.TopLevel result = p.compilationUnit();
        ParserTest.assertEquals((String)"parse contained errors", (int)0, (int)log.errorCount());
        ParserTest.assertEquals((String)"parse contained warnings", (int)0, (int)log.nwarnings);
        ParserTest.assertEquals((String)"AST structure wrong", (String)ParserTest.removeWhiteSpace("{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef I<> extends null implements () flags: 513    null    }}"), (String)ParserTest.removeWhiteSpace(result.longString()));
    }

    public void testConstructorsInInterfaces() {
        ErrorLog log = new ErrorLog();
        String CLASS_SOURCE = "public interface I { \n  public I() {}      \n}                    \n";
        String EXPECTED = "{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef I<> extends null implements () flags: 513    null    {VarDef {Ident I} <error>}}}";
        Scanner s = new Scanner(new ByteArrayInputStream("public interface I { \n  public I() {}      \n}                    \n".getBytes()), log);
        TreeMaker t = new TreeMaker();
        Parser p = new Parser(s, t, log);
        Tree.TopLevel result = p.compilationUnit();
        ParserTest.assertEquals((String)"parse should've signaled errors", (int)3, (int)log.errorCount());
        ParserTest.assertEquals((String)"parse contained warnings", (int)0, (int)log.nwarnings);
        ParserTest.assertEquals((String)"AST structure wrong", (String)ParserTest.removeWhiteSpace("{TopLevel for null  packageId: null packageSymbol: null  starImportScope (except for java.lang): null  namedImportScope: null  ==========  {ClassDef I<> extends null implements () flags: 513    null    {VarDef {Ident I} <error>}}}"), (String)ParserTest.removeWhiteSpace(result.longString()));
    }
}

