/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.parser;

import edu.rice.cs.nextgen.compiler.parser.Scanner;
import edu.rice.cs.nextgen.compiler.parser.Tokens;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Name;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import junit.framework.TestCase;

public class ScannerTest
extends TestCase
implements Tokens {
    InputStream inputStream;
    ErrorLog log;
    Scanner scanner;

    public ScannerTest(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        this.log = new ErrorLog();
    }

    public void setUp(String testString) {
        this.scanner = new Scanner(new ByteArrayInputStream(testString.getBytes()), this.log);
    }

    public void check(String testString, int[] tokens, String[] names) {
        this.setUp(testString);
        for (int i = 0; i < tokens.length; ++i) {
            ScannerTest.assertEquals((String)("Unexpected scanner token at position " + i + ":"), (int)tokens[i], (int)this.scanner.currentToken);
            ScannerTest.assertEquals((String)("Unexpected scanner name at position " + i + ":"), (Object)Name.fromString(names[i]), (Object)this.scanner.name);
            this.scanner.nextToken();
        }
    }

    public void testClassSource() {
        String CLASS_SOURCE = "public class C<T> { \n}                   \n";
        int[] CLASS_TOKENS = new int[]{35, 10, 2, 71, 2, 70, 62, 63};
        String[] CLASS_NAMES = new String[]{"public", "class", "C", "<", "T", ">", ">", ">"};
        this.check("public class C<T> { \n}                   \n", CLASS_TOKENS, CLASS_NAMES);
    }

    public void testMethodSignatureSource() {
        String METHOD_SIGNATURE_SOURCE = "public <Type extends Object> Object fun(Type input);";
        int[] METHOD_SIGNATURE_TOKENS = new int[]{35, 71, 2, 17, 2, 70, 2, 2, 60, 2, 2, 61, 66};
        String[] METHOD_SIGNATURE_NAMES = new String[]{"public", "<", "Type", "extends", "Object", ">", "Object", "fun", "fun", "Type", "input", "input", "input", "input"};
        this.check("public <Type extends Object> Object fun(Type input);", METHOD_SIGNATURE_TOKENS, METHOD_SIGNATURE_NAMES);
    }

    public void testMethodApplicationSource() {
        String METHOD_APP_SOURCE = "fun(arg0, arg1, arg2)";
        int[] METHOD_APP_TOKENS = new int[]{2, 60, 2, 67, 2, 67, 2, 61};
        String[] METHOD_APP_NAMES = new String[]{"fun", "fun", "arg0", "arg0", "arg1", "arg1", "arg2", "arg2"};
        this.check("fun(arg0, arg1, arg2)", METHOD_APP_TOKENS, METHOD_APP_NAMES);
    }

    public void testPrimitiveFieldDefSource() {
        String PRIMITIVE_FIELD_DEF_SOURCE = "int i = 0;";
        int[] PRIMITIVE_FIELD_DEF_TOKENS = new int[]{27, 2, 69, 51, 66};
        String[] PRIMITIVE_FIELD_DEF_NAMES = new String[]{"int", "i", "=", "=", "="};
        this.check("int i = 0;", PRIMITIVE_FIELD_DEF_TOKENS, PRIMITIVE_FIELD_DEF_NAMES);
    }

    public void testRefFieldDefSource() {
        String REF_FIELD_DEF_SOURCE = "List l = new Cons(\"test\", Empty.ONLY);";
        int[] REF_FIELD_DEF_TOKENS = new int[]{2, 2, 69, 31, 2, 60, 56, 67, 2, 68, 2, 61};
        String[] REF_FIELD_DEF_NAMES = new String[]{"List", "l", "=", "new", "Cons", "Cons", "Cons", "Cons", "Empty", "Empty", "ONLY", "ONLY", "ONLY"};
        this.check("List l = new Cons(\"test\", Empty.ONLY);", REF_FIELD_DEF_TOKENS, REF_FIELD_DEF_NAMES);
    }

    public void testPackageSource() {
        String PACKAGE_SOURCE = "package dis.is.a.test; \nimport java.io.InputStream; \nimport java.util.*; \n";
        int[] PACKAGE_TOKENS = new int[]{32, 2, 68, 2, 68, 2, 68, 2, 66, 25, 2, 68, 2, 68, 2, 66, 25, 2, 68, 2, 68, 86, 66};
        String[] PACKAGE_NAMES = new String[]{"package", "dis", "dis", "is", "is", "a", "a", "test", "test", "import", "java", "java", "io", "io", "InputStream", "InputStream", "import", "java", "java", "util", "util", "*", "*"};
        this.check("package dis.is.a.test; \nimport java.io.InputStream; \nimport java.util.*; \n", PACKAGE_TOKENS, PACKAGE_NAMES);
    }
}

