/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.tree;

import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Tree
extends PrintableObject {
    public static final int TOPLEVEL = 1;
    public static final int IMPORT = 2;
    public static final int CLASSDEF = 3;
    public static final int METHODDEF = 4;
    public static final int VARDEF = 5;
    public static final int BLOCK = 6;
    public static final int DOLOOP = 7;
    public static final int WHILELOOP = 8;
    public static final int FORLOOP = 9;
    public static final int LABELLED = 10;
    public static final int SWITCH = 11;
    public static final int CASE = 12;
    public static final int SYNCHRONIZED = 13;
    public static final int TRY = 14;
    public static final int CATCH = 15;
    public static final int CONDEXPR = 16;
    public static final int CONDSTAT = 17;
    public static final int EXEC = 18;
    public static final int BREAK = 19;
    public static final int CONTINUE = 20;
    public static final int RETURN = 21;
    public static final int THROW = 22;
    public static final int APPLY = 23;
    public static final int NEWINSTANCE = 24;
    public static final int NEWARRAY = 25;
    public static final int ASSIGN = 26;
    public static final int TYPECAST = 27;
    public static final int TYPETEST = 28;
    public static final int INDEXED = 29;
    public static final int SELECT = 30;
    public static final int IDENT = 31;
    public static final int LITERAL = 32;
    public static final int TYPEIDENT = 33;
    public static final int TYPEARRAY = 34;
    public static final int TYPEAPPLY = 35;
    public static final int TYPEPARAMETER = 36;
    public static final int ERRONEOUS = 37;
    public static final int POS = 38;
    public static final int NEG = 39;
    public static final int NOT = 40;
    public static final int COMPL = 41;
    public static final int PREINC = 42;
    public static final int PREDEC = 43;
    public static final int POSTINC = 44;
    public static final int POSTDEC = 45;
    public static final int OR = 46;
    public static final int AND = 47;
    public static final int BITOR = 48;
    public static final int BITXOR = 49;
    public static final int BITAND = 50;
    public static final int EQ = 51;
    public static final int NE = 52;
    public static final int LT = 53;
    public static final int GT = 54;
    public static final int LE = 55;
    public static final int GE = 56;
    public static final int SL = 57;
    public static final int SR = 58;
    public static final int USR = 59;
    public static final int PLUS = 60;
    public static final int MINUS = 61;
    public static final int MUL = 62;
    public static final int DIV = 63;
    public static final int MOD = 64;
    public static final int BITOR_ASG = 65;
    public static final int BITXOR_ASG = 66;
    public static final int BITAND_ASG = 67;
    public static final int SL_ASG = 74;
    public static final int SR_ASG = 75;
    public static final int USR_ASG = 76;
    public static final int PLUS_ASG = 77;
    public static final int MINUS_ASG = 78;
    public static final int MUL_ASG = 79;
    public static final int DIV_ASG = 80;
    public static final int MOD_ASG = 81;
    public static final int ASGOffset = 17;
    public static final String LEFT_PAREN = "$$L";
    public static final String COMMA = "$$C";
    public static final String RIGHT_PAREN = "$$R";
    public static final String LEFT_BRACK = "[";
    public static final String RIGHT_BRACK = "]";
    public static final List<Tree> EMPTY_LIST = new Empty<Tree>();
    public static int count = 0;
    public int sourcePosition;
    public Type type;
    public int tag;

    public Tree(int tag) {
        this.tag = tag;
    }

    public Tree(int pos, Type type, int tag) {
        this.sourcePosition = pos;
        this.type = type;
        this.tag = tag;
    }

    public int getSourcePosition() {
        return this.sourcePosition;
    }

    public Tree setPosition(int pos) {
        this.sourcePosition = pos;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Tree setType(Type type) {
        this.type = type;
        return this;
    }

    public <R, A> R accept(Visitor<R, A> v, A arg) {
        return v._case(this, arg);
    }

    public static <R, A, T extends Tree> List<R> mapAccept(List<T> these, Visitor<R, A> v, A arg) {
        if (these == null) {
            return null;
        }
        ListBox<R> results = new ListBox<R>();
        List<T> l = these;
        while (l.nonEmpty()) {
            results.insertEnd(((Tree)l.getFirst()).accept(v, arg));
            l = l.getRest();
        }
        return results.toList();
    }

    public static <R, A, T extends Tree> void doVisit(List<T> these, Visitor<R, A> v, A arg) {
        List<T> l = these;
        while (l.nonEmpty()) {
            ((Tree)l.getFirst()).accept(v, arg);
            l = l.getRest();
        }
    }

    @Override
    public void print() {
        Tree.leftBrace();
        Tree.print("Tree");
        Tree.include(" pos: ", this.sourcePosition, false);
        Tree.include(" tag: ", this.tag, false);
        Tree.include(" type: ", this.type, false);
        Tree.rightBrace();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Visitor<R, A> {
        public R _case(TopLevel that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Import that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(ClassDef that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(MethodDef that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(VarDef that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Block that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(DoLoop that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(WhileLoop that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(ForLoop that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Labelled that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Switch that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Case that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Synchronized that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Try that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Catch that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Conditional that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(ExpressionStatement that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Break that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Continue that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Return that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Throw that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Apply that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(NewInstance that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(NewArray that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Assign that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(AssignOp that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Operation that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(TypeCast that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(InstanceofTest that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(IndexedArrayElement that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Select that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Ident that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Literal that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(TypeIdent that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(ArrayTypeExpression that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(TypeApply that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(TypeParameter that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Erroneous that, A arg) {
            return this._case((Tree)that, arg);
        }

        public R _case(Tree that, A arg) {
            throw new InternalError(new StringBuffer().append("unexpected: ").append(that).toString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public TopLevel newTopLevel(Tree var1, List<Tree> var2);

        public Import newImport(Tree var1);

        public ClassDef newClassDef(int var1, Name var2, List<TypeParameter> var3, Tree var4, List<Tree> var5, List<Tree> var6);

        public MethodDef newMethodDef(int var1, Name var2, Tree var3, List<TypeParameter> var4, List<VarDef> var5, List<Tree> var6, Block var7);

        public VarDef newVarDef(int var1, Name var2, Tree var3, Tree var4);

        public Block newBlock(int var1, List<Tree> var2);

        public DoLoop newDoLoop(Tree var1, Tree var2);

        public WhileLoop newWhileLoop(Tree var1, Tree var2);

        public ForLoop newForLoop(List<Tree> var1, Tree var2, List<Tree> var3, Tree var4);

        public Labelled newLabelled(Name var1, Tree var2);

        public Switch newSwitch(Tree var1, List<Case> var2);

        public Case newCase(Tree var1, List<Tree> var2);

        public Synchronized newSynchronized(Tree var1, Tree var2);

        public Try newTry(Tree var1, List<Catch> var2, Tree var3);

        public Catch newCatch(VarDef var1, Tree var2);

        public Conditional newConditional(int var1, Tree var2, Tree var3, Tree var4);

        public ExpressionStatement newExpressionStatement(Tree var1);

        public Break newBreak(Name var1);

        public Continue newContinue(Name var1);

        public Return newReturn(Tree var1);

        public Throw newThrow(Tree var1);

        public Apply newApply(Tree var1, List<Tree> var2);

        public NewInstance newNewInstance(Tree var1, Tree var2, List<Tree> var3, ClassDef var4);

        public NewArray newNewArray(Tree var1, List<Tree> var2, List<Tree> var3);

        public Assign newAssign(Tree var1, Tree var2);

        public AssignOp newAssignOp(int var1, Tree var2, Tree var3);

        public Operation newOperation(int var1, List<Tree> var2);

        public TypeCast newTypeCast(Tree var1, Tree var2);

        public InstanceofTest newInstanceofTest(Tree var1, Tree var2);

        public IndexedArrayElement newIndexedArrayElement(Tree var1, Tree var2);

        public Select newSelect(Tree var1, Name var2);

        public Ident newIdent(Name var1);

        public Literal newLiteral(int var1, Object var2);

        public TypeIdent newTypeIdent(int var1);

        public ArrayTypeExpression newArrayTypeExpression(Tree var1);

        public TypeApply newTypeApply(Tree var1, List<Tree> var2);

        public TypeParameter newTypeParameter(Name var1, Tree var2, Tree var3);

        public Erroneous newErroneous();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Erroneous
    extends Tree {
        public Erroneous() {
            super(37);
        }

        public Erroneous(int pos, Type type) {
            super(pos, type, 37);
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return "ERRONEOUS";
        }

        @Override
        public void print() {
            Erroneous.leftBrace();
            Erroneous.print("Erroneous");
            Erroneous.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeParameter
    extends Tree {
        public Name name;
        public Tree extendsBound;
        public Tree implementsBound;
        public static List<TypeParameter> emptyList = new Empty<TypeParameter>();

        public TypeParameter(Name name, Tree extBound, Tree implBound) {
            super(36);
            this.name = name;
            this.extendsBound = extBound;
            this.implementsBound = implBound;
        }

        public TypeParameter(int pos, Type type, Name name, Tree extBound, Tree implBound) {
            super(pos, type, 36);
            this.name = name;
            this.extendsBound = extBound;
            this.implementsBound = implBound;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return this.name.toString();
        }

        @Override
        public void print() {
            TypeParameter.leftBrace();
            TypeParameter.print("TypeParameter ");
            TypeParameter.include(this.name);
            TypeParameter.include(" extends ", this.extendsBound, false);
            TypeParameter.include(" implements ", this.implementsBound, false);
            TypeParameter.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeApply
    extends Tree
    implements Stringable {
        public Tree _class;
        public List<Tree> arguments;

        public TypeApply(Tree clazz, List<Tree> arguments) {
            super(35);
            this._class = clazz;
            this.arguments = arguments;
        }

        public TypeApply(int pos, Type type, Tree clazz, List<Tree> arguments) {
            super(pos, type, 35);
            this._class = clazz;
            this.arguments = arguments;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this._class).append("<").append(this.arguments).append(">").toString();
        }

        @Override
        public String toString(List<Name> boundVars) {
            StringBuffer buf = new StringBuffer(this._class.toString()).append(Tree.LEFT_PAREN);
            List<Tree> l = this.arguments;
            l = this.arguments;
            while (!l.isEmpty()) {
                String suffix;
                Stringable next = (Stringable)((Object)l.getFirst());
                String string = suffix = l.getRest().isEmpty() ? Tree.RIGHT_PAREN : Tree.COMMA;
                if (next instanceof TypeApply || !boundVars.contains(((Ident)next).name)) {
                    buf.append(new StringBuffer().append(next.toString(boundVars)).append(suffix).toString());
                } else {
                    buf.append(new StringBuffer().append(Tree.LEFT_BRACK).append(boundVars.index(((Ident)next).name)).append(Tree.RIGHT_BRACK).append(suffix).toString());
                }
                l = l.getRest();
            }
            return buf.toString();
        }

        @Override
        public void print() {
            TypeApply.leftBrace();
            TypeApply.print("TypeApply ");
            TypeApply.include(this._class);
            this.arguments.toString("<", ",", ">");
            TypeApply.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ArrayTypeExpression
    extends Tree {
        public Tree elementType;

        public ArrayTypeExpression(Tree elemtype) {
            super(34);
            this.elementType = elemtype;
        }

        public ArrayTypeExpression(int pos, Type type, Tree elemtype) {
            super(pos, type, 34);
            this.elementType = elemtype;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return this.type == null ? "!NOARRAYTYPE!" : this.type.toString();
        }

        @Override
        public void print() {
            ArrayTypeExpression.leftBrace();
            ArrayTypeExpression.print("ArrayType ");
            this.elementType.print();
            ArrayTypeExpression.print("[]");
            ArrayTypeExpression.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeIdent
    extends Tree {
        public int typeTag;

        public TypeIdent(int typetag) {
            super(33);
            this.typeTag = typetag;
        }

        public TypeIdent(int pos, Type type, int typetag) {
            super(pos, type, 33);
            this.typeTag = typetag;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            if (this.type == null) {
                return "!NOTYPE!";
            }
            return this.type.toString();
        }

        @Override
        public void print() {
            TypeIdent.leftBrace();
            TypeIdent.print("TypeIdent ");
            TypeIdent.include(this.type);
            TypeIdent.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Literal
    extends Tree {
        public int typeTag;
        public Object value;

        public Literal(int typetag, Object value) {
            super(32);
            this.typeTag = typetag;
            this.value = value;
        }

        public Literal(int pos, Type type, int typetag, Object value) {
            super(pos, type, 32);
            this.typeTag = typetag;
            this.value = value;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return this.value.toString();
        }

        @Override
        public void print() {
            Literal.leftBrace();
            Literal.print("Literal ");
            Literal.include(this.value);
            Literal.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Ident
    extends Tree
    implements Stringable,
    Polymorphic {
        public Name name;
        public Symbol symbol;
        private List<Type> typeArgs = null;

        public Ident(Name name, Symbol sym) {
            super(31);
            this.name = name;
            this.symbol = sym;
        }

        public Ident(int pos, Type type, Name name, Symbol sym) {
            super(pos, type, 31);
            this.name = name;
            this.symbol = sym;
        }

        public String toString() {
            return this.name.toString();
        }

        @Override
        public String toString(List<Name> boundVars) {
            return this.toString();
        }

        @Override
        public Symbol.MethodSymbol getSymbol() {
            return (Symbol.MethodSymbol)this.symbol;
        }

        @Override
        public List<Type> getTypeArgs() {
            return this.typeArgs;
        }

        @Override
        public void setTypeArgs(List<Type> args) {
            this.typeArgs = args;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        @Override
        public void print() {
            Ident.leftBrace();
            Ident.print("Ident ");
            Ident.print(this.name.toString());
            Ident.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Select
    extends Tree
    implements Polymorphic {
        public Tree selected;
        public Name name;
        public Symbol symbol;
        private List<Type> typeArgs = null;

        public Select(Tree selected, Name name, Symbol sym) {
            super(30);
            this.selected = selected;
            this.name = name;
            this.symbol = sym;
        }

        public Select(int pos, Type type, Tree selected, Name name, Symbol sym) {
            super(pos, type, 30);
            this.selected = selected;
            this.name = name;
            this.symbol = sym;
        }

        @Override
        public Symbol.MethodSymbol getSymbol() {
            return (Symbol.MethodSymbol)this.symbol;
        }

        @Override
        public List<Type> getTypeArgs() {
            return this.typeArgs;
        }

        @Override
        public void setTypeArgs(List<Type> args) {
            this.typeArgs = args;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.selected).append(".").append(this.name).toString();
        }

        @Override
        public void print() {
            Select.leftBrace();
            Select.print("Select ");
            this.selected.print();
            Select.print(".");
            Select.print(this.name.toString());
            Select.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IndexedArrayElement
    extends Tree {
        public Tree indexedArray;
        public Tree index;

        public IndexedArrayElement(Tree indexed, Tree index) {
            super(29);
            this.indexedArray = indexed;
            this.index = index;
        }

        public IndexedArrayElement(int pos, Type type, Tree indexed, Tree index) {
            super(pos, type, 29);
            this.indexedArray = indexed;
            this.index = index;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.indexedArray).append(Tree.LEFT_BRACK).append(this.index).append(Tree.RIGHT_BRACK).toString();
        }

        @Override
        public void print() {
            IndexedArrayElement.leftBrace();
            IndexedArrayElement.print("IndexedArrayElement ");
            IndexedArrayElement.include(this.indexedArray);
            IndexedArrayElement.leftBracket();
            IndexedArrayElement.include(this.index);
            IndexedArrayElement.rightBracket();
            IndexedArrayElement.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InstanceofTest
    extends Tree
    implements Snippetable {
        public Tree expression;
        public Tree testedType;

        public InstanceofTest(Tree expr, Tree clazz) {
            super(28);
            this.expression = expr;
            this.testedType = clazz;
        }

        public InstanceofTest(int pos, Type type, Tree expr, Tree clazz) {
            super(pos, type, 28);
            this.expression = expr;
            this.testedType = clazz;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        @Override
        public int getPos() {
            return this.sourcePosition;
        }

        @Override
        public Type getTypeArg() {
            return this.testedType.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.testedType = new Ident(this.testedType.sourcePosition, t, t.typeSymbol.name, t.typeSymbol);
        }

        @Override
        public List<Tree> getArgs() {
            return new Cons<Tree>(this.expression);
        }

        @Override
        public void setArgs(List<Tree> _args) {
            this.expression = _args.getFirst();
        }

        @Override
        public Snippetable copy() {
            return new InstanceofTest(this.sourcePosition, this.type, this.expression, this.testedType);
        }

        @Override
        public <T> T accept(SnippetableVisitor<T> sv) {
            return sv.forInstanceofTest(this);
        }

        @Override
        public String toSnippetString() {
            return new StringBuffer().append("$instanceOf$").append(this.getTypeArg().toMethodString()).toString();
        }

        public String toString() {
            return new StringBuffer().append("instanceof ").append(this.type).toString();
        }

        @Override
        public void print() {
            InstanceofTest.leftBrace();
            InstanceofTest.print("InstanceofTest ");
            InstanceofTest.include(this.expression);
            InstanceofTest.include(" instanceof ", this.testedType, false);
            InstanceofTest.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TypeCast
    extends Tree
    implements Snippetable {
        public Tree castType;
        public Tree expression;

        public TypeCast(Tree clazz, Tree expr) {
            super(27);
            this.castType = clazz;
            this.expression = expr;
        }

        public TypeCast(int pos, Type type, Tree clazz, Tree expr) {
            super(pos, type, 27);
            this.castType = clazz;
            this.expression = expr;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        @Override
        public int getPos() {
            return this.sourcePosition;
        }

        @Override
        public Type getTypeArg() {
            return this.castType.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.castType = new Ident(this.castType.sourcePosition, t, t.typeSymbol.name, t.typeSymbol);
        }

        @Override
        public List<Tree> getArgs() {
            return new Cons<Tree>(this.expression);
        }

        @Override
        public void setArgs(List<Tree> _args) {
            this.expression = _args.getFirst();
        }

        @Override
        public Snippetable copy() {
            return new TypeCast(this.sourcePosition, this.type, this.castType, this.expression);
        }

        @Override
        public <T> T accept(SnippetableVisitor<T> sv) {
            return sv.forTypeCast(this);
        }

        @Override
        public String toSnippetString() {
            return new StringBuffer().append("$castTo$").append(this.getTypeArg().toMethodString()).toString();
        }

        public String toString() {
            return new StringBuffer().append("(").append(this.type).append(")").append(this.expression).toString();
        }

        @Override
        public void print() {
            TypeCast.leftBrace();
            TypeCast.print("TypeCast ");
            TypeCast.leftParen();
            TypeCast.include(this.castType);
            TypeCast.rightParen();
            this.expression.print();
            TypeCast.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Operation
    extends Tree {
        public List<Tree> args;
        public Symbol operator;

        public Operation(int opcode, List<Tree> args, Symbol operator) {
            super(opcode);
            this.args = args;
            this.operator = operator;
        }

        public Operation(int pos, Type type, int opcode, List<Tree> args, Symbol operator) {
            super(pos, type, opcode);
            this.args = args;
            this.operator = operator;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            if (this.args.length() == 1) {
                return new StringBuffer().append(this.operator).append(" ").append(this.args.getFirst()).toString();
            }
            return new StringBuffer().append(this.args.getFirst()).append(" ").append(this.operator).append(" ").append(this.args.getRest().getFirst()).toString();
        }

        @Override
        public void print() {
            Operation.leftBrace();
            Operation.print("Operation ");
            if (this.args.length() == 1) {
                Operation.include(this.operator);
                Operation.space();
                Operation.include(this.args.getFirst());
            } else {
                Operation.include(this.args.getFirst());
                Operation.space();
                Operation.include(this.operator);
                Operation.space();
                Operation.include(this.args.eltAt(1));
                Operation.rightBrace();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssignOp
    extends Tree {
        public Tree lhs;
        public Tree rhs;
        public Symbol operator;

        public AssignOp(int opcode, Tree lhs, Tree rhs, Symbol operator) {
            super(opcode);
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = operator;
        }

        public AssignOp(int pos, Type type, int opcode, Tree lhs, Tree rhs, Symbol operator) {
            super(pos, type, opcode);
            this.lhs = lhs;
            this.rhs = rhs;
            this.operator = operator;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.lhs).append(" ").append(this.operator).append(" ").append(this.rhs).toString();
        }

        @Override
        public void print() {
            AssignOp.leftBrace();
            AssignOp.print("AssignOp ");
            AssignOp.include(this.lhs);
            AssignOp.space();
            AssignOp.include(this.operator);
            AssignOp.space();
            AssignOp.include(this.rhs);
            AssignOp.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Assign
    extends Tree {
        public Tree lhs;
        public Tree rhs;

        public Assign(Tree lhs, Tree rhs) {
            super(26);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public Assign(int pos, Type type, Tree lhs, Tree rhs) {
            super(pos, type, 26);
            this.lhs = lhs;
            this.rhs = rhs;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.lhs).append(" = ").append(this.rhs).toString();
        }

        @Override
        public void print() {
            Assign.leftBrace();
            Assign.print("Assign ");
            Assign.include(this.lhs);
            Assign.include(" = ", this.rhs, false);
            Assign.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewArray
    extends Tree
    implements Snippetable {
        public Tree elementType;
        public List<Tree> dimensions;
        public List<Tree> elements;
        private int dimsLengthField = -1;
        private int elemsLengthField = -1;

        public NewArray(Tree elemtype, List<Tree> dims, List<Tree> elems) {
            super(25);
            this.elementType = elemtype;
            this.dimensions = dims;
            this.elements = elems;
        }

        public NewArray(int pos, Type type, Tree elemtype, List<Tree> dims, List<Tree> elems) {
            super(pos, type, 25);
            this.elementType = elemtype;
            this.dimensions = dims;
            this.elements = elems;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public int dimsLength() {
            if (this.dimensions == null) {
                throw new InternalError(new StringBuffer().append("dims is null in ").append(this).toString());
            }
            if (this.dimsLengthField == -1) {
                this.dimsLengthField = this.dimensions.length();
            }
            return this.dimsLengthField;
        }

        public int elemsLength() {
            if (this.elemsLengthField == -1) {
                this.elemsLengthField = this.elements.length();
            }
            return this.elemsLengthField;
        }

        @Override
        public int getPos() {
            return this.sourcePosition;
        }

        @Override
        public Type getTypeArg() {
            return this.elementType.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.elementType = new Ident(this.elementType.sourcePosition, t, t.typeSymbol.name, t.typeSymbol);
            this.type = new Type.ArrayType(t);
        }

        @Override
        public List<Tree> getArgs() {
            if (this.dimensions == null) {
                throw new InternalError(new StringBuffer().append("dims field is null in ").append(this).toString());
            }
            if (this.dimensions == EMPTY_LIST) {
                return this.elements;
            }
            return this.dimensions;
        }

        @Override
        public void setArgs(List<Tree> args) {
            if (this.dimensions == null) {
                throw new InternalError(new StringBuffer().append("dims is null in ").append(this).toString());
            }
            if (this.dimensions.isEmpty()) {
                this.elements = args;
            } else if (this.elements.isEmpty()) {
                this.dimensions = args;
            } else {
                throw new IllegalArgumentException(new StringBuffer().append("NewArray ").append(this).append(" with dims = ").append(this.dimensions).append(" and elems = ").append(" in setArgs").toString());
            }
        }

        @Override
        public Snippetable copy() {
            return new NewArray(this.sourcePosition, this.type, this.elementType, this.dimensions, this.elements);
        }

        @Override
        public <T> T accept(SnippetableVisitor<T> sv) {
            return sv.forNewArray(this);
        }

        @Override
        public String toSnippetString() {
            return new StringBuffer().append("$newArray$").append(this.getTypeArg().toMethodString()).append("$").append(this.dimsLength()).append("$").append(this.elemsLength()).toString();
        }

        public String toString() {
            String prefix = new StringBuffer().append("new ").append(this.elementType).toString();
            if (this.elements.isEmpty()) {
                return new StringBuffer().append(prefix).append(Tree.LEFT_BRACK).append(this.dimensions).append(Tree.RIGHT_BRACK).toString();
            }
            return new StringBuffer().append(prefix).append("[]{").append(this.elements).append("}").toString();
        }

        @Override
        public void print() {
            NewArray.leftBrace();
            NewArray.print("NewArray ");
            NewArray.include(this.elementType);
            NewArray.printItems(this.dimensions, Tree.LEFT_BRACK, ",", Tree.RIGHT_BRACK);
            NewArray.printItems(this.elements, "{", ",", "}");
            NewArray.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NewInstance
    extends Tree
    implements Snippetable {
        public Tree enclosingClassPrefix;
        public Tree _class;
        public List<Tree> args;
        public ClassDef anonymousClassDef;
        public Symbol constructor;

        public NewInstance(Tree encl, Tree clazz, List<Tree> args, ClassDef def, Symbol constructor) {
            super(24);
            this.enclosingClassPrefix = encl;
            this._class = clazz;
            this.args = args;
            this.anonymousClassDef = def;
            this.constructor = constructor;
        }

        public NewInstance(int pos, Type type, Tree encl, Tree clazz, List<Tree> args, ClassDef def, Symbol constructor) {
            super(pos, type, 24);
            this.enclosingClassPrefix = encl;
            this._class = clazz;
            this.args = args;
            this.anonymousClassDef = def;
            this.constructor = constructor;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        @Override
        public int getPos() {
            return this.sourcePosition;
        }

        @Override
        public Type getTypeArg() {
            return this.type;
        }

        @Override
        public void setTypeArg(Type t) {
            this.type = t;
            this._class = new Ident(this._class.sourcePosition, t, t.typeSymbol.name, t.typeSymbol);
        }

        @Override
        public void setArgs(List<Tree> _args) {
            this.args = _args;
        }

        @Override
        public List<Tree> getArgs() {
            return this.args;
        }

        @Override
        public Snippetable copy() {
            return new NewInstance(this.sourcePosition, this.type, this.enclosingClassPrefix, this._class, this.args, this.anonymousClassDef, this.constructor);
        }

        @Override
        public <T> T accept(SnippetableVisitor<T> sv) {
            return sv.forNewInstance(this);
        }

        @Override
        public String toSnippetString() {
            return new StringBuffer().append("$new$").append(this.getTypeArg().toMethodString()).toString();
        }

        public String toString() {
            return new StringBuffer().append("new ").append(this.type).append("(").append(this.args).append(")").toString();
        }

        @Override
        public void print() {
            NewInstance.leftBrace();
            NewInstance.print("NewInstance ");
            if (this.enclosingClassPrefix != null) {
                NewInstance.include(this.enclosingClassPrefix);
                NewInstance.print(".");
            }
            NewInstance.include(this._class);
            NewInstance.printItems(this.args, "(", ",", ")");
            NewInstance.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Apply
    extends Tree {
        public Tree method;
        public List<Tree> args;

        public Apply(Tree meth, List<Tree> args) {
            super(23);
            this.method = meth;
            this.args = args;
        }

        public Apply(int pos, Type type, Tree meth, List<Tree> args) {
            super(pos, type, 23);
            this.method = meth;
            this.args = args;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.method).append("(").append(this.args).append(")").toString();
        }

        @Override
        public void print() {
            Apply.leftBrace();
            Apply.print("Apply ");
            this.method.print();
            Apply.printItems(this.args, "(", ",", ")");
            Apply.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Throw
    extends Tree {
        public Tree expression;

        public Throw(Tree expr) {
            super(22);
            this.expression = expr;
        }

        public Throw(int pos, Type type, Tree expr) {
            super(pos, type, 22);
            this.expression = expr;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("throw ").append(this.expression).append(";").toString();
        }

        @Override
        public void print() {
            Throw.leftBrace();
            Throw.print("Throw ");
            this.expression.print();
            Throw.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Return
    extends Tree {
        public Tree expression;

        public Return(Tree expr) {
            super(21);
            this.expression = expr;
        }

        public Return(int pos, Type type, Tree expr) {
            super(pos, type, 21);
            this.expression = expr;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("return ").append(this.expression).append(";").toString();
        }

        @Override
        public void print() {
            Return.leftBrace();
            Return.print("Return ");
            Return.include(this.expression);
            Return.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Continue
    extends Tree {
        public Name label;
        public Tree target;

        public Continue(Name label, Tree target) {
            super(20);
            this.label = label;
            this.target = target;
        }

        public Continue(int pos, Type type, Name label, Tree target) {
            super(pos, type, 20);
            this.label = label;
            this.target = target;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return "continue;";
        }

        @Override
        public void print() {
            Continue.leftBrace();
            Continue.print("Continue ");
            Continue.include(this.label);
            Continue.print(": ");
            Continue.include(this.target);
            Continue.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Break
    extends Tree {
        public Name label;
        public Tree target;

        public Break(Name label, Tree target) {
            super(19);
            this.label = label;
            this.target = target;
        }

        public Break(int pos, Type type, Name label, Tree target) {
            super(pos, type, 19);
            this.label = label;
            this.target = target;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            if (this.target == null) {
                return "break;";
            }
            return new StringBuffer().append("break ").append(this.label).append(";").toString();
        }

        @Override
        public void print() {
            Break.leftBrace();
            Break.print("Break ");
            Break.print(this.label.toString());
            Break.print(":");
            Break.include("", this.target, true);
            Break.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionStatement
    extends Tree {
        public Tree expression;

        public ExpressionStatement(Tree expr) {
            super(18);
            this.expression = expr;
        }

        public ExpressionStatement(int pos, Type type, Tree expr) {
            super(pos, type, 18);
            this.expression = expr;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.expression).append("; ").toString();
        }

        @Override
        public void print() {
            ExpressionStatement.leftBrace();
            ExpressionStatement.print("ExpressionStatement ");
            ExpressionStatement.include(this.expression);
            ExpressionStatement.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Conditional
    extends Tree {
        public Tree condition;
        public Tree thenClause;
        public Tree elseClause;

        public Conditional(int tag, Tree cond, Tree thenpart, Tree elsepart) {
            super(tag);
            this.condition = cond;
            this.thenClause = thenpart;
            this.elseClause = elsepart;
        }

        public Conditional(int pos, Type type, int tag, Tree cond, Tree thenpart, Tree elsepart) {
            super(pos, type, tag);
            this.condition = cond;
            this.thenClause = thenpart;
            this.elseClause = elsepart;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("(").append(this.condition).append("? ").append(this.thenClause).append(": ").append(this.elseClause).append(")").toString();
        }

        @Override
        public void print() {
            Conditional.leftBrace();
            Conditional.print("Conditional ");
            this.condition.print();
            Conditional.print("? ");
            Conditional.include(this.thenClause);
            Conditional.include(": ", this.elseClause, false);
            Conditional.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Catch
    extends Tree {
        public VarDef param;
        public Tree body;
        public static List<Catch> emptyList = new Empty<Catch>();

        public Catch(VarDef param, Tree body) {
            super(15);
            this.param = param;
            this.body = body;
        }

        public Catch(int pos, Type type, VarDef param, Tree body) {
            super(pos, type, 15);
            this.param = param;
            this.body = body;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("catch(").append(this.param).append(") ").append(this.body).toString();
        }

        @Override
        public void print() {
            Catch.leftBrace();
            Catch.print("Catch ");
            Catch.leftParen();
            this.param.print();
            Catch.rightParen();
            Catch.newline();
            this.body.print();
            Catch.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Try
    extends Tree {
        public Tree body;
        public List<Catch> catchers;
        public Tree finalizer;

        public Try(Tree body, List<Catch> catchers, Tree finalizer) {
            super(14);
            this.body = body;
            this.catchers = catchers;
            this.finalizer = finalizer;
        }

        public Try(int pos, Type type, Tree body, List<Catch> catchers, Tree finalizer) {
            super(pos, type, 14);
            this.body = body;
            this.catchers = catchers;
            this.finalizer = finalizer;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("try ").append(this.body).append(this.catchers.toString()).append(" finally ").append(this.finalizer).toString();
        }

        @Override
        public void print() {
            Try.leftBrace();
            Try.print("Try ");
            Try.newline();
            this.body.print();
            Try.newline();
            Try.printItems(this.catchers);
            Try.newline();
            Try.include("finally ", this.finalizer, false);
            Try.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Synchronized
    extends Tree {
        public Tree lockedObject;
        public Tree body;

        public Synchronized(Tree lock, Tree body) {
            super(13);
            this.lockedObject = lock;
            this.body = body;
        }

        public Synchronized(int pos, Type type, Tree lock, Tree body) {
            super(pos, type, 13);
            this.lockedObject = lock;
            this.body = body;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("synchronized ").append(this.body).toString();
        }

        @Override
        public void print() {
            Synchronized.leftBrace();
            Synchronized.print("Synchronized ");
            Synchronized.leftParen();
            Synchronized.include(this.lockedObject);
            Synchronized.rightParen();
            Synchronized.newline();
            this.body.print();
            Synchronized.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Case
    extends Tree {
        public Tree pattern;
        public List<Tree> statements;

        public Case(Tree pat, List<Tree> stats) {
            super(12);
            this.pattern = pat;
            this.statements = stats;
        }

        public Case(int pos, Type type, Tree pat, List<Tree> stats) {
            super(pos, type, 12);
            this.pattern = pat;
            this.statements = stats;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.pattern).append(": ").append(this.statements.toString()).toString();
        }

        @Override
        public void print() {
            Case.leftBrace();
            Case.print("Case");
            Case.space();
            Case.leftParen();
            Case.include(this.pattern);
            Case.rightParen();
            Case.newline();
            Case.printItemsNoFlush(this.statements);
            Case.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Switch
    extends Tree {
        public Tree selector;
        public List<Case> cases;

        public Switch(Tree selector, List<Case> cases) {
            super(11);
            this.selector = selector;
            this.cases = cases;
        }

        public Switch(int pos, Type type, Tree selector, List<Case> cases) {
            super(pos, type, 11);
            this.selector = selector;
            this.cases = cases;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("switch (").append(this.selector).append(")").append(this.cases.toString()).toString();
        }

        @Override
        public void print() {
            Switch.leftBrace();
            Switch.print("Switch ");
            Switch.leftParen();
            Switch.include(this.selector);
            Switch.rightParen();
            Switch.newline();
            Switch.printItemsNoFlush(this.cases);
            Switch.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Labelled
    extends Tree {
        public Name label;
        public Tree body;

        public Labelled(Name label, Tree body) {
            super(10);
            this.label = label;
            this.body = body;
        }

        public Labelled(int pos, Type type, Name label, Tree body) {
            super(pos, type, 10);
            this.label = label;
            this.body = body;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.label).append(": ").append(this.body).toString();
        }

        @Override
        public void print() {
            Labelled.leftBrace();
            Labelled.print("Labelled ");
            Labelled.print(this.label.toString());
            Labelled.space();
            this.body.print();
            Labelled.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ForLoop
    extends Tree {
        public List<Tree> initializations;
        public Tree conditions;
        public List<Tree> incrementations;
        public Tree body;

        public ForLoop(List<Tree> init, Tree cond, List<Tree> step, Tree body) {
            super(9);
            this.initializations = init;
            this.conditions = cond;
            this.incrementations = step;
            this.body = body;
        }

        public ForLoop(int pos, Type type, List<Tree> init, Tree cond, List<Tree> step, Tree body) {
            super(pos, type, 9);
            this.initializations = init;
            this.conditions = cond;
            this.incrementations = step;
            this.body = body;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("for (").append(this.initializations).append("; ").append(this.conditions).append("; ").append(this.incrementations).append(")").append(this.body).toString();
        }

        @Override
        public void print() {
            ForLoop.leftBrace();
            ForLoop.print("ForLoop:");
            ForLoop.include(" ", this.initializations, false);
            ForLoop.include(": ", this.conditions, false);
            ForLoop.include(": ", this.incrementations, false);
            ForLoop.newline();
            this.body.print();
            ForLoop.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class WhileLoop
    extends Tree {
        public Tree condition;
        public Tree body;

        public WhileLoop(Tree cond, Tree body) {
            super(8);
            this.condition = cond;
            this.body = body;
        }

        public WhileLoop(int pos, Type type, Tree cond, Tree body) {
            super(pos, type, 8);
            this.condition = cond;
            this.body = body;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("while (").append(this.condition).append(") ").append(this.body).toString();
        }

        @Override
        public void print() {
            WhileLoop.leftBrace();
            WhileLoop.print("WhileLoop ");
            WhileLoop.print("(");
            this.condition.print();
            WhileLoop.print(")");
            WhileLoop.newline();
            this.body.print();
            WhileLoop.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoLoop
    extends Tree {
        public Tree body;
        public Tree cond;

        public DoLoop(Tree body, Tree cond) {
            super(7);
            this.body = body;
            this.cond = cond;
        }

        public DoLoop(int pos, Type type, Tree body, Tree condition) {
            super(pos, type, 7);
            this.body = body;
            this.cond = condition;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("do ").append(this.body).append(" while (").append(this.cond).append(")").toString();
        }

        @Override
        public void print() {
            DoLoop.leftBrace();
            DoLoop.print("DoLoop ");
            DoLoop.newline();
            this.body.print();
            DoLoop.newline();
            DoLoop.include("while ", this.cond, false);
            DoLoop.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Block
    extends Tree {
        public int flags;
        public List<Tree> statements;
        public static final Block EMPTY_BLOCK = new Block(0, new Empty<Tree>());

        public Block(int flags, List<Tree> stats) {
            super(6);
            this.statements = stats;
            this.flags = flags;
        }

        public Block(int pos, Type type, int flags, List<Tree> stats) {
            super(pos, type, 6);
            this.statements = stats;
            this.flags = flags;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("{").append(this.statements.toString()).append("}").toString();
        }

        @Override
        public void print() {
            Block.leftBrace();
            Block.openBox(6);
            Block.print("Block ");
            Block.printItemsNoFlush(this.statements);
            Block.closeBox();
            Block.rightBrace();
        }

        static {
            Block.EMPTY_BLOCK.type = Type.ERROR_TYPE;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VarDef
    extends Tree {
        public int flags;
        public Name name;
        public Tree varType;
        public Tree initialization;
        public Symbol.VarSymbol varSymbol;
        public static List<VarDef> emptyList = new Empty<VarDef>();

        public VarDef(int flags, Name name, Tree vartype, Tree init, Symbol.VarSymbol sym) {
            super(5);
            this.flags = flags;
            this.name = name;
            this.varType = vartype;
            this.initialization = init;
            this.varSymbol = sym;
        }

        public VarDef(int pos, Type type, int flags, Name name, Tree vartype, Tree init, Symbol.VarSymbol sym) {
            super(pos, type, 5);
            this.flags = flags;
            this.name = name;
            this.varType = vartype;
            this.initialization = init;
            this.varSymbol = sym;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            String prefix = new StringBuffer().append(this.varType).append(" ").append(this.name).toString();
            if (this.initialization == null) {
                return prefix;
            }
            return new StringBuffer().append(prefix).append(" = ").append(this.initialization).append("; ").toString();
        }

        @Override
        public void print() {
            VarDef.leftBrace();
            VarDef.print("VarDef ");
            VarDef.include(this.varType);
            VarDef.space();
            VarDef.include(this.name);
            if (this.initialization != null) {
                VarDef.include(" = ", this.initialization, false);
            }
            VarDef.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MethodDef
    extends Tree {
        public int flags;
        public Name name;
        public Tree returnType;
        public List<TypeParameter> typeParams;
        public List<VarDef> params;
        public List<Tree> thrown;
        public Block body;
        public Symbol.MethodSymbol methodSymbol;

        public MethodDef(int flags, Name name, Tree restype, List<TypeParameter> typarams, List<VarDef> params, List<Tree> thrown, Block body, Symbol.MethodSymbol sym) {
            super(4);
            this.flags = flags;
            this.name = name;
            this.returnType = restype;
            this.typeParams = typarams;
            this.params = params;
            this.thrown = thrown;
            this.body = body;
            this.methodSymbol = sym;
        }

        public MethodDef(int pos, Type type, int flags, Name name, Tree restype, List<TypeParameter> typarams, List<VarDef> params, List<Tree> thrown, Block body, Symbol.MethodSymbol sym) {
            super(pos, type, 4);
            this.flags = flags;
            this.name = name;
            this.returnType = restype;
            this.typeParams = typarams;
            this.params = params;
            this.thrown = thrown;
            this.body = body;
            this.methodSymbol = sym;
        }

        public MethodDef(int flags, Name name, Tree restype, List<TypeParameter> typarams, List<VarDef> params, List<Tree> thrown, Block body, Symbol.MethodSymbol sym, Type type) {
            super(4);
            this.flags = flags;
            this.name = name;
            this.returnType = restype;
            this.typeParams = typarams;
            this.params = params;
            this.thrown = thrown;
            this.body = body;
            this.methodSymbol = sym;
            this.type = type;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            R result = v._case(this, arg);
            return result;
        }

        public String toString() {
            String suffix = new StringBuffer().append(this.returnType).append(" ").append(this.name).append(this.params).append(this.body).toString();
            if (this.typeParams == null || this.typeParams.isEmpty()) {
                return new StringBuffer().append("method ").append(suffix).toString();
            }
            return new StringBuffer().append("method <").append(this.typeParams).append("> ").append(suffix).toString();
        }

        @Override
        public void print() {
            MethodDef.leftBrace();
            MethodDef.print("MethodDef ");
            MethodDef.printItems(this.typeParams, "<", ",", ">");
            MethodDef.space();
            MethodDef.include(this.returnType);
            MethodDef.space();
            MethodDef.include(this.name);
            MethodDef.printItems(this.params, "(", ",", ")");
            MethodDef.print(" throws ");
            MethodDef.printItems(this.thrown, "", ",", "");
            MethodDef.include(" flags: ", this.flags, false);
            MethodDef.newline();
            MethodDef.include(this.methodSymbol);
            MethodDef.newline();
            MethodDef.include(this.body);
            MethodDef.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassDef
    extends Tree {
        public int flags;
        public Name name;
        public List<TypeParameter> typeParams;
        public Tree extendedClass;
        public List<Tree> implementedInterfaces;
        public List<Tree> members;
        public Symbol.ClassSymbol classSymbol;

        public ClassDef(int flags, Name name, List<TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs, Symbol.ClassSymbol sym) {
            super(3);
            this.flags = flags;
            this.name = name;
            this.typeParams = typarams;
            this.extendedClass = extending;
            this.implementedInterfaces = implementing;
            this.members = defs;
            this.classSymbol = sym;
        }

        public ClassDef(int pos, Type type, int flags, Name name, List<TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs, Symbol.ClassSymbol sym) {
            super(pos, type, 3);
            this.flags = flags;
            this.name = name;
            this.typeParams = typarams;
            this.extendedClass = extending;
            this.implementedInterfaces = implementing;
            this.members = defs;
            this.classSymbol = sym;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append(this.name).append(this.typeParams.toString("<", ",", ">")).toString();
        }

        @Override
        public void print() {
            ClassDef.leftBrace();
            ClassDef.include("ClassDef ", this.name, false);
            ClassDef.printItems(this.typeParams, "<", ",", ">");
            ClassDef.include(" extends ", this.extendedClass, false);
            ClassDef.include(" implements ", this.implementedInterfaces, false);
            ClassDef.include(" flags: ", this.flags, false);
            ClassDef.newline();
            ClassDef.include(this.classSymbol);
            ClassDef.newline();
            ClassDef.printItemsNoFlush(this.members);
            ClassDef.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Import
    extends Tree {
        public Tree importedClass;

        public Import(Tree qualid) {
            super(2);
            this.importedClass = qualid;
        }

        public Import(int pos, Type type, Tree qualid) {
            super(pos, type, 2);
            this.importedClass = qualid;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("import ").append(this.importedClass).toString();
        }

        @Override
        public void print() {
            Import.leftBrace();
            Import.print("Import ");
            this.importedClass.print();
            Import.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TopLevel
    extends Tree {
        public Tree packageId;
        public List<Tree> members;
        public Name sourcefile;
        public Symbol.PackageSymbol packageSymbol;
        public Scope namedImportScope;
        public Scope starImportScope;

        public TopLevel(Tree pid, List<Tree> defs, Name sourcefile, Symbol.PackageSymbol _package, Scope namedImportScope, Scope starImportScope) {
            super(1);
            this.packageId = pid;
            this.members = defs;
            this.sourcefile = sourcefile;
            this.packageSymbol = _package;
            this.namedImportScope = namedImportScope;
            this.starImportScope = starImportScope;
        }

        public TopLevel(int pos, Type type, Tree pid, List<Tree> defs, Name sourcefile, Symbol.PackageSymbol _package, Scope namedImportScope, Scope starImportScope) {
            super(pos, type, 1);
            this.packageId = pid;
            this.members = defs;
            this.sourcefile = sourcefile;
            this.packageSymbol = _package;
            this.namedImportScope = namedImportScope;
            this.starImportScope = starImportScope;
        }

        @Override
        public <R, A> R accept(Visitor<R, A> v, A arg) {
            return v._case(this, arg);
        }

        public String toString() {
            return new StringBuffer().append("TopLevel:").append(this.sourcefile).toString();
        }

        @Override
        public void print() {
            TopLevel.leftBrace();
            TopLevel.include("TopLevel for ", this.sourcefile, false);
            TopLevel.newline();
            TopLevel.include("packageId: ", this.packageId, false);
            TopLevel.space();
            TopLevel.include("packageSymbol: ", this.packageSymbol, false);
            TopLevel.newline();
            Scope shortImports = this.starImportScope == null ? null : this.starImportScope.nextScope;
            TopLevel.include("starImportScope (except for java.lang): ", shortImports, false);
            TopLevel.newline();
            TopLevel.include("namedImportScope: ", this.namedImportScope, false);
            TopLevel.newline();
            TopLevel.print("==========");
            TopLevel.newline();
            TopLevel.printItemsNoFlush(this.members);
            TopLevel.rightBrace();
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Polymorphic {
        public Symbol.MethodSymbol getSymbol();

        public List<Type> getTypeArgs();

        public void setTypeArgs(List<Type> var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Stringable {
        public String toString(List<Name> var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SnippetableVisitor<T> {
        public T forNewInstance(NewInstance var1);

        public T forTypeCast(TypeCast var1);

        public T forInstanceofTest(InstanceofTest var1);

        public T forNewArray(NewArray var1);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Snippetable {
        public static final List<Snippetable> EMPTY_LIST = new Empty<Snippetable>();

        public int getPos();

        public Type getTypeArg();

        public void setTypeArg(Type var1);

        public List<Tree> getArgs();

        public void setArgs(List<Tree> var1);

        public Snippetable copy();

        public <T> T accept(SnippetableVisitor<T> var1);

        public String toSnippetString();
    }
}

