/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.tree;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeInspector
implements Flags {
    private static final String[] flagName = new String[]{"public", "private", "protected", "static", "final", "synchronized", "volatile", "transient", "native", "interface", "abstract"};
    private static Name[] opname = new Name[27];
    public static final int noPrec = 0;
    public static final int assignPrec = 1;
    public static final int assignopPrec = 2;
    public static final int condPrec = 3;
    public static final int orPrec = 4;
    public static final int andPrec = 5;
    public static final int bitorPrec = 6;
    public static final int bitxorPrec = 7;
    public static final int bitandPrec = 8;
    public static final int eqPrec = 9;
    public static final int ordPrec = 10;
    public static final int shiftPrec = 11;
    public static final int addPrec = 12;
    public static final int mulPrec = 13;
    public static final int prefixPrec = 14;
    public static final int postfixPrec = 15;
    public static final int precCount = 16;

    public static boolean isConstructor(Tree tree) {
        return tree.tag == 4 && ((Tree.MethodDef)tree).name == Names.init;
    }

    public static boolean hasConstructors(List<Tree> trees) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            if (TreeInspector.isConstructor(l.getFirst())) {
                return true;
            }
            l = l.getRest();
        }
        return false;
    }

    public static boolean isSyntheticInit(Tree stat) {
        if (stat.tag == 18) {
            Tree.ExpressionStatement exec = (Tree.ExpressionStatement)stat;
            if (exec.expression.tag == 26) {
                Tree.Assign assign = (Tree.Assign)exec.expression;
                if (assign.lhs.tag == 30) {
                    Tree.Select select = (Tree.Select)assign.lhs;
                    if ((select.symbol.flags() & 0x10000) != 0 && TreeInspector.name(select.selected) == Names._this) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public static boolean isInitialConstructor(Tree tree) {
        if (tree.tag != 4) {
            return false;
        }
        Tree.MethodDef md = (Tree.MethodDef)tree;
        if (md.name != Names.init && md.name != Names.clinit) {
            return false;
        }
        if (md.body != null && md.body.statements.nonEmpty() && md.body.statements.getFirst().tag == 18) {
            Tree.ExpressionStatement exec = (Tree.ExpressionStatement)md.body.statements.getFirst();
            if (exec.expression.tag == 23) {
                Tree.Apply apply = (Tree.Apply)exec.expression;
                if (TreeInspector.name(apply.method) == Names._this) {
                    return false;
                }
            }
        }
        return true;
    }

    public static Name name(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).name;
            }
            case 30: {
                return ((Tree.Select)tree).name;
            }
            case 35: {
                return TreeInspector.name(((Tree.TypeApply)tree)._class);
            }
        }
        return null;
    }

    public static Name fullName(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).name;
            }
            case 30: {
                Name sname = TreeInspector.fullName(((Tree.Select)tree).selected);
                return sname == null ? null : Name.fromString(new StringBuffer().append(sname).append(".").append(TreeInspector.name(tree)).toString());
            }
        }
        return null;
    }

    public static Symbol symbol(Tree tree) {
        switch (tree.tag) {
            case 31: {
                return ((Tree.Ident)tree).symbol;
            }
            case 30: {
                return ((Tree.Select)tree).symbol;
            }
        }
        return null;
    }

    public static int flags(Tree tree) {
        switch (tree.tag) {
            case 5: {
                return ((Tree.VarDef)tree).flags;
            }
            case 4: {
                return ((Tree.MethodDef)tree).flags;
            }
            case 3: {
                return ((Tree.ClassDef)tree).flags;
            }
            case 6: {
                return ((Tree.Block)tree).flags;
            }
        }
        return 0;
    }

    public static int firstFlag(int flags) {
        int flag = 1;
        while ((flag & 0x7FF) != 0 && (flag & flags) == 0) {
            flag <<= 1;
        }
        return flag;
    }

    public static String flagNames(int flags) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        int f = flags & 0x7FF;
        while (f != 0) {
            if ((f & 1) != 0) {
                if (sbuf.length() != 0) {
                    sbuf.append(" ");
                }
                sbuf.append(flagName[i]);
            }
            f >>= 1;
            ++i;
        }
        return sbuf.toString();
    }

    public static Name operatorName(int tag) {
        return opname[tag - 38];
    }

    public static int opPrec(int op) {
        switch (op) {
            case 38: {
                return 14;
            }
            case 39: {
                return 14;
            }
            case 40: {
                return 14;
            }
            case 41: {
                return 14;
            }
            case 42: {
                return 14;
            }
            case 43: {
                return 14;
            }
            case 44: {
                return 15;
            }
            case 45: {
                return 15;
            }
            case 26: {
                return 1;
            }
            case 65: 
            case 66: 
            case 67: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: {
                return 2;
            }
            case 46: {
                return 4;
            }
            case 47: {
                return 5;
            }
            case 51: {
                return 9;
            }
            case 52: {
                return 9;
            }
            case 53: {
                return 10;
            }
            case 54: {
                return 10;
            }
            case 55: {
                return 10;
            }
            case 56: {
                return 10;
            }
            case 48: {
                return 6;
            }
            case 49: {
                return 7;
            }
            case 50: {
                return 8;
            }
            case 57: {
                return 11;
            }
            case 58: {
                return 11;
            }
            case 59: {
                return 11;
            }
            case 60: {
                return 12;
            }
            case 61: {
                return 12;
            }
            case 62: {
                return 13;
            }
            case 63: {
                return 13;
            }
            case 64: {
                return 13;
            }
            case 28: {
                return 10;
            }
        }
        throw new InternalError();
    }

    static {
        TreeInspector.opname[0] = Name.fromString("+");
        TreeInspector.opname[1] = Name.fromString("-");
        TreeInspector.opname[2] = Name.fromString("!");
        TreeInspector.opname[3] = Name.fromString("~");
        TreeInspector.opname[4] = Name.fromString("++");
        TreeInspector.opname[5] = Name.fromString("--");
        TreeInspector.opname[6] = Name.fromString("++");
        TreeInspector.opname[7] = Name.fromString("--");
        TreeInspector.opname[8] = Name.fromString("||");
        TreeInspector.opname[9] = Name.fromString("&&");
        TreeInspector.opname[13] = Name.fromString("==");
        TreeInspector.opname[14] = Name.fromString("!=");
        TreeInspector.opname[15] = Name.fromString("<");
        TreeInspector.opname[16] = Name.fromString(">");
        TreeInspector.opname[17] = Name.fromString("<=");
        TreeInspector.opname[18] = Name.fromString(">=");
        TreeInspector.opname[10] = Name.fromString("|");
        TreeInspector.opname[11] = Name.fromString("^");
        TreeInspector.opname[12] = Name.fromString("&");
        TreeInspector.opname[19] = Name.fromString("<<");
        TreeInspector.opname[20] = Name.fromString(">>");
        TreeInspector.opname[21] = Name.fromString(">>>");
        TreeInspector.opname[22] = Name.fromString("+");
        TreeInspector.opname[23] = Name.fromString("-");
        TreeInspector.opname[24] = Name.fromString("*");
        TreeInspector.opname[25] = Name.fromString("/");
        TreeInspector.opname[26] = Name.fromString("%");
    }
}

