/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.tree;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeMaker
implements Tree.Factory,
Kinds,
Flags,
TypeTags {
    public int pos = 0;
    public Tree.TopLevel toplevel;
    public static TreeMaker make = new TreeMaker();

    public TreeMaker() {
        this.pos = 0;
        this.toplevel = null;
    }

    public TreeMaker(Tree.TopLevel toplevel) {
        this.pos = 1025;
        this.toplevel = toplevel;
    }

    public TreeMaker at(int pos) {
        this.pos = pos;
        return this;
    }

    @Override
    public Tree.TopLevel newTopLevel(Tree pid, List<Tree> defs) {
        Tree.TopLevel tree = new Tree.TopLevel(pid, defs, null, null, null, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Import newImport(Tree qualid) {
        Tree.Import tree = new Tree.Import(qualid);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.ClassDef newClassDef(int flags, Name name, List<Tree.TypeParameter> typarams, Tree extending, List<Tree> implementing, List<Tree> defs) {
        Tree.ClassDef tree = new Tree.ClassDef(flags, name, typarams, extending, implementing, defs, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.MethodDef newMethodDef(int flags, Name name, Tree restype, List<Tree.TypeParameter> typarams, List<Tree.VarDef> params, List<Tree> thrown, Tree.Block body) {
        Tree.MethodDef tree = new Tree.MethodDef(flags, name, restype, typarams, params, thrown, body, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.VarDef newVarDef(int flags, Name name, Tree vartype, Tree init) {
        Tree.VarDef tree = new Tree.VarDef(flags, name, vartype, init, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Block newBlock(int flags, List<Tree> stats) {
        Tree.Block tree = new Tree.Block(flags, stats);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.DoLoop newDoLoop(Tree body, Tree cond) {
        Tree.DoLoop tree = new Tree.DoLoop(body, cond);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.WhileLoop newWhileLoop(Tree cond, Tree body) {
        Tree.WhileLoop tree = new Tree.WhileLoop(cond, body);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.ForLoop newForLoop(List<Tree> init, Tree cond, List<Tree> step, Tree body) {
        Tree.ForLoop tree = new Tree.ForLoop(init, cond, step, body);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Labelled newLabelled(Name label, Tree body) {
        Tree.Labelled tree = new Tree.Labelled(label, body);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Switch newSwitch(Tree selector, List<Tree.Case> cases) {
        Tree.Switch tree = new Tree.Switch(selector, cases);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Case newCase(Tree pat, List<Tree> stats) {
        Tree.Case tree = new Tree.Case(pat, stats);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Synchronized newSynchronized(Tree lock, Tree body) {
        Tree.Synchronized tree = new Tree.Synchronized(lock, body);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Try newTry(Tree body, List<Tree.Catch> catchers, Tree finalizer) {
        Tree.Try tree = new Tree.Try(body, catchers, finalizer);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Catch newCatch(Tree.VarDef param, Tree body) {
        Tree.Catch tree = new Tree.Catch(param, body);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Conditional newConditional(int tag, Tree cond, Tree thenpart, Tree elsepart) {
        Tree.Conditional tree = new Tree.Conditional(tag, cond, thenpart, elsepart);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.ExpressionStatement newExpressionStatement(Tree expr) {
        Tree.ExpressionStatement tree = new Tree.ExpressionStatement(expr);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Break newBreak(Name label) {
        Tree.Break tree = new Tree.Break(label, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Continue newContinue(Name label) {
        Tree.Continue tree = new Tree.Continue(label, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Return newReturn(Tree expr) {
        Tree.Return tree = new Tree.Return(expr);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Throw newThrow(Tree expr) {
        Tree.Throw tree = new Tree.Throw(expr);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Apply newApply(Tree fn, List<Tree> args) {
        Tree.Apply tree = new Tree.Apply(fn, args);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.NewInstance newNewInstance(Tree encl, Tree clazz, List<Tree> args, Tree.ClassDef def) {
        Tree.NewInstance tree = new Tree.NewInstance(encl, clazz, args, def, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.NewArray newNewArray(Tree elemtype, List<Tree> dims, List<Tree> elems) {
        Tree.NewArray tree = new Tree.NewArray(elemtype, dims, elems);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Assign newAssign(Tree lhs, Tree rhs) {
        Tree.Assign tree = new Tree.Assign(lhs, rhs);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.AssignOp newAssignOp(int opcode, Tree lhs, Tree rhs) {
        Tree.AssignOp tree = new Tree.AssignOp(opcode, lhs, rhs, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Operation newOperation(int opcode, List<Tree> args) {
        Tree.Operation tree = new Tree.Operation(opcode, args, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.TypeCast newTypeCast(Tree clazz, Tree expr) {
        Tree.TypeCast tree = new Tree.TypeCast(clazz, expr);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.InstanceofTest newInstanceofTest(Tree expr, Tree clazz) {
        Tree.InstanceofTest tree = new Tree.InstanceofTest(expr, clazz);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.IndexedArrayElement newIndexedArrayElement(Tree indexed, Tree index) {
        Tree.IndexedArrayElement tree = new Tree.IndexedArrayElement(indexed, index);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Select newSelect(Tree selected, Name selector) {
        Tree.Select tree = new Tree.Select(selected, selector, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Ident newIdent(Name name) {
        Tree.Ident tree = new Tree.Ident(name, null);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Literal newLiteral(int tag, Object value) {
        Tree.Literal tree = new Tree.Literal(tag, value);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.TypeIdent newTypeIdent(int typetag) {
        Tree.TypeIdent tree = new Tree.TypeIdent(typetag);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.ArrayTypeExpression newArrayTypeExpression(Tree elemtype) {
        Tree.ArrayTypeExpression tree = new Tree.ArrayTypeExpression(elemtype);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.TypeApply newTypeApply(Tree clazz, List<Tree> arguments) {
        Tree.TypeApply tree = new Tree.TypeApply(clazz, arguments);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.TypeParameter newTypeParameter(Name name, Tree extBound, Tree implBound) {
        Tree.TypeParameter tree = new Tree.TypeParameter(name, extBound, implBound);
        tree.sourcePosition = this.pos;
        return tree;
    }

    @Override
    public Tree.Erroneous newErroneous() {
        Tree.Erroneous tree = new Tree.Erroneous();
        tree.sourcePosition = this.pos;
        return tree;
    }

    public Tree.TopLevel setTopLevel(Tree.TopLevel toplevel) {
        Tree.TopLevel prev = this.toplevel;
        this.toplevel = toplevel;
        return prev;
    }

    public Tree newIdent(Symbol sym) {
        return new Tree.Ident(sym.name, sym).setPosition(this.pos).setType(sym.type);
    }

    public Tree newSelect(Tree base, Symbol sym) {
        return new Tree.Select(base, sym.name, sym).setPosition(this.pos).setType(sym.type);
    }

    public Tree newQualIdent(Symbol sym) {
        return this.isUnqualifiable(sym) ? this.newIdent(sym) : this.newSelect(this.newQualIdent(sym.owner), sym);
    }

    public Tree newIdent(Tree.VarDef param) {
        return this.newIdent(param.varSymbol);
    }

    public Tree newApp(Tree meth, List<Tree> args) {
        Type mtype = meth.type;
        meth.type = mtype.returnType();
        return this.newApply(meth, args).setType(mtype.returnType());
    }

    public List<Tree> newIdents(List<Tree.VarDef> params) {
        ListBox<Tree> ids = new ListBox<Tree>();
        List<Tree.VarDef> l = params;
        while (l.nonEmpty()) {
            ids.insertEnd(this.newIdent(l.getFirst()));
            l = l.getRest();
        }
        return ids.toList();
    }

    public Tree newThis(Type t) {
        return this.newIdent(new Symbol.VarSymbol(16, Names._this, t, t.typeSymbol));
    }

    public Tree newSuper(Type t) {
        return this.newIdent(new Symbol.VarSymbol(16, Names._super, t, t.typeSymbol));
    }

    /*
     * WARNING - void declaration
     */
    public Tree newType(Type t) {
        void var2_2;
        if (t == null) {
            return null;
        }
        switch (t.tag) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                Tree tp = this.newTypeIdent(t.tag);
                break;
            }
            case 14: {
                Tree tp = this.newIdent(t.typeSymbol.name);
                break;
            }
            case 10: {
                Type outer = t.enclosingType();
                Tree clazz = outer.tag == 10 ? this.newSelectors(this.newType(outer), t.typeSymbol, outer.typeSymbol) : this.newQualIdent(t.typeSymbol);
                Tree tp = t.getTypeParams().isEmpty() ? clazz : this.newTypeApply(clazz, this.newTypes(t.getTypeParams()));
                break;
            }
            case 11: {
                Tree tp = this.newArrayTypeExpression(this.newType(t.elementType()));
                break;
            }
            default: {
                throw new InternalError(new StringBuffer().append("unexpected type: ").append(t).toString());
            }
        }
        return var2_2.setType(t);
    }

    private Tree newSelectors(Tree base, Symbol sym, Symbol limit) {
        if (sym == limit) {
            return base;
        }
        return this.newSelect(this.newSelectors(base, sym.owner, limit), sym);
    }

    public List<Tree> newTypes(List<Type> ts) {
        ListBox<Tree> types = new ListBox<Tree>();
        List<Type> l = ts;
        while (l.nonEmpty()) {
            types.insertEnd(this.newType(l.getFirst()));
            l = l.getRest();
        }
        return types.toList();
    }

    public List<Tree> newClasses(List<Symbol.ClassSymbol> ts) {
        ListBox<Tree> classes = new ListBox<Tree>();
        List<Symbol.ClassSymbol> l = ts;
        while (l.nonEmpty()) {
            classes.insertEnd(this.newType(l.getFirst().type.erasure()));
            l = l.getRest();
        }
        return classes.toList();
    }

    public Tree.VarDef newVarDef(Symbol.VarSymbol v, Tree init) {
        return (Tree.VarDef)new Tree.VarDef(v.flags(), v.name, this.newType(v.type), init, v).setPosition(this.pos).setType(v.type);
    }

    public Tree.MethodDef newMethodDef(Symbol.MethodSymbol m, Tree.Block body) {
        return (Tree.MethodDef)new Tree.MethodDef(m.flags(), m.name, this.newType(m.type.returnType()), this.newTypeParameters(m.type.getTypeParams()), this.newVarDefs(m.type.argTypes(), m), this.newClasses(m.type.thrown()), body, m).setPosition(this.pos).setType(m.type);
    }

    public Tree.TypeParameter newTypeParameter(Name name, Type.TypeVar tvar) {
        Tree extBound = null;
        Tree implBound = null;
        if ((tvar.bound.typeSymbol.flags() & 0x200) == 0) {
            extBound = this.newType(tvar.bound);
        } else {
            implBound = this.newType(tvar.bound);
        }
        return (Tree.TypeParameter)this.newTypeParameter(name, extBound, implBound).setPosition(this.pos).setType(tvar);
    }

    public List<Tree.TypeParameter> newTypeParameters(List<Type> typarams) {
        ListBox<Tree.TypeParameter> tparams = new ListBox<Tree.TypeParameter>();
        int i = 0;
        List<Type> l = typarams;
        while (l.nonEmpty()) {
            tparams.insertEnd(this.newTypeParameter(this.getTypeParamName(i++), (Type.TypeVar)l.getFirst()));
            l = l.getRest();
        }
        return tparams.toList();
    }

    public Tree.VarDef newVarDef(Name name, Type argtype, Symbol owner) {
        return this.newVarDef(new Symbol.VarSymbol(0, name, argtype, owner), null);
    }

    public List<Tree.VarDef> newVarDefs(List<Type> argtypes, Symbol owner) {
        ListBox<Tree.VarDef> params = new ListBox<Tree.VarDef>();
        int i = 0;
        List<Type> l = argtypes;
        while (l.nonEmpty()) {
            params.insertEnd(this.newVarDef(this.getParamName(i++), l.getFirst(), owner));
            l = l.getRest();
        }
        return params.toList();
    }

    public Tree newInvocation(Tree apply) {
        return apply.type.tag == 9 ? this.newExpressionStatement(apply) : this.newReturn(apply);
    }

    public Tree newAssignment(Symbol v, Tree init) {
        return this.newExpressionStatement(this.newAssign(this.newIdent(v), init).setType(v.type));
    }

    boolean isUnqualifiable(Symbol sym) {
        if (sym.kind == 2 && this.toplevel != null) {
            Scope.Entry e = this.toplevel.namedImportScope.lookup(sym.name);
            if (e.scope != null) {
                return e.symbol == sym && e.next().scope == null;
            }
            e = this.toplevel.packageSymbol.members().lookup(sym.name);
            if (e.scope != null) {
                return e.symbol == sym && e.next().scope == null;
            }
            e = this.toplevel.starImportScope.lookup(sym.name);
            if (e.scope != null) {
                return e.symbol == sym && e.next().scope == null;
            }
            return false;
        }
        return sym.owner == null || sym.owner.name == Names.empty || (sym.owner.kind & 0x14) != 0;
    }

    Name getParamName(int i) {
        return Name.fromString(new StringBuffer().append("x").append(i).toString());
    }

    Name getTypeParamName(int i) {
        return Name.fromString(new StringBuffer().append("A").append(i).toString());
    }
}

