/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Bits;
import junit.framework.TestCase;

public class BitsTest
extends TestCase {
    public BitsTest(String name) {
        super(name);
    }

    public void testInit() {
        Bits b = new Bits();
        BitsTest.assertEquals((String)"Bits not initialized properly.", (String)"00000000000000000000000000000000", (String)b.toString());
    }

    public void testInitRange() {
        Bits b = new Bits(2, 7);
        BitsTest.assertEquals((String)"Bits not initialized properly.", (String)"00111110000000000000000000000000", (String)b.toString());
    }

    public void testInitFromArray() {
        int[] bits = new int[]{4};
        Bits b = new Bits(bits);
        BitsTest.assertEquals((String)"Bits not initialized properly.", (String)"00100000000000000000000000000000", (String)b.toString());
        int[] bits1 = new int[]{1434543217};
        Bits b1 = new Bits(bits1);
        BitsTest.assertEquals((String)"Bits not initialized properly.", (String)"10001110001001101000000110101010", (String)b1.toString());
        int[] bits2 = new int[]{1434543217, 4};
        Bits b2 = new Bits(bits2);
        BitsTest.assertEquals((String)"Bits not initialized properly.", (String)"1000111000100110100000011010101000100000000000000000000000000000", (String)b2.toString());
    }

    public void testClear() {
        int[] bits = new int[]{435137345, 70970979};
        Bits b = new Bits(bits);
        b.clear();
        BitsTest.assertEquals((String)"Bits not cleared properly.", (String)"0000000000000000000000000000000000000000000000000000000000000000", (String)b.toString());
    }

    public void testCopy() {
        Bits b1 = new Bits(9, 11);
        Bits b2 = b1.copy();
        BitsTest.assertEquals((String)"Bits not copied properly.", (String)b1.toString(), (String)b2.toString());
        BitsTest.assertFalse((String)"Copy operator is not returning a new instance of Bits", (b1 == b2 ? 1 : 0) != 0);
    }

    public void testInclude() {
        Bits b = new Bits();
        b.include(0);
        b.include(20);
        BitsTest.assertEquals((String)"Bits not included properly.", (String)"10000000000000000000100000000000", (String)b.toString());
    }

    public void testIncludeRange() {
        Bits b = new Bits();
        b.includeRange(2, 20);
        BitsTest.assertEquals((String)"Bits.includeRange() is not adding bits properly.", (String)"00111111111111111111000000000000", (String)b.toString());
    }

    public void testExclude() {
        Bits b = new Bits();
        b.includeRange(2, 20);
        b.exclude(10);
        BitsTest.assertEquals((String)"Bits are not excluded properly.", (String)"00111111110111111111000000000000", (String)b.toString());
    }

    public void testIsMember() {
        Bits b = new Bits(2, 20);
        BitsTest.assertTrue((String)"Bits.isMember not looking up bits properly.", (boolean)b.isMember(9));
    }

    public void testAndSet() {
        Bits b1 = new Bits(2, 12);
        Bits b2 = new Bits(10, 22);
        b1.andSet(b2);
        BitsTest.assertEquals((String)"Bits not and'ed properly.", (String)"00000000001100000000000000000000", (String)b1.toString());
        BitsTest.assertEquals((String)"Bits.and affects parameter!", (String)"00000000001111111111110000000000", (String)b2.toString());
    }

    public void testOrSet() {
        Bits b1 = new Bits(2, 12);
        Bits b2 = new Bits(10, 22);
        b1.orSet(b2);
        BitsTest.assertEquals((String)"Bits not or'ed properly.", (String)"00111111111111111111110000000000", (String)b1.toString());
        BitsTest.assertEquals((String)"Bits.or affects parameter!", (String)"00000000001111111111110000000000", (String)b2.toString());
    }
}

