/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Name;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class ByteBuffer {
    public byte[] elements;
    public int length;

    public ByteBuffer() {
        this(64);
    }

    public ByteBuffer(int initialSize) {
        this.elements = new byte[initialSize];
        this.length = 0;
    }

    private void copy(int size) {
        byte[] newelems = new byte[size];
        System.arraycopy(this.elements, 0, newelems, 0, this.elements.length);
        this.elements = newelems;
    }

    public void appendByte(int b) {
        if (this.length >= this.elements.length) {
            this.copy(this.elements.length * 2);
        }
        this.elements[this.length++] = (byte)b;
    }

    public void appendBytes(byte[] bs, int start, int len) {
        while (this.length + len > this.elements.length) {
            this.copy(this.elements.length * 2);
        }
        System.arraycopy(bs, start, this.elements, this.length, len);
        this.length += len;
    }

    public void appendBytes(byte[] bs) {
        this.appendBytes(bs, 0, bs.length);
    }

    public void appendChar(int x) {
        while (this.length + 1 >= this.elements.length) {
            this.copy(this.elements.length * 2);
        }
        this.elements[this.length] = (byte)(x >> 8 & 0xFF);
        this.elements[this.length + 1] = (byte)(x & 0xFF);
        this.length += 2;
    }

    public void appendInt(int x) {
        while (this.length + 3 >= this.elements.length) {
            this.copy(this.elements.length * 2);
        }
        this.elements[this.length] = (byte)(x >> 24 & 0xFF);
        this.elements[this.length + 1] = (byte)(x >> 16 & 0xFF);
        this.elements[this.length + 2] = (byte)(x >> 8 & 0xFF);
        this.elements[this.length + 3] = (byte)(x & 0xFF);
        this.length += 4;
    }

    public void appendLong(long x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeLong(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException e) {
            throw new InternalError("write");
        }
    }

    public void appendFloat(float x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(4);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeFloat(x);
            this.appendBytes(buffer.toByteArray(), 0, 4);
        }
        catch (IOException e) {
            throw new InternalError("write");
        }
    }

    public void appendDouble(double x) {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(8);
        DataOutputStream bufout = new DataOutputStream(buffer);
        try {
            bufout.writeDouble(x);
            this.appendBytes(buffer.toByteArray(), 0, 8);
        }
        catch (IOException e) {
            throw new InternalError("write");
        }
    }

    public void appendName(Name name) {
        this.appendBytes(Name.names, name.index, name.length);
    }

    public void reset() {
        this.length = 0;
    }

    public Name toName() {
        return Name.fromUtf(this.elements, 0, this.length);
    }
}

