/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.TestCase;

public class ConverterTest
extends TestCase {
    public ConverterTest(String name) {
        super(name);
    }

    public void testString2int() {
        ConverterTest.assertEquals((String)"string2int (radix 10) fails.", (long)5L, (long)Converter.string2long("5", 10));
        ConverterTest.assertEquals((String)"string2int (radix 2) fails.", (long)11L, (long)Converter.string2long("1011", 2));
    }

    public void testUtf2chars() {
        byte[] src = Converter.string2utf("atest");
        int sindex = 1;
        char[] dst = new char[]{'*', '*', '*', '*', '*', '*'};
        int dindex = 2;
        int len = 4;
        int result = Converter.utf2chars(src, sindex, dst, dindex, len);
        ConverterTest.assertEquals((String)"Converter.utf2chars corrupted destination array.", (char)'*', (char)dst[0]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'*', (char)dst[1]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'t', (char)dst[2]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'e', (char)dst[3]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'s', (char)dst[4]);
        ConverterTest.assertEquals((String)"Converter.utf2chars corrupted destination array.", (char)'t', (char)dst[5]);
        ConverterTest.assertEquals((String)"Converter.utf2chars did not report correct end position in destination.", (int)6, (int)result);
    }

    public void testFunctionalUtf2chars() {
        byte[] src = Converter.string2utf("atest");
        int sindex = 1;
        int len = 4;
        char[] result = Converter.utf2chars(src, sindex, len);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'t', (char)result[0]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'e', (char)result[1]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'s', (char)result[2]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'t', (char)result[3]);
    }

    public void testOneArgUtf2chars() {
        byte[] src = Converter.string2utf("test");
        char[] result = Converter.utf2chars(src);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'t', (char)result[0]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'e', (char)result[1]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'s', (char)result[2]);
        ConverterTest.assertEquals((String)"Converter.utf2chars didn't convert source array properly.", (char)'t', (char)result[3]);
    }

    public void testUtf2string() {
        String expected = "test";
        byte[] src = Converter.string2utf("a" + expected);
        int sindex = 1;
        int len = 4;
        String result = Converter.utf2string(src, sindex, len);
        ConverterTest.assertEquals((String)"Converter.utf2string didn't construct String properly.", (String)expected, (String)result);
    }

    public void testOneArgUtf2string() {
        String expected = "test";
        byte[] src = Converter.string2utf(expected);
        String result = Converter.utf2string(src);
        ConverterTest.assertEquals((String)"Converter.utf2string didn't construct String properly.", (String)expected, (String)result);
    }

    public void testChars2utf() {
        char[] src = Converter.utf2chars(Converter.string2utf("atest"));
        byte[] dst = new byte[]{0, 0, 0, 0};
        int sindex = 1;
        int dindex = 0;
        int len = 4;
        int result = Converter.chars2utf(src, sindex, dst, dindex, len);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)dst[0]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)101, (int)dst[1]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)115, (int)dst[2]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)dst[3]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't return correct end position in destination.", (int)4, (int)result);
    }

    public void testFunctionalChars2utf() {
        char[] src = Converter.utf2chars(Converter.string2utf("atest"));
        int sindex = 1;
        int len = 4;
        byte[] test = Converter.chars2utf(src, sindex, len);
        ConverterTest.assertEquals((String)"Converter.chars2utf returned a String of the wrong length.", (int)4, (int)test.length);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)test[0]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)101, (int)test[1]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)115, (int)test[2]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)test[3]);
    }

    public void testOneArgChars2utf() {
        char[] src = Converter.utf2chars(Converter.string2utf("test"));
        byte[] test = Converter.chars2utf(src);
        ConverterTest.assertEquals((String)"Converter.chars2utf returned a String of the wrong length.", (int)4, (int)test.length);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)test[0]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)101, (int)test[1]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)115, (int)test[2]);
        ConverterTest.assertEquals((String)"Converter.chars2utf didn't convert source array properly.", (int)116, (int)test[3]);
    }

    public void testString2utf() {
        byte[] test = Converter.string2utf("test");
        byte[] expected = new byte[]{116, 101, 115, 116};
        ConverterTest.assertEquals((String)"Converter.string2utf returns array of the wrong length.", (int)expected.length, (int)test.length);
        for (int i = 0; i < expected.length; ++i) {
            ConverterTest.assertEquals((String)"Converter.string2utf did not convert character appropriately.", (byte)expected[i], (byte)test[i]);
        }
    }

    public void testQuote() {
        ConverterTest.assertEquals((String)"Converter.quote shouldn't modify Strings without special characters.", (String)"test", (String)Converter.escapeUnicode("test"));
        String testString = "\n\nthis\t\nis\b\b\t\na\n\"'test'\"\nstring\\\\\n";
        String quotedString = Converter.quote(testString);
        String expected = "\\n\\nthis\\t\\nis\\b\\b\\t\\na\\n\\\"\\'test\\'\\\"\\nstring\\\\\\\\\\n";
        ConverterTest.assertEquals((String)"String not quoted properly.", (String)expected, (String)quotedString);
    }

    public void testEscapeUnicode() {
        ConverterTest.assertEquals((String)"Converter.escapeUnicode shouldn't modify Strings without special characters.", (String)"test", (String)Converter.escapeUnicode("test"));
        String test = "\u0101\u0102\u0103abc\u0101\u0102\u0103";
        ConverterTest.assertEquals((String)"Converter.escapeUnicode doesn't convert Strings properly.", (String)"\\u\\u\\uabc\\u\\u\\u", (String)Converter.escapeUnicode(test));
    }

    public void testShortName() {
        ConverterTest.assertEquals((String)"Converter.shortName doesn't convert Strings properly.", (String)"List", (String)Converter.shortName(Name.fromString("java.lang.List")).toString());
        ConverterTest.assertEquals((String)"Converter.shortName doesn't convert Strings properly.", (String)"List", (String)Converter.shortName(Name.fromString("List")).toString());
        ConverterTest.assertEquals((String)"Converter.shortName doesn't convert Strings properly.", (String)"", (String)Converter.shortName(Name.fromString("")).toString());
        ConverterTest.assertEquals((String)"Converter.shortName doesn't convert Strings properly.", (String)"$$LList$$R", (String)Converter.shortName(Name.fromString("$$LList$$R")).toString());
        ConverterTest.assertEquals((String)"Converter.shortName doesn't convert Strings properly.", (String)"java$$Dlang$$DList", (String)Converter.shortName(Name.fromString("java$$Dlang$$DList")).toString());
    }

    public void testPackagePart() {
        ConverterTest.assertEquals((String)"Converter.packagePart doesn't convert Strings properly.", (String)"java.lang", (String)Converter.packagePart(Name.fromString("java.lang.List")).toString());
        ConverterTest.assertEquals((String)"Converter.packagePart doesn't convert Strings properly.", (String)"", (String)Converter.packagePart(Name.fromString("List")).toString());
        ConverterTest.assertEquals((String)"Converter.packagePart doesn't convert Strings properly.", (String)"", (String)Converter.packagePart(Name.fromString("")).toString());
        ConverterTest.assertEquals((String)"Converter.packagePart doesn't convert Strings properly.", (String)"", (String)Converter.packagePart(Name.fromString("$$LList$$R")).toString());
        ConverterTest.assertEquals((String)"Converter.packagePart doesn't convert Strings properly.", (String)"", (String)Converter.packagePart(Name.fromString("java$$Dlang$$DList")).toString());
    }
}

