/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.Filter;
import java.io.PrintStream;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hashtable<Key, Data>
extends PrintableObject {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key, Data>[] table;

    public Hashtable(int initialSize, float fillFactor) {
        int hashSize;
        for (hashSize = 1; hashSize < initialSize; hashSize <<= 1) {
        }
        this.hashSize = hashSize;
        this.hashMask = hashSize - 1;
        this.limit = (int)((float)hashSize * fillFactor);
        this.size = 0;
        this.table = new Entry[hashSize];
    }

    public Hashtable(int initialSize) {
        this(initialSize, 0.75f);
    }

    public Hashtable() {
        this(32);
    }

    public static <A, B> Hashtable<A, B> make() {
        return new Hashtable();
    }

    private void _double() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key, Data>[] oldtable = this.table;
        this.table = new Entry[this.hashSize];
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry<Key, Data> e) {
        if (e != null) {
            this.copy(e.next);
            e.next = this.table[e.hash & this.hashMask];
            this.table[e.hash & this.hashMask] = e;
        }
    }

    public Data get(Key key) {
        int hash = key.hashCode();
        Entry<Key, Data> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public Data put(Key key, Data value) {
        int hash = key.hashCode();
        Entry<Key, Data> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                Object oldvalue = e.value;
                e.value = value;
                return oldvalue;
            }
            e = e.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this._double();
        }
        int index = hash & this.hashMask;
        Entry<Key, Data> e2 = new Entry<Key, Data>(key, value, hash, this.table[index]);
        this.table[index] = e2;
        return null;
    }

    public Data remove(Key key) {
        int hash = key.hashCode();
        Entry<Key, Data> prev = null;
        Entry<Key, Data> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    this.table[hash & this.hashMask] = e.next;
                }
                --this.size;
                return e.value;
            }
            prev = e;
            e = e.next;
        }
        return null;
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    public void forEach(PairOp<Key, Data> op) {
        for (int i = 0; i < this.hashSize; ++i) {
            Entry<Key, Data> e = this.table[i];
            while (e != null) {
                op.invoke(e.key, e.value);
                e = e.next;
            }
        }
    }

    @Override
    public void print() {
        PrintOp po = new PrintOp();
        this.forEach(po);
    }

    public void print(Filter f) {
        PrintOp po = new PrintOp(f);
        this.forEach(po);
    }

    public void print(PrintStream out) {
        PrintStream oldOutputStream = outputStream;
        outputStream = out;
        this.print();
        outputStream = oldOutputStream;
        out.flush();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class PrintOp
    implements PairOp<Key, Data> {
        Filter _filter;

        PrintOp(Filter filter) {
            this._filter = filter;
        }

        PrintOp() {
            this(new Filter(){

                public boolean ignore(Object o) {
                    return false;
                }
            });
        }

        @Override
        public void invoke(Key k, Data d) {
            if (!this._filter.ignore(k)) {
                PrintableObject.include(k);
                PrintableObject.print(" => ");
                PrintableObject.include(d);
                PrintableObject.newline();
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PairOp<Key, Data> {
        public void invoke(Key var1, Data var2);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key, Data> {
        Key key;
        Data value;
        int hash;
        Entry<Key, Data> next;

        Entry(Key key, Data value, int hash, Entry<Key, Data> next) {
            this.key = key;
            this.value = value;
            this.hash = hash;
            this.next = next;
        }
    }
}

