/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.ListIterator;
import edu.rice.cs.nextgen.compiler.util.ListVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class List<Item> {
    public static <Item> List<Item> make(Item[] elts) {
        ListBox<Item> result = new ListBox<Item>();
        for (int i = elts.length - 1; i >= 0; --i) {
            result.insertFront(elts[i]);
        }
        return result.toList();
    }

    public static <Item> List<Item> make(int length, Item elt) {
        if (length == 0) {
            return new Empty();
        }
        return new Cons<Item>(elt, List.make(length - 1, elt));
    }

    public boolean subset(List<Item> that) {
        return that.isEmpty() || this.contains(that.getFirst()) && this.subset(that.getRest());
    }

    public List<Item> empty() {
        return new Empty();
    }

    public Cons<Item> cons(Item first) {
        return new Cons<Item>(first, this);
    }

    public boolean nonEmpty() {
        return !this.isEmpty();
    }

    public ListIterator<Item> iterator() {
        return new ListIterator(this);
    }

    public abstract Item getFirst();

    public abstract List<Item> getRest();

    public abstract List<Item> getLast();

    public abstract Item eltAt(int var1);

    public abstract boolean isEmpty();

    public abstract List<Item> updateFirst(Item var1);

    public abstract List<Item> updateRest(List<Item> var1);

    public abstract List<Item> reverse();

    public abstract int length();

    public abstract boolean contains(Item var1);

    public abstract int index(Item var1);

    public abstract List<Item> append(List<Item> var1);

    public abstract <Return> Return accept(ListVisitor<Item, Return> var1);

    public void print() {
        System.out.println(this);
    }

    public abstract String toString(String var1);

    public abstract String toString(String var1, String var2, String var3);

    abstract String elementsToString(String var1);
}

