/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListIterator;
import edu.rice.cs.nextgen.compiler.util.ListVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListBox<Item> {
    private final List<Item> EMPTY = new Empty();
    private List<Item> value;

    public ListBox() {
        this.value = this.EMPTY;
    }

    public ListBox(List<Item> _value) {
        this.value = _value;
    }

    public ListBox<Item> empty() {
        return new ListBox<Item>();
    }

    public ListBox<Item> cons(Item newElt) {
        return new ListBox<Item>(this.value.cons(newElt));
    }

    public Item getFirst() {
        return this.value.getFirst();
    }

    public List<Item> getRest() {
        return this.value.getRest();
    }

    public List<Item> getLast() {
        return this.value.getLast();
    }

    public Item elementAt(int i) {
        return this.value.eltAt(i);
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public boolean nonEmpty() {
        return this.value.nonEmpty();
    }

    public ListBox<Item> updateFirst(Item first) {
        return new ListBox<Item>(this.value.updateFirst(first));
    }

    public ListBox<Item> updateRest(List<Item> rest) {
        return new ListBox<Item>(this.value.updateRest(rest));
    }

    public List<Item> toList() {
        return this.value;
    }

    public ListIterator<Item> iterator() {
        return new ListIterator<Item>(this.value);
    }

    public void setFirst(Item o) {
        this.value = this.value.updateFirst(o);
    }

    public void setRest(List<Item> r) {
        this.value = this.value.updateRest(r);
    }

    public void set(List<Item> _value) {
        this.value = _value;
    }

    public void setEltAt(int i, Item val) {
        this.value = (List)this.accept(new UpdateEltAt<Item>(i, val));
    }

    public int length() {
        return this.value.length();
    }

    public void insertFront(Item o) {
        this.value = this.value.cons(o);
    }

    public void insertEnd(Item o) {
        this.value = this.value.reverse().cons(o).reverse();
    }

    public void insertEltsEnd(List<Item> items) {
        this.value = this.value.reverse().append(items.reverse()).reverse();
    }

    public void remove() {
        this.value = this.value.getRest();
    }

    public <Return> Return accept(ListVisitor<Item, Return> v) {
        return this.value.accept(v);
    }

    public void print() {
        System.out.println(this);
    }

    public String toString() {
        return new StringBuffer().append("[").append(this.value.toString()).append("]").toString();
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UpdateEltAt<Item>
    implements ListVisitor<Item, List<Item>> {
        int index;
        Item eltValue;

        UpdateEltAt(int i, Item e) {
            this.index = i;
            this.eltValue = e;
        }

        @Override
        public List<Item> forEmpty(Empty<Item> host) {
            throw new IllegalArgumentException("out-of-bounds index in UpdateEltAt");
        }

        @Override
        public List<Item> forCons(Cons<Item> host) {
            if (this.index == 0) {
                return host.getRest().cons(this.eltValue);
            }
            return ((List)host.getRest().accept(new UpdateEltAt<Item>(this.index - 1, this.eltValue))).cons(host.getFirst());
        }

        @Override
        public /* synthetic */ Object forCons(Cons x0) {
            return this.forCons(x0);
        }

        @Override
        public /* synthetic */ Object forEmpty(Empty x0) {
            return this.forEmpty(x0);
        }
    }
}

