/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.List;
import junit.framework.TestCase;

public class ListTest
extends TestCase {
    private List<String> _l;

    public ListTest(String name) {
        super(name);
    }

    public void setUp() {
        this._l = List.make(new String[]{"a", "b", "c"});
    }

    public void testMake() {
        List<String> l = List.make(new String[]{"a", "b", "c"});
        ListTest.assertEquals((String)"List.make didn't construct list properly", (String)"a", (String)l.getFirst());
        ListTest.assertEquals((String)"List.make didn't construct list properly", (String)"b", (String)l.getRest().getFirst());
        ListTest.assertEquals((String)"List.make didn't construct list properly", (String)"c", (String)l.getRest().getRest().getFirst());
    }

    public void testUpdateFirst() {
        List<String> newL = this._l.updateFirst("d");
        ListTest.assertEquals((String)"Updated list contains wrong values.", List.make(new String[]{"d", "b", "c"}), newL);
    }

    public void testUpdateRest() {
        List<String> newL = this._l.updateRest(List.make(new String[]{"d", "e", "f"}));
        ListTest.assertEquals((String)"Updated list contains wrong values.", List.make(new String[]{"a", "d", "e", "f"}), newL);
    }

    public void testLength() {
        ListTest.assertEquals((String)"List has wrong length.", (int)3, (int)this._l.length());
    }

    public void testEltAt() {
        ListTest.assertEquals((String)"List contains wrong element.", (String)"b", (String)this._l.eltAt(1));
    }

    public void testToString() {
        ListTest.assertEquals((String)"List prints improperly.", (String)"(a b c)", (String)this._l.toString());
    }

    public void testReverse() {
        ListTest.assertEquals((String)"Reversed list not constructed properly.", List.make(new String[]{"c", "b", "a"}), this._l.reverse());
    }

    public void testIndex() {
        ListTest.assertEquals((String)"List.index returned wrong value.", (int)2, (int)this._l.index("c"));
    }

    public void testContains() {
        ListTest.assertTrue((String)"List.contains returned false negative.", (boolean)this._l.contains("b"));
        ListTest.assertFalse((String)"List.contains returned false positive.", (boolean)this._l.contains("z"));
    }

    public void testToStringWithSeparator() {
        ListTest.assertEquals((String)"List.toString(separator) returned wrong value.", (String)"(a#b#c)", (String)this._l.toString("#"));
    }

    public void testAppend() {
        ListTest.assertEquals((String)"List.append returned wrong value.", List.make(new String[]{"d", "e", "a", "b", "c"}), this._l.append(List.make(new String[]{"d", "e"})));
    }

    public void testElementsToString() {
        ListTest.assertEquals((String)"List.elementsToString returned wrong value.", (String)"~a~b~c", (String)this._l.elementsToString("~"));
    }
}

