/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;

public class Name {
    public static final List<Name> EMPTY_LIST = new Empty<Name>();
    public int index;
    public int length;
    Name nextName;
    private static final int HASH_SIZE = 32768;
    private static final int HASH_MASK = Short.MAX_VALUE;
    private static final int NAME_SIZE = 131072;
    private static final Name[] hashtable = new Name[32768];
    public static byte[] names = new byte[131072];
    private static int nameCount = 0;

    private Name() {
    }

    private static int hashValue(byte[] cs, int start, int len) {
        if (len > 0) {
            return len * 68921 + cs[start] * 1681 + cs[start + len - 1] * 41 + cs[start + (len >> 1)];
        }
        return 0;
    }

    private static boolean equals(int index, byte[] cs, int start, int len) {
        int i;
        for (i = 0; i < len && names[index + i] == cs[start + i]; ++i) {
        }
        return i == len;
    }

    public static Name fromUtf(byte[] cs, int start, int len) {
        int h = Name.hashValue(cs, start, len) & Short.MAX_VALUE;
        Name n = hashtable[h];
        while (!(n == null || n.length == len && Name.equals(n.index, cs, start, len))) {
            n = n.nextName;
        }
        if (n == null) {
            while (nameCount + len > names.length) {
                byte[] newnames = new byte[names.length * 2];
                System.arraycopy(names, 0, newnames, 0, names.length);
                names = newnames;
            }
            System.arraycopy(cs, start, names, nameCount, len);
            n = new Name();
            n.index = nameCount;
            n.length = len;
            n.nextName = hashtable[h];
            Name.hashtable[h] = n;
            nameCount += len;
            if (len == 0) {
                ++nameCount;
            }
        }
        return n;
    }

    public static Name fromUtf(byte[] cs) {
        return Name.fromUtf(cs, 0, cs.length);
    }

    public static Name fromChars(char[] cs, int start, int len) {
        while (nameCount + cs.length * 3 >= names.length) {
            byte[] newnames = new byte[names.length * 2];
            System.arraycopy(names, 0, newnames, 0, names.length);
            names = newnames;
        }
        int nbytes = Converter.chars2utf(cs, start, names, nameCount, len) - nameCount;
        int h = Name.hashValue(names, nameCount, nbytes) & Short.MAX_VALUE;
        Name n = hashtable[h];
        while (!(n == null || n.length == nbytes && Name.equals(n.index, names, nameCount, nbytes))) {
            n = n.nextName;
        }
        if (n == null) {
            n = new Name();
            n.index = nameCount;
            n.length = nbytes;
            n.nextName = hashtable[h];
            Name.hashtable[h] = n;
            nameCount += nbytes;
            if (nbytes == 0) {
                ++nameCount;
            }
        }
        return n;
    }

    public static Name fromString(String s) {
        char[] cs = s.toCharArray();
        return Name.fromChars(cs, 0, cs.length);
    }

    public byte[] toUtf() {
        byte[] bs = new byte[this.length];
        System.arraycopy(names, this.index, bs, 0, this.length);
        return bs;
    }

    public String toString() {
        return Converter.utf2string(names, this.index, this.length);
    }

    public void getBytes(byte[] cs, int start) {
        System.arraycopy(names, this.index, cs, start, this.length);
    }

    public int hashCode() {
        return this.index;
    }

    public boolean equals(Object other) {
        return this.getClass() == other.getClass() && this.index == ((Name)other).index;
    }

    public int length() {
        return this.length;
    }

    public byte byteAt(int i) {
        return names[this.index + i];
    }

    public int indexOf(byte b) {
        int i;
        for (i = 0; i < this.length && names[this.index + i] != b; ++i) {
        }
        return i;
    }

    public int lastIndexOf(byte b) {
        int i;
        for (i = this.length - 1; i >= 0 && names[this.index + i] != b; --i) {
        }
        return i;
    }

    public boolean startsWith(Name prefix) {
        int i;
        for (i = 0; i < prefix.length && i < this.length && names[this.index + i] == names[prefix.index + i]; ++i) {
        }
        return i == prefix.length;
    }

    public boolean endsWith(Name suffix) {
        int j;
        int i = this.length - 1;
        for (j = suffix.length - 1; j >= 0 && i >= 0 && names[this.index + i] == names[suffix.index + j]; --i, --j) {
        }
        return j < 0;
    }

    public Name subName(int start, int end) {
        if (end < start) {
            end = start;
        }
        return Name.fromUtf(names, this.index + start, end - start);
    }

    public Name replace(byte from, byte to) {
        for (int i = 0; i < this.length; ++i) {
            if (names[this.index + i] != from) continue;
            byte[] bs = new byte[this.length];
            System.arraycopy(names, this.index, bs, 0, i);
            bs[i] = to;
            ++i;
            while (i < this.length) {
                byte b = names[this.index + i];
                bs[i] = b == from ? to : b;
                ++i;
            }
            return Name.fromUtf(bs, 0, this.length);
        }
        return this;
    }

    public Name append(Name n) {
        byte[] bs = new byte[this.length + n.length];
        this.getBytes(bs, 0);
        n.getBytes(bs, this.length);
        return Name.fromUtf(bs, 0, bs.length);
    }

    public static Name concatenate(Name[] ns) {
        int len = 0;
        for (int i = 0; i < ns.length; ++i) {
            len += ns[i].length;
        }
        byte[] bs = new byte[len];
        len = 0;
        for (int i = 0; i < ns.length; ++i) {
            ns[i].getBytes(bs, len);
            len += ns[i].length;
        }
        return Name.fromUtf(bs, 0, len);
    }
}

