/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.util;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Set<Key> {
    private int hashSize;
    private int hashMask;
    private int limit;
    private int size;
    private Entry<Key>[] table;

    public Set(int initialSize, float fillFactor) {
        int hashSize;
        for (hashSize = 1; hashSize < initialSize; hashSize <<= 1) {
        }
        this.hashSize = hashSize;
        this.hashMask = hashSize - 1;
        this.limit = (int)((float)hashSize * fillFactor);
        this.size = 0;
        this.table = new Entry[hashSize];
    }

    public Set(int initialSize) {
        this(initialSize, 0.75f);
    }

    public Set() {
        this(32);
    }

    public static <A> Set<A> make() {
        return new Set();
    }

    private void _double() {
        this.hashSize <<= 1;
        this.hashMask = this.hashSize - 1;
        this.limit <<= 1;
        Entry<Key>[] oldtable = this.table;
        this.table = new Entry[this.hashSize];
        for (int i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry<Key> e) {
        if (e != null) {
            this.copy(e.next);
            e.next = this.table[e.hash & this.hashMask];
            this.table[e.hash & this.hashMask] = e;
        }
    }

    public boolean contains(Key key) {
        int hash = key.hashCode();
        Entry<Key> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public boolean put(Key key) {
        int hash = key.hashCode();
        Entry<Key> e = this.table[hash & this.hashMask];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return true;
            }
            e = e.next;
        }
        ++this.size;
        if (this.size > this.limit) {
            this._double();
        }
        int index = hash & this.hashMask;
        Entry<Key> e2 = new Entry<Key>(key, hash, this.table[index]);
        this.table[index] = e2;
        return false;
    }

    public void reset() {
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = null;
        }
        this.size = 0;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<Key> {
        Key key;
        int hash;
        Entry<Key> next;

        Entry(Key key, int hash, Entry<Key> next) {
            this.key = key;
            this.hash = hash;
            this.next = next;
        }
    }
}

