/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.classloader;

import edu.rice.cs.nextgen.classloader.InstantiationName;
import edu.rice.cs.nextgen.classloader.Trio;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class InstantiationNameTest
extends TestCase {
    private static Trio<String, String, String[]>[] _instantiationTemplateTrios = new Trio[]{Trio.make("oneparam$$LA$$R", "oneparam$$L{0}$$R", new String[]{"A"}), Trio.make("twoparams$$LA$$CB$$R", "twoparams$$L{1}$$C{0}$$R", new String[]{"A", "B"}), Trio.make("nested1$$LList$$LA$$R$$CB$$R", "nested1$$L{1}$$C{0}$$R", new String[]{"List$$LA$$R", "B"}), Trio.make("nested2$$LList$$LList$$LA$$R$$R$$CB$$R", "nested2$$L{1}$$C{0}$$R", new String[]{"List$$LList$$LA$$R$$R", "B"}), Trio.make("nested3$$Lpack$$DList$$Ljava$$Dlang$$DObject$$R$$R", "nested3$$L{0}$$R", new String[]{"pack.List$$Ljava$$Dlang$$DObject$$R"}), Trio.make("outer$inner$$LA$$R", "outer$inner$$L{0}$$R", new String[]{"A"}), Trio.make("outer$inner$$LA$$CB$$R", "outer$inner$$L{1}$$C{0}$$R", new String[]{"A", "B"}), Trio.make("outer$inner$$LA$$CB$$CC$$R", "outer$inner$$L{2}$$C{1}$$C{0}$$R", new String[]{"A", "B", "C"}), Trio.make("first$$Ljava$$Dlang$$DInteger$$R", "first$$L{0}$$R", new String[]{"java.lang.Integer"}), Trio.make("first$$Ljava$$Dlang$$DInteger$$R$", "first$$L{0}$$R$", new String[]{"java.lang.Integer"}), Trio.make("Foo$$L$$AI$$R", "Foo$$L{0}$$R", new String[]{"[I"}), Trio.make("Foo$$L$$ALjava$$Dlang$$DInteger$$S$$R", "Foo$$L{0}$$R", new String[]{"[Ljava.lang.Integer;"}), Trio.make("Hashtable$$Ljava$$Dlang$$DString$$Cjava$$Dutil$$DList$$Ljava$$Dlang$$DString$$R$$R", "Hashtable$$L{1}$$C{0}$$R", new String[]{"java.lang.String", "java.util.List$$Ljava$$Dlang$$DString$$R"}), Trio.make("Hashtable$$L$$ALjava$$Dlang$$DString$$S$$Cjava$$Dutil$$DList$$L$$ALjava$$Dlang$$DString$$S$$R$$R", "Hashtable$$L{1}$$C{0}$$R", new String[]{"[Ljava.lang.String;", "java.util.List$$L$$ALjava$$Dlang$$DString$$S$$R"})};

    public InstantiationNameTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public static Test suite() {
        return new TestSuite(1.class$edu$rice$cs$nextgen$classloader$InstantiationNameTest == null ? (1.class$edu$rice$cs$nextgen$classloader$InstantiationNameTest = 1.class$("edu.rice.cs.nextgen.classloader.InstantiationNameTest")) : 1.class$edu$rice$cs$nextgen$classloader$InstantiationNameTest);
    }

    public void testCreateInstantiationName() {
        String[] packageNames = new String[]{"", "foo.", "foo.bar."};
        for (int i = 0; i < packageNames.length; ++i) {
            String curPackage = packageNames[i];
            for (int j = 0; j < _instantiationTemplateTrios.length; ++j) {
                String curClass = (String)_instantiationTemplateTrios[j].first();
                String combined = curPackage + curClass;
                InstantiationName name = new InstantiationName(combined);
                String[] correctArgs = _instantiationTemplateTrios[j].third();
                String[] createdArgs = name.getTypeParameters();
                InstantiationNameTest.assertEquals((String)("Incorrect number of arguments of instantiation name " + combined), (int)correctArgs.length, (int)createdArgs.length);
                for (int argNum = 0; argNum < correctArgs.length; ++argNum) {
                    InstantiationNameTest.assertEquals((String)("Argument #" + argNum + " of " + combined), (String)correctArgs[argNum], (String)createdArgs[argNum]);
                }
            }
        }
    }

    public void testInstantiationToTemplate() {
        String[] packageNames = new String[]{"", "foo.", "foo.bar."};
        for (int i = 0; i < packageNames.length; ++i) {
            String curPackage = packageNames[i];
            for (int j = 0; j < _instantiationTemplateTrios.length; ++j) {
                String inst = (String)_instantiationTemplateTrios[j].first();
                String correctTemplate = curPackage + (String)_instantiationTemplateTrios[j].second();
                String combined = curPackage + inst;
                InstantiationName instName = new InstantiationName(combined);
                String templateName = instName.getTemplateName();
                InstantiationNameTest.assertEquals((String)("Template name of " + combined), (String)correctTemplate, (String)templateName);
            }
        }
    }

    static class 1 {
        static /* synthetic */ Class class$edu$rice$cs$nextgen$classloader$InstantiationNameTest;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

