/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.classloader;

import edu.rice.cs.nextgen.classloader.ClassLoadChecker;
import edu.rice.cs.nextgen.classloader.InstantiationName;
import edu.rice.cs.nextgen.classloader.TemplateCache;
import edu.rice.cs.nextgen.classloader.TemplateClass;
import java.io.IOException;
import java.io.InputStream;

public class NextGenLoader
extends ClassLoader {
    public static final NextGenLoader ONLY = new NextGenLoader();
    public static final boolean DEBUG = false;
    public static final boolean WRITE_OUT_CLASSFILES = false;
    public static final char PARAM_BEGIN = '{';
    public static final char PARAM_END = '}';
    private static final ClassLoadChecker _classLoadChecker = new ClassLoadChecker();
    private static final TemplateCache _cache = new TemplateCache();

    private NextGenLoader() {
    }

    public NextGenLoader(ClassLoader parent) {
        super(parent);
    }

    public static String dotToSlash(String s) {
        return s.replace('.', '/');
    }

    public static String slashToDot(String s) {
        return s.replace(System.getProperty("file.separator").charAt(0), '.');
    }

    public static String replaceSubstring(String orig, String find, String repl) {
        int foundPos;
        StringBuffer buf = new StringBuffer();
        int pos = 0;
        while (pos < orig.length() && (foundPos = orig.indexOf(find, pos)) != -1) {
            buf.append(orig.substring(pos, foundPos));
            buf.append(repl);
            pos = foundPos + find.length();
        }
        buf.append(orig.substring(pos));
        return buf.toString();
    }

    private byte[] readClassFile(String className) throws IOException {
        String fileName = NextGenLoader.dotToSlash(className) + ".class";
        InputStream stream = this.getResourceAsStream(fileName);
        if (stream == null) {
            throw new IOException("Resource not found: " + fileName);
        }
        byte[] data = new byte[stream.available()];
        stream.read(data);
        return data;
    }

    static boolean isParametric(String name) {
        return name.indexOf("$$L") != -1;
    }

    /*
     * WARNING - void declaration
     */
    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        void var3_3;
        Class<?> clazz;
        if (_classLoadChecker.mustUseSystemLoader(name = NextGenLoader.slashToDot(name))) {
            clazz = this.findSystemClass(name);
        } else {
            try {
                byte[] classData;
                if (NextGenLoader.isParametric(name)) {
                    TemplateClass templateClass;
                    InstantiationName instName = new InstantiationName(name);
                    String templateName = instName.getTemplateName();
                    if (_cache.hasCached(templateName)) {
                        templateClass = _cache.getFromCache(templateName);
                    } else {
                        byte[] templateData = this.readClassFile(templateName);
                        templateClass = new TemplateClass(templateData);
                        _cache.putInCache(templateName, templateClass);
                    }
                    classData = templateClass.getInstantiation(instName.getTypeParameters());
                } else {
                    classData = this.readClassFile(name);
                }
                clazz = this.defineClass(name, classData, 0, classData.length);
            }
            catch (IOException ioe) {
                System.err.println("Got IO Exception reading class file");
                ioe.printStackTrace();
                throw new ClassNotFoundException("IO Exception in reading class file: " + ioe);
            }
        }
        if (var3_3 == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass((Class<?>)var3_3);
        }
        return var3_3;
    }
}

