/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Pair;
import java.io.File;

public abstract class ClassFile
extends PrintableObject {
    public static final int JAVA_MAGIC = -889275714;
    public static final int JAVA_MAJOR_VERSION = 48;
    public static final int JAVA_MINOR_VERSION = 0;
    public static final int JAVA_MIN_MAJOR_VERSION = 45;
    public static final int JAVA_MIN_MINOR_VERSION = 3;
    public static final int DEFAULT_MAJOR_VERSION = 46;
    public static final int DEFAULT_MINOR_VERSION = 0;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_FieldRef = 9;
    public static final int CONSTANT_MethodRef = 10;
    public static final int CONSTANT_InterfaceMethodRef = 11;
    public static final int CONSTANT_NameAndType = 12;
    static final String[] releases = new String[]{"1.1", "1.2", "1.3", "1.4"};
    static final short[] majorVersions = new short[]{45, 46, 47, 48};
    static final short[] minorVersions = new short[]{3, 0, 0, 0};
    public static final short MAJOR_VERSION_1_2 = ClassFile.classMajorVersion("1.2");
    public static final short MAJOR_VERSION_1_3 = ClassFile.classMajorVersion("1.3");
    public static final short MAJOR_VERSION_1_4 = ClassFile.classMajorVersion("1.4");

    public static boolean isValidTargetRelease(String target) {
        for (int i = 0; i < releases.length; ++i) {
            if (!releases[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static short classMajorVersion(String target) {
        for (int i = 0; i < releases.length; ++i) {
            if (!releases[i].equals(target)) continue;
            return majorVersions[i];
        }
        return 46;
    }

    public static short classMinorVersion(String target) {
        for (int i = 0; i < releases.length; ++i) {
            if (!releases[i].equals(target)) continue;
            return minorVersions[i];
        }
        return 0;
    }

    static byte[] internalize(byte[] buf, int offset, int len) {
        byte[] translated = new byte[len];
        for (int j = 0; j < len; ++j) {
            int b = buf[offset + j];
            translated[j] = b == 47 ? 46 : b;
        }
        return translated;
    }

    static byte[] externalize(byte[] buf, int offset, int len) {
        byte[] translated = new byte[len];
        for (int j = 0; j < len; ++j) {
            int b = buf[offset + j];
            translated[j] = b == 46 ? 47 : b;
        }
        return translated;
    }

    static byte[] externalize(Name name) {
        return ClassFile.externalize(Name.names, name.index, name.length);
    }

    static Name internalizeFileName(String s) {
        return Name.fromString(s.replace(File.separatorChar, '.'));
    }

    static String externalizeFileName(Name n) {
        return n.toString().replace('.', File.separatorChar);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NameAndType
    extends Pair<Name, Type> {
        NameAndType(Name name, Type type) {
            super(name, type);
        }
    }
}

