/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.ClassFile;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.FileEntry;
import edu.rice.cs.nextgen.compiler.util.Filter;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassReader
extends ClassFile
implements Symbol.Completer,
Flags,
Kinds,
TypeTags {
    public static final String pathSeparator = System.getProperty("path.separator");
    CompilerOptions compilerOptions;
    public SourceCompleter sourceCompleter = null;
    public Hashtable<Name, Symbol.ClassSymbol> classes = new Hashtable();
    public Hashtable<Name, Symbol.PackageSymbol> packages = new Hashtable();
    private Scope typeVars = new Scope(null);
    private String currentClassFileName = null;
    private Symbol.ClassSymbol currentClassSymbol = null;
    private Symbol currentOwner = null;
    byte[] classFileBytes = new byte[65536];
    int classFilePosition;
    Object[] constantPool;
    private int[] constantPoolDefIndices;
    byte[] signature;
    int sigp;
    int siglimit;
    Hashtable<String, ZipFile> dirs = new Hashtable();

    public ClassReader(CompilerOptions options) {
        this.compilerOptions = options;
        this.packages.put(Symbol.EMPTY_PACKAGE_SYMBOL.fullname, Symbol.EMPTY_PACKAGE_SYMBOL);
        Symbol.EMPTY_PACKAGE_SYMBOL.completer = this;
    }

    @Override
    public void print() {
        ClassReader.openBox(10);
        ClassReader.print("packages: ");
        this.packages.print(new Filter(){

            public boolean ignore(Object o) {
                return o.toString().equals("") || o.toString().startsWith("java") || o.toString().startsWith("sun");
            }
        });
        ClassReader.closeBox();
        ClassReader.newline();
        ClassReader.openBox(9);
        ClassReader.print("classes: ");
        this.classes.print(new Filter(){

            public boolean ignore(Object o) {
                return o.toString().equals("") || o.toString().startsWith("java") || o.toString().startsWith("sun");
            }
        });
        ClassReader.closeBox();
    }

    char nextChar() {
        return (char)(((this.classFileBytes[this.classFilePosition++] & 0xFF) << 8) + (this.classFileBytes[this.classFilePosition++] & 0xFF));
    }

    int nextInt() {
        return ((this.classFileBytes[this.classFilePosition++] & 0xFF) << 24) + ((this.classFileBytes[this.classFilePosition++] & 0xFF) << 16) + ((this.classFileBytes[this.classFilePosition++] & 0xFF) << 8) + (this.classFileBytes[this.classFilePosition++] & 0xFF);
    }

    char getChar(int bp) {
        return (char)(((this.classFileBytes[bp] & 0xFF) << 8) + (this.classFileBytes[bp + 1] & 0xFF));
    }

    int getInt(int bp) {
        return ((this.classFileBytes[bp] & 0xFF) << 24) + ((this.classFileBytes[bp + 1] & 0xFF) << 16) + ((this.classFileBytes[bp + 2] & 0xFF) << 8) + (this.classFileBytes[bp + 3] & 0xFF);
    }

    long getLong(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.classFileBytes, bp, 8));
        try {
            return bufin.readLong();
        }
        catch (IOException e) {
            throw new InternalError();
        }
    }

    float getFloat(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.classFileBytes, bp, 4));
        try {
            return bufin.readFloat();
        }
        catch (IOException e) {
            throw new InternalError("get");
        }
    }

    double getDouble(int bp) {
        DataInputStream bufin = new DataInputStream(new ByteArrayInputStream(this.classFileBytes, bp, 8));
        try {
            return bufin.readDouble();
        }
        catch (IOException e) {
            throw new InternalError("get");
        }
    }

    void indexPool() {
        this.constantPoolDefIndices = new int[this.nextChar()];
        this.constantPool = new Object[this.constantPoolDefIndices.length];
        int i = 1;
        block6: while (i < this.constantPoolDefIndices.length) {
            this.constantPoolDefIndices[i++] = this.classFilePosition;
            byte tag = this.classFileBytes[this.classFilePosition++];
            switch (tag) {
                case 1: 
                case 2: {
                    char len = this.nextChar();
                    this.classFilePosition += len;
                    continue block6;
                }
                case 7: 
                case 8: {
                    this.classFilePosition += 2;
                    continue block6;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.classFilePosition += 4;
                    continue block6;
                }
                case 5: 
                case 6: {
                    this.classFilePosition += 8;
                    ++i;
                    continue block6;
                }
            }
            throw new LoadError(new StringBuffer().append("bad constant pool tag: ").append(tag).append(" at ").append(this.classFilePosition - 1).toString());
        }
    }

    Object readPool(int i) {
        Object result = this.constantPool[i];
        if (result != null) {
            return result;
        }
        int index = this.constantPoolDefIndices[i];
        if (index == 0) {
            return null;
        }
        byte tag = this.classFileBytes[index];
        switch (tag) {
            case 1: {
                this.constantPool[i] = Name.fromUtf(this.classFileBytes, index + 3, this.getChar(index + 1));
                break;
            }
            case 2: {
                throw new LoadError("unicode string in class file not supported");
            }
            case 7: {
                this.constantPool[i] = this.readClassOrType(this.getChar(index + 1));
                break;
            }
            case 8: {
                this.constantPool[i] = this.readName(this.getChar(index + 1)).toString();
                break;
            }
            case 9: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                Name name = (Name)nt.first;
                Type sig = (Type)nt.second;
                this.constantPool[i] = new Symbol.VarSymbol(0, name, sig, owner);
                break;
            }
            case 10: 
            case 11: {
                Symbol.ClassSymbol owner = this.readClassSymbol(this.getChar(index + 1));
                ClassFile.NameAndType nt = (ClassFile.NameAndType)this.readPool(this.getChar(index + 3));
                Name name = (Name)nt.first;
                Type sig = (Type)nt.second;
                this.constantPool[i] = new Symbol.MethodSymbol(0, name, sig, owner);
                break;
            }
            case 12: {
                this.constantPool[i] = new ClassFile.NameAndType(this.readName(this.getChar(index + 1)), this.readType(this.getChar(index + 3)));
                break;
            }
            case 3: {
                this.constantPool[i] = new Integer(this.getInt(index + 1));
                break;
            }
            case 4: {
                this.constantPool[i] = new Float(this.getFloat(index + 1));
                break;
            }
            case 5: {
                this.constantPool[i] = new Long(this.getLong(index + 1));
                break;
            }
            case 6: {
                this.constantPool[i] = new Double(this.getDouble(index + 1));
                break;
            }
            default: {
                throw new LoadError(new StringBuffer().append("bad constant pool tag: ").append(tag).toString());
            }
        }
        return this.constantPool[i];
    }

    Type readType(int i) {
        int index = this.constantPoolDefIndices[i];
        return this.sigToType(this.classFileBytes, index + 3, this.getChar(index + 1));
    }

    Object readClassOrType(int i) {
        int index = this.constantPoolDefIndices[i];
        char len = this.getChar(index + 1);
        int start = index + 3;
        if (this.classFileBytes[start] == 91 || this.classFileBytes[start + len - 1] == 59) {
            return this.sigToType(this.classFileBytes, start, len);
        }
        return this.enterClass(Name.fromUtf(ClassReader.internalize(this.classFileBytes, start, len)));
    }

    List<Type> readTypeParams(int i) {
        int index = this.constantPoolDefIndices[i];
        return this.sigToTypeParams(this.classFileBytes, index + 3, this.getChar(index + 1));
    }

    Symbol.ClassSymbol readClassSymbol(int i) {
        return (Symbol.ClassSymbol)this.readPool(i);
    }

    Name readName(int i) {
        return (Name)this.readPool(i);
    }

    Type sigToType(Name sig) {
        return sig == null ? null : this.sigToType(Name.names, sig.index, sig.length);
    }

    Type sigToType(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToType();
    }

    Type sigToType() {
        switch (this.signature[this.sigp]) {
            case 84: {
                ++this.sigp;
                int start = this.sigp;
                while (this.signature[this.sigp] != 59) {
                    ++this.sigp;
                }
                ++this.sigp;
                return this.findTypeVar(Name.fromUtf(this.signature, start, this.sigp - 1 - start));
            }
            case 66: {
                ++this.sigp;
                return Type.BYTE_TYPE;
            }
            case 67: {
                ++this.sigp;
                return Type.CHAR_TYPE;
            }
            case 68: {
                ++this.sigp;
                return Type.DOUBLE_TYPE;
            }
            case 70: {
                ++this.sigp;
                return Type.FLOAT_TYPE;
            }
            case 73: {
                ++this.sigp;
                return Type.INT_TYPE;
            }
            case 74: {
                ++this.sigp;
                return Type.LONG_TYPE;
            }
            case 76: {
                Type t = this.classSigToType(Type.NO_TYPE);
                while (this.sigp < this.siglimit && this.signature[this.sigp] == 46) {
                    ++this.sigp;
                    t = this.classSigToType(t);
                }
                return t;
            }
            case 83: {
                ++this.sigp;
                return Type.SHORT_TYPE;
            }
            case 86: {
                ++this.sigp;
                return Type.VOID_TYPE;
            }
            case 90: {
                ++this.sigp;
                return Type.BOOLEAN_TYPE;
            }
            case 91: {
                ++this.sigp;
                while (48 <= this.signature[this.sigp] && this.signature[this.sigp] <= 57) {
                    ++this.sigp;
                }
                return new Type.ArrayType(this.sigToType());
            }
            case 40: {
                List<Type> argtypes = this.sigToTypes(')');
                Type restype = this.sigToType();
                return new Type.MethodType(argtypes, restype, Symbol.ClassSymbol.EMPTY_LIST);
            }
            case 60: {
                this.typeVars = this.typeVars.extend();
                Type.ForAll poly = new Type.ForAll(this.sigToTypeParams(), (Type.MethodType)this.sigToType());
                this.typeVars = this.typeVars.leave();
                return poly;
            }
        }
        throw new LoadError(new StringBuffer().append("bad signature: ").append(Converter.utf2string(this.signature, this.sigp, 10)).toString());
    }

    Type classSigToType(Type outer) {
        if (this.signature[this.sigp] == 76) {
            ++this.sigp;
            int start = this.sigp;
            while (this.signature[this.sigp] != 59 && this.signature[this.sigp] != 60) {
                ++this.sigp;
            }
            Type t = this.enterClass((Name)Name.fromUtf((byte[])ClassReader.internalize((byte[])this.signature, (int)start, (int)(this.sigp - start)))).type;
            if (this.signature[this.sigp] == 60) {
                t = new Type.ClassType(null, this.sigToTypes('>'), t.typeSymbol);
            }
            ((Type.ClassType)t).enclosingInstanceType = outer;
            ++this.sigp;
            return t;
        }
        throw new LoadError(new StringBuffer().append("bad class signature: ").append(Converter.utf2string(this.signature, this.sigp, 10)).toString());
    }

    List<Type> sigToTypes(char terminator) {
        ++this.sigp;
        ListBox<Type> types = new ListBox<Type>();
        while (this.signature[this.sigp] != terminator) {
            types.insertEnd(this.sigToType());
        }
        ++this.sigp;
        return types.toList();
    }

    List<Type> sigToTypeParams(Name name) {
        return this.sigToTypeParams(Name.names, name.index, name.length);
    }

    List<Type> sigToTypeParams(byte[] sig, int offset, int len) {
        this.signature = sig;
        this.sigp = offset;
        this.siglimit = offset + len;
        return this.sigToTypeParams();
    }

    List<Type> sigToTypeParams() {
        ListBox<Type> tvars = new ListBox<Type>();
        if (this.signature[this.sigp] == 60) {
            ++this.sigp;
            while (this.signature[this.sigp] != 62) {
                tvars.insertEnd(this.sigToTypeParam());
            }
            ++this.sigp;
        }
        return tvars.toList();
    }

    Type sigToTypeParam() {
        int start = this.sigp;
        while (this.signature[this.sigp] != 58) {
            ++this.sigp;
        }
        Name name = Name.fromUtf(this.signature, start, this.sigp - start);
        Type.TypeVar tvar = new Type.TypeVar(null, name, this.currentOwner);
        this.typeVars.addSymbol(tvar.typeSymbol);
        ++this.sigp;
        tvar.bound = this.sigToType();
        return tvar;
    }

    Type findTypeVar(Name name) {
        Scope.Entry e = this.typeVars.lookup(name);
        if (e.scope != null) {
            return e.symbol.type;
        }
        throw new LoadError(new StringBuffer().append("undeclared type variable: ").append(name).toString());
    }

    void unrecogized(Name attrName) {
        if (this.compilerOptions.checkClassFile()) {
            System.err.println(new StringBuffer().append("unrecogized attribute: ").append(attrName).toString());
        }
    }

    void readAttr(Symbol sym, Name attrName, int attrLen) {
        if (attrName == Names.ConstantValue) {
            ((Symbol.VarSymbol)sym).constantValue = this.readPool(this.nextChar());
        } else if (attrName == Names.Code) {
            this.classFilePosition += attrLen;
        } else if (attrName == Names.Exceptions) {
            int nexceptions = this.nextChar();
            ListBox<Symbol.ClassSymbol> thrown = new ListBox<Symbol.ClassSymbol>();
            for (int j = 0; j < nexceptions; ++j) {
                thrown.insertEnd(this.readClassSymbol(this.nextChar()));
            }
            sym.type.methodType().thrown = thrown.toList();
        } else if (attrName == Names.Synthetic) {
            sym.flags_field |= 0x10000;
        } else if (attrName == Names.Deprecated) {
            sym.flags_field |= 0x20000;
        } else if (attrName == Names.Signature) {
            sym.type = this.readType(this.nextChar());
        } else {
            this.unrecogized(attrName);
            this.classFilePosition += attrLen;
        }
    }

    void readAttrs(Symbol sym) {
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            this.readAttr(sym, attrName, attrLen);
        }
    }

    Symbol.VarSymbol readField() {
        char flags = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        Symbol.VarSymbol v = new Symbol.VarSymbol(flags, name, type, this.currentOwner);
        this.readAttrs(v);
        return v;
    }

    Symbol.MethodSymbol readMethod() {
        char flags = this.nextChar();
        Name name = this.readName(this.nextChar());
        Type type = this.readType(this.nextChar());
        if (name == Names.init && this.currentOwner.isNested()) {
            type = new Type.MethodType(type.argTypes().getRest(), type.returnType(), type.thrown());
        }
        Symbol.MethodSymbol m = new Symbol.MethodSymbol(flags, name, type, this.currentOwner);
        Symbol prevOwner = this.currentOwner;
        this.currentOwner = m;
        this.readAttrs(m);
        this.currentOwner = prevOwner;
        return m;
    }

    void skipMember() {
        this.classFilePosition += 6;
        int ac = this.nextChar();
        for (int i = 0; i < ac; ++i) {
            this.classFilePosition += 2;
            int attrLen = this.nextInt();
            this.classFilePosition += attrLen;
        }
    }

    void enterTypevars(Type t) {
        if (t.enclosingType().tag == 10) {
            this.enterTypevars(t.enclosingType());
        }
        List<Type> xs = t.getTypeParams();
        while (xs.nonEmpty()) {
            this.typeVars.addSymbol(xs.getFirst().typeSymbol);
            xs = xs.getRest();
        }
    }

    void readClass(Symbol.ClassSymbol c) {
        int i;
        Symbol.ClassSymbol self;
        this.currentOwner = c;
        Type.ClassType ct = (Type.ClassType)c.type;
        c.members_field = new Scope(c);
        this.typeVars = this.typeVars.extend();
        if (ct.enclosingType().tag == 10) {
            this.enterTypevars(ct.enclosingType());
        }
        char flags = this.nextChar();
        if (c.owner.kind == 1) {
            c.flags_field = flags;
        }
        if (c != (self = this.readClassSymbol(this.nextChar()))) {
            throw new LoadError(new StringBuffer().append("class file contains wrong class: ").append(self.flatname).toString());
        }
        int startbp = this.classFilePosition;
        this.nextChar();
        char interfaceCount = this.nextChar();
        this.classFilePosition += interfaceCount * 2;
        int fieldCount = this.nextChar();
        for (int i2 = 0; i2 < fieldCount; ++i2) {
            this.skipMember();
        }
        int methodCount = this.nextChar();
        for (int i3 = 0; i3 < methodCount; ++i3) {
            this.skipMember();
        }
        int attrCount = this.nextChar();
        for (int i4 = 0; i4 < attrCount; ++i4) {
            Name attrName = this.readName(this.nextChar());
            int attrLen = this.nextInt();
            if (attrName == Names.SourceFile) {
                c.sourcefile = this.readName(this.nextChar());
                continue;
            }
            if (attrName == Names.InnerClasses) {
                this.readInnerClasses(c);
                continue;
            }
            if (attrName == Names.Signature) {
                ct.typeParams = this.readTypeParams(this.nextChar());
                ct.parentType = this.sigToType();
                ListBox<Type> is = new ListBox<Type>();
                while (this.sigp != this.siglimit) {
                    is.insertEnd(this.sigToType());
                }
                ct.interfaces = is.toList();
                continue;
            }
            this.readAttr(c, attrName, attrLen);
        }
        this.classFilePosition = startbp;
        int n = this.nextChar();
        if (ct.parentType == null) {
            ct.parentType = n == 0 ? Type.NO_TYPE : this.readClassSymbol((int)n).type;
        }
        n = this.nextChar();
        Type[] is = new Type[n];
        for (i = 0; i < n; ++i) {
            is[i] = this.readClassSymbol((int)this.nextChar()).type;
        }
        if (ct.interfaces == null) {
            ct.interfaces = List.make(is);
        }
        Asserter._assert(fieldCount == this.nextChar());
        for (i = 0; i < fieldCount; ++i) {
            c.members_field.addSymbol(this.readField());
        }
        Asserter._assert(methodCount == this.nextChar());
        for (i = 0; i < methodCount; ++i) {
            c.members_field.addSymbol(this.readMethod());
        }
        this.typeVars = this.typeVars.leave();
    }

    void readInnerClasses(Symbol.ClassSymbol c) {
        int n = this.nextChar();
        for (int i = 0; i < n; ++i) {
            this.nextChar();
            Symbol.ClassSymbol outer = this.readClassSymbol(this.nextChar());
            char nameIndex = this.nextChar();
            char flags = this.nextChar();
            if (nameIndex == '\u0000') continue;
            Name name = this.readName(nameIndex);
            if (outer == null) continue;
            Symbol.ClassSymbol member = this.enterClass(name, outer);
            if ((flags & 8) == 0) {
                ((Type.ClassType)member.type).enclosingInstanceType = outer.type;
            }
            if (c != outer) continue;
            member.flags_field = flags;
            c.members_field.addSymbol(member);
        }
    }

    void readClassFile(Symbol.ClassSymbol c) throws IOException {
        int magic = this.nextInt();
        if (magic != -889275714) {
            throw new LoadError("illegal start of class file");
        }
        char minorVersion = this.nextChar();
        char majorVersion = this.nextChar();
        if (majorVersion > '0' || majorVersion * 10000 + minorVersion < 450003) {
            throw new LoadError(new StringBuffer().append("class file has wrong version ").append((int)majorVersion).append(".").append((int)minorVersion).append(", should be ").append(48).append(".").append(0).toString());
        }
        if (this.compilerOptions.checkClassFile() && majorVersion == '0' && minorVersion > '\u0000') {
            this.printCCF("found.later.version", Integer.toString(minorVersion));
        }
        this.indexPool();
        this.readClass(c);
    }

    boolean isZip(String name) {
        return name.endsWith(".zip") || name.endsWith(".jar");
    }

    ZipFile openDir(String dirname) throws IOException {
        ZipFile zdir = this.dirs.get(dirname);
        if (zdir == null) {
            zdir = new ZipFile(dirname);
            this.dirs.put(dirname, zdir);
        }
        return zdir;
    }

    private List<FileEntry> list(String dirname, String name) {
        ListBox<FileEntry> entries = null;
        try {
            if (this.isZip(dirname)) {
                ZipFile zdir = this.openDir(dirname);
                if (name.length() != 0 && !(name = name.replace('\\', '/')).endsWith("/")) {
                    name = new StringBuffer().append(name).append("/").toString();
                }
                int namelen = name.length();
                Enumeration<? extends ZipEntry> e = zdir.entries();
                while (e.hasMoreElements()) {
                    String suffix;
                    ZipEntry entry = e.nextElement();
                    String ename = entry.getName();
                    if (!ename.startsWith(name)) continue;
                    if (entries == null) {
                        entries = new ListBox();
                    }
                    if ((suffix = ename.substring(namelen)).length() <= 0 || suffix.indexOf(47) >= 0) continue;
                    entries.insertEnd(new FileEntry.Zipped(suffix, zdir, entry));
                }
            } else {
                File f = name.length() != 0 ? new File(dirname, name) : new File(dirname);
                String[] names = f.list();
                if (names != null) {
                    if (entries == null) {
                        entries = new ListBox<FileEntry>();
                    }
                    for (int i = 0; i < names.length; ++i) {
                        entries.insertEnd(new FileEntry.Regular(names[i], new File(f, names[i])));
                    }
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        return entries != null ? entries.toList() : null;
    }

    public Symbol.ClassSymbol defineClass(Name name, Symbol owner) {
        Symbol.ClassSymbol c = new Symbol.ClassSymbol(0, name, owner);
        c.completer = this;
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name name, Symbol.TypeSymbol owner) {
        Name flatname = Symbol.TypeSymbol.formFlatName(name, owner);
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            c = this.defineClass(name, owner);
            this.classes.put(flatname, c);
        } else if ((c.name != name || c.owner != owner) && owner.kind == 2) {
            c.name = name;
            c.owner = owner;
            c.fullname = Symbol.ClassSymbol.formFullName(name, owner);
        }
        return c;
    }

    public Symbol.ClassSymbol enterClass(Name flatname) {
        Symbol.ClassSymbol c = this.classes.get(flatname);
        if (c == null) {
            if (this.compilerOptions.checkClassFile()) {
                Asserter._assert(flatname.indexOf((byte)36) == flatname.length, flatname);
            }
            c = this.defineClass(Converter.shortName(flatname), this.enterPackage(Converter.packagePart(flatname)));
            this.classes.put(flatname, c);
        }
        return c;
    }

    @Override
    public void complete(Symbol sym) throws Symbol.CompletionFailure {
        if (sym.kind == 2) {
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)sym;
            c.owner.complete();
            this.fillIn(c);
        } else if (sym.kind == 1) {
            Symbol.PackageSymbol p = (Symbol.PackageSymbol)sym;
            this.fillIn(p);
        }
    }

    public void fillIn(Symbol.ClassSymbol c) {
        this.currentClassSymbol = c;
        this.currentClassFileName = c.toString();
        FileEntry classfile = c.classfile;
        c.members_field = Scope.ERROR;
        if (classfile != null) {
            try {
                InputStream s = classfile.open();
                String filename = classfile.getPath();
                this.compilerOptions.printIfVerbose(new StringBuffer().append("[loading ").append(filename).append("]").toString());
                if (classfile.getName().endsWith(".class")) {
                    int actuallyRead;
                    int size = (int)classfile.length();
                    if (this.classFileBytes.length < size) {
                        this.classFileBytes = new byte[size];
                    }
                    int totalRead = 0;
                    do {
                        actuallyRead = s.read(this.classFileBytes, totalRead, size - totalRead);
                        totalRead += actuallyRead;
                    } while (actuallyRead > 0);
                    s.close();
                    this.classFilePosition = 0;
                    this.readClassFile(c);
                } else {
                    this.sourceCompleter.complete(c, filename, s);
                }
                return;
            }
            catch (IOException ex) {
                throw new LoadError(ex.getMessage());
            }
        }
        throw new Symbol.CompletionFailure(c, new StringBuffer().append("file ").append(ClassReader.externalizeFileName(c.flatname)).append(".class not found").toString());
    }

    public Symbol.ClassSymbol loadClass(Name flatname) throws Symbol.CompletionFailure {
        boolean absent = this.classes.get(flatname) == null;
        Symbol.ClassSymbol c = this.enterClass(flatname);
        if (c.members_field == null && c.completer != null) {
            try {
                c.complete();
            }
            catch (Symbol.CompletionFailure ex) {
                if (absent) {
                    this.classes.remove(flatname);
                }
                throw ex;
            }
        }
        return c;
    }

    public Symbol.PackageSymbol enterPackage(Name fullname) {
        Symbol.PackageSymbol p = this.packages.get(fullname);
        if (p == null) {
            p = new Symbol.PackageSymbol(Converter.shortName(fullname), this.enterPackage(Converter.packagePart(fullname)));
            p.completer = this;
            this.packages.put(fullname, p);
        }
        return p;
    }

    private void fillIn(Symbol.PackageSymbol p) {
        if (p.members_field == null) {
            p.members_field = new Scope(p);
        }
        String dirname = ClassReader.externalizeFileName(p.fullname);
        String classPath = this.compilerOptions.getClassPath();
        int i = 0;
        while (i < classPath.length()) {
            int end = classPath.indexOf(pathSeparator, i);
            String pathname = classPath.substring(i, end);
            List<FileEntry> files = this.list(pathname, dirname);
            if (files != null) {
                p.flags_field |= 0x800000;
                this.includeClassFiles(files, p);
            }
            i = end + 1;
        }
    }

    void includeClassFiles(List<FileEntry> files, Symbol.PackageSymbol p) {
        List<FileEntry> l = files;
        while (l.nonEmpty()) {
            this.includeClassFile(l.getFirst(), p, ".class");
            if (this.sourceCompleter != null) {
                this.includeClassFile(l.getFirst(), p, ".java");
            }
            l = l.getRest();
        }
    }

    public void includeClassFile(FileEntry file, Symbol.PackageSymbol p, String extension) {
        Symbol.ClassSymbol c;
        String filename = file.getName();
        if (filename.endsWith(extension) && p.members_field.lookup((Name)c.name).symbol != (c = this.enterClass(Name.fromString(filename.substring(0, filename.length() - extension.length())), p))) {
            c.classfile = file;
            p.members_field.addSymbol(c);
        }
    }

    private void printCCF(String key, String arg) {
        System.out.println(ErrorLog.getLocalizedString(new StringBuffer().append("verbose.").append(key).toString(), arg));
    }

    public static interface SourceCompleter {
        public void complete(Symbol.ClassSymbol var1, String var2, InputStream var3) throws Symbol.CompletionFailure;
    }

    public class LoadError
    extends Symbol.CompletionFailure {
        public LoadError(Symbol.ClassSymbol c, String cname, String msg) {
            super(c, "bad file: " + cname + ", " + msg + ". Please remove or make sure it appears in correct " + "subdirectory of the classpath");
            throw new InternalError("bad file: " + cname + ", " + msg + ". Please remove or make sure it appears in correct " + "subdirectory of the classpath");
        }

        public LoadError(String msg) {
            this(this$0.currentClassSymbol, this$0.currentClassFileName, msg);
        }
    }
}

