/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Position;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Code
extends PrintableObject
implements ByteCodes,
TypeTags {
    static final boolean debugCode = true;
    public int maxStackSize = 0;
    public int maxLocals = 0;
    public byte[] byteCodeArray = new byte[64];
    public int byteCodeIndex = 0;
    ListBox<char[]> catchInfo = new ListBox();
    List<char[]> lineInfo = new Empty<char[]>();
    char[] localVarStartPc = new char[4];
    char[] localVarLength = new char[4];
    char[] localVarRegister = new char[4];
    Symbol.VarSymbol[] localVar = new Symbol.VarSymbol[4];
    int varCount = 0;
    public boolean longJumpsAllowed;
    public boolean codeGenerationEnabled = true;
    private int stackSize = 0;
    private boolean fixedPc = false;
    public int nextVarAddress = 0;
    private int nextRegister = 0;
    private int[] varLocations = new int[64];
    boolean _debugInfo;
    private static final int[] STACK_DIFF = new int[203];
    private static String[] mnemonic;

    public Code(boolean fatcode, boolean debugInfo) {
        this.longJumpsAllowed = fatcode;
        this._debugInfo = debugInfo;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    @Override
    public void print() {
        Code.leftBracket();
        Code.openBox(6);
        Code.print("Code: ");
        for (int i = 0; i < this.byteCodeIndex; ++i) {
            byte next = this.byteCodeArray[i];
            if (0 <= next && next <= mnemonic.length) {
                String prettyOutput = mnemonic[next];
                if (prettyOutput != null) {
                    Code.print(prettyOutput);
                } else {
                    Code.include(new Integer(next));
                }
            } else {
                Code.include(new Integer(next));
            }
            Code.print("; ");
            Code.breakHint();
        }
        Code.closeBox();
        Code.rightBracket();
    }

    public static int typecode(Type type) {
        switch (type.tag) {
            case 1: {
                return 5;
            }
            case 3: {
                return 7;
            }
            case 2: {
                return 6;
            }
            case 4: {
                return 0;
            }
            case 5: {
                return 1;
            }
            case 6: {
                return 2;
            }
            case 7: {
                return 3;
            }
            case 8: {
                return 5;
            }
            case 9: {
                return 8;
            }
            case 10: 
            case 11: 
            case 12: 
            case 16: {
                return 4;
            }
        }
        throw new InternalError(new StringBuffer().append("typecode ").append(type.tag).toString());
    }

    public static int truncate(int tc) {
        switch (tc) {
            case 5: 
            case 6: 
            case 7: {
                return 0;
            }
        }
        return tc;
    }

    public static int shortcode(Type type) {
        return Code.truncate(Code.typecode(type));
    }

    public static int width(int typecode) {
        switch (typecode) {
            case 1: 
            case 3: {
                return 2;
            }
            case 8: {
                return 0;
            }
        }
        return 1;
    }

    public static int width(Type type) {
        return Code.width(Code.typecode(type));
    }

    public static int width(List<Type> types) {
        int w = 0;
        List<Type> l = types;
        while (l.nonEmpty()) {
            w += Code.width(l.getFirst());
            l = l.getRest();
        }
        return w;
    }

    public static int arrayCode(Type type) {
        switch (type.tag) {
            case 1: {
                return 8;
            }
            case 8: {
                return 4;
            }
            case 3: {
                return 9;
            }
            case 2: {
                return 5;
            }
            case 4: {
                return 10;
            }
            case 5: {
                return 11;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 10: {
                return 0;
            }
            case 11: {
                return 1;
            }
        }
        throw new InternalError(new StringBuffer().append("arraycode ").append(type).toString());
    }

    public int currentPc() {
        this.fixedPc = true;
        return this.byteCodeIndex;
    }

    public void emitOneByte(int od) {
        if (this.byteCodeIndex == this.byteCodeArray.length) {
            byte[] newcode = new byte[this.byteCodeIndex * 2];
            System.arraycopy(this.byteCodeArray, 0, newcode, 0, this.byteCodeIndex);
            this.byteCodeArray = newcode;
        }
        this.byteCodeArray[this.byteCodeIndex++] = (byte)od;
    }

    public void emitTwoBytes(int od) {
        if (this.codeGenerationEnabled) {
            if (this.byteCodeIndex + 2 > this.byteCodeArray.length) {
                this.emitOneByte(od >> 8);
                this.emitOneByte(od);
            } else {
                this.byteCodeArray[this.byteCodeIndex++] = (byte)(od >> 8);
                this.byteCodeArray[this.byteCodeIndex++] = (byte)od;
            }
        }
    }

    public void emitFourBytes(int od) {
        if (this.codeGenerationEnabled) {
            if (this.byteCodeIndex + 4 > this.byteCodeArray.length) {
                this.emitOneByte(od >> 24);
                this.emitOneByte(od >> 16);
                this.emitOneByte(od >> 8);
                this.emitOneByte(od);
            } else {
                this.byteCodeArray[this.byteCodeIndex++] = (byte)(od >> 24);
                this.byteCodeArray[this.byteCodeIndex++] = (byte)(od >> 16);
                this.byteCodeArray[this.byteCodeIndex++] = (byte)(od >> 8);
                this.byteCodeArray[this.byteCodeIndex++] = (byte)od;
            }
        }
    }

    public void emitOp(int op, int sdiff) {
        if (this.codeGenerationEnabled) {
            this.emitOneByte(op);
            if (sdiff <= -1000) {
                this.stackSize = this.stackSize + sdiff + 1000;
                this.codeGenerationEnabled = false;
                Asserter._assert(this.stackSize == 0);
            } else {
                this.stackSize += sdiff;
                Asserter._assert(this.stackSize >= 0);
                if (this.stackSize > this.maxStackSize) {
                    this.maxStackSize = this.stackSize;
                }
            }
        }
    }

    public void emitOp(int op) {
        this.emitOp(op, STACK_DIFF[op]);
    }

    public void emitOpByte(int op, int od) {
        this.emitOp(op);
        this.emitOneByte(od);
    }

    public void emitOpOneByteAndWiden(int op, int od) {
        if (od > 255) {
            this.emitOneByte(196);
            this.emitOpTwoBytes(op, od);
        } else {
            this.emitOpByte(op, od);
        }
    }

    public void emitOpTwoBytes(int op, int od) {
        this.emitOp(op);
        this.emitTwoBytes(od);
    }

    public void emitOpFourBytes(int op, int od) {
        this.emitOp(op);
        this.emitFourBytes(od);
    }

    public void align(int factor) {
        if (this.codeGenerationEnabled) {
            while (this.byteCodeIndex % factor != 0) {
                this.emitOneByte(0);
            }
        }
    }

    public void putByte(int pc, int op) {
        this.byteCodeArray[pc] = (byte)op;
    }

    public void putTwoBytes(int pc, int od) {
        this.putByte(pc, od >> 8);
        this.putByte(pc + 1, od);
    }

    public void putFourBytes(int pc, int od) {
        this.putByte(pc, od >> 24);
        this.putByte(pc + 1, od >> 16);
        this.putByte(pc + 2, od >> 8);
        this.putByte(pc + 3, od);
    }

    public int getByte(int pc) {
        return this.byteCodeArray[pc] & 0xFF;
    }

    public int getFourBytes(int pc) {
        return this.getByte(pc) << 24 | this.getByte(pc + 1) << 16 | this.getByte(pc + 2) << 8 | this.getByte(pc + 3);
    }

    public void clearStack() {
        this.stackSize = 0;
    }

    public void pushStack(int tos) {
        this.stackSize += Code.width(tos);
        if (this.stackSize > this.maxStackSize) {
            this.maxStackSize = this.stackSize;
        }
    }

    public void popStack(int tos) {
        this.stackSize -= Code.width(tos);
    }

    public static int negate(int opcode) {
        return (opcode + 1 ^ 1) - 1;
    }

    public void emitJump(Chain chain, int opcode) {
        if (this.longJumpsAllowed) {
            if (opcode == 167 || opcode == 168) {
                this.emitOpFourBytes(opcode + 200 - 167, 0);
            } else {
                this.emitOpTwoBytes(Code.negate(opcode), 8);
                this.emitOpFourBytes(200, 0);
                chain.pc += 3;
            }
        } else {
            this.emitOpTwoBytes(opcode, 0);
        }
    }

    public Chain branch(int opcode) {
        if (opcode == 168 || !this.codeGenerationEnabled) {
            return null;
        }
        int sdiff = STACK_DIFF[opcode];
        Chain chain = new Chain(this.byteCodeIndex, null, this.stackSize + sdiff);
        this.emitJump(chain, opcode);
        this.fixedPc = this.longJumpsAllowed;
        if (opcode == 167) {
            this.codeGenerationEnabled = false;
        }
        return chain;
    }

    public void resolve(Chain chain, int target) {
        if (chain != null) {
            Asserter._assert(target > chain.pc || this.stackSize == 0);
            if (target > this.byteCodeIndex) {
                target = this.byteCodeIndex;
            }
            if (this.getByte(chain.pc) == 167 && chain.pc + 3 == target && target == this.byteCodeIndex && !this.fixedPc) {
                this.byteCodeIndex -= 3;
                target -= 3;
            } else {
                if (this.longJumpsAllowed) {
                    this.putFourBytes(chain.pc + 1, target - chain.pc);
                } else if (target - chain.pc < Short.MIN_VALUE || target - chain.pc > Short.MAX_VALUE) {
                    this.longJumpsAllowed = true;
                } else {
                    this.putTwoBytes(chain.pc + 1, target - chain.pc);
                }
                Asserter._assert(!this.codeGenerationEnabled || chain.stackSize == this.stackSize);
            }
            this.fixedPc = true;
            this.resolve(chain.next, target);
            if (this.byteCodeIndex == target) {
                this.stackSize = chain.stackSize;
                this.codeGenerationEnabled = true;
            }
        }
    }

    public void resolve(Chain chain) {
        this.resolve(chain, this.byteCodeIndex);
    }

    public static Chain mergeChains(Chain chain1, Chain chain2) {
        if (chain2 == null) {
            return chain1;
        }
        if (chain1 == null) {
            return chain2;
        }
        Asserter._assert(chain1.stackSize == chain2.stackSize);
        return new Chain(chain2.pc, Code.mergeChains(chain1, chain2.next), chain2.stackSize);
    }

    public void addCatch(char startPc, char endPc, char handlerPc, char catchType) {
        this.catchInfo.insertEnd(new char[]{startPc, endPc, handlerPc, catchType});
    }

    public void addLineNumber(char startPc, char lineNumber) {
        if (this.lineInfo.nonEmpty() && this.lineInfo.getFirst()[0] == startPc) {
            this.lineInfo = this.lineInfo.getRest();
        }
        this.lineInfo = this.lineInfo.cons(new char[]{startPc, lineNumber});
    }

    public void markStatementBeginning(int pos) {
        if (pos != 0 && this.codeGenerationEnabled) {
            Asserter._assert(this.stackSize == 0);
            int line = Position.line(pos);
            char cp1 = (char)this.byteCodeIndex;
            char line1 = (char)line;
            if (cp1 == this.byteCodeIndex && line1 == line) {
                this.addLineNumber(cp1, line1);
            }
        }
    }

    public void addLocalVar(int reg, Symbol.VarSymbol v) {
        while (v.address >= this.localVar.length) {
            char[] new_lvar_start_pc = new char[this.localVar.length * 2];
            char[] new_lvar_length = new char[this.localVar.length * 2];
            char[] new_lvar_reg = new char[this.localVar.length * 2];
            Symbol.VarSymbol[] new_lvar = new Symbol.VarSymbol[this.localVar.length * 2];
            for (int i = 0; i < this.localVar.length; ++i) {
                new_lvar_start_pc[i] = this.localVarStartPc[i];
                new_lvar_length[i] = this.localVarLength[i];
                new_lvar_reg[i] = this.localVarRegister[i];
                new_lvar[i] = this.localVar[i];
            }
            this.localVarStartPc = new_lvar_start_pc;
            this.localVarLength = new_lvar_length;
            this.localVarRegister = new_lvar_reg;
            this.localVar = new_lvar;
        }
        this.localVarStartPc[v.address] = 65535;
        this.localVarLength[v.address] = 65535;
        this.localVarRegister[v.address] = (char)reg;
        this.localVar[v.address] = v;
        ++this.varCount;
    }

    public void setStartPc(int adr) {
        if (this._debugInfo && this.byteCodeIndex < 65535 && adr < this.localVarStartPc.length && this.localVarStartPc[adr] == '\uffff') {
            this.localVarStartPc[adr] = (char)this.byteCodeIndex;
        }
    }

    public void setEndPc(int adr) {
        if (this._debugInfo && adr < this.localVarStartPc.length && this.localVarStartPc[adr] != '\uffff' && this.byteCodeIndex - this.localVarStartPc[adr] < 65535 && this.localVarLength[adr] == '\uffff') {
            this.localVarLength[adr] = (char)(this.byteCodeIndex - this.localVarStartPc[adr]);
        }
    }

    public int newLocal(int typecode) {
        int adr = this.nextVarAddress++;
        int w = Code.width(typecode);
        int reg = this.nextRegister;
        this.nextRegister = reg + w;
        if (this.nextRegister > this.maxLocals) {
            this.maxLocals = this.nextRegister;
        }
        while (adr >= this.varLocations.length) {
            int[] newadrmap = new int[this.varLocations.length * 2];
            System.arraycopy(this.varLocations, 0, newadrmap, 0, this.varLocations.length);
            this.varLocations = newadrmap;
        }
        this.varLocations[adr] = w == 2 ? -reg : reg;
        return adr;
    }

    public int newLocal(Type type) {
        return this.newLocal(Code.typecode(type));
    }

    public void newLocal(Symbol.VarSymbol v) {
        v.address = this.newLocal(v.erasure());
        if (this._debugInfo) {
            this.addLocalVar(this.regOf(v.address), v);
        }
    }

    public int regOf(int adr) {
        int reg = this.varLocations[adr];
        if (reg < 0) {
            reg = -reg;
        }
        return reg;
    }

    public void newRegSegment() {
        this.nextRegister = this.maxLocals;
    }

    public void endScopes(int first) {
        if (first < this.nextVarAddress) {
            for (int i = first; i < this.nextVarAddress; ++i) {
                this.setEndPc(i);
            }
            this.nextRegister = this.regOf(first);
        }
    }

    static {
        Code.STACK_DIFF[0] = 0;
        Code.STACK_DIFF[1] = 1;
        Code.STACK_DIFF[2] = 1;
        Code.STACK_DIFF[3] = 1;
        Code.STACK_DIFF[4] = 1;
        Code.STACK_DIFF[5] = 1;
        Code.STACK_DIFF[6] = 1;
        Code.STACK_DIFF[7] = 1;
        Code.STACK_DIFF[8] = 1;
        Code.STACK_DIFF[9] = 2;
        Code.STACK_DIFF[10] = 2;
        Code.STACK_DIFF[11] = 1;
        Code.STACK_DIFF[12] = 1;
        Code.STACK_DIFF[13] = 1;
        Code.STACK_DIFF[14] = 2;
        Code.STACK_DIFF[15] = 2;
        Code.STACK_DIFF[16] = 1;
        Code.STACK_DIFF[17] = 1;
        Code.STACK_DIFF[18] = -999;
        Code.STACK_DIFF[19] = -999;
        Code.STACK_DIFF[20] = -999;
        Code.STACK_DIFF[21] = 1;
        Code.STACK_DIFF[22] = 2;
        Code.STACK_DIFF[23] = 1;
        Code.STACK_DIFF[24] = 2;
        Code.STACK_DIFF[25] = 1;
        Code.STACK_DIFF[26] = 1;
        Code.STACK_DIFF[30] = 2;
        Code.STACK_DIFF[34] = 1;
        Code.STACK_DIFF[38] = 2;
        Code.STACK_DIFF[42] = 1;
        Code.STACK_DIFF[27] = 1;
        Code.STACK_DIFF[31] = 2;
        Code.STACK_DIFF[35] = 1;
        Code.STACK_DIFF[39] = 2;
        Code.STACK_DIFF[43] = 1;
        Code.STACK_DIFF[28] = 1;
        Code.STACK_DIFF[32] = 2;
        Code.STACK_DIFF[36] = 1;
        Code.STACK_DIFF[40] = 2;
        Code.STACK_DIFF[44] = 1;
        Code.STACK_DIFF[29] = 1;
        Code.STACK_DIFF[33] = 2;
        Code.STACK_DIFF[37] = 1;
        Code.STACK_DIFF[41] = 2;
        Code.STACK_DIFF[45] = 1;
        Code.STACK_DIFF[46] = -1;
        Code.STACK_DIFF[47] = 0;
        Code.STACK_DIFF[48] = -1;
        Code.STACK_DIFF[49] = 0;
        Code.STACK_DIFF[50] = -1;
        Code.STACK_DIFF[51] = -1;
        Code.STACK_DIFF[52] = -1;
        Code.STACK_DIFF[53] = -1;
        Code.STACK_DIFF[54] = -1;
        Code.STACK_DIFF[55] = -2;
        Code.STACK_DIFF[56] = -1;
        Code.STACK_DIFF[57] = -2;
        Code.STACK_DIFF[58] = -1;
        Code.STACK_DIFF[59] = -1;
        Code.STACK_DIFF[63] = -2;
        Code.STACK_DIFF[67] = -1;
        Code.STACK_DIFF[71] = -2;
        Code.STACK_DIFF[75] = -1;
        Code.STACK_DIFF[60] = -1;
        Code.STACK_DIFF[64] = -2;
        Code.STACK_DIFF[68] = -1;
        Code.STACK_DIFF[72] = -2;
        Code.STACK_DIFF[76] = -1;
        Code.STACK_DIFF[61] = -1;
        Code.STACK_DIFF[65] = -2;
        Code.STACK_DIFF[69] = -1;
        Code.STACK_DIFF[73] = -2;
        Code.STACK_DIFF[77] = -1;
        Code.STACK_DIFF[62] = -1;
        Code.STACK_DIFF[66] = -2;
        Code.STACK_DIFF[70] = -1;
        Code.STACK_DIFF[74] = -2;
        Code.STACK_DIFF[78] = -1;
        Code.STACK_DIFF[79] = -3;
        Code.STACK_DIFF[80] = -4;
        Code.STACK_DIFF[81] = -3;
        Code.STACK_DIFF[82] = -4;
        Code.STACK_DIFF[83] = -3;
        Code.STACK_DIFF[84] = -3;
        Code.STACK_DIFF[85] = -3;
        Code.STACK_DIFF[86] = -3;
        Code.STACK_DIFF[87] = -1;
        Code.STACK_DIFF[88] = -2;
        Code.STACK_DIFF[89] = 1;
        Code.STACK_DIFF[90] = 1;
        Code.STACK_DIFF[91] = 1;
        Code.STACK_DIFF[92] = 2;
        Code.STACK_DIFF[93] = 2;
        Code.STACK_DIFF[94] = 2;
        Code.STACK_DIFF[95] = 0;
        Code.STACK_DIFF[96] = -1;
        Code.STACK_DIFF[97] = -2;
        Code.STACK_DIFF[98] = -1;
        Code.STACK_DIFF[99] = -2;
        Code.STACK_DIFF[100] = -1;
        Code.STACK_DIFF[101] = -2;
        Code.STACK_DIFF[102] = -1;
        Code.STACK_DIFF[103] = -2;
        Code.STACK_DIFF[104] = -1;
        Code.STACK_DIFF[105] = -2;
        Code.STACK_DIFF[106] = -1;
        Code.STACK_DIFF[107] = -2;
        Code.STACK_DIFF[108] = -1;
        Code.STACK_DIFF[109] = -2;
        Code.STACK_DIFF[110] = -1;
        Code.STACK_DIFF[111] = -2;
        Code.STACK_DIFF[112] = -1;
        Code.STACK_DIFF[113] = -2;
        Code.STACK_DIFF[114] = -1;
        Code.STACK_DIFF[115] = -2;
        Code.STACK_DIFF[116] = 0;
        Code.STACK_DIFF[117] = 0;
        Code.STACK_DIFF[118] = 0;
        Code.STACK_DIFF[119] = 0;
        Code.STACK_DIFF[120] = -1;
        Code.STACK_DIFF[121] = -1;
        Code.STACK_DIFF[122] = -1;
        Code.STACK_DIFF[123] = -1;
        Code.STACK_DIFF[124] = -1;
        Code.STACK_DIFF[125] = -1;
        Code.STACK_DIFF[126] = -1;
        Code.STACK_DIFF[127] = -2;
        Code.STACK_DIFF[128] = -1;
        Code.STACK_DIFF[129] = -2;
        Code.STACK_DIFF[130] = -1;
        Code.STACK_DIFF[131] = -2;
        Code.STACK_DIFF[132] = 0;
        Code.STACK_DIFF[133] = 1;
        Code.STACK_DIFF[134] = 0;
        Code.STACK_DIFF[135] = 1;
        Code.STACK_DIFF[136] = -1;
        Code.STACK_DIFF[137] = -1;
        Code.STACK_DIFF[138] = 0;
        Code.STACK_DIFF[139] = 0;
        Code.STACK_DIFF[140] = 1;
        Code.STACK_DIFF[141] = 1;
        Code.STACK_DIFF[142] = -1;
        Code.STACK_DIFF[143] = 0;
        Code.STACK_DIFF[144] = -1;
        Code.STACK_DIFF[145] = 0;
        Code.STACK_DIFF[146] = 0;
        Code.STACK_DIFF[147] = 0;
        Code.STACK_DIFF[148] = -3;
        Code.STACK_DIFF[149] = -1;
        Code.STACK_DIFF[150] = -1;
        Code.STACK_DIFF[151] = -3;
        Code.STACK_DIFF[152] = -3;
        Code.STACK_DIFF[153] = -1;
        Code.STACK_DIFF[154] = -1;
        Code.STACK_DIFF[155] = -1;
        Code.STACK_DIFF[156] = -1;
        Code.STACK_DIFF[157] = -1;
        Code.STACK_DIFF[158] = -1;
        Code.STACK_DIFF[159] = -2;
        Code.STACK_DIFF[160] = -2;
        Code.STACK_DIFF[161] = -2;
        Code.STACK_DIFF[162] = -2;
        Code.STACK_DIFF[163] = -2;
        Code.STACK_DIFF[164] = -2;
        Code.STACK_DIFF[165] = -2;
        Code.STACK_DIFF[166] = -2;
        Code.STACK_DIFF[167] = 0;
        Code.STACK_DIFF[168] = 0;
        Code.STACK_DIFF[169] = 0;
        Code.STACK_DIFF[170] = -1;
        Code.STACK_DIFF[171] = -1;
        Code.STACK_DIFF[172] = -1001;
        Code.STACK_DIFF[173] = -1002;
        Code.STACK_DIFF[174] = -1001;
        Code.STACK_DIFF[175] = -1002;
        Code.STACK_DIFF[176] = -1001;
        Code.STACK_DIFF[177] = -1000;
        Code.STACK_DIFF[178] = -999;
        Code.STACK_DIFF[179] = -999;
        Code.STACK_DIFF[180] = -999;
        Code.STACK_DIFF[181] = -999;
        Code.STACK_DIFF[182] = -999;
        Code.STACK_DIFF[183] = -999;
        Code.STACK_DIFF[184] = -999;
        Code.STACK_DIFF[185] = -999;
        Code.STACK_DIFF[186] = 0;
        Code.STACK_DIFF[187] = 1;
        Code.STACK_DIFF[188] = 0;
        Code.STACK_DIFF[189] = 0;
        Code.STACK_DIFF[190] = 0;
        Code.STACK_DIFF[191] = -1001;
        Code.STACK_DIFF[192] = 0;
        Code.STACK_DIFF[193] = 0;
        Code.STACK_DIFF[194] = -1;
        Code.STACK_DIFF[195] = -1;
        Code.STACK_DIFF[196] = 0;
        Code.STACK_DIFF[197] = -999;
        Code.STACK_DIFF[198] = -1;
        Code.STACK_DIFF[199] = -1;
        Code.STACK_DIFF[200] = 0;
        Code.STACK_DIFF[201] = 0;
        Code.STACK_DIFF[202] = 0;
        mnemonic = new String[203];
        Code.mnemonic[0] = "nop";
        Code.mnemonic[1] = "aconst_null";
        Code.mnemonic[2] = "iconst_m1";
        Code.mnemonic[3] = "iconst_0";
        Code.mnemonic[4] = "iconst_1";
        Code.mnemonic[5] = "iconst_2";
        Code.mnemonic[6] = "iconst_3";
        Code.mnemonic[7] = "iconst_4";
        Code.mnemonic[8] = "iconst_5";
        Code.mnemonic[9] = "lconst_0";
        Code.mnemonic[10] = "lconst_1";
        Code.mnemonic[11] = "fconst_0";
        Code.mnemonic[12] = "fconst_1";
        Code.mnemonic[13] = "fconst_2";
        Code.mnemonic[14] = "dconst_0";
        Code.mnemonic[15] = "dconst_1";
        Code.mnemonic[16] = "bipush";
        Code.mnemonic[17] = "sipush";
        Code.mnemonic[18] = "ldc1";
        Code.mnemonic[19] = "ldc2";
        Code.mnemonic[20] = "ldc2w";
        Code.mnemonic[21] = "iload";
        Code.mnemonic[22] = "lload";
        Code.mnemonic[23] = "fload";
        Code.mnemonic[24] = "dload";
        Code.mnemonic[25] = "aload";
        Code.mnemonic[26] = "iload_0";
        Code.mnemonic[30] = "lload_0";
        Code.mnemonic[34] = "fload_0";
        Code.mnemonic[38] = "dload_0";
        Code.mnemonic[42] = "aload_0";
        Code.mnemonic[27] = "iload_1";
        Code.mnemonic[31] = "lload_1";
        Code.mnemonic[35] = "fload_1";
        Code.mnemonic[39] = "dload_1";
        Code.mnemonic[43] = "aload_1";
        Code.mnemonic[28] = "iload_2";
        Code.mnemonic[32] = "lload_2";
        Code.mnemonic[36] = "fload_2";
        Code.mnemonic[40] = "dload_2";
        Code.mnemonic[44] = "aload_2";
        Code.mnemonic[29] = "iload_3";
        Code.mnemonic[33] = "lload_3";
        Code.mnemonic[37] = "fload_3";
        Code.mnemonic[41] = "dload_3";
        Code.mnemonic[45] = "aload_3";
        Code.mnemonic[46] = "iaload";
        Code.mnemonic[47] = "laload";
        Code.mnemonic[48] = "faload";
        Code.mnemonic[49] = "daload";
        Code.mnemonic[50] = "aaload";
        Code.mnemonic[51] = "baload";
        Code.mnemonic[52] = "caload";
        Code.mnemonic[53] = "saload";
        Code.mnemonic[54] = "istore";
        Code.mnemonic[55] = "lstore";
        Code.mnemonic[56] = "fstore";
        Code.mnemonic[57] = "dstore";
        Code.mnemonic[58] = "astore";
        Code.mnemonic[59] = "istore_0";
        Code.mnemonic[63] = "lstore_0";
        Code.mnemonic[67] = "fstore_0";
        Code.mnemonic[71] = "dstore_0";
        Code.mnemonic[75] = "astore_0";
        Code.mnemonic[60] = "istore_1";
        Code.mnemonic[64] = "lstore_1";
        Code.mnemonic[68] = "fstore_1";
        Code.mnemonic[72] = "dstore_1";
        Code.mnemonic[76] = "astore_1";
        Code.mnemonic[61] = "istore_2";
        Code.mnemonic[65] = "lstore_2";
        Code.mnemonic[69] = "fstore_2";
        Code.mnemonic[73] = "dstore_2";
        Code.mnemonic[77] = "astore_2";
        Code.mnemonic[62] = "istore_3";
        Code.mnemonic[66] = "lstore_3";
        Code.mnemonic[70] = "fstore_3";
        Code.mnemonic[74] = "dstore_3";
        Code.mnemonic[78] = "astore_3";
        Code.mnemonic[79] = "iastore";
        Code.mnemonic[80] = "lastore";
        Code.mnemonic[81] = "fastore";
        Code.mnemonic[82] = "dastore";
        Code.mnemonic[83] = "aastore";
        Code.mnemonic[84] = "bastore";
        Code.mnemonic[85] = "castore";
        Code.mnemonic[86] = "sastore";
        Code.mnemonic[87] = "pop";
        Code.mnemonic[88] = "pop2";
        Code.mnemonic[89] = "dup";
        Code.mnemonic[90] = "dup_x1";
        Code.mnemonic[91] = "dup_x2";
        Code.mnemonic[92] = "dup2";
        Code.mnemonic[93] = "dup2_x1";
        Code.mnemonic[94] = "dup2_x2";
        Code.mnemonic[95] = "swap";
        Code.mnemonic[96] = "iadd";
        Code.mnemonic[97] = "ladd";
        Code.mnemonic[98] = "fadd";
        Code.mnemonic[99] = "dadd";
        Code.mnemonic[100] = "isub";
        Code.mnemonic[101] = "lsub";
        Code.mnemonic[102] = "fsub";
        Code.mnemonic[103] = "dsub";
        Code.mnemonic[104] = "imul";
        Code.mnemonic[105] = "lmul";
        Code.mnemonic[106] = "fmul";
        Code.mnemonic[107] = "dmul";
        Code.mnemonic[108] = "idiv";
        Code.mnemonic[109] = "ldiv";
        Code.mnemonic[110] = "fdiv";
        Code.mnemonic[111] = "ddiv";
        Code.mnemonic[112] = "imod";
        Code.mnemonic[113] = "lmod";
        Code.mnemonic[114] = "fmod";
        Code.mnemonic[115] = "dmod";
        Code.mnemonic[116] = "ineg";
        Code.mnemonic[117] = "lneg";
        Code.mnemonic[118] = "fneg";
        Code.mnemonic[119] = "dneg";
        Code.mnemonic[120] = "ishl";
        Code.mnemonic[121] = "lshl";
        Code.mnemonic[122] = "ishr";
        Code.mnemonic[123] = "lshr";
        Code.mnemonic[124] = "iushr";
        Code.mnemonic[125] = "lushr";
        Code.mnemonic[126] = "iand";
        Code.mnemonic[127] = "land";
        Code.mnemonic[128] = "ior";
        Code.mnemonic[129] = "lor";
        Code.mnemonic[130] = "ixor";
        Code.mnemonic[131] = "lxor";
        Code.mnemonic[132] = "iinc";
        Code.mnemonic[133] = "i2l";
        Code.mnemonic[134] = "i2f";
        Code.mnemonic[135] = "i2d";
        Code.mnemonic[136] = "l2i";
        Code.mnemonic[137] = "l2f";
        Code.mnemonic[138] = "l2d";
        Code.mnemonic[139] = "f2i";
        Code.mnemonic[140] = "f2l";
        Code.mnemonic[141] = "f2d";
        Code.mnemonic[142] = "d2i";
        Code.mnemonic[143] = "d2l";
        Code.mnemonic[144] = "d2f";
        Code.mnemonic[145] = "int2byte";
        Code.mnemonic[146] = "int2char";
        Code.mnemonic[147] = "int2short";
        Code.mnemonic[148] = "lcmp";
        Code.mnemonic[149] = "fcmpl";
        Code.mnemonic[150] = "fcmpg";
        Code.mnemonic[151] = "dcmpl";
        Code.mnemonic[152] = "dcmpg";
        Code.mnemonic[153] = "ifeq";
        Code.mnemonic[154] = "ifne";
        Code.mnemonic[155] = "iflt";
        Code.mnemonic[156] = "ifge";
        Code.mnemonic[157] = "ifgt";
        Code.mnemonic[158] = "ifle";
        Code.mnemonic[159] = "if_icmpeq";
        Code.mnemonic[160] = "if_icmpne";
        Code.mnemonic[161] = "if_icmplt";
        Code.mnemonic[162] = "if_icmpge";
        Code.mnemonic[163] = "if_icmpgt";
        Code.mnemonic[164] = "if_icmple";
        Code.mnemonic[165] = "if_acmpeq";
        Code.mnemonic[166] = "if_acmpne";
        Code.mnemonic[167] = "goto_";
        Code.mnemonic[168] = "jsr";
        Code.mnemonic[169] = "ret";
        Code.mnemonic[170] = "tableswitch";
        Code.mnemonic[171] = "lookupswitch";
        Code.mnemonic[172] = "ireturn";
        Code.mnemonic[173] = "lreturn";
        Code.mnemonic[174] = "freturn";
        Code.mnemonic[175] = "dreturn";
        Code.mnemonic[176] = "areturn";
        Code.mnemonic[177] = "return_";
        Code.mnemonic[178] = "getstatic";
        Code.mnemonic[179] = "putstatic";
        Code.mnemonic[180] = "getfield";
        Code.mnemonic[181] = "putfield";
        Code.mnemonic[182] = "invokevirtual";
        Code.mnemonic[183] = "invokespecial";
        Code.mnemonic[184] = "invokestatic";
        Code.mnemonic[185] = "invokeinterface";
        Code.mnemonic[186] = "newfromname";
        Code.mnemonic[187] = "new_";
        Code.mnemonic[188] = "newarray";
        Code.mnemonic[189] = "anewarray";
        Code.mnemonic[190] = "arraylength";
        Code.mnemonic[191] = "athrow";
        Code.mnemonic[192] = "checkcast";
        Code.mnemonic[193] = "instanceof_";
        Code.mnemonic[194] = "monitorenter";
        Code.mnemonic[195] = "monitorexit";
        Code.mnemonic[196] = "wide";
        Code.mnemonic[197] = "multianewarray";
        Code.mnemonic[198] = "if_acmp_null";
        Code.mnemonic[199] = "if_acmp_nonnull";
        Code.mnemonic[200] = "goto_w";
        Code.mnemonic[201] = "jsr_w";
        Code.mnemonic[202] = "breakpoint";
    }

    public static class Chain
    extends PrintableObject {
        public Chain next;
        public int pc;
        public int stackSize;

        public Chain(int pc, Chain next, int stacksize) {
            this.pc = pc;
            this.next = next;
            this.stackSize = stacksize;
        }

        public void print() {
            Chain.leftParen();
            Chain.print("Chain");
            Chain.include("pc:", this.pc, false);
            Chain.include("stackSize:", this.stackSize, false);
            Chain.breakHint();
            Chain.include(this.next);
        }
    }
}

