/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CodeTest
extends TestCase {
    private Code code;
    private Code.Chain chain;

    public CodeTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.code = new Code(true, false);
        this.chain = new Code.Chain(0, null, 0);
    }

    protected void tearDown() {
        this.code = null;
        this.chain = null;
    }

    public void testResolve_1() {
        this.code.resolve(this.chain, -1);
        this.code.resolve(this.chain, 0);
        this.code.resolve(this.chain, Integer.MAX_VALUE);
        this.code.resolve(this.chain, Integer.MIN_VALUE);
    }

    public void testResolve() {
        this.code.resolve(this.chain);
    }

    public void testWidthOfCode() {
        CodeTest.assertEquals((String)"Code.width(-1) returned the wrong value.", (int)1, (int)Code.width(-1));
        CodeTest.assertEquals((String)"Code.width on ints returned the wrong value.", (int)1, (int)Code.width(0));
        CodeTest.assertEquals((String)"Code.width on longs returned the wrong value.", (int)2, (int)Code.width(1));
        CodeTest.assertEquals((String)"Code.width on floats returned the wrong value.", (int)1, (int)Code.width(2));
        CodeTest.assertEquals((String)"Code.width on doubles returned the wrong value.", (int)2, (int)Code.width(3));
        CodeTest.assertEquals((String)"Code.width on objects returned the wrong value.", (int)1, (int)Code.width(4));
        CodeTest.assertEquals((String)"Code.width on bytes returned the wrong value.", (int)1, (int)Code.width(5));
        CodeTest.assertEquals((String)"Code.width on chars returned the wrong value.", (int)1, (int)Code.width(6));
        CodeTest.assertEquals((String)"Code.width on shorts returned the wrong value.", (int)1, (int)Code.width(7));
        CodeTest.assertEquals((String)"Code.width on void returned the wrong value.", (int)0, (int)Code.width(8));
        CodeTest.assertEquals((String)"Code.width on max int value returned the wrong value.", (int)1, (int)Code.width(Integer.MAX_VALUE));
        CodeTest.assertEquals((String)"Code.width on min int value returned the wrong value.", (int)1, (int)Code.width(Integer.MIN_VALUE));
    }

    public void testWidthOfType() {
        Symbol.TypeSymbol symbol = new Symbol.TypeSymbol(0, Name.fromString("testSymbol"), null, null);
        Type type = new Type(10, symbol);
        Type.ClassType classType = new Type.ClassType(null, new Empty<Type>(), symbol);
        Type.MethodType methodType = new Type.MethodType(new Empty<Type>(), classType, new Empty<Symbol.ClassSymbol>());
        Type.TypeVar typeVar = new Type.TypeVar(classType, symbol);
        Type.PackageType packageType = new Type.PackageType(symbol);
        Type.ForAll forAll = new Type.ForAll(new Empty<Type>(), methodType);
        Type.ErrorType errorType = new Type.ErrorType(symbol);
        CodeTest.assertEquals((String)"Code.width on ClassType returned the wrong value.", (int)1, (int)Code.width(classType));
        CodeTest.assertEquals((String)"Code.width on ArrayType returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on MethodType returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on TypeVar returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on PackageType returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on ForAllType returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on ErrorType returned the wrong value.", (int)1, (int)Code.width(type));
        CodeTest.assertEquals((String)"Code.width on Type returned the wrong value.", (int)1, (int)Code.width(type));
    }

    public void testWidth() {
    }

    public void testAlign() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testNegate() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitop() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testBranch() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testMergeChains() {
    }

    public void testRegOf() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitop1w() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testTypecode() {
    }

    public void testTruncate() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmit2() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmit1() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitOp() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitop1() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitop2() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testShortcode() {
    }

    public void testArraycode() {
    }

    public void testCurPc() {
    }

    public void testEmit4() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitop4() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testPut1() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testPut2() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testPut4() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testGet1() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testGet4() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testClearStack() {
    }

    public void testPushStack() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testPopStack() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testEmitJump() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testAddCatch() {
        char[] cValues = new char[]{' ', ' ', '\uffff', '\u0000'};
    }

    public void testAddLineNumber() {
        char[] cValues = new char[]{' ', ' ', '\uffff', '\u0000'};
    }

    public void testMarkStatementBeginning() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testAddLocalVar() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testSetStartPc() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testSetEndPc() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testNewLocal_2() {
    }

    public void testNewLocal_1() {
    }

    public void testNewLocal() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public void testNewRegSegment() {
    }

    public void testEndScopes() {
        int[] intValues = new int[]{-1, 0, 1, Integer.MAX_VALUE, Integer.MIN_VALUE};
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(1.class$edu$rice$cs$nextgen$compiler$code$CodeTest == null ? (1.class$edu$rice$cs$nextgen$compiler$code$CodeTest = 1.class$("edu.rice.cs.nextgen.compiler.code.CodeTest")) : 1.class$edu$rice$cs$nextgen$compiler$code$CodeTest));
    }

    static class 1 {
        static /* synthetic */ Class class$edu$rice$cs$nextgen$compiler$code$CodeTest;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

