/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.util.Hashtable;

public class ConstantPool {
    int nextConstantPosition;
    Object[] constantPool;
    Hashtable<Object, Integer> constantPositions;

    public ConstantPool(int pp, Object[] pool) {
        this.nextConstantPosition = pp;
        this.constantPool = pool;
        this.constantPositions = new Hashtable(pool.length);
        for (int i = 1; i < pp; ++i) {
            if (pool[i] == null) continue;
            this.constantPositions.put(pool[i], new Integer(i));
        }
    }

    public ConstantPool() {
        this(1, new Object[64]);
    }

    public void reset() {
        this.nextConstantPosition = 1;
        this.constantPositions.clear();
    }

    private void doublePool() {
        Object[] newpool = new Object[this.constantPool.length * 2];
        System.arraycopy(this.constantPool, 0, newpool, 0, this.constantPool.length);
        this.constantPool = newpool;
    }

    public int put(Object value) {
        Integer index = this.constantPositions.get(value);
        if (index == null) {
            index = new Integer(this.nextConstantPosition);
            this.constantPositions.put(value, index);
            if (this.nextConstantPosition == this.constantPool.length) {
                this.doublePool();
            }
            this.constantPool[this.nextConstantPosition++] = value;
            if (value instanceof Long || value instanceof Double) {
                if (this.nextConstantPosition == this.constantPool.length) {
                    this.doublePool();
                }
                this.constantPool[this.nextConstantPosition++] = null;
            }
        }
        return index;
    }

    public int get(Object o) {
        Integer n = this.constantPositions.get(o);
        return n == null ? -1 : n;
    }
}

