/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.code;

import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.Filter;
import edu.rice.cs.nextgen.compiler.util.Name;

public class Scope
extends PrintableObject {
    public static int count = 0;
    private static final int INITIAL_SIZE = 128;
    public static final Scope EMPTY = new Scope(null, null, new Entry[0]);
    public static final Scope ERROR = new Scope(null);
    public Scope nextScope;
    public Symbol owningSymbol;
    public Entry entries;
    private Entry[] _entryTable;
    private int _hashCodeMask;
    private int elementCount = 0;

    private Scope(Scope next, Symbol owner, Entry[] table) {
        this.nextScope = next;
        this.owningSymbol = owner;
        this._entryTable = table;
        this._hashCodeMask = table.length - 1;
        this.entries = null;
        this.elementCount = 0;
    }

    public Scope(Symbol owner) {
        this(null, owner, new Entry[128]);
        for (int i = 0; i < 128; ++i) {
            this._entryTable[i] = Entry.ERROR;
        }
    }

    public Filter print(Filter f) {
        Scope.leftBracket();
        Scope.openBox(7);
        Scope.print("Scope: ");
        if (this.entries != null) {
            f = this.entries.print(f);
        }
        Scope.closeBox();
        if (this.nextScope != null) {
            Scope.newline();
            f = this.nextScope.print(f);
        }
        Scope.rightBracket();
        return f;
    }

    public void print() {
        this.print(Filter.NO_FILTER);
    }

    public Scope extend() {
        return new Scope(this, this.owningSymbol, this._entryTable);
    }

    public Scope leave() {
        while (this.entries != null) {
            int hash = this.entries.symbol.name.index & this._hashCodeMask;
            Entry e = this._entryTable[hash];
            if (e != this.entries) {
                throw new InternalError(this.entries.symbol.toString());
            }
            this._entryTable[hash] = this.entries.shadowed;
            this.entries = this.entries.sibling;
        }
        return this.nextScope;
    }

    private void doubleSize() {
        int i;
        Entry[] oldtable = this._entryTable;
        Entry[] newtable = new Entry[oldtable.length * 2];
        Scope s = this;
        do {
            s._entryTable = newtable;
            s._hashCodeMask = newtable.length - 1;
        } while ((s = s.nextScope) != null);
        for (i = 0; i < newtable.length; ++i) {
            newtable[i] = Entry.ERROR;
        }
        for (i = 0; i < oldtable.length; ++i) {
            this.copy(oldtable[i]);
        }
    }

    private void copy(Entry e) {
        if (e.symbol != null) {
            this.copy(e.shadowed);
            int hash = e.symbol.name.index & this._hashCodeMask;
            e.shadowed = this._entryTable[hash];
            this._entryTable[hash] = e;
        }
    }

    public void addSymbol(Symbol sym) {
        Entry e;
        if (this.elementCount * 3 >= this._hashCodeMask * 2) {
            this.doubleSize();
        }
        int hash = sym.name.index & this._hashCodeMask;
        this._entryTable[hash] = e = new Entry(sym, this._entryTable[hash], this.entries, this);
        this.entries = e;
        ++this.elementCount;
    }

    public void addSymbolIfAbsent(Symbol sym) {
        Entry e = this.lookup(sym.name);
        while (e.scope == this && e.symbol.kind != sym.kind) {
            e = e.next();
        }
        if (e.scope != this) {
            this.addSymbol(sym);
        }
    }

    public Entry lookup(Name name) {
        Entry e = this._entryTable[name.index & this._hashCodeMask];
        while (e.scope != null && e.symbol.name != name) {
            e = e.shadowed;
        }
        if (e.scope == null && this == ERROR) {
            return Entry.ERROR;
        }
        return e;
    }

    public Entry lookup(String name) {
        return this.lookup(Name.fromString(name));
    }

    public static class Entry
    extends PrintableObject {
        public static int count = 0;
        public static final Entry ERROR = new Entry(null, null, null, null);
        public final Symbol symbol;
        public Entry shadowed;
        public final Entry sibling;
        public final Scope scope;

        public Filter print(Filter f) {
            if (f.ignore(this.symbol)) {
                Entry.print("<filtered entry>: " + this.symbol);
            } else if (this.symbol != null) {
                f = this.symbol.print(f);
            }
            if (this.sibling != null) {
                Entry.newline();
                f = this.sibling.print(f);
            }
            return f;
        }

        public void print() {
            this.print(Filter.NO_FILTER);
        }

        public Entry(Symbol sym, Entry shadowed, Entry sibling, Scope scope) {
            this.symbol = sym;
            this.shadowed = shadowed;
            this.sibling = sibling;
            this.scope = scope;
        }

        public Entry next() {
            Entry next = this.shadowed;
            while (next.scope != null && next.symbol.name != this.symbol.name) {
                next = next.shadowed;
            }
            return next;
        }
    }
}

