/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.instrument.PrintableObject;
import edu.rice.cs.nextgen.compiler.util.IntBox;

public class AnalyzerContext
extends PrintableObject {
    Scope scope = Scope.EMPTY;
    Type expectedType = Type.NoType.ONLY;
    int expectedKind = 0;
    int staticLevel = 0;
    boolean isSelfCall = false;
    boolean isSuperSelector = false;
    private IntBox localClassCount = new IntBox(0);

    public int getLocalClassCount() {
        return this.localClassCount.getValue();
    }

    public void incrementLocalClassCount() {
        this.localClassCount.increment();
    }

    AnalyzerContext copy(Scope scope) {
        AnalyzerContext info = new AnalyzerContext();
        info.scope = scope;
        info.expectedType = this.expectedType;
        info.staticLevel = this.staticLevel;
        info.isSelfCall = this.isSelfCall;
        info.isSuperSelector = this.isSuperSelector;
        info.localClassCount = this.localClassCount;
        return info;
    }

    AnalyzerContext copy() {
        return this.copy(this.scope);
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        AnalyzerContext thatContext = (AnalyzerContext)that;
        return thatContext.scope == this.scope && thatContext.expectedType == this.expectedType && thatContext.staticLevel == this.staticLevel && thatContext.isSelfCall == this.isSelfCall && thatContext.isSuperSelector == this.isSuperSelector && thatContext.localClassCount == this.localClassCount;
    }

    public void print() {
        AnalyzerContext.leftBracket();
        AnalyzerContext.print("AnalyzerContext ");
        AnalyzerContext.include(" expectedType: ", this.expectedType, false);
        AnalyzerContext.space();
        AnalyzerContext.include(" expectedKind: ", this.expectedKind, false);
        AnalyzerContext.newline();
        this.scope.print();
        AnalyzerContext.rightBracket();
    }
}

