/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeChecker;
import edu.rice.cs.nextgen.compiler.comp.VoidContext;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Bits;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Pair;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataFlowChecker
extends Tree.Visitor<VoidContext, Integer>
implements Flags,
Kinds,
TypeTags {
    static final Integer exprStatus = new Integer(0);
    static final Integer varStatus = new Integer(1);
    static final Integer condStatus = new Integer(2);
    ErrorLog errorLog;
    SymbolTable symbolTable;
    TypeChecker typeChecker;
    Bits inits = new Bits();
    Bits uninits = new Bits();
    Bits initsWhenTrue;
    Bits initsWhenFalse;
    Bits uninitsWhenTrue;
    Bits uninitsWhenFalse;
    Symbol.VarSymbol[] vars = new Symbol.VarSymbol[32];
    int[] levels = new int[32];
    List<Symbol.ClassSymbol> thrown;
    List<Symbol.ClassSymbol> reported;
    boolean alive;
    int loopLevel = 0;
    int firstadr = 0;
    int nextadr = 0;
    Hashtable<Tree, Pair<Bits, Bits>> breaks = new Hashtable();
    Hashtable<Tree, Pair<Bits, Bits>> continues = new Hashtable();
    Symbol.ClassSymbol enclClass;

    public DataFlowChecker(ErrorLog log, SymbolTable syms, TypeChecker chk) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.typeChecker = chk;
    }

    boolean trackable(Symbol sym) {
        return sym != null && sym.kind == 4 && (sym.owner.kind == 16 || sym.owner == this.enclClass && (sym.flags() & 0x10) != 0 && ((Symbol.VarSymbol)sym).constantValue == null && sym.name != Names._this && sym.name != Names._super);
    }

    void newVar(Symbol.VarSymbol sym) {
        if (this.nextadr == this.vars.length) {
            Symbol.VarSymbol[] newvars = new Symbol.VarSymbol[this.nextadr * 2];
            System.arraycopy(this.vars, 0, newvars, 0, this.nextadr);
            this.vars = newvars;
            int[] newlevels = new int[this.nextadr * 2];
            System.arraycopy(this.levels, 0, newlevels, 0, this.nextadr);
            this.levels = newlevels;
        }
        sym.address = this.nextadr;
        this.vars[this.nextadr] = sym;
        this.levels[this.nextadr] = this.loopLevel;
        ++this.nextadr;
    }

    void letInit(int pos, Symbol.VarSymbol sym) {
        if (this.inits == null) {
            Bits initsWhenTrue1 = this.initsWhenTrue.copy();
            Bits initsWhenFalse1 = this.initsWhenFalse.copy();
            Bits uninitsWhenTrue1 = this.uninitsWhenTrue.copy();
            Bits uninitsWhenFalse1 = this.uninitsWhenFalse.copy();
            this.merge();
            this.letInit(pos, sym);
            this.initsWhenTrue = initsWhenTrue1.orSet(this.inits);
            this.initsWhenFalse = initsWhenFalse1.orSet(this.inits);
            this.uninitsWhenTrue = uninitsWhenTrue1.orSet(this.uninits);
            this.uninitsWhenFalse = uninitsWhenFalse1.orSet(this.uninits);
            this.inits = null;
            this.uninits = null;
        } else {
            this.inits.include(sym.address);
            if (!((sym.flags() & 0x10) == 0 || this.levels[sym.address] >= this.loopLevel && this.uninits.isMember(sym.address))) {
                this.errorLog.error(pos, new StringBuffer().append(sym).append(" might already have been assigned to").toString());
            }
            this.uninits.exclude(sym.address);
        }
    }

    void letInit(Tree tree) {
        Symbol sym;
        if ((tree.tag == 31 || tree.tag == 30 && TreeInspector.name(((Tree.Select)tree).selected) == Names._this) && this.trackable(sym = TreeInspector.symbol(tree))) {
            this.letInit(tree.sourcePosition, (Symbol.VarSymbol)sym);
        }
    }

    void checkInit(int pos, Symbol.VarSymbol sym) {
        if (!this.inits.isMember(sym.address)) {
            this.errorLog.error(pos, new StringBuffer().append(sym).append(" might not have been initialized").toString());
            this.inits.include(sym.address);
        }
    }

    boolean isFalse(Tree tree) {
        return tree.type.tag == 8 && tree.type.constantValue != null && (Integer)tree.type.constantValue == 0;
    }

    boolean isTrue(Tree tree) {
        return tree.type.tag == 8 && tree.type.constantValue != null && (Integer)tree.type.constantValue != 0;
    }

    void jump(Tree target, Hashtable<Tree, Pair<Bits, Bits>> initTable) {
        Pair<Bits, Bits> initState = initTable.get(target);
        if (initState == null) {
            initTable.put(target, new Pair<Bits, Bits>(this.inits.copy(), this.uninits.copy()));
        } else {
            ((Bits)initState.first).andSet(this.inits);
            ((Bits)initState.second).andSet(this.uninits);
        }
    }

    void resolve(Tree target, Hashtable<Tree, Pair<Bits, Bits>> initTable) {
        Pair<Bits, Bits> initState = initTable.get(target);
        if (initState != null) {
            this.inits.andSet((Bits)initState.first);
            this.uninits.andSet((Bits)initState.second);
            this.alive = true;
        }
    }

    void markThrown(int pos, Symbol.ClassSymbol exc) {
        if (!this.typeChecker.isUnchecked(exc)) {
            this.typeChecker.checkHandled(pos, exc, this.reported);
            this.thrown = TypeChecker.includeIn(exc, this.thrown);
        }
    }

    void markDead() {
        this.inits.includeRange(this.firstadr, this.nextadr);
        this.uninits.includeRange(this.firstadr, this.nextadr);
        this.alive = false;
    }

    void split() {
        this.initsWhenFalse = this.inits.copy();
        this.uninitsWhenFalse = this.uninits.copy();
        this.initsWhenTrue = this.inits;
        this.uninitsWhenTrue = this.uninits;
    }

    void merge() {
        this.inits = this.initsWhenFalse.andSet(this.initsWhenTrue);
        this.uninits = this.uninitsWhenFalse.andSet(this.uninitsWhenTrue);
    }

    public void analyze(Tree tree) {
        if (tree != null) {
            tree.accept(this, null);
        }
    }

    void analyzeVar(Tree tree) {
        tree.accept(this, varStatus);
    }

    void analyzeExpr(Tree tree) {
        if (tree != null) {
            tree.accept(this, exprStatus);
            if (this.inits == null) {
                this.merge();
            }
        }
    }

    void analyzeCond(Tree tree) {
        if (this.isFalse(tree)) {
            this.initsWhenTrue = new Bits(this.firstadr, this.nextadr);
            this.uninitsWhenTrue = new Bits(this.firstadr, this.nextadr);
            this.initsWhenFalse = this.inits;
            this.uninitsWhenFalse = this.uninits;
        } else if (this.isTrue(tree)) {
            this.initsWhenFalse = new Bits(this.firstadr, this.nextadr);
            this.uninitsWhenFalse = new Bits(this.firstadr, this.nextadr);
            this.initsWhenTrue = this.inits;
            this.uninitsWhenTrue = this.uninits;
        } else {
            tree.accept(this, condStatus);
            if (this.inits != null) {
                this.split();
            }
        }
        this.inits = null;
        this.uninits = null;
    }

    void analyzeStat(Tree tree) {
        if (!this.alive && tree != null && (tree.tag != 6 || ((Tree.Block)tree).statements.nonEmpty())) {
            this.errorLog.error(tree.sourcePosition, "unreachable statement");
            this.alive = true;
        }
        tree.accept(this, null);
        this.resolve(tree, this.breaks);
    }

    void analyzeExprs(List<Tree> trees) {
        if (trees != null) {
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                this.analyzeExpr(l.getFirst());
                l = l.getRest();
            }
        }
    }

    void analyzeStats(List<Tree> trees) {
        if (trees != null) {
            List<Tree> l = trees;
            while (l.nonEmpty()) {
                this.analyzeStat(l.getFirst());
                l = l.getRest();
            }
        }
    }

    @Override
    public VoidContext _case(Tree.ClassDef tree, Integer status) {
        if (tree.classSymbol == null) {
            return null;
        }
        List<Symbol.ClassSymbol> thrownPrev = this.thrown;
        List<Symbol.ClassSymbol> reportedPrev = this.reported;
        boolean alivePrev = this.alive;
        int firstadrPrev = this.firstadr;
        Symbol.ClassSymbol enclClassPrev = this.enclClass;
        this.thrown = Symbol.ClassSymbol.EMPTY_LIST;
        this.reported = Symbol.ClassSymbol.EMPTY_LIST;
        List<Tree> l = tree.members;
        while (l.nonEmpty()) {
            if (TreeInspector.isInitialConstructor(l.getFirst())) {
                List<Symbol.ClassSymbol> thrown = ((Tree.MethodDef)l.getFirst()).methodSymbol.type.thrown();
                this.reported = this.reported == null ? thrown : TypeChecker.intersect(thrown, this.reported);
            }
            l = l.getRest();
        }
        this.firstadr = this.nextadr;
        this.enclClass = tree.classSymbol;
        l = tree.members;
        while (l.nonEmpty()) {
            this.alive = true;
            if (l.getFirst().tag != 4 && (TreeInspector.flags(l.getFirst()) & 8) != 0) {
                this.analyze(l.getFirst());
            }
            l = l.getRest();
        }
        l = tree.members;
        while (l.nonEmpty()) {
            this.alive = true;
            if (l.getFirst().tag != 4 && (TreeInspector.flags(l.getFirst()) & 8) == 0) {
                this.analyze(l.getFirst());
            }
            l = l.getRest();
        }
        l = tree.members;
        while (l.nonEmpty()) {
            this.alive = true;
            if (l.getFirst().tag == 4) {
                this.analyze(l.getFirst());
            }
            l = l.getRest();
        }
        this.thrown = thrownPrev;
        this.reported = reportedPrev;
        this.alive = alivePrev;
        this.nextadr = this.firstadr;
        this.firstadr = firstadrPrev;
        this.enclClass = enclClassPrev;
        return null;
    }

    @Override
    public VoidContext _case(Tree.MethodDef tree, Integer status) {
        if (tree.body != null) {
            Bits initsPrev = this.inits.copy();
            Bits uninitsPrev = this.uninits.copy();
            List<Symbol.ClassSymbol> reportedPrev = this.reported;
            int nextadrPrev = this.nextadr;
            List<Symbol.ClassSymbol> thrown = tree.methodSymbol.type.thrown();
            boolean isInitialConstr = TreeInspector.isInitialConstructor(tree);
            this.reported = isInitialConstr ? this.reported.append(thrown) : thrown;
            this.breaks.clear();
            this.continues.clear();
            if (!isInitialConstr) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.inits.include(i);
                    this.uninits.exclude(i);
                }
            }
            List<Tree.VarDef> l = tree.params;
            while (l.nonEmpty()) {
                this.analyze(l.getFirst());
                Asserter._assert(l.getFirst().varSymbol != null, tree.methodSymbol);
                this.letInit(l.getFirst().sourcePosition, l.getFirst().varSymbol);
                l = l.getRest();
            }
            this.analyzeStat(tree.body);
            int pos = tree.body.sourcePosition;
            if (this.alive && tree.methodSymbol.type.returnType().tag != 9) {
                this.errorLog.error(pos, "missing return statement");
            }
            if (isInitialConstr) {
                for (int i = this.firstadr; i < this.nextadr; ++i) {
                    this.checkInit(pos, this.vars[i]);
                }
            }
            this.inits = initsPrev;
            this.uninits = uninitsPrev;
            this.reported = reportedPrev;
            this.nextadr = nextadrPrev;
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.VarDef tree, Integer status) {
        boolean track = this.trackable(tree.varSymbol);
        if (track) {
            this.newVar(tree.varSymbol);
        }
        if (tree.initialization != null) {
            this.analyzeExpr(tree.initialization);
            if (track) {
                this.inits.include(tree.varSymbol.address);
                this.uninits.exclude(tree.varSymbol.address);
            }
        } else if (track) {
            this.inits.exclude(tree.varSymbol.address);
            this.uninits.include(tree.varSymbol.address);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Block tree, Integer status) {
        int nextadrPrev = this.nextadr;
        this.analyzeStats(tree.statements);
        this.nextadr = nextadrPrev;
        return null;
    }

    @Override
    public VoidContext _case(Tree.DoLoop tree, Integer status) {
        ++this.loopLevel;
        this.analyzeStat(tree.body);
        this.resolve(tree, this.continues);
        this.analyzeCond(tree.cond);
        this.alive = this.alive && !this.isTrue(tree.cond);
        this.inits = this.initsWhenFalse;
        this.uninits = this.uninitsWhenFalse;
        --this.loopLevel;
        return null;
    }

    @Override
    public VoidContext _case(Tree.WhileLoop tree, Integer status) {
        ++this.loopLevel;
        this.analyzeCond(tree.condition);
        Bits initsCond = this.initsWhenFalse;
        Bits uninitsCond = this.uninitsWhenFalse;
        this.inits = this.initsWhenTrue;
        this.uninits = this.uninitsWhenTrue;
        boolean aliveWhile = this.alive;
        this.alive = this.alive && !this.isFalse(tree.condition);
        this.analyzeStat(tree.body);
        this.alive = aliveWhile && !this.isTrue(tree.condition);
        this.inits = initsCond;
        this.uninits = uninitsCond;
        --this.loopLevel;
        return null;
    }

    @Override
    public VoidContext _case(Tree.ForLoop tree, Integer status) {
        Bits uninitsCond;
        Bits initsCond;
        int nextadrPrev = this.nextadr;
        this.analyzeStats(tree.initializations);
        ++this.loopLevel;
        if (tree.conditions != null) {
            this.analyzeCond(tree.conditions);
            initsCond = this.initsWhenFalse;
            uninitsCond = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenFalse;
            this.alive &= !this.isFalse(tree.conditions);
        } else {
            initsCond = new Bits(this.firstadr, this.nextadr);
            uninitsCond = new Bits(this.firstadr, this.nextadr);
        }
        this.analyzeStat(tree.body);
        this.resolve(tree, this.continues);
        this.analyzeStats(tree.incrementations);
        this.alive = this.alive && tree.conditions != null && !this.isTrue(tree.conditions);
        this.inits = initsCond;
        this.uninits = uninitsCond;
        --this.loopLevel;
        this.nextadr = nextadrPrev;
        return null;
    }

    @Override
    public VoidContext _case(Tree.Labelled tree, Integer status) {
        this.analyzeStat(tree.body);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Switch tree, Integer status) {
        int nextadrPrev = this.nextadr;
        this.analyzeExpr(tree.selector);
        Bits initsSwitch = this.inits;
        Bits uninitsSwitch = this.uninits;
        boolean aliveSwitch = this.alive;
        boolean hasDefault = false;
        List<Tree.Case> l = tree.cases;
        while (l.nonEmpty()) {
            this.inits = initsSwitch.copy();
            this.alive = aliveSwitch;
            this.analyzeStats(l.getFirst().statements);
            if (l.getFirst().pattern == null) {
                hasDefault = true;
            }
            l = l.getRest();
        }
        if (!hasDefault) {
            this.alive |= aliveSwitch;
            this.inits.andSet(initsSwitch);
        }
        this.nextadr = nextadrPrev;
        return null;
    }

    @Override
    public VoidContext _case(Tree.Synchronized tree, Integer status) {
        this.analyzeExpr(tree.lockedObject);
        this.analyzeStat(tree.body);
        return null;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public VoidContext _case(Tree.Try tree, Integer status) {
        reportedPrev = this.reported;
        thrownPrev = this.thrown;
        this.thrown = Symbol.ClassSymbol.EMPTY_LIST;
        l = tree.catchers;
        while (l.nonEmpty()) {
            exc = (Symbol.ClassSymbol)l.getFirst().param.type.typeSymbol;
            this.reported = TypeChecker.includeIn(exc, this.reported);
            l = l.getRest();
        }
        initsTry = this.inits.copy();
        aliveTry = this.alive;
        this.analyzeStat(tree.body);
        initsEnd = this.inits;
        uninitsEnd = this.uninits;
        uninitsTry = this.uninits.copy();
        aliveEnd = this.alive;
        thrownInTry = this.thrown;
        this.thrown = thrownPrev;
        caught = Symbol.ClassSymbol.EMPTY_LIST;
        nextadrCatch = this.nextadr;
        this.reported = reportedPrev;
        l = tree.catchers;
        while (l.nonEmpty()) {
            param = l.getFirst().param;
            exc = (Symbol.ClassSymbol)param.type.typeSymbol;
            if (TypeChecker.instanceofSome(exc, caught)) ** GOTO lbl-1000
            if (this.typeChecker.isUnchecked(exc) || exc == this.symbolTable.THROWABLE_TYPE.typeSymbol || exc == this.symbolTable.EXCEPTION_TYPE.typeSymbol) ** GOTO lbl-1000
            if (TypeChecker.intersects(exc, thrownInTry)) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.alive = v0;
            caught = TypeChecker.includeIn(exc, caught);
            this.inits = initsTry.copy();
            this.uninits = uninitsTry.copy();
            this.analyze(param);
            this.letInit(param.sourcePosition, param.varSymbol);
            this.analyzeStat(l.getFirst().body);
            initsEnd.andSet(this.inits);
            uninitsEnd.andSet(this.uninits);
            aliveEnd |= this.alive;
            this.nextadr = nextadrCatch;
            l = l.getRest();
        }
        if (tree.finalizer != null) {
            this.inits = initsTry.copy();
            this.uninits = uninitsTry.copy();
            this.alive = aliveTry;
            this.analyzeStat(tree.finalizer);
            this.inits = this.inits.orSet(initsEnd);
            this.uninits = this.uninits.andSet(uninitsEnd);
            this.alive &= aliveEnd;
        } else {
            this.alive = aliveEnd;
        }
        this.thrown = TypeChecker.union(this.thrown, TypeChecker.difference(thrownInTry, caught));
        return null;
    }

    @Override
    public VoidContext _case(Tree.Conditional tree, Integer status) {
        this.analyzeCond(tree.condition);
        if (tree.tag == 17) {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            boolean aliveBeforeElse = this.alive;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.analyzeStat(tree.thenClause);
            if (tree.elseClause != null) {
                Bits initsAfterThen = this.inits.copy();
                Bits uninitsAfterThen = this.uninits.copy();
                boolean aliveAfterThen = this.alive;
                this.inits = initsBeforeElse;
                this.uninits = uninitsBeforeElse;
                this.alive = aliveBeforeElse;
                this.analyzeStat(tree.elseClause);
                this.inits.andSet(initsAfterThen);
                this.uninits.andSet(uninitsAfterThen);
                this.alive |= aliveAfterThen;
            } else {
                this.inits.andSet(initsBeforeElse);
                this.uninits.andSet(uninitsBeforeElse);
                this.alive = true;
            }
        } else if (tree.type.tag != 8) {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            this.inits = this.initsWhenTrue;
            this.uninits = this.uninitsWhenTrue;
            this.analyzeExpr(tree.thenClause);
            Bits initsAfterThen = this.inits.copy();
            Bits uninitsAfterThen = this.uninits.copy();
            this.inits = initsBeforeElse;
            this.uninits = uninitsBeforeElse;
            this.analyzeExpr(tree.elseClause);
            this.inits.andSet(initsAfterThen);
            this.uninits.andSet(uninitsAfterThen);
        } else {
            Bits initsBeforeElse = this.initsWhenFalse;
            Bits uninitsBeforeElse = this.uninitsWhenFalse;
            Bits initsBeforeThen = this.initsWhenTrue;
            Bits uninitsBeforeThen = this.uninitsWhenTrue;
            this.inits = this.initsWhenTrue.copy();
            this.uninits = this.uninitsWhenTrue.copy();
            this.analyzeCond(tree.thenClause);
            Bits initsAfterThenWhenTrue = this.initsWhenTrue;
            Bits uninitsAfterThenWhenTrue = this.uninitsWhenTrue;
            Bits initsAfterThenWhenFalse = this.initsWhenFalse;
            Bits uninitsAfterThenWhenFalse = this.uninitsWhenFalse;
            this.inits = initsBeforeElse.copy();
            this.uninits = uninitsBeforeElse.copy();
            this.analyzeCond(tree.elseClause);
            this.initsWhenTrue = initsBeforeThen.copy().orSet(initsAfterThenWhenTrue).andSet(initsBeforeElse.copy().orSet(this.initsWhenTrue));
            this.uninitsWhenTrue = uninitsBeforeThen.copy().andSet(uninitsAfterThenWhenTrue).andSet(uninitsBeforeElse.copy().andSet(this.uninitsWhenTrue));
            this.initsWhenFalse = initsBeforeThen.copy().orSet(initsAfterThenWhenFalse).andSet(initsBeforeElse.copy().orSet(this.initsWhenFalse));
            this.uninitsWhenFalse = uninitsBeforeThen.copy().andSet(uninitsAfterThenWhenFalse).andSet(uninitsBeforeElse.copy().andSet(this.uninitsWhenFalse));
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.ExpressionStatement tree, Integer status) {
        this.analyzeExpr(tree.expression);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Break tree, Integer status) {
        this.jump(tree.target, this.breaks);
        this.markDead();
        return null;
    }

    @Override
    public VoidContext _case(Tree.Continue tree, Integer status) {
        this.jump(tree.target, this.continues);
        this.markDead();
        return null;
    }

    @Override
    public VoidContext _case(Tree.Return tree, Integer status) {
        this.analyzeExpr(tree.expression);
        this.markDead();
        return null;
    }

    @Override
    public VoidContext _case(Tree.Throw tree, Integer status) {
        this.analyzeExpr(tree.expression);
        this.markThrown(tree.sourcePosition, (Symbol.ClassSymbol)tree.expression.type.typeSymbol);
        this.markDead();
        return null;
    }

    @Override
    public VoidContext _case(Tree.Apply tree, Integer status) {
        this.analyzeExpr(tree.method);
        this.analyzeExprs(tree.args);
        List<Symbol.ClassSymbol> l = TreeInspector.symbol((Tree)tree.method).type.thrown();
        while (l.nonEmpty()) {
            this.markThrown(tree.method.sourcePosition, l.getFirst());
            l = l.getRest();
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.NewInstance tree, Integer status) {
        this.analyzeExpr(tree.enclosingClassPrefix);
        this.analyzeExprs(tree.args);
        List<Symbol.ClassSymbol> l = tree.constructor.type.thrown();
        while (l.nonEmpty()) {
            this.markThrown(tree.sourcePosition, l.getFirst());
            l = l.getRest();
        }
        this.analyze(tree.anonymousClassDef);
        return null;
    }

    @Override
    public VoidContext _case(Tree.NewArray tree, Integer status) {
        this.analyzeExprs(tree.dimensions);
        this.analyzeExprs(tree.elements);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Assign tree, Integer status) {
        this.analyzeVar(tree.lhs);
        if (status == condStatus) {
            this.analyzeCond(tree.rhs);
        } else {
            this.analyzeExpr(tree.rhs);
        }
        this.letInit(tree.lhs);
        return null;
    }

    @Override
    public VoidContext _case(Tree.AssignOp tree, Integer status) {
        if (tree.type.tag == 8 && 65 <= tree.tag && tree.tag <= 67) {
            this.booleanBinop(tree.tag - 65 + 48, tree.lhs, tree.rhs);
        } else {
            this.analyzeExpr(tree.lhs);
            this.analyzeExpr(tree.rhs);
        }
        this.letInit(tree.lhs);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Operation tree, Integer status) {
        switch (tree.tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: {
                if (tree.args.getFirst().type.tag == 8) {
                    this.booleanBinop(tree.tag, tree.args.getFirst(), tree.args.getRest().getFirst());
                    break;
                }
                this.analyzeExpr(tree.args.getFirst());
                this.analyzeExpr(tree.args.getRest().getFirst());
                break;
            }
            case 47: {
                this.analyzeCond(tree.args.getFirst());
                Bits initsWhenFalseLeft = this.initsWhenFalse;
                Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
                this.inits = this.initsWhenTrue;
                this.uninits = this.uninitsWhenTrue;
                this.analyzeCond(tree.args.getRest().getFirst());
                this.initsWhenFalse.andSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 46: {
                this.analyzeCond(tree.args.getFirst());
                Bits initsWhenTrueLeft = this.initsWhenTrue;
                Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
                this.inits = this.initsWhenFalse;
                this.uninits = this.uninitsWhenFalse;
                this.analyzeCond(tree.args.getRest().getFirst());
                this.initsWhenTrue.andSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            case 40: {
                this.analyzeCond(tree.args.getFirst());
                Bits t = this.initsWhenFalse;
                this.initsWhenFalse = this.initsWhenTrue;
                this.initsWhenTrue = t;
                t = this.uninitsWhenFalse;
                this.uninitsWhenFalse = this.uninitsWhenTrue;
                this.uninitsWhenTrue = t;
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                this.analyzeExpr(tree.args.getFirst());
                this.letInit(tree.args.getFirst());
                break;
            }
            default: {
                ListBox<Tree> l = new ListBox<Tree>(tree.args);
                while (l.nonEmpty()) {
                    this.analyzeExpr(l.getFirst());
                    l.remove();
                }
                break block0;
            }
        }
        return null;
    }

    void booleanBinop(int tag, Tree left, Tree right) {
        this.analyzeCond(left);
        Bits initsWhenFalseLeft = this.initsWhenFalse;
        Bits uninitsWhenFalseLeft = this.uninitsWhenFalse;
        Bits initsWhenTrueLeft = this.initsWhenTrue;
        Bits uninitsWhenTrueLeft = this.uninitsWhenTrue;
        this.inits = this.initsWhenTrue.copy().andSet(this.initsWhenFalse);
        this.uninits = this.uninitsWhenTrue.copy().andSet(this.uninitsWhenFalse);
        this.analyzeCond(right);
        Bits initsRight = this.initsWhenFalse.copy().andSet(this.initsWhenTrue.copy());
        Bits uninitsRight = this.uninitsWhenFalse.copy().andSet(this.uninitsWhenTrue.copy());
        switch (tag) {
            case 50: {
                this.initsWhenFalse = initsRight.orSet(initsWhenFalseLeft.andSet(this.initsWhenFalse));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenFalseLeft.andSet(this.uninitsWhenFalse));
                this.initsWhenTrue.orSet(initsWhenTrueLeft);
                this.uninitsWhenTrue.andSet(uninitsWhenTrueLeft);
                break;
            }
            case 48: {
                this.initsWhenTrue = initsRight.orSet(initsWhenTrueLeft.andSet(this.initsWhenTrue));
                this.uninitsWhenTrue = uninitsRight.andSet(uninitsWhenTrueLeft.andSet(this.uninitsWhenTrue));
                this.initsWhenFalse.orSet(initsWhenFalseLeft);
                this.uninitsWhenFalse.andSet(uninitsWhenFalseLeft);
                break;
            }
            case 49: 
            case 52: {
                Bits initsWhenTrueRight = this.initsWhenTrue.copy();
                Bits initsWhenFalseRight = this.initsWhenFalse.copy();
                Bits uninitsWhenTrueRight = this.uninitsWhenTrue.copy();
                Bits uninitsWhenFalseRight = this.uninitsWhenFalse.copy();
                this.initsWhenTrue = initsRight.copy().orSet(initsWhenTrueLeft.copy().andSet(initsWhenTrueRight)).orSet(initsWhenFalseLeft.copy().andSet(initsWhenFalseRight));
                this.uninitsWhenTrue = uninitsRight.copy().andSet(uninitsWhenTrueLeft.copy().andSet(uninitsWhenTrueRight)).andSet(uninitsWhenFalseLeft.copy().andSet(uninitsWhenFalseRight));
                this.initsWhenFalse = initsRight.orSet(initsWhenTrueLeft.andSet(initsWhenFalseRight)).orSet(initsWhenFalseLeft.andSet(initsWhenTrueRight));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenTrueLeft.andSet(uninitsWhenFalseRight)).andSet(uninitsWhenFalseLeft.andSet(uninitsWhenTrueRight));
                break;
            }
            case 51: {
                Bits initsWhenTrueRight = this.initsWhenTrue.copy();
                Bits initsWhenFalseRight = this.initsWhenFalse.copy();
                Bits uninitsWhenTrueRight = this.uninitsWhenTrue.copy();
                Bits uninitsWhenFalseRight = this.uninitsWhenFalse.copy();
                this.initsWhenTrue = initsRight.copy().orSet(initsWhenTrueLeft.copy().andSet(initsWhenFalseRight)).orSet(initsWhenFalseLeft.copy().andSet(initsWhenTrueRight));
                this.uninitsWhenTrue = uninitsRight.copy().andSet(uninitsWhenTrueLeft.copy().andSet(uninitsWhenFalseRight)).andSet(uninitsWhenFalseLeft.copy().andSet(uninitsWhenTrueRight));
                this.initsWhenFalse = initsRight.orSet(initsWhenFalseLeft.andSet(initsWhenFalseRight)).orSet(initsWhenTrueLeft.andSet(initsWhenTrueRight));
                this.uninitsWhenFalse = uninitsRight.andSet(uninitsWhenFalseLeft.andSet(uninitsWhenFalseRight)).andSet(uninitsWhenTrueLeft.andSet(uninitsWhenTrueRight));
                break;
            }
            default: {
                throw new InternalError();
            }
        }
    }

    @Override
    public VoidContext _case(Tree.TypeCast tree, Integer status) {
        this.analyzeExpr(tree.expression);
        return null;
    }

    @Override
    public VoidContext _case(Tree.InstanceofTest tree, Integer status) {
        this.analyzeExpr(tree.expression);
        return null;
    }

    @Override
    public VoidContext _case(Tree.IndexedArrayElement tree, Integer status) {
        this.analyzeExpr(tree.indexedArray);
        this.analyzeExpr(tree.index);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Ident tree, Integer status) {
        if (this.trackable(tree.symbol) && status != varStatus) {
            this.checkInit(tree.sourcePosition, (Symbol.VarSymbol)tree.symbol);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Select tree, Integer status) {
        this.analyzeExpr(tree.selected);
        return null;
    }

    @Override
    public VoidContext _case(Tree tree, Integer status) {
        return null;
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Integer)x1);
    }
}

