/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.tree.Tree;

public class EnvironmentTest
extends NextGenTestCase {
    public EnvironmentTest(String name) {
        super(name);
    }

    public void testNullEnvironment() {
        Environment<Object> env = new Environment<Object>(null, null);
        EnvironmentTest.assertEquals((String)"Null environment doesn't print properly.", (String)EnvironmentTest.removeWhiteSpace("[Environment null null]"), (String)EnvironmentTest.removeWhiteSpace(env.longString()));
    }

    public void testSimpleEnvironment() {
        Tree.TopLevel simpleTree = EnvironmentTest.makeClassTree("public class C {}");
        Environment<Object> env = new Environment<Object>(simpleTree, null);
        String EXPECTED = "[Environment  null {TopLevel for null   packageId: null packageSymbol: null   starImportScope (except for java.lang): null   namedImportScope: null   ==========   {ClassDef C<> extends null implements () flags: 1     null     }}]";
        EnvironmentTest.assertEquals((String)"Simple environment contains unexpected data.", (String)EnvironmentTest.removeWhiteSpace("[Environment  null {TopLevel for null   packageId: null packageSymbol: null   starImportScope (except for java.lang): null   namedImportScope: null   ==========   {ClassDef C<> extends null implements () flags: 1     null     }}]"), (String)EnvironmentTest.removeWhiteSpace(env.longString()));
        EnvironmentTest.assertEquals((String)"Simple environment contains non-null next", null, env.enclosingEnv);
        EnvironmentTest.assertEquals((String)"Simple environment contains non-null outer", null, env.enclosingClassEnv);
        EnvironmentTest.assertEquals((String)"Simple environment contains non-null enclClass", null, (Object)env.enclosingClass);
        EnvironmentTest.assertEquals((String)"Simple environment contains non-null enclMethod", null, (Object)env.enclosingMethod);
    }

    public void testSpawn() {
        Tree.TopLevel innerTree = EnvironmentTest.makeClassTree("public class C {}");
        Environment<Object> innerEnv = new Environment<Object>(innerTree, null);
        Tree.TopLevel outerTree = EnvironmentTest.makeClassTree("public class D {}");
        Environment<Object> outerEnv = innerEnv.spawn(outerTree, null);
        EnvironmentTest.assertEquals((String)"Spawned environment does not point to original", innerEnv, outerEnv.enclosingEnv);
        EnvironmentTest.assertEquals((String)"Spawned environment does not share outer with original", innerEnv.enclosingClassEnv, outerEnv.enclosingClassEnv);
        EnvironmentTest.assertEquals((String)"Spawned environment does not share enclClass with original", (Object)innerEnv.enclosingClass, (Object)outerEnv.enclosingClass);
        EnvironmentTest.assertEquals((String)"Spawned environment does not share enclMethod with original", (Object)outerEnv.enclosingMethod, (Object)outerEnv.enclosingMethod);
    }

    public void testSingleArgSpawn() {
        Tree.TopLevel innerTree = EnvironmentTest.makeClassTree("public class C {}");
        Environment<Object> innerEnv = new Environment<Object>(innerTree, null);
        Tree.TopLevel outerTree = EnvironmentTest.makeClassTree("public class D {}");
        Environment<Object> outerEnv = innerEnv.spawn(outerTree);
        EnvironmentTest.assertEquals((String)"(Single arg) spawned environment does not point to to original", innerEnv, outerEnv.enclosingEnv);
        EnvironmentTest.assertEquals((String)"(Single arg) spawned environment does not share outer with original", innerEnv.enclosingClassEnv, outerEnv.enclosingClassEnv);
        EnvironmentTest.assertEquals((String)"(Single arg) spawned environment does not share enclClass with original", (Object)outerEnv.enclosingClass, (Object)outerEnv.enclosingClass);
        EnvironmentTest.assertEquals((String)"(Single arg) spawned environment does not share enclMethod with original", (Object)outerEnv.enclosingMethod, (Object)outerEnv.enclosingMethod);
    }

    public void testEnclosing() {
        Tree.TopLevel tree0 = EnvironmentTest.makeClassTree("public class C0 {}");
        Tree.Import tree1 = EnvironmentTest.makeImportTree("import java.util.C1;");
        Tree.TopLevel tree2 = EnvironmentTest.makeClassTree("public class C2 {}");
        Tree.TopLevel tree3 = EnvironmentTest.makeClassTree("public class C3 {}");
        Tree.TopLevel tree4 = EnvironmentTest.makeClassTree("public class C4 {}");
        Environment<Object> env0 = new Environment<Object>(tree0, null);
        Environment<Object> env1 = env0.spawn(tree1);
        Environment<Object> env2 = env1.spawn(tree2);
        Environment<Object> env3 = env2.spawn(tree3);
        Environment<Object> env4 = env3.spawn(tree4);
        EnvironmentTest.assertEquals((String)"Environment \"enclosing\" method returns the wrong result", env1, env4.enclosing(2));
    }
}

