/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.VoidContext;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.tree.TreeTranslator;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.Converter;
import edu.rice.cs.nextgen.compiler.util.Empty;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.ListIterator;
import edu.rice.cs.nextgen.compiler.util.ListMapper;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassFlattener
extends TreeTranslator<Tree>
implements Flags,
Kinds,
TypeTags,
ByteCodes {
    ErrorLog errorLog;
    SymbolTable symbolTable;
    TreeMaker treeMaker;
    Symbol.ClassSymbol currentClass;
    Tree toplevelMemberDef;
    ListBox<Tree> translated;
    Hashtable<Symbol.ClassSymbol, Tree.ClassDef> classdefs;
    Hashtable<Symbol.ClassSymbol, List<Symbol.VarSymbol>> freevarCache;
    private static final int DEREFcode = 0;
    private static final int ASSIGNcode = 1;
    private static final int PREINCcode = 2;
    private static final int PREDECcode = 3;
    private static final int POSTINCcode = 4;
    private static final int POSTDECcode = 5;
    private static final int FIRSTASGOPcode = 6;
    private static final int FIRSTLONGcode = InnerClassFlattener.accessCode(270);
    private static final int NCODES = InnerClassFlattener.accessCode(274) + 1;
    private Hashtable<Symbol, Integer> accessNums;
    private Hashtable<Symbol, Symbol.MethodSymbol[]> accessSyms;
    private ListBox<Symbol> accessed;
    Scope proxies;

    public InnerClassFlattener(ErrorLog log, SymbolTable syms, TreeMaker make) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.treeMaker = make;
    }

    Tree.ClassDef classDef(Symbol.ClassSymbol c) {
        Tree.ClassDef def = this.classdefs.get(c);
        if (def == null && this.toplevelMemberDef != null) {
            this.toplevelMemberDef.accept(new ClassMap(), null);
            def = this.classdefs.get(c);
        }
        return def;
    }

    List<Symbol.VarSymbol> freevars(Symbol.ClassSymbol c) {
        if ((c.owner.kind & 0x14) != 0) {
            List<Symbol.VarSymbol> fvs = this.freevarCache.get(c);
            if (fvs == null) {
                fvs = new FreeVarCollector().freevars(this.classDef(c));
                this.freevarCache.put(c, fvs);
            }
            return fvs;
        }
        return Symbol.VarSymbol.EMPTY_LIST;
    }

    private static int accessCode(int bytecode) {
        if (96 <= bytecode && bytecode <= 131) {
            return bytecode - 96 + 6;
        }
        if (270 <= bytecode && bytecode <= 274) {
            return bytecode - 270 + 131 + 1 - 96 + 6;
        }
        return -1;
    }

    private static int accessCode(Tree tree, Tree encl) {
        if (encl == null) {
            return 0;
        }
        if (encl.tag == 26 && tree == ((Tree.Assign)encl).lhs) {
            return 1;
        }
        if (42 <= encl.tag && encl.tag <= 45 && tree == ((Tree.Operation)encl).args.getFirst()) {
            return encl.tag - 42 + 2;
        }
        if (65 <= encl.tag && encl.tag <= 81 && tree == ((Tree.AssignOp)encl).lhs) {
            return InnerClassFlattener.accessCode(((Symbol.OperatorSymbol)((Tree.AssignOp)encl).operator).opcode);
        }
        return 0;
    }

    private Symbol.OperatorSymbol binaryAccessOperator(int acode) {
        Scope.Entry e = this.symbolTable.predefinedSymbolOwner.members().entries;
        while (e != null) {
            if (e.symbol instanceof Symbol.OperatorSymbol) {
                Symbol.OperatorSymbol op = (Symbol.OperatorSymbol)e.symbol;
                if (InnerClassFlattener.accessCode(op.opcode) == acode) {
                    return op;
                }
            }
            e = e.sibling;
        }
        return null;
    }

    private Symbol.OperatorSymbol unaryAccessOperator(int opcode, Type argtype) {
        Name name = TreeInspector.operatorName(opcode);
        Scope.Entry e = this.symbolTable.predefinedSymbolOwner.members().lookup(name);
        while (!(e.symbol == null || e.symbol.type.argTypes().getFirst() == argtype && e.symbol.type.argTypes().getRest().isEmpty())) {
            e = e.next();
        }
        return (Symbol.OperatorSymbol)e.symbol;
    }

    private static int treeTag(Symbol.OperatorSymbol operator) {
        switch (operator.opcode) {
            case 128: 
            case 129: {
                return 65;
            }
            case 130: 
            case 131: {
                return 66;
            }
            case 126: 
            case 127: {
                return 67;
            }
            case 120: 
            case 121: 
            case 270: 
            case 271: {
                return 74;
            }
            case 122: 
            case 123: 
            case 272: 
            case 273: {
                return 75;
            }
            case 124: 
            case 125: 
            case 274: 
            case 275: {
                return 76;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: {
                return 77;
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: {
                return 78;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return 79;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: {
                return 80;
            }
            case 112: 
            case 113: 
            case 114: 
            case 115: {
                return 81;
            }
        }
        throw new InternalError();
    }

    static Name accessName(int anum, int acode) {
        return Name.fromString(new StringBuffer().append("access$").append(anum).append(acode / 10).append(acode % 10).toString());
    }

    /*
     * WARNING - void declaration
     */
    Symbol.MethodSymbol accessSymbol(Symbol sym, Tree tree, Tree encl) {
        void var5_5;
        Symbol.MethodSymbol[] accessors;
        Symbol.MethodSymbol accessor;
        List<Symbol.ClassSymbol> thrown;
        Type restype;
        List argtypes;
        int acode;
        Integer anum = this.accessNums.get(sym);
        if (anum == null) {
            anum = new Integer(this.accessed.length());
            this.accessNums.put(sym, anum);
            this.accessSyms.put(sym, new Symbol.MethodSymbol[NCODES]);
            this.accessed.insertEnd(sym);
        }
        if (sym.kind == 4) {
            acode = InnerClassFlattener.accessCode(tree, encl);
            argtypes = acode >= 6 ? this.binaryAccessOperator((int)acode).type.argTypes().getRest() : (acode == 1 ? Type.EMPTY_LIST.cons(sym.erasure()) : Type.EMPTY_LIST);
            restype = sym.erasure();
            thrown = Symbol.ClassSymbol.EMPTY_LIST;
        } else if (sym.kind == 16) {
            acode = 0;
            argtypes = sym.erasure().argTypes();
            restype = sym.erasure().returnType();
            thrown = sym.type.thrown();
        } else {
            throw new InternalError();
        }
        if ((sym.flags() & 8) == 0) {
            argtypes = argtypes.cons((Type)sym.owner.erasure());
        }
        if ((accessor = (accessors = this.accessSyms.get(sym))[var5_5]) == null) {
            void var8_8;
            void var7_7;
            void var6_6;
            accessor = new Symbol.MethodSymbol(65544, InnerClassFlattener.accessName(anum, (int)var5_5), new Type.MethodType((List<Type>)var6_6, (Type)var7_7, (List<Symbol.ClassSymbol>)var8_8), sym.owner);
            ((Symbol.ClassSymbol)sym.owner).members().addSymbol(accessor);
            accessors[var5_5] = accessor;
        }
        return accessor;
    }

    Tree makeLit(int typetag, Object value) {
        if (typetag == 8) {
            return this.treeMaker.newIdent((Integer)value == 0 ? this.symbolTable.TRUE_SYMBOL : this.symbolTable.FALSE_SYMBOL);
        }
        return this.treeMaker.newLiteral(typetag, value);
    }

    Tree accessBase(int pos, Symbol sym) {
        return (sym.flags() & 8) != 0 ? this.access(this.treeMaker.at(pos).newQualIdent(sym.owner)) : this.makeThis(pos, sym.owner.enclClass());
    }

    Tree access(Symbol sym, Tree tree, Tree encl) {
        if (sym.kind == 4 && (sym.flags() & 0x40000) != 0 && sym.owner.enclClass() != this.currentClass) {
            this.treeMaker.at(tree.sourcePosition);
            Object cv = ((Symbol.VarSymbol)sym).constantValue;
            if (cv != null) {
                return this.makeLit(sym.type.tag, cv).setType(sym.type.constType(cv));
            }
            sym = this.proxies.lookup((Name)InnerClassFlattener.proxyName((Name)sym.name)).symbol;
            tree = this.treeMaker.at(tree.sourcePosition).newIdent(sym);
        }
        Tree base = tree.tag == 30 ? ((Tree.Select)tree).selected : null;
        switch (sym.kind) {
            case 2: {
                if (sym.owner.kind == 1) break;
                Name flatname = Converter.shortName(sym.flatName());
                while (base != null && TreeInspector.symbol((Tree)base).kind != 1) {
                    base = base.tag == 30 ? ((Tree.Select)base).selected : null;
                }
                if (tree.tag == 31) {
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                if (base == null) {
                    tree = this.treeMaker.at(tree.sourcePosition).newIdent(sym);
                    ((Tree.Ident)tree).name = flatname;
                    break;
                }
                ((Tree.Select)tree).selected = base;
                ((Tree.Select)tree).name = flatname;
                break;
            }
            case 4: 
            case 16: {
                Object cv;
                if (sym.owner.kind != 2 || ((sym.flags() & 2) == 0 || sym.owner == this.currentClass) && (base != null || sym.owner == this.symbolTable.predefinedSymbolOwner || this.currentClass.subclass(sym.owner))) break;
                this.treeMaker.at(tree.sourcePosition);
                if (sym.kind == 4 && sym.owner != this.symbolTable.predefinedSymbolOwner && (cv = ((Symbol.VarSymbol)sym).constantValue) != null) {
                    return this.makeLit(sym.type.tag, cv).setType(sym.type.constType(cv));
                }
                if ((sym.flags() & 2) != 0) {
                    List<Tree> args = Tree.EMPTY_LIST;
                    if ((sym.flags() & 8) == 0) {
                        if (base == null) {
                            args = args.cons(this.makeThis(tree.sourcePosition, sym.owner.enclClass()));
                        } else {
                            args = args.cons(base);
                            base = null;
                        }
                    }
                    Tree receiver = this.treeMaker.newSelect(base != null ? base : this.treeMaker.newQualIdent(sym.owner), this.accessSymbol(sym, tree, encl));
                    return this.treeMaker.newApp(receiver, args);
                }
                return this.treeMaker.at(tree.sourcePosition).newSelect(this.accessBase(tree.sourcePosition, sym), sym);
            }
        }
        return tree;
    }

    Tree access(Tree tree) {
        Symbol sym = TreeInspector.symbol(tree);
        return sym == null ? tree : this.access(sym, tree, null);
    }

    void makeAccessible(Symbol sym) {
        Tree.ClassDef cdef = this.classDef(sym.owner.enclClass());
        Symbol.MethodSymbol[] accessors = this.accessSyms.get(sym);
        for (int i = 0; i < NCODES; ++i) {
            if (accessors[i] == null) continue;
            cdef.members = cdef.members.cons(this.accessDef(cdef.sourcePosition, sym, accessors[i], i));
        }
    }

    Tree accessDef(int pos, Symbol sym, Symbol.MethodSymbol accessor, int acode) {
        Tree stat;
        List<Tree> args;
        Tree receiver;
        this.currentClass = sym.owner.enclClass();
        this.treeMaker.at(pos);
        Tree.MethodDef md = this.treeMaker.newMethodDef(accessor, null);
        if ((sym.flags() & 8) != 0) {
            receiver = this.treeMaker.newIdent(sym);
            args = this.treeMaker.newIdents(md.params);
        } else {
            receiver = this.treeMaker.newSelect(this.treeMaker.newIdent(md.params.getFirst()), sym);
            args = this.treeMaker.newIdents(md.params.getRest());
        }
        if (sym.kind == 4) {
            Tree expr;
            switch (acode) {
                case 0: {
                    expr = receiver;
                    break;
                }
                case 1: {
                    expr = this.treeMaker.newAssign(receiver, args.getFirst());
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    int opcode = acode - 2 + 42;
                    expr = this.treeMaker.newOperation(opcode, new Cons<Tree>(receiver));
                    ((Tree.Operation)expr).operator = this.unaryAccessOperator(opcode, receiver.type);
                    break;
                }
                default: {
                    expr = this.treeMaker.newAssignOp(InnerClassFlattener.treeTag(this.binaryAccessOperator(acode)), receiver, args.getFirst());
                    ((Tree.AssignOp)expr).operator = this.binaryAccessOperator(acode);
                }
            }
            stat = this.treeMaker.newReturn(expr.setType(sym.type));
        } else {
            stat = this.treeMaker.newInvocation(this.treeMaker.newApp(receiver, args));
        }
        md.body = this.treeMaker.newBlock(0, new Cons<Tree>(stat));
        ListIterator<Tree.VarDef> l = md.params.iterator();
        while (l.hasNext()) {
            Tree.VarDef next = l.next();
            next.varType = this.access(next.varType);
        }
        md.returnType = this.access(md.returnType);
        md.thrown = md.thrown.accept(new ListMapper<Tree>(){

            @Override
            public Tree apply(Tree item) {
                return InnerClassFlattener.this.access(item);
            }

            @Override
            public /* synthetic */ Object apply(Object x0) {
                return this.apply((Tree)x0);
            }

            @Override
            public /* synthetic */ Object forCons(Cons x0) {
                return super.forCons(x0);
            }

            @Override
            public /* synthetic */ Object forEmpty(Empty x0) {
                return super.forEmpty(x0);
            }
        });
        return md;
    }

    static Name proxyName(Name name) {
        return Name.fromString(new StringBuffer().append("val$").append(name).toString());
    }

    List<Tree.VarDef> freevarDefs(int pos, List<Symbol.VarSymbol> freevars, Symbol owner) {
        List<Tree.VarDef> defs = Tree.VarDef.emptyList;
        List<Symbol.VarSymbol> l = freevars;
        while (l.nonEmpty()) {
            Symbol.VarSymbol v = l.getFirst();
            Symbol.VarSymbol proxy = new Symbol.VarSymbol(65552, InnerClassFlattener.proxyName(v.name), v.erasure(), owner);
            this.proxies.addSymbol(proxy);
            Tree.VarDef vd = this.treeMaker.at(pos).newVarDef(proxy, null);
            vd.varType = this.access(vd.varType);
            defs = defs.cons(vd);
            l = l.getRest();
        }
        return defs;
    }

    Tree.VarDef this0Def(int pos, Symbol owner) {
        Symbol.VarSymbol this0 = new Symbol.VarSymbol(65552, Names.this0, owner.enclClass().type.enclosingType().erasure(), owner);
        this.proxies.addSymbol(this0);
        Tree.VarDef vd = this.treeMaker.at(pos).newVarDef(this0, null);
        vd.varType = this.access(vd.varType);
        return vd;
    }

    List<Tree> loadFreevars(int pos, List<Symbol.VarSymbol> freevars) {
        List<Tree> args = Tree.EMPTY_LIST;
        List<Symbol.VarSymbol> l = freevars;
        while (l.nonEmpty()) {
            args = args.cons(this.loadFreevar(pos, l.getFirst()));
            l = l.getRest();
        }
        return args;
    }

    Tree loadFreevar(int pos, Symbol.VarSymbol v) {
        return this.access(v, this.treeMaker.at(pos).newIdent(v), null);
    }

    Tree makeThis(int pos, Symbol.TypeSymbol c) {
        Symbol.TypeSymbol c1 = this.currentClass;
        if (c.type.tag != 10) {
            return this.treeMaker.newIdent(this.symbolTable.NULL_SYMBOL);
        }
        if (this.currentClass.subclass(c)) {
            return this.treeMaker.at(pos).newThis(c.erasure());
        }
        Scope.Entry e = this.proxies.lookup(Names.this0);
        Tree tree = this.treeMaker.at(pos).newIdent(e.symbol);
        c1 = e.symbol.type.typeSymbol;
        while (!c1.subclass(c)) {
            do {
                e = e.next();
            } while (e.symbol.owner != c1);
            tree = this.treeMaker.at(pos).newSelect(tree, e.symbol);
            c1 = e.symbol.type.typeSymbol;
        }
        return tree;
    }

    Tree initField(int pos, Name name) {
        Scope.Entry e = this.proxies.lookup(name);
        Symbol rhs = e.symbol;
        Asserter._assert(rhs.owner.kind == 16);
        Symbol lhs = e.next().symbol;
        Asserter._assert(rhs.owner.owner == lhs.owner);
        this.treeMaker.at(pos);
        return this.treeMaker.newExpressionStatement(this.treeMaker.newAssign(this.treeMaker.newSelect(this.treeMaker.newThis(lhs.owner.erasure()), lhs), this.treeMaker.newIdent(rhs)).setType(lhs.erasure()));
    }

    @Override
    public Tree _case(Tree.ClassDef tree, final Tree encl) {
        Symbol.ClassSymbol currentClassPrev = this.currentClass;
        this.currentClass = tree.classSymbol;
        this.classdefs.put(this.currentClass, tree);
        this.proxies = this.proxies.extend();
        Tree.VarDef this0def = null;
        if (this.currentClass.isNested()) {
            this0def = this.this0Def(tree.sourcePosition, this.currentClass);
        }
        List<Tree.VarDef> fvdefs = this.freevarDefs(tree.sourcePosition, this.freevars(this.currentClass), this.currentClass);
        tree.extendedClass = this.translate(tree.extendedClass, (Object)encl);
        tree.implementedInterfaces = this.translate((List)tree.implementedInterfaces, (Object)encl);
        List<Tree> l = tree.members = tree.members.accept(new ListMapper<Tree>(){

            @Override
            public Tree apply(Tree item) {
                Tree toplevelMemberDefPrev = InnerClassFlattener.this.toplevelMemberDef;
                if (toplevelMemberDefPrev == null) {
                    InnerClassFlattener.this.toplevelMemberDef = item;
                }
                Tree result = InnerClassFlattener.this.translate(item, (Object)encl);
                InnerClassFlattener.this.toplevelMemberDef = toplevelMemberDefPrev;
                return result;
            }

            @Override
            public /* synthetic */ Object apply(Object x0) {
                return this.apply((Tree)x0);
            }

            @Override
            public /* synthetic */ Object forCons(Cons x0) {
                return super.forCons(x0);
            }

            @Override
            public /* synthetic */ Object forEmpty(Empty x0) {
                return super.forEmpty(x0);
            }
        });
        while (l.nonEmpty()) {
            l = l.getRest();
        }
        if ((tree.flags & 4) != 0) {
            tree.flags |= 1;
        }
        tree.flags &= 0xE11;
        tree.name = Converter.shortName(this.currentClass.flatName());
        l = fvdefs;
        while (l.nonEmpty()) {
            tree.members = tree.members.cons(l.getFirst());
            this.currentClass.members().addSymbol(((Tree.VarDef)l.getFirst()).varSymbol);
            l = l.getRest();
        }
        if (this.currentClass.isNested()) {
            tree.members = tree.members.cons(this0def);
            this.currentClass.members().addSymbol(this0def.varSymbol);
        }
        this.proxies = this.proxies.leave();
        this.translated.insertEnd(tree);
        this.currentClass = currentClassPrev;
        return this.treeMaker.at(tree.sourcePosition).newBlock(0, Tree.EMPTY_LIST);
    }

    @Override
    public Tree _case(Tree.MethodDef tree, Tree encl) {
        if (tree.name == Names.init && this.currentClass.isInner()) {
            Symbol.MethodSymbol m = tree.methodSymbol;
            this.proxies = this.proxies.extend();
            List<Symbol.VarSymbol> fvs = this.freevars(this.currentClass);
            Tree.VarDef this0def = null;
            if (this.currentClass.isNested()) {
                this0def = this.this0Def(tree.sourcePosition, m);
            }
            List<Tree.VarDef> fvdefs = this.freevarDefs(tree.sourcePosition, fvs, m);
            super._case(tree, (Object)encl);
            tree.params = tree.params.append(fvdefs);
            if (this.currentClass.isNested()) {
                tree.params = tree.params.cons(this0def);
            }
            Tree selfCall = tree.body.statements.getFirst();
            List<Tree> rest = tree.body.statements.getRest();
            if (fvs.nonEmpty()) {
                List<Type> argtypes = m.erasure().argTypes();
                List<Symbol.VarSymbol> l = fvs;
                while (l.nonEmpty()) {
                    if (TreeInspector.isInitialConstructor(tree)) {
                        rest = rest.cons(this.initField(tree.body.sourcePosition, InnerClassFlattener.proxyName(l.getFirst().name)));
                    }
                    argtypes = argtypes.cons(l.getFirst().erasure());
                    l = l.getRest();
                }
                m.erasure_field = new Type.MethodType(argtypes, m.erasure().returnType(), m.erasure().thrown());
            }
            if (this.currentClass.isNested() && TreeInspector.isInitialConstructor(tree)) {
                rest = rest.cons(this.initField(tree.body.sourcePosition, Names.this0));
            }
            tree.body.statements = rest.cons(selfCall);
            this.proxies = this.proxies.leave();
        } else {
            super._case(tree, (Object)encl);
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.NewInstance tree, Tree encl) {
        Symbol.ClassSymbol c = tree.anonymousClassDef == null ? (Symbol.ClassSymbol)tree._class.type.typeSymbol : tree.anonymousClassDef.classSymbol;
        tree._class = this.access(c, tree._class, encl);
        tree.args = this.translate((List)tree.args, (Object)encl);
        if ((c.owner.kind & 0x14) != 0) {
            tree.args = tree.args.append(this.loadFreevars(tree.sourcePosition, this.freevars(c)));
        }
        if (c.isNested()) {
            Tree thisArg = tree.enclosingClassPrefix != null ? this.translate(tree.enclosingClassPrefix, (Object)encl) : this.makeThis(tree.sourcePosition, c.type.enclosingType().typeSymbol);
            tree.args = tree.args.cons(thisArg);
        }
        tree.enclosingClassPrefix = null;
        if (tree.anonymousClassDef != null) {
            this.translate((Tree)tree.anonymousClassDef, (Object)encl);
            tree._class = this.access(this.treeMaker.at(tree._class.sourcePosition).newIdent(tree.anonymousClassDef.classSymbol));
            tree.anonymousClassDef = null;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Apply tree, Tree encl) {
        tree.args = this.translate((List)tree.args, (Object)encl);
        Name methName = TreeInspector.name(tree.method);
        if (methName == Names._this || methName == Names._super) {
            Symbol self = TreeInspector.symbol(tree.method);
            Symbol.ClassSymbol c = (Symbol.ClassSymbol)self.owner;
            if ((c.owner.kind & 0x14) != 0) {
                tree.args = tree.args.append(this.loadFreevars(tree.sourcePosition, this.freevars(c)));
            }
            if (c.isNested()) {
                Tree thisArg;
                if (tree.method.tag == 30) {
                    thisArg = this.translate(((Tree.Select)tree.method).selected, (Object)encl);
                    tree.method = this.treeMaker.newIdent(self);
                    ((Tree.Ident)tree.method).name = methName;
                } else {
                    thisArg = this.makeThis(tree.sourcePosition, c.type.enclosingType().typeSymbol);
                }
                tree.args = tree.args.cons(thisArg);
            }
        } else {
            tree.method = this.translate(tree.method, (Object)encl);
            if (tree.method.tag == 23) {
                Tree.Apply app = (Tree.Apply)tree.method;
                app.args = tree.args.append(app.args);
                return app;
            }
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Assign tree, Tree encl) {
        tree.lhs = this.translate(tree.lhs, (Object)tree);
        tree.rhs = this.translate(tree.rhs, (Object)encl);
        if (tree.lhs.tag == 23) {
            Tree.Apply app = (Tree.Apply)tree.lhs;
            app.args = new Cons<Tree>(tree.rhs).append(app.args);
            return app;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.AssignOp tree, Tree encl) {
        tree.lhs = this.translate(tree.lhs, (Object)tree);
        tree.rhs = this.translate(tree.rhs, (Object)encl);
        if (tree.lhs.tag == 23) {
            Tree.Apply app = (Tree.Apply)tree.lhs;
            app.args = new Cons<Tree>(tree.rhs).append(app.args);
            return app;
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Operation tree, Tree encl) {
        tree.args = this.translate((List)tree.args, (Object)tree);
        if (42 <= tree.tag && tree.tag <= 45 && tree.args.getFirst().tag == 23) {
            return tree.args.getFirst();
        }
        return tree;
    }

    @Override
    public Tree _case(Tree.Ident tree, Tree encl) {
        return this.access(tree.symbol, tree, encl);
    }

    @Override
    public Tree _case(Tree.Select tree, Tree encl) {
        tree.selected = this.translate(tree.selected, (Object)encl);
        if (tree.name == Names._class) {
            return tree;
        }
        if (tree.name == Names._this) {
            return this.makeThis(tree.sourcePosition, tree.selected.type.typeSymbol);
        }
        return this.access(tree.symbol, tree, encl);
    }

    public List<Tree> translateTopLevelClass(Tree cdef) {
        this.currentClass = null;
        this.toplevelMemberDef = null;
        this.translated = new ListBox();
        this.classdefs = new Hashtable();
        this.freevarCache = new Hashtable();
        this.proxies = new Scope(null);
        this.accessNums = new Hashtable();
        this.accessSyms = new Hashtable();
        this.accessed = new ListBox();
        cdef = this.translate(cdef, (Object)null);
        List<Symbol> l = this.accessed.toList();
        while (l.nonEmpty()) {
            this.makeAccessible(l.getFirst());
            l = l.getRest();
        }
        return this.translated.toList();
    }

    @Override
    public /* synthetic */ Tree _case(Tree x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Literal x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.IndexedArrayElement x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.InstanceofTest x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TypeCast x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewArray x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Throw x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Return x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Continue x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Break x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ExpressionStatement x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Conditional x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Try x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Synchronized x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Switch x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Labelled x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ForLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.DoLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Block x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.VarDef x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Tree _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ List translateCatchers(List x0, Object x1) {
        return super.translateCatchers(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ List translateCases(List x0, Object x1) {
        return super.translateCases(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ List translateTypeParams(List x0, Object x1) {
        return super.translateTypeParams(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ List translateVarDefs(List x0, Object x1) {
        return super.translateVarDefs(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ List translate(List x0, Object x1) {
        return super.translate(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Tree translate(Tree x0, Object x1) {
        return super.translate(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Tree)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Object)((Tree)x1));
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FreeVarCollector
    extends TreeTranslator<VoidContext>
    implements Flags,
    Kinds {
        private Symbol owner;
        private List<Symbol.VarSymbol> fvs;

        FreeVarCollector() {
        }

        @Override
        public Tree _case(Tree.Ident tree, VoidContext arg) {
            if (tree.symbol.kind == 4 && tree.symbol.owner == this.owner) {
                Symbol.VarSymbol v = (Symbol.VarSymbol)tree.symbol;
                if (v.constantValue == null && (v.flags_field & 0x40000) != 0) {
                    List<Symbol.VarSymbol> l = this.fvs;
                    while (l.nonEmpty()) {
                        if (l.getFirst() == v) {
                            return tree;
                        }
                        l = l.getRest();
                    }
                    this.fvs = this.fvs.cons(v);
                }
            }
            return tree;
        }

        List<Symbol.VarSymbol> freevars(Tree.ClassDef def) {
            this.owner = def.classSymbol.owner;
            this.fvs = Symbol.VarSymbol.EMPTY_LIST;
            def.accept(this, null);
            return this.fvs;
        }

        @Override
        public /* synthetic */ Tree _case(Tree x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeApply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ArrayTypeExpression x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Ident x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Select x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Return x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Break x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Try x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Case x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Block x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.VarDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.MethodDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ClassDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Import x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TopLevel x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ List translateCatchers(List x0, Object x1) {
            return super.translateCatchers(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateCases(List x0, Object x1) {
            return super.translateCases(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateTypeParams(List x0, Object x1) {
            return super.translateTypeParams(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateVarDefs(List x0, Object x1) {
            return super.translateVarDefs(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translate(List x0, Object x1) {
            return super.translate(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Tree translate(Tree x0, Object x1) {
            return super.translate(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClassMap
    extends TreeTranslator<VoidContext> {
        ClassMap() {
        }

        @Override
        public Tree _case(Tree.ClassDef tree, VoidContext arg) {
            InnerClassFlattener.this.classdefs.put(tree.classSymbol, tree);
            return super._case(tree, (Object)arg);
        }

        @Override
        public /* synthetic */ Tree _case(Tree x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeParameter x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeApply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ArrayTypeExpression x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Ident x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Select x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Return x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Break x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Try x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Case x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Block x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.VarDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.MethodDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.ClassDef x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Tree _case(Tree.Import x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Tree _case(Tree.TopLevel x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ List translateCatchers(List x0, Object x1) {
            return super.translateCatchers(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateCases(List x0, Object x1) {
            return super.translateCases(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateTypeParams(List x0, Object x1) {
            return super.translateTypeParams(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translateVarDefs(List x0, Object x1) {
            return super.translateVarDefs(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ List translate(List x0, Object x1) {
            return super.translate(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Tree translate(Tree x0, Object x1) {
            return super.translate(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
            return this._case(x0, (VoidContext)x1);
        }

        @Override
        public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }

        @Override
        public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
            return super._case(x0, (Object)((VoidContext)x1));
        }
    }
}

