/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ByteCodes;
import edu.rice.cs.nextgen.compiler.code.Code;
import edu.rice.cs.nextgen.compiler.code.ConstantPool;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.util.Asserter;

public final class Items
implements ByteCodes,
TypeTags {
    private ConstantPool constantPool;
    private Code code;
    private final Item VOID_ITEM;
    private final Item THIS_ITEM;
    private final Item SUPER_ITEM;
    private final Item[] STACK_ITEM = new Item[9];
    public static int count = 0;

    public Items() {
        this.VOID_ITEM = new Item(8);
        this.THIS_ITEM = new SelfItem(false);
        this.SUPER_ITEM = new SelfItem(true);
        for (int i = 0; i < 8; ++i) {
            this.STACK_ITEM[i] = new StackItem(i);
        }
        this.STACK_ITEM[8] = this.VOID_ITEM;
    }

    void setPool(ConstantPool pool) {
        this.constantPool = pool;
    }

    void setCode(Code code) {
        this.code = code;
    }

    Item makeVoidItem() {
        return this.VOID_ITEM;
    }

    Item makeThisItem() {
        return this.THIS_ITEM;
    }

    Item makeSuperItem() {
        return this.SUPER_ITEM;
    }

    Item makeStackItem(Type type) {
        return this.STACK_ITEM[Code.typecode(type)];
    }

    Item makeIndexedItem(Type type) {
        return new IndexedItem(type);
    }

    Item makeLocalItem(Symbol.VarSymbol v) {
        return new LocalItem(v.erasure(), v.address);
    }

    Item makeLocalItem(Type t, int adr) {
        return new LocalItem(t, adr);
    }

    Item makeStaticItem(Symbol member) {
        return new StaticItem(member);
    }

    Item makeMemberItem(Symbol member, boolean nonvirtual) {
        return new MemberItem(member, nonvirtual);
    }

    Item makeImmediateItem(Type type, Object value) {
        return new ImmediateItem(type, value);
    }

    Item makeAssignItem(Item lhs) {
        return new AssignItem(lhs);
    }

    CondItem makeCondItem(int opcode, Code.Chain truejumps, Code.Chain falsejumps) {
        return new CondItem(opcode, truejumps, falsejumps);
    }

    CondItem makeCondItem(int opcode) {
        return this.makeCondItem(opcode, null, null);
    }

    class CondItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Code.Chain trueJumps;
        Code.Chain falseJumps;
        int opcode;

        CondItem(int opcode, Code.Chain truejumps, Code.Chain falsejumps) {
            super(5);
            this.opcode = opcode;
            this.trueJumps = truejumps;
            this.falseJumps = falsejumps;
        }

        Item load() {
            Code.Chain trueExit = null;
            Code.Chain falseChain = this.jumpFalse();
            if (this.trueJumps != null || this.opcode != 168) {
                Items.this.code.resolve(this.trueJumps);
                Items.this.code.emitOp(4);
                trueExit = Items.this.code.branch(167);
            }
            if (falseChain != null) {
                Items.this.code.resolve(falseChain);
                Items.this.code.emitOp(3);
            }
            Items.this.code.resolve(trueExit);
            return Items.this.STACK_ITEM[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.load().drop();
        }

        void stash(int toscode) {
            throw new InternalError("stash");
        }

        CondItem mkCond() {
            return this;
        }

        Code.Chain jumpTrue() {
            Items.this.code;
            return Code.mergeChains(this.trueJumps, Items.this.code.branch(this.opcode));
        }

        Code.Chain jumpFalse() {
            Items.this.code;
            Code code = Items.this.code;
            Items.this.code;
            return Code.mergeChains(this.falseJumps, code.branch(Code.negate(this.opcode)));
        }

        CondItem negate() {
            Items.this.code;
            return new CondItem(Code.negate(this.opcode), this.falseJumps, this.trueJumps);
        }
    }

    class AssignItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Item lhs;

        AssignItem(Item lhs) {
            super(lhs.typecode);
            this.lhs = lhs;
        }

        Item load() {
            this.lhs.stash(this.typecode);
            this.lhs.store();
            return Items.this.STACK_ITEM[this.typecode];
        }

        void duplicate() {
            this.load().duplicate();
        }

        void drop() {
            this.lhs.store();
        }

        void stash(int toscode) {
            throw new InternalError("stash");
        }
    }

    class ImmediateItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Object value;

        ImmediateItem(Type type, Object value) {
            super(Code.typecode(type));
            this.value = value;
        }

        private void ldc() {
            int idx = Items.this.constantPool.put(this.value);
            if (this.typecode == 1 || this.typecode == 3) {
                Items.this.code.emitOp(20, 2);
                Items.this.code.emitTwoBytes(idx);
            } else if (idx <= 255) {
                Items.this.code.emitOp(18, 1);
                Items.this.code.emitOneByte(idx);
            } else {
                Items.this.code.emitOp(19, 1);
                Items.this.code.emitTwoBytes(idx);
            }
        }

        Item load() {
            switch (this.typecode) {
                case 0: 
                case 5: 
                case 6: 
                case 7: {
                    int ival = ((Number)this.value).intValue();
                    if (-1 <= ival && ival <= 5) {
                        Items.this.code.emitOp(3 + ival);
                        break;
                    }
                    if (-128 <= ival && ival <= 127) {
                        Items.this.code.emitOpByte(16, ival);
                        break;
                    }
                    if (Short.MIN_VALUE <= ival && ival <= Short.MAX_VALUE) {
                        Items.this.code.emitOpTwoBytes(17, ival);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 1: {
                    long lval = ((Number)this.value).longValue();
                    if (lval == 0L || lval == 1L) {
                        Items.this.code.emitOp(9 + (int)lval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 2: {
                    float fval = ((Number)this.value).floatValue();
                    if ((double)fval == 0.0 || (double)fval == 1.0 || (double)fval == 2.0) {
                        Items.this.code.emitOp(11 + (int)fval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 3: {
                    double dval = ((Number)this.value).doubleValue();
                    if (dval == 0.0 || dval == 1.0) {
                        Items.this.code.emitOp(14 + (int)dval);
                        break;
                    }
                    this.ldc();
                    break;
                }
                case 4: {
                    this.ldc();
                    break;
                }
                default: {
                    throw new InternalError("load");
                }
            }
            return Items.this.STACK_ITEM[this.typecode];
        }

        CondItem mkCond() {
            int ival = ((Number)this.value).intValue();
            return Items.this.makeCondItem(ival != 0 ? 167 : 168);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            switch (targetcode) {
                case 0: {
                    if (Code.truncate(this.typecode) == 0) {
                        return this;
                    }
                    return new ImmediateItem(Type.INT_TYPE, new Integer(((Number)this.value).intValue()));
                }
                case 1: {
                    return new ImmediateItem(Type.LONG_TYPE, new Long(((Number)this.value).longValue()));
                }
                case 2: {
                    return new ImmediateItem(Type.FLOAT_TYPE, new Float(((Number)this.value).floatValue()));
                }
                case 3: {
                    return new ImmediateItem(Type.DOUBLE_TYPE, new Double(((Number)this.value).doubleValue()));
                }
                case 5: {
                    return new ImmediateItem(Type.BYTE_TYPE, new Integer((byte)((Number)this.value).intValue()));
                }
                case 6: {
                    return new ImmediateItem(Type.CHAR_TYPE, new Integer((char)((Number)this.value).intValue()));
                }
                case 7: {
                    return new ImmediateItem(Type.SHORT_TYPE, new Integer((short)((Number)this.value).intValue()));
                }
            }
            return super.coerce(targetcode);
        }
    }

    class MemberItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Symbol member;
        boolean nonvirtual;

        MemberItem(Symbol member, boolean nonvirtual) {
            super(Code.typecode(member.erasure()));
            this.member = member;
            this.nonvirtual = nonvirtual;
        }

        Item load() {
            Items.this.code.emitOp(180, Code.width(this.typecode) - 1);
            Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            return Items.this.STACK_ITEM[this.typecode];
        }

        Item store() {
            Items.this.code.emitOp(181, -Code.width(this.typecode) - 1);
            Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            return Items.this.VOID_ITEM;
        }

        Item invoke() {
            Type.MethodType methodType = (Type.MethodType)this.member.externalType();
            int argSize = Code.width(methodType.paramTypes) + 1;
            int resultCode = Code.typecode(methodType.returnType);
            int stackDifference = Code.width(resultCode) - argSize;
            if ((this.member.owner.flags() & 0x200) != 0) {
                Items.this.code.emitOp(185, stackDifference);
                Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
                Items.this.code.emitOneByte(argSize);
                Items.this.code.emitOneByte(0);
            } else if (this.nonvirtual) {
                Items.this.code.emitOp(183, stackDifference);
                Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            } else {
                Items.this.code.emitOp(182, stackDifference);
                Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            }
            return Items.this.STACK_ITEM[resultCode];
        }

        void duplicate() {
            Items.this.STACK_ITEM[4].duplicate();
        }

        void drop() {
            Items.this.STACK_ITEM[4].drop();
        }

        void stash(int toscode) {
            Items.this.STACK_ITEM[4].stash(toscode);
        }
    }

    class StaticItem
    extends Item
    implements ByteCodes,
    TypeTags {
        Symbol member;

        StaticItem(Symbol member) {
            super(Code.typecode(member.erasure()));
            this.member = member;
        }

        Item load() {
            Items.this.code.emitOp(178, Code.width(this.typecode));
            Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            return Items.this.STACK_ITEM[this.typecode];
        }

        Item store() {
            Items.this.code.emitOp(179, -Code.width(this.typecode));
            Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            return Items.this.VOID_ITEM;
        }

        Item invoke() {
            Type.MethodType mtype = (Type.MethodType)this.member.erasure();
            int argsize = Code.width(mtype.paramTypes);
            int rescode = Code.typecode(mtype.returnType);
            int sdiff = Code.width(rescode) - argsize;
            Items.this.code.emitOp(184, sdiff);
            Items.this.code.emitTwoBytes(Items.this.constantPool.put(this.member));
            return Items.this.STACK_ITEM[rescode];
        }
    }

    class LocalItem
    extends Item
    implements ByteCodes,
    TypeTags {
        int adr;
        Type type;

        LocalItem(Type type, int adr) {
            super(Code.typecode(type));
            Asserter._assert(adr >= 0);
            this.type = type;
            this.adr = adr;
        }

        Item load() {
            int reg = Items.this.code.regOf(this.adr);
            if (reg <= 3) {
                Items.this.code.emitOp(26 + Code.truncate(this.typecode) * 4 + reg);
            } else {
                Items.this.code.emitOpOneByteAndWiden(21 + Code.truncate(this.typecode), reg);
            }
            return Items.this.STACK_ITEM[this.typecode];
        }

        Item store() {
            int reg = Items.this.code.regOf(this.adr);
            if (reg <= 3) {
                Items.this.code.emitOp(59 + Code.truncate(this.typecode) * 4 + reg);
            } else {
                Items.this.code.emitOpOneByteAndWiden(54 + Code.truncate(this.typecode), reg);
            }
            return Items.this.VOID_ITEM;
        }

        void incr(int x) {
            if (this.typecode == 0) {
                int reg = Items.this.code.regOf(this.adr);
                Items.this.code.emitOpOneByteAndWiden(132, reg);
                if (reg > 255) {
                    Items.this.code.emitTwoBytes(x);
                } else {
                    Items.this.code.emitOneByte(x);
                }
            } else {
                this.load();
                Items.this.makeImmediateItem(Type.INT_TYPE, new Integer(x)).load();
                Items.this.code.emitOp(96);
                Items.this.makeStackItem(Type.INT_TYPE).coerce(this.typecode);
                this.store();
            }
        }
    }

    class SelfItem
    extends Item
    implements ByteCodes,
    TypeTags {
        boolean isSuper;

        SelfItem(boolean isSuper) {
            super(4);
            this.isSuper = isSuper;
        }

        Item load() {
            Items.this.code.emitOp(42);
            return Items.this.STACK_ITEM[this.typecode];
        }
    }

    class IndexedItem
    extends Item
    implements ByteCodes,
    TypeTags {
        final Type type;

        IndexedItem(Type type) {
            super(Code.typecode(type));
            this.type = type;
        }

        Item load() {
            Items.this.code.emitOp(46 + this.typecode);
            return Items.this.STACK_ITEM[this.typecode];
        }

        Item store() {
            Items.this.code.emitOp(79 + this.typecode);
            return Items.this.VOID_ITEM;
        }

        void duplicate() {
            Items.this.code.emitOp(92);
        }

        void drop() {
            Items.this.code.emitOp(88);
        }

        void stash(int toscode) {
            Items.this.code.emitOp(91 + 3 * (Code.width(toscode) - 1));
        }
    }

    class StackItem
    extends Item
    implements ByteCodes,
    TypeTags {
        StackItem(int typecode) {
            super(typecode);
        }

        Item load() {
            return this;
        }

        void duplicate() {
            Items.this.code.emitOp(Code.width(this.typecode) == 2 ? 92 : 89);
        }

        void drop() {
            Items.this.code.emitOp(Code.width(this.typecode) == 2 ? 88 : 87);
        }

        void stash(int toscode) {
            Items.this.code.emitOp((Code.width(this.typecode) == 2 ? 91 : 90) + 3 * (Code.width(toscode) - 1));
        }
    }

    class Item
    implements ByteCodes,
    TypeTags {
        final int typecode;

        Item(int typecode) {
            this.typecode = typecode;
        }

        Item load() {
            throw new InternalError();
        }

        Item store() {
            throw new InternalError("store unsupported: " + this);
        }

        Item invoke() {
            throw new InternalError();
        }

        void duplicate() {
        }

        void drop() {
        }

        void stash(int toscode) {
            Items.this.STACK_ITEM[toscode].duplicate();
        }

        CondItem mkCond() {
            this.load();
            return Items.this.makeCondItem(154);
        }

        Item coerce(int targetcode) {
            if (this.typecode == targetcode) {
                return this;
            }
            this.load();
            int typecode1 = Code.truncate(this.typecode);
            int targetcode1 = Code.truncate(targetcode);
            if (typecode1 != targetcode1) {
                int offset = targetcode1 > typecode1 ? targetcode1 - 1 : targetcode1;
                Items.this.code.emitOp(133 + typecode1 * 3 + offset);
            }
            if (targetcode != targetcode1) {
                Items.this.code.emitOp(145 + targetcode - 5);
            }
            return Items.this.STACK_ITEM[targetcode];
        }

        Item coerce(Type targettype) {
            if (this.typecode == 0) {
                // empty if block
            }
            return this.coerce(Code.typecode(targettype));
        }
    }
}

