/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.ClassReader;
import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeInferrer;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameResolver
implements Flags,
Kinds,
TypeTags {
    static final int AMBIGUOUS = 256;
    static final int HIDDEN = 257;
    static final int ABSENT_VAR = 258;
    static final int WRONG_MTH = 259;
    static final int ABSENT_MTH = 260;
    static final int ABSENT_TYP = 261;
    ErrorLog errorLog;
    SymbolTable symbolTable;
    TypeInferrer typeInferrer;
    private ListBox<Type> typeArgs = new ListBox();

    public NameResolver(ErrorLog log, SymbolTable syms, TypeInferrer infer) {
        this.symbolTable = syms;
        this.errorLog = log;
        this.typeInferrer = infer;
    }

    boolean accessible(Environment<AnalyzerContext> env, Symbol.TypeSymbol c) {
        switch (c.flags() & 7) {
            case 2: {
                return env.enclosingClass.classSymbol.outermostClass() == c.owner.outermostClass();
            }
            case 0: {
                return env.topLevel.packageSymbol == c.owner || env.topLevel.packageSymbol == c.outermostClass().owner;
            }
            case 1: {
                return true;
            }
            case 4: {
                return env.topLevel.packageSymbol == c.owner || env.topLevel.packageSymbol == c.outermostClass().owner || env.enclosingClass.classSymbol.subclass(c.owner);
            }
        }
        throw new InternalError();
    }

    boolean accessible(Environment<AnalyzerContext> env, Type site, Symbol sym) {
        if (sym.name == Names.init && sym.owner != site.typeSymbol) {
            return false;
        }
        switch (sym.flags() & 7) {
            case 2: {
                return env.enclosingClass.classSymbol == sym.owner || env.enclosingClass.classSymbol.outermostClass() == sym.owner.outermostClass();
            }
            case 0: {
                return env.topLevel.packageSymbol == sym.owner.owner || env.topLevel.packageSymbol == sym.outermostClass().owner;
            }
            case 4: {
                return env.topLevel.packageSymbol == sym.owner.owner || env.topLevel.packageSymbol == sym.outermostClass().owner || env.enclosingClass.classSymbol.subclass(sym.owner) && site.typeSymbol.subclass(env.enclosingClass.classSymbol) || ((AnalyzerContext)env.context).isSuperSelector;
            }
        }
        return this.accessible(env, site.typeSymbol);
    }

    Type instantiate(Type site, Symbol m, ListBox<Type> typeParamsBox, List<Type> argtypes) {
        List<Type> undetTvars;
        Type mt0 = site.memberType(m);
        List<Type> tvars = Type.EMPTY_LIST;
        if (mt0.tag == 15) {
            tvars = ((Type.ForAll)mt0).typeParams;
            mt0 = ((Type.ForAll)mt0).quantifiedType;
        }
        Type.MethodType mt = (Type.MethodType)mt0;
        List<Type> formals = mt.paramTypes;
        Type restype = mt.returnType;
        List<Type> list = undetTvars = typeParamsBox.isEmpty() ? tvars : Type.EMPTY_LIST;
        if (m.name == Names.init) {
            restype = site;
            tvars = m.owner.type.getTypeParams();
            undetTvars = Type.EMPTY_LIST;
            if (site.enclosingType().tag == 10) {
                formals = formals.cons(site.enclosingType());
                List<Type> outerParams = site.enclosingType().allParams();
                tvars = tvars.append(outerParams);
            }
        } else if (!m.isStatic() && site.occurrencesCount(Type.ALL_TYPE) >= 1) {
            formals = m.type.argTypes().cons(m.owner.type);
            argtypes = argtypes.cons(site);
            List<Type> ownerParams = m.owner.type.allParams();
            tvars = tvars.append(ownerParams);
            undetTvars = undetTvars.append(ownerParams);
        }
        if (tvars.nonEmpty()) {
            if (undetTvars.nonEmpty()) {
                List<Type> infTvars = this.typeInferrer.typeParams(undetTvars, formals, argtypes);
                if (infTvars == null) {
                    return null;
                }
                typeParamsBox.insertEltsEnd(infTvars);
            }
            List<Type> typeParams = typeParamsBox.toList();
            formals = Type.substitute(formals, tvars, typeParams);
            restype = restype.substitute(tvars, typeParams);
        }
        if (Type.subTypes(argtypes, formals)) {
            return restype;
        }
        return null;
    }

    boolean asGood(Environment<AnalyzerContext> env, Type site, Symbol a, Symbol b) {
        return a.kind < b.kind || a.kind == b.kind && (!this.accessible(env, site, b) || this.accessible(env, site, a) && (((a.flags() | b.flags()) & 8) != 0 || (b.owner.flags() & 0x200) != 0 || a.owner.subclass(b.owner)) && this.instantiate(site, b, new ListBox<Type>(), site.memberType(a).argTypes()) != null);
    }

    Symbol findField(Environment<AnalyzerContext> env, Type site, Symbol.TypeSymbol c, Name name) {
        Symbol sym = ResolveError.varNotFound;
        Scope.Entry e = c.members().lookup(name);
        while (e.scope != null && sym.kind > 257) {
            if (e.symbol.kind == 4) {
                sym = this.accessible(env, site, e.symbol) ? e.symbol : new AccessError(e.symbol);
            }
            e = e.next();
        }
        if (sym.kind > 257) {
            Symbol sym1;
            Type superType = c.type.getSuperType();
            if (superType != null && superType.tag == 10) {
                sym1 = this.findField(env, site, superType.typeSymbol, name);
                if (sym1.kind < sym.kind) {
                    sym = sym1;
                }
            }
            List<Type> l = c.type.getInterfaces();
            while (sym.kind != 256 && l.nonEmpty()) {
                sym1 = this.findField(env, site, l.getFirst().typeSymbol, name);
                if (sym.kind < 256 && sym1.kind < 256 && sym.owner != sym1.owner) {
                    sym = new AmbiguityError(sym, sym1);
                } else if (sym1.kind < sym.kind) {
                    sym = sym1;
                }
                l = l.getRest();
            }
        }
        return sym;
    }

    Symbol findVar(Environment<AnalyzerContext> env, Name name) {
        Symbol sym1;
        ResolveError sym = ResolveError.varNotFound;
        Environment<AnalyzerContext> env1 = env;
        boolean staticOnly = false;
        while (env1.enclosingClassEnv != null) {
            if (NameResolver.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AnalyzerContext)env1.context).scope.lookup(name);
            while (e.scope != null) {
                sym1 = e.symbol;
                if (sym1.kind == 4) {
                    if (staticOnly && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                        return new StaticError(sym1);
                    }
                    return sym1;
                }
                e = e.next();
            }
            sym1 = this.findField(env1, env1.enclosingClass.classSymbol.type, env1.enclosingClass.classSymbol, name);
            if (sym1.kind < 258) {
                if (staticOnly && sym1.kind != 256 && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                    return new StaticError(sym1);
                }
                return sym1;
            }
            if ((env1.enclosingClass.classSymbol.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.enclosingClassEnv;
        }
        sym1 = this.findField(env, this.symbolTable.predefinedSymbolOwner.type, this.symbolTable.predefinedSymbolOwner, name);
        if (sym1.kind <= 256) {
            return sym1;
        }
        return sym;
    }

    Symbol findInterfaceMethod(Environment<AnalyzerContext> env, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes, Symbol.ClassSymbol c, Symbol bestSoFar) {
        List<Type> l = c.type.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)l.getFirst().typeSymbol;
            Scope.Entry e = i.members().lookup(name);
            while (e.scope != null) {
                if (e.symbol.kind == 16) {
                    if (this.instantiate(site, e.symbol, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, e.symbol)) {
                        bestSoFar = e.symbol;
                    } else if (bestSoFar.kind > 259) {
                        bestSoFar = ResolveError.wrongMethod;
                    }
                }
                e = e.next();
            }
            bestSoFar = this.findInterfaceMethod(env, site, name, typarams, argtypes, i, bestSoFar);
            l = l.getRest();
        }
        return bestSoFar;
    }

    Symbol checkBestInterfaceMethod(Environment<AnalyzerContext> env, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes, Symbol.ClassSymbol c, Symbol bestSoFar) {
        List<Type> l = c.type.getInterfaces();
        while (bestSoFar.kind == 16 && l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)l.getFirst().typeSymbol;
            Scope.Entry e = i.members().lookup(name);
            while (bestSoFar.kind == 16 && e.scope != null) {
                if (e.symbol.kind == 16 && this.instantiate(site, e.symbol, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, e.symbol)) {
                    bestSoFar = new AmbiguityError(bestSoFar, e.symbol);
                }
                e = e.next();
            }
            bestSoFar = this.checkBestInterfaceMethod(env, site, name, typarams, argtypes, i, bestSoFar);
            l = l.getRest();
        }
        return bestSoFar;
    }

    Symbol findMethod(Environment<AnalyzerContext> env, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
        Scope.Entry e;
        Symbol.ClassSymbol c;
        Symbol bestSoFar = ResolveError.methodNotFound;
        Type ct = site.typeSymbol.type;
        boolean isAbstract = true;
        do {
            if (((c = (Symbol.ClassSymbol)ct.typeSymbol).flags() & 0x600) == 0) {
                isAbstract = false;
            }
            e = c.members().lookup(name);
            while (e.scope != null) {
                if (e.symbol.kind == 16) {
                    if (this.instantiate(site, e.symbol, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, e.symbol)) {
                        bestSoFar = e.symbol;
                    } else if (bestSoFar.kind > 259) {
                        bestSoFar = ResolveError.wrongMethod;
                    }
                }
                e = e.next();
            }
            if (!isAbstract) continue;
            bestSoFar = this.findInterfaceMethod(env, site, name, typarams, argtypes, c, bestSoFar);
        } while ((ct = ct.getSuperType()) != null && ct.tag == 10);
        if (bestSoFar.kind == 16 && !this.accessible(env, site, bestSoFar)) {
            bestSoFar = new AccessError(bestSoFar);
        }
        ct = site.typeSymbol.type;
        isAbstract = true;
        while (bestSoFar.kind == 16 && ct.tag == 10) {
            c = (Symbol.ClassSymbol)ct.typeSymbol;
            if ((c.flags() & 0x600) == 0) {
                isAbstract = false;
            }
            e = c.members().lookup(name);
            while (bestSoFar.kind == 16 && e.scope != null) {
                if (bestSoFar != e.symbol && e.symbol.kind == 16 && this.instantiate(site, e.symbol, typarams, argtypes) != null && !this.asGood(env, site, bestSoFar, e.symbol)) {
                    bestSoFar = new AmbiguityError(bestSoFar, e.symbol);
                }
                e = e.next();
            }
            if (bestSoFar.kind == 16 && isAbstract) {
                bestSoFar = this.checkBestInterfaceMethod(env, site, name, typarams, argtypes, c, bestSoFar);
            }
            ct = ct.getSuperType();
        }
        return bestSoFar;
    }

    Symbol findFun(Environment<AnalyzerContext> env, Name name, ListBox<Type> typarams, List<Type> argtypes) {
        Symbol sym1;
        ResolveError sym = ResolveError.methodNotFound;
        Environment<AnalyzerContext> env1 = env;
        boolean staticOnly = false;
        while (env1.enclosingClassEnv != null) {
            if (NameResolver.isStatic(env1)) {
                staticOnly = true;
            }
            sym1 = this.findMethod(env1, env1.enclosingClass.classSymbol.type, name, typarams, argtypes);
            if (sym1.kind < 260) {
                if (staticOnly && sym1.kind < 256 && sym1.owner.kind == 2 && (sym1.flags() & 8) == 0) {
                    return new StaticError(sym1);
                }
                return sym1;
            }
            if ((env1.enclosingClass.classSymbol.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.enclosingClassEnv;
        }
        sym1 = this.findMethod(env, this.symbolTable.predefinedSymbolOwner.type, name, typarams, argtypes);
        if (sym1.kind <= 256) {
            return sym1;
        }
        return sym;
    }

    Symbol loadClass(Environment<AnalyzerContext> env, Name name) {
        try {
            Symbol.ClassSymbol c = this.symbolTable.classReader.loadClass(name);
            if (this.accessible(env, c)) {
                return c;
            }
            return new AccessError(c);
        }
        catch (ClassReader.LoadError err) {
            throw err;
        }
        catch (Symbol.CompletionFailure ex) {
            return ResolveError.typeNotFound;
        }
    }

    Symbol findMemberType(Environment<AnalyzerContext> env, Type site, Name name) {
        Symbol sym = ResolveError.typeNotFound;
        Symbol.ClassSymbol c = (Symbol.ClassSymbol)site.typeSymbol;
        Scope s = c.members();
        if (s != null) {
            Scope.Entry e = c.members().lookup(name);
            while (e.scope != null && sym.kind > 257) {
                if (e.symbol.kind == 2) {
                    sym = this.accessible(env, site, e.symbol) ? e.symbol : new AccessError(e.symbol);
                }
                e = e.next();
            }
            if (sym.kind > 257) {
                Type superType = c.type.getSuperType();
                if (superType.tag == 10) {
                    Symbol sym1 = this.findMemberType(env, superType, name);
                    if (sym1.kind < sym.kind) {
                        sym = sym1;
                    }
                }
            }
        }
        return sym;
    }

    Symbol findGlobalType(Environment<AnalyzerContext> env, Scope scope, Name name, boolean topOnly) {
        Symbol sym = ResolveError.typeNotFound;
        Scope.Entry e = scope.lookup(name);
        while (e.scope != null) {
            if (!topOnly || e.symbol.owner.kind == 1) {
                Symbol sym1 = this.loadClass(env, e.symbol.flatName());
                if (sym.kind == 2 && sym1.kind == 2 && sym != sym1) {
                    return new AmbiguityError(sym, sym1);
                }
                if (sym1.kind < sym.kind) {
                    sym = sym1;
                }
            }
            e = e.next();
        }
        return sym;
    }

    Symbol findType(Environment<AnalyzerContext> env, Name name) {
        Symbol sym1;
        Symbol sym = ResolveError.typeNotFound;
        Environment<AnalyzerContext> env1 = env;
        boolean staticOnly = false;
        while (env1.enclosingClassEnv != null) {
            if (NameResolver.isStatic(env1)) {
                staticOnly = true;
            }
            Scope.Entry e = ((AnalyzerContext)env1.context).scope.lookup(name);
            while (e.scope != null) {
                if (e.symbol.kind == 2) {
                    if (staticOnly && e.symbol.type.tag == 14 && e.symbol.owner.kind == 2) {
                        return new StaticError(e.symbol);
                    }
                    return e.symbol;
                }
                e = e.next();
            }
            sym1 = this.findMemberType(env1, env1.enclosingClass.classSymbol.type, name);
            if (sym1.kind < 261) {
                return sym1;
            }
            if ((env1.enclosingClass.classSymbol.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.enclosingClassEnv;
        }
        sym1 = this.findGlobalType(env, env.topLevel.namedImportScope, name, false);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        sym1 = this.findGlobalType(env, env.topLevel.packageSymbol.members(), name, true);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        sym1 = this.findGlobalType(env, env.topLevel.starImportScope, name, false);
        if (sym1.kind <= 256) {
            return sym1;
        }
        if (sym1.kind < sym.kind) {
            sym = sym1;
        }
        return sym;
    }

    Symbol findIdent(Environment<AnalyzerContext> env, Name name, int kind) {
        Symbol sym = ResolveError.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findVar(env, name);
        }
        if (sym.kind > 256 && (kind & 2) != 0) {
            Symbol sym1 = this.findType(env, name);
            if (sym1.kind < sym.kind) {
                sym = sym1;
            }
        }
        if (sym.kind > 256 && (kind & 1) != 0) {
            sym = this.symbolTable.classReader.enterPackage(name);
        }
        return sym;
    }

    Symbol findIdentInPackage(Environment<AnalyzerContext> env, Symbol.TypeSymbol pck, Name name, int kind) {
        Name fullname = Symbol.TypeSymbol.formFullName(name, pck);
        Symbol sym = ResolveError.typeNotFound;
        if ((kind & 2) != 0) {
            sym = this.loadClass(env, fullname);
        }
        if (sym.kind > 257 && (kind & 1) != 0) {
            sym = this.symbolTable.classReader.enterPackage(fullname);
        }
        return sym;
    }

    Symbol findIdentInType(Environment<AnalyzerContext> env, Type site, Name name, int kind) {
        Symbol sym = ResolveError.typeNotFound;
        if ((kind & 4) != 0) {
            sym = this.findField(env, site, site.typeSymbol, name);
        }
        if (sym.kind > 256 && (kind & 2) != 0) {
            Symbol sym1 = this.findMemberType(env, site, name);
            if (sym1.kind < sym.kind) {
                sym = sym1;
            }
        }
        return sym;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
        if (sym.kind >= 256) {
            if (!site.isErroneous() && !Type.isErroneous(argtypes)) {
                ((ResolveError)sym).report(this.errorLog, pos, site, name, typarams, argtypes);
            }
            return ((ResolveError)sym).sym;
        }
        return sym;
    }

    Symbol access(Symbol sym, int pos, Type site, Name name) {
        if (sym.kind >= 256) {
            return this.access(sym, pos, site, name, new ListBox<Type>(), Type.EMPTY_LIST);
        }
        return sym;
    }

    static boolean isStatic(Environment<AnalyzerContext> env) {
        return ((AnalyzerContext)env.context).staticLevel > ((AnalyzerContext)env.enclosingClassEnv.context).staticLevel;
    }

    static int staticLevel(Symbol sym) {
        int level = 0;
        do {
            if ((sym.flags() & 8) != 0) {
                ++level;
            }
            sym = sym.owner;
        } while (sym.kind != 1);
        return level;
    }

    void checkNonAbstract(int pos, Symbol sym) {
        if ((sym.flags() & 0x400) != 0) {
            this.errorLog.error(pos, new StringBuffer().append("abstract ").append(sym).append(" cannot be accessed directly").toString());
        }
    }

    public static void printscopes(Scope s) {
        while (s != null) {
            if (s.owningSymbol != null) {
                Scope.Entry e = s.entries;
                while (e != null) {
                    if ((e.symbol.flags() & 0x400) != 0) {
                        // empty if block
                    }
                    e = e.sibling;
                }
            }
            s = s.nextScope;
        }
    }

    static void printscopes(Environment<AnalyzerContext> env) {
        while (env.enclosingClassEnv != null) {
            NameResolver.printscopes(((AnalyzerContext)env.context).scope);
            env = env.enclosingClassEnv;
        }
    }

    Symbol resolveIdent(int pos, Environment<AnalyzerContext> env, Name name, int kind) {
        return this.access(this.findIdent(env, name, kind), pos, env.enclosingClass.classSymbol.type, name);
    }

    Symbol resolveMethod(int pos, Environment<AnalyzerContext> env, Name name, ListBox<Type> typarams, List<Type> argtypes) {
        return this.access(this.findFun(env, name, typarams, argtypes), pos, env.enclosingClass.classSymbol.type, name, typarams, argtypes);
    }

    Symbol resolveQualifiedMethod(int pos, Environment<AnalyzerContext> env, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
        return this.access(this.findMethod(env, site, name, typarams, argtypes), pos, site, name, typarams, argtypes);
    }

    Symbol resolveSelf(int pos, Environment<AnalyzerContext> env, Symbol.TypeSymbol c, Name name) {
        Environment<AnalyzerContext> env1 = env;
        boolean staticOnly = false;
        while (env1.enclosingClassEnv != null) {
            Symbol sym;
            if (NameResolver.isStatic(env1)) {
                staticOnly = true;
            }
            if (env1.enclosingClass.classSymbol.subclass(c) && (sym = ((AnalyzerContext)env1.context).scope.lookup((Name)name).symbol) != null) {
                if (staticOnly) {
                    sym = new StaticError(sym);
                }
                return this.access(sym, pos, env.enclosingClass.classSymbol.type, name);
            }
            if ((env1.enclosingClass.classSymbol.flags() & 8) != 0) {
                staticOnly = true;
            }
            env1 = env1.enclosingClassEnv;
        }
        this.errorLog.error(pos, new StringBuffer().append("not an enclosing class: ").append(c.fullName()).toString());
        return Symbol.ERROR_SYMBOL;
    }

    Symbol resolveConstructor(int pos, Environment<AnalyzerContext> env, Type site, ListBox<Type> typaramsCell, List<Type> argtypes) {
        return this.access(this.findMethod(env, site, Names.init, typaramsCell, argtypes), pos, site.typeSymbol.type, Names.init, typaramsCell, argtypes);
    }

    Symbol resolveSelfConstructor(int pos, Environment<AnalyzerContext> env, Name name, List<Type> argtypes) {
        Type site = env.enclosingClass.classSymbol.type;
        if (name == Names._super) {
            site = site.getSuperType();
        }
        boolean selectSuperPrev = ((AnalyzerContext)env.context).isSuperSelector;
        ((AnalyzerContext)env.context).isSuperSelector = true;
        Symbol.ClassSymbol sym = site.tag == 10 ? this.resolveConstructor(pos, env, site.typeSymbol.type, new ListBox<Type>(site.getTypeParams()), argtypes) : Symbol.ERROR_SYMBOL;
        ((AnalyzerContext)env.context).isSuperSelector = selectSuperPrev;
        return sym;
    }

    Symbol resolveOperator(int pos, int opcode, Environment<AnalyzerContext> env, List<Type> argtypes) {
        Name name = TreeInspector.operatorName(opcode);
        return this.access(this.findMethod(env, this.symbolTable.predefinedSymbolOwner.type, name, new ListBox<Type>(), argtypes), pos, env.enclosingClass.classSymbol.type, name, new ListBox<Type>(), argtypes);
    }

    static String kindName(int kind) {
        switch (kind) {
            case 1: {
                return "package";
            }
            case 2: {
                return "class";
            }
            case 4: {
                return "variable";
            }
            case 12: {
                return "value";
            }
            case 16: {
                return "method";
            }
        }
        return new StringBuffer().append("identifier(").append(kind).append(")").toString();
    }

    static String kindNames(int kind) {
        String[] s = new String[4];
        int i = 0;
        if ((kind & 0xC) != 0) {
            String string = s[i++] = (kind & 0xC) == 4 ? "variable" : "value";
        }
        if ((kind & 0x10) != 0) {
            s[i++] = "method";
        }
        if ((kind & 2) != 0) {
            s[i++] = "class";
        }
        if ((kind & 1) != 0) {
            s[i++] = "package";
        }
        String names = "";
        for (int j = 0; j < i - 2; ++j) {
            names = new StringBuffer().append(names).append(s[j]).append(", ").toString();
        }
        if (i >= 2) {
            names = new StringBuffer().append(names).append(s[i - 2]).append(" or ").toString();
        }
        names = i >= 1 ? new StringBuffer().append(names).append(s[i - 1]).toString() : "identifier";
        return names;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AmbiguityError
    extends ResolveError {
        Symbol sym1;
        Symbol sym2;

        AmbiguityError(Symbol sym1, Symbol sym2) {
            super(256);
            this.sym1 = sym1;
            this.sym2 = sym2;
        }

        @Override
        void report(ErrorLog log, int pos, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
            Name sname = this.sym1.name;
            if (sname == Names.init) {
                sname = this.sym1.owner.name;
            }
            log.error(pos, new StringBuffer().append("reference to ").append(sname).append(" is ambiguous, both ").append(this.sym1).append(this.sym1.location()).append(" and ").append(this.sym2).append(this.sym2.location()).append(" match").toString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StaticError
    extends ResolveError {
        StaticError(Symbol sym) {
            super(257);
            this.sym = sym;
        }

        @Override
        void report(ErrorLog log, int pos, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
            log.error(pos, new StringBuffer().append("non-static ").append(this.sym).append(" cannot be referenced from a static context").toString());
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class AccessError
    extends ResolveError {
        AccessError(Symbol sym) {
            super(257);
            this.sym = sym;
        }

        @Override
        void report(ErrorLog log, int pos, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
            if (this.sym.name == Names.init && this.sym.owner != site.typeSymbol) {
                ResolveError.methodNotFound.report(log, pos, site, name, typarams, argtypes);
            } else if ((this.sym.flags() & 1) != 0) {
                log.error(pos, new StringBuffer().append(this.sym).append(this.sym.location()).append(" is not defined in a public class or interface").append("; cannot be accessed from outside package").toString());
            } else if ((this.sym.flags() & 6) != 0) {
                log.error(pos, new StringBuffer().append(this.sym).append(" has ").append(TreeInspector.flagNames(this.sym.flags() & 6)).append(" access").append(this.sym.location()).toString());
            } else {
                log.error(pos, new StringBuffer().append(this.sym).append(" is not public").append(this.sym.location()).append("; cannot be accessed from outside package").toString());
            }
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ResolveError
    extends Symbol
    implements TypeTags {
        static final ResolveError varNotFound = new ResolveError(258);
        static final ResolveError wrongMethod = new ResolveError(259);
        static final ResolveError methodNotFound = new ResolveError(260);
        static final ResolveError typeNotFound = new ResolveError(261);
        Symbol sym = Symbol.ERROR_SYMBOL;

        ResolveError(int kind) {
            super(kind, 0, null, null, null);
        }

        void report(ErrorLog log, int pos, Type site, Name name, ListBox<Type> typarams, List<Type> argtypes) {
            if (name != Names.error) {
                String kindname = this.absentKindName(this.kind);
                String idname = name.toString();
                String targs = "";
                String args = "";
                if (this.kind == 260 || this.kind == 259) {
                    if (name == Names.init) {
                        kindname = "constructor";
                        idname = site.typeSymbol.name.toString();
                        if (site.enclosingType().tag == 10) {
                            idname = new StringBuffer().append("(").append(argtypes.getFirst()).append(")").append(idname).toString();
                            argtypes = argtypes.getRest();
                        }
                    }
                    if (typarams.nonEmpty()) {
                        targs = new StringBuffer().append("<").append(typarams).append(">").toString();
                    }
                    args = new StringBuffer().append("(").append(argtypes).append(")").toString();
                }
                log.error(pos, new StringBuffer().append(kindname).append(" ").append(idname).append(targs).append(args).append(" not found").append(site.typeSymbol.name.length != 0 ? new StringBuffer().append(" in ").append(site.typeSymbol).toString() : "").toString());
            }
        }

        private String absentKindName(int kind) {
            switch (kind) {
                case 258: {
                    return "variable";
                }
                case 259: 
                case 260: {
                    return "method";
                }
                case 261: {
                    return "class";
                }
            }
            return "identifier";
        }
    }
}

