/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Scope;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.AnalyzerContext;
import edu.rice.cs.nextgen.compiler.comp.ConstantFolder;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.NameResolver;
import edu.rice.cs.nextgen.compiler.comp.SymbolEnterer;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.comp.TypeChecker;
import edu.rice.cs.nextgen.compiler.comp.TypeInferrer;
import edu.rice.cs.nextgen.compiler.tree.PrettyPrinter;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.tree.TreeInspector;
import edu.rice.cs.nextgen.compiler.tree.TreeMaker;
import edu.rice.cs.nextgen.compiler.util.Asserter;
import edu.rice.cs.nextgen.compiler.util.Cons;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.Name;
import edu.rice.cs.nextgen.compiler.util.Names;
import edu.rice.cs.nextgen.compiler.util.Set;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StaticAnalyzer
extends Tree.Visitor<Type, Environment<AnalyzerContext>>
implements Flags,
Kinds,
TypeTags {
    ErrorLog errorLog;
    SymbolTable symbolTable;
    NameResolver nameResolver;
    TypeChecker typeChecker;
    TypeInferrer typeInferrer;
    TreeMaker treeMaker;
    public SymbolEnterer symbolEnterer;
    public ConstantFolder constantFolder;
    ListBox<Type.MethodType> methTemplateSupply = new ListBox();

    public StaticAnalyzer(ErrorLog log, SymbolTable syms, NameResolver rs, TypeChecker chk, TypeInferrer infer, TreeMaker make, SymbolEnterer enter) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.nameResolver = rs;
        this.typeChecker = chk;
        this.typeInferrer = infer;
        this.treeMaker = make;
        this.symbolEnterer = enter;
        if (enter != null) {
            enter.staticAnalyzer = this;
        }
        this.constantFolder = new ConstantFolder(log, syms);
    }

    Type check(Tree tree, Type owntype, int ownkind, int pkind, Type pt) {
        if (owntype.tag != 18 && pt.tag != 12) {
            if ((ownkind & ~pkind) == 0) {
                if (pt.tag != 17) {
                    owntype = this.typeChecker.checkType(tree.sourcePosition, owntype, pt);
                }
            } else {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append(NameResolver.kindNames(pkind)).append(" required, but ").append(NameResolver.kindName(ownkind)).append(" found").toString());
                owntype = Type.ERROR_TYPE;
            }
        }
        tree.type = owntype;
        return owntype;
    }

    static boolean finalAssignable(Symbol.VarSymbol v, Environment<AnalyzerContext> env) {
        Symbol owner = ((AnalyzerContext)env.context).scope.owningSymbol;
        return v.constantValue == null && (v.owner == owner || (owner.name == Names.init || (owner.flags() & 0x80000) != 0) && v.owner == owner.owner && (v.flags() & 8) != 0 == NameResolver.isStatic(env));
    }

    void checkAssignable(int pos, Symbol.VarSymbol v, Tree base, Environment<AnalyzerContext> env) {
        if (!((v.flags() & 0x10) == 0 || (base == null || base.tag == 31 && TreeInspector.name(base) == Names._this) && StaticAnalyzer.finalAssignable(v, env))) {
            this.errorLog.error(pos, new StringBuffer().append("can't assign a value to final ").append(v).toString());
        }
    }

    void warnDeprecated(int pos, Symbol sym) {
        if (!this.symbolEnterer.compiled.contains(sym.enclClass().fullname)) {
            this.errorLog.warning(pos, new StringBuffer().append(sym).append(sym.location()).append(" has been deprecated").toString());
        }
    }

    Symbol thisSym(Environment<AnalyzerContext> env) {
        return this.nameResolver.resolveSelf(0, env, env.enclosingClass.classSymbol, Names._this);
    }

    List<Type> constructorArgs(int pos, Environment<AnalyzerContext> env, Type site, Type outer, List<Type> argtypes) {
        if (site.enclosingType().tag == 10) {
            if (outer == null) {
                Symbol outerthis = this.nameResolver.resolveSelf(pos, env, site.enclosingType().typeSymbol, Names._this);
                outer = outerthis.kind == 4 ? outerthis.owner.type : Type.ERROR_TYPE;
            }
            argtypes = argtypes.cons(outer);
        } else if (outer != null && outer.tag == 10 && site.tag != 18) {
            this.errorLog.error(pos, new StringBuffer().append("illegal qualifier; ").append(site.typeSymbol).append(" is not an inner class").toString());
        }
        return argtypes;
    }

    Type attributeTerm(Tree tree, Environment<AnalyzerContext> env, int pkind, Type pt) {
        try {
            ((AnalyzerContext)env.context).expectedKind = pkind;
            ((AnalyzerContext)env.context).expectedType = pt;
            return tree.accept(this, env);
        }
        catch (Symbol.CompletionFailure ex) {
            return this.typeChecker.completionError(tree.sourcePosition, ex);
        }
    }

    Type attributeExpression(Tree tree, Environment<AnalyzerContext> env, Type pt) {
        return this.attributeTerm(tree, env, 12, pt);
    }

    Type attributeExpression(Tree tree, Environment<AnalyzerContext> env) {
        return this.attributeExpression(tree, env, Type.NO_TYPE);
    }

    Type attributeType(Tree tree, Environment<AnalyzerContext> env) {
        return this.attributeTerm(tree, env, 2, Type.NO_TYPE);
    }

    Type attributeStatement(Tree tree, Environment<AnalyzerContext> env) {
        return this.attributeTerm(tree, env, 0, Type.NO_TYPE);
    }

    List<Type> attributeExpressions(List<Tree> trees, Environment<AnalyzerContext> env, Type pt) {
        ListBox<Type> ts = new ListBox<Type>();
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            ts.insertEnd(this.attributeExpression(l.getFirst(), env, pt));
            l = l.getRest();
        }
        return ts.toList();
    }

    <T extends Tree> void attributeStatements(List<T> trees, Environment<AnalyzerContext> env) {
        List<T> l = trees;
        while (l.nonEmpty()) {
            this.attributeStatement((Tree)l.getFirst(), env);
            l = l.getRest();
        }
    }

    List<Type> attributeArgs(List<Tree> trees, Environment<AnalyzerContext> env) {
        ListBox<Type> argtypes = new ListBox<Type>();
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            argtypes.insertEnd(this.typeChecker.checkNonVoid(l.getFirst().sourcePosition, this.attributeExpression(l.getFirst(), env)));
            l = l.getRest();
        }
        return argtypes.toList();
    }

    Type attributeBaseType(Tree tree, Environment<AnalyzerContext> env, int interfaceFlag) {
        Type t = this.typeChecker.checkClassType(tree.sourcePosition, this.attributeType(tree, env));
        if ((t.typeSymbol.flags() & 0x200) != interfaceFlag) {
            this.errorLog.error(tree.sourcePosition, new StringBuffer().append(interfaceFlag == 0 ? "no " : "").append("interface expected here").toString());
        }
        if ((t.typeSymbol.flags() & 0x10) != 0) {
            this.errorLog.error(tree.sourcePosition, new StringBuffer().append("can't inherit from final ").append(t.typeSymbol).toString());
        }
        return t;
    }

    private void addAbstractMethod(Tree.ClassDef cd, Symbol.MethodSymbol m, Environment<AnalyzerContext> env) {
        Tree.MethodDef def = this.treeMaker.at(cd.sourcePosition).newMethodDef(new Symbol.MethodSymbol(m.flags() | 0x100000, m.name, cd.classSymbol.type.memberType(m), cd.classSymbol), null);
        cd.members = cd.members.cons(def);
        this.symbolEnterer.memberEnter(def, env);
    }

    void implementInterfaceMethods(Symbol.ClassSymbol c, Environment<AnalyzerContext> env) {
        Tree.ClassDef cd = (Tree.ClassDef)env.tree;
        List<Type> l = c.type.getInterfaces();
        while (l.nonEmpty()) {
            Symbol.ClassSymbol i = (Symbol.ClassSymbol)l.getFirst().typeSymbol;
            Scope.Entry e = i.members().entries;
            while (e != null) {
                Symbol.MethodSymbol absMeth;
                Symbol.MethodSymbol implMeth;
                if (e.symbol.kind == 16 && (e.symbol.flags() & 8) == 0 && (implMeth = (absMeth = (Symbol.MethodSymbol)e.symbol).implementation(cd.classSymbol)) == null) {
                    this.addAbstractMethod(cd, absMeth, env);
                }
                e = e.sibling;
            }
            this.implementInterfaceMethods(i, env);
            l = l.getRest();
        }
    }

    @Override
    public Type _case(Tree.ClassDef tree, Environment<AnalyzerContext> env) {
        if ((((AnalyzerContext)env.context).scope.owningSymbol.kind & 0x14) != 0) {
            this.symbolEnterer.classEnter(tree, env);
        } else if (tree.name.length == 0) {
            System.out.println(((AnalyzerContext)env.context).scope.owningSymbol);
        }
        Symbol.ClassSymbol c = tree.classSymbol;
        if (c == null) {
            return null;
        }
        c.complete();
        this.analyzeClass(c);
        tree.type = c.type;
        return tree.type;
    }

    @Override
    public Type _case(Tree.MethodDef tree, Environment<AnalyzerContext> env) {
        Symbol.MethodSymbol m = tree.methodSymbol;
        this.typeChecker.checkOverride(tree.sourcePosition, m);
        Environment<AnalyzerContext> localEnv = this.symbolEnterer.methodEnv(tree, env);
        List<Tree> l = tree.typeParams;
        while (l.nonEmpty()) {
            ((AnalyzerContext)localEnv.context).scope.addSymbolIfAbsent(((Tree.TypeParameter)l.getFirst()).type.typeSymbol);
            l = l.getRest();
        }
        l = tree.params;
        while (l.nonEmpty()) {
            this.attributeStatement(l.getFirst(), localEnv);
            l = l.getRest();
        }
        this.typeChecker.validateTypeParams(tree.typeParams);
        this.typeChecker.validate(tree.returnType);
        l = tree.thrown;
        while (l.nonEmpty()) {
            this.typeChecker.checkType(l.getFirst().sourcePosition, l.getFirst().type, this.symbolTable.THROWABLE_TYPE);
            l = l.getRest();
        }
        Symbol.ClassSymbol owner = env.enclosingClass.classSymbol;
        if (tree.body == null) {
            if ((owner.flags() & 0x200) == 0 && (tree.flags & 0x500) == 0) {
                this.errorLog.error(tree.sourcePosition, "missing method body, or declare as abstract");
            }
        } else if ((owner.flags() & 0x200) != 0) {
            this.errorLog.error(tree.sourcePosition, "interface methods cannot have body");
        } else if ((tree.flags & 0x400) != 0) {
            this.errorLog.error(tree.sourcePosition, "abstract methods cannot have body");
        } else if ((tree.flags & 0x100) != 0) {
            this.errorLog.error(tree.sourcePosition, "native methods cannot have body");
        } else {
            if (tree.name == Names.init && owner.type != this.symbolTable.OBJECT_TYPE) {
                Tree.Block body = tree.body;
                if (body.statements.isEmpty() || !this.isSelfCall(body.statements.getFirst())) {
                    body.statements = body.statements.cons(SymbolEnterer.SuperCall(this.treeMaker.at(body.sourcePosition), Tree.VarDef.emptyList, false));
                }
            }
            this.attributeStatement(tree.body, localEnv);
        }
        ((AnalyzerContext)localEnv.context).scope.leave();
        tree.type = m.type;
        return tree.type;
    }

    private boolean isSelfCall(Tree tree) {
        if (tree.tag == 18) {
            Name mname;
            Tree.ExpressionStatement exec = (Tree.ExpressionStatement)tree;
            if (exec.expression.tag == 23 && ((mname = TreeInspector.name(((Tree.Apply)exec.expression).method)) == Names._this || mname == Names._super)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Type _case(Tree.VarDef tree, Environment<AnalyzerContext> env) {
        if (((AnalyzerContext)env.context).scope.owningSymbol.kind == 16) {
            this.symbolEnterer.memberEnter(tree, env);
        }
        this.typeChecker.validate(tree.varType);
        Symbol.VarSymbol v = tree.varSymbol;
        Asserter._assert(v != null, tree.name);
        if (tree.initialization != null) {
            v.position = Integer.MAX_VALUE;
            if ((v.flags_field & 0x10) != 0) {
                this.evalInit(v, env);
            } else {
                Type itype = this.attributeExpression(tree.initialization, this.symbolEnterer.initEnv(tree, env), v.type);
            }
            v.position = tree.sourcePosition;
        }
        tree.type = v.type;
        return tree.type;
    }

    @Override
    public Type _case(Tree.Block tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> localEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy(((AnalyzerContext)env.context).scope.extend()));
        if (((AnalyzerContext)env.context).scope.owningSymbol.kind == 2) {
            ((AnalyzerContext)localEnv.context).scope.owningSymbol = new Symbol.MethodSymbol(tree.flags | 0x80000, Names.empty, null, ((AnalyzerContext)env.context).scope.owningSymbol);
            if ((tree.flags & 8) != 0) {
                ++((AnalyzerContext)localEnv.context).staticLevel;
            }
        }
        this.attributeStatements(tree.statements, localEnv);
        ((AnalyzerContext)localEnv.context).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.DoLoop tree, Environment<AnalyzerContext> env) {
        this.attributeStatement(tree.body, env.spawn(tree));
        this.attributeExpression(tree.cond, env, Type.BOOLEAN_TYPE);
        return null;
    }

    @Override
    public Type _case(Tree.WhileLoop tree, Environment<AnalyzerContext> env) {
        this.attributeExpression(tree.condition, env, Type.BOOLEAN_TYPE);
        this.attributeStatement(tree.body, env.spawn(tree));
        return null;
    }

    @Override
    public Type _case(Tree.ForLoop tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> loopEnv = env.spawn(env.tree, ((AnalyzerContext)env.context).copy(((AnalyzerContext)env.context).scope.extend()));
        this.attributeStatements(tree.initializations, loopEnv);
        if (tree.conditions != null) {
            this.attributeExpression(tree.conditions, loopEnv, Type.BOOLEAN_TYPE);
        }
        loopEnv.tree = tree;
        this.attributeStatements(tree.incrementations, loopEnv);
        this.attributeStatement(tree.body, loopEnv);
        ((AnalyzerContext)loopEnv.context).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.Labelled tree, Environment<AnalyzerContext> env) {
        this.attributeStatement(tree.body, env.spawn(tree));
        return null;
    }

    @Override
    public Type _case(Tree.Switch tree, Environment<AnalyzerContext> env) {
        Type seltype = this.attributeExpression(tree.selector, env, Type.INT_TYPE);
        Environment<AnalyzerContext> switchEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy(((AnalyzerContext)env.context).scope.extend()));
        Set tags = Set.make();
        boolean hasDefault = false;
        List<Tree.Case> l = tree.cases;
        while (l.nonEmpty()) {
            Tree.Case c = l.getFirst();
            if (c.pattern != null) {
                Type pattype = this.attributeExpression(c.pattern, switchEnv, Type.INT_TYPE);
                if (pattype.tag != 18) {
                    if (pattype.constantValue == null) {
                        this.errorLog.error(c.pattern.sourcePosition, "constant expression required");
                    } else if (tags.contains(pattype.constantValue)) {
                        this.errorLog.error(c.sourcePosition, "duplicate case label");
                    } else {
                        tags.put(pattype.constantValue);
                    }
                }
            } else if (hasDefault) {
                this.errorLog.error(c.sourcePosition, "duplicate default label");
            } else {
                hasDefault = true;
            }
            this.attributeStatements(c.statements, switchEnv);
            l = l.getRest();
        }
        ((AnalyzerContext)switchEnv.context).scope.leave();
        return null;
    }

    @Override
    public Type _case(Tree.Synchronized tree, Environment<AnalyzerContext> env) {
        this.attributeExpression(tree.lockedObject, env, this.symbolTable.OBJECT_TYPE);
        this.attributeStatement(tree.body, env);
        return null;
    }

    @Override
    public Type _case(Tree.Try tree, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> tryEnv = env.spawn(tree, ((AnalyzerContext)env.context).copy());
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            Tree.Catch c = l.getFirst();
            Environment<AnalyzerContext> catchEnv = env.spawn(c, ((AnalyzerContext)env.context).copy(((AnalyzerContext)env.context).scope.extend()));
            Type ctype = this.attributeStatement(c.param, catchEnv);
            this.typeChecker.checkType(c.param.varType.sourcePosition, ctype, this.symbolTable.THROWABLE_TYPE);
            this.attributeStatement(c.body, catchEnv);
            Symbol.ClassSymbol exc = (Symbol.ClassSymbol)ctype.typeSymbol;
            ((AnalyzerContext)catchEnv.context).scope.leave();
            l = l.getRest();
        }
        this.attributeStatement(tree.body, tryEnv);
        if (tree.finalizer != null) {
            this.attributeStatement(tree.finalizer, env);
        }
        return null;
    }

    @Override
    public Type _case(Tree.Conditional tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        this.attributeExpression(tree.condition, env, Type.BOOLEAN_TYPE);
        this.attributeExpression(tree.thenClause, env, pt);
        if (tree.elseClause != null) {
            this.attributeExpression(tree.elseClause, env, pt);
        }
        if (tree.tag == 17) {
            return null;
        }
        return this.check(tree, this.condType(tree.sourcePosition, tree.condition.type, tree.thenClause.type, tree.elseClause.type), 12, pkind, pt);
    }

    private Type condType(int pos, Type condtype, Type thentype, Type elsetype) {
        if (condtype.constantValue != null && thentype.constantValue != null && elsetype.constantValue != null) {
            return ((Number)condtype.constantValue).intValue() != 0 ? thentype : elsetype;
        }
        if (thentype.tag < 4 && elsetype.tag == 4 && elsetype.isCoerceableTo(thentype)) {
            return thentype;
        }
        if (elsetype.tag < 4 && thentype.tag == 4 && thentype.isCoerceableTo(elsetype)) {
            return elsetype;
        }
        if (thentype.tag <= 7 && elsetype.tag <= 7) {
            for (int i = 1; i <= 7; ++i) {
                Type candidate = Type.TYPES_OF_TAGS[i];
                if (!thentype.isSubType(candidate) || !elsetype.isSubType(candidate)) continue;
                return candidate;
            }
        }
        if (thentype.typeSymbol == this.symbolTable.STRING_TYPE.typeSymbol && elsetype.typeSymbol == this.symbolTable.STRING_TYPE.typeSymbol) {
            return this.symbolTable.STRING_TYPE;
        }
        if (thentype.isSubType(elsetype)) {
            return elsetype;
        }
        this.typeChecker.checkType(pos, elsetype, thentype);
        return thentype;
    }

    @Override
    public Type _case(Tree.ExpressionStatement tree, Environment<AnalyzerContext> env) {
        this.attributeExpression(tree.expression, env);
        return null;
    }

    @Override
    public Type _case(Tree.Break tree, Environment<AnalyzerContext> env) {
        tree.target = this.findJumpTarget(tree.sourcePosition, tree.tag, tree.label, env);
        return null;
    }

    @Override
    public Type _case(Tree.Continue tree, Environment<AnalyzerContext> env) {
        tree.target = this.findJumpTarget(tree.sourcePosition, tree.tag, tree.label, env);
        return null;
    }

    private Tree findJumpTarget(int pos, int tag, Name label, Environment<AnalyzerContext> env) {
        Environment<AnalyzerContext> env1 = env;
        while (env1 != null) {
            switch (env1.tree.tag) {
                case 10: {
                    Tree.Labelled labelled = (Tree.Labelled)env1.tree;
                    if (label != labelled.label) break;
                    Tree target = labelled.body;
                    while (target.tag == 10) {
                        target = ((Tree.Labelled)target).body;
                    }
                    if (tag == 20 && target.tag != 7 && target.tag != 8 && target.tag != 9) {
                        this.errorLog.error(pos, new StringBuffer().append("not a loop label: ").append(label).toString());
                    }
                    return target;
                }
                case 7: 
                case 8: 
                case 9: {
                    if (label != null) break;
                    return env1.tree;
                }
                case 11: {
                    if (label != null || tag != 19) break;
                    return env1.tree;
                }
            }
            env1 = env1.enclosingEnv;
        }
        if (label != null) {
            this.errorLog.error(pos, new StringBuffer().append("undefined label: ").append(label).toString());
        } else if (tag == 20) {
            this.errorLog.error(pos, "continue outside of loop");
        } else {
            this.errorLog.error(pos, "break outside switch or loop");
        }
        return null;
    }

    @Override
    public Type _case(Tree.Return tree, Environment<AnalyzerContext> env) {
        if (env.enclosingMethod == null || env.enclosingClass.classSymbol.owner == env.enclosingMethod.methodSymbol) {
            this.errorLog.error(tree.sourcePosition, "return outside method");
        } else {
            Symbol.MethodSymbol m = env.enclosingMethod.methodSymbol;
            if (m.type.returnType().tag == 9) {
                if (tree.expression != null) {
                    this.errorLog.error(tree.expression.sourcePosition, "can't return a value from method whose result type is void");
                }
            } else if (tree.expression == null) {
                this.errorLog.error(tree.sourcePosition, "missing return value");
            } else {
                this.attributeExpression(tree.expression, env, m.type.returnType());
            }
        }
        return null;
    }

    @Override
    public Type _case(Tree.Throw tree, Environment<AnalyzerContext> env) {
        Type t = this.attributeExpression(tree.expression, env, this.symbolTable.THROWABLE_TYPE);
        return null;
    }

    @Override
    public Type _case(Tree.Apply tree, Environment<AnalyzerContext> env) {
        Symbol called;
        List<Type> argtypes;
        boolean isConstructorCall;
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = Type.ERROR_TYPE;
        Environment<AnalyzerContext> localEnv = env;
        Name methName = TreeInspector.name(tree.method);
        boolean bl = isConstructorCall = methName == Names._this || methName == Names._super;
        if (isConstructorCall && this.checkFirstConstructorStat(tree, env)) {
            localEnv = env.spawn(env.tree, ((AnalyzerContext)env.context).copy());
            ((AnalyzerContext)localEnv.context).isSelfCall = true;
            argtypes = this.attributeArgs(tree.args, localEnv);
            Type site = env.enclosingClass.classSymbol.type;
            if (methName == Names._super) {
                site = site.getSuperType();
            }
            Type encltype = tree.method.tag == 30 ? this.attributeExpression(((Tree.Select)tree.method).selected, env) : null;
            argtypes = this.constructorArgs(tree.method.sourcePosition, localEnv, site, encltype, argtypes);
        } else {
            argtypes = this.attributeArgs(tree.args, localEnv);
        }
        List<Type.MethodType> saved = this.methTemplateSupply.toList();
        Type mpt = this.newMethTemplate(argtypes);
        owntype = this.attributeExpression(tree.method, localEnv, mpt);
        this.methTemplateSupply.set(saved);
        if (isConstructorCall && (called = TreeInspector.symbol(tree.method)) == env.enclosingMethod.methodSymbol) {
            this.errorLog.error(tree.sourcePosition, "recursive constructor invocation");
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    private boolean checkFirstConstructorStat(Tree.Apply tree, Environment<AnalyzerContext> env) {
        Tree.MethodDef enclMethod = env.enclosingMethod;
        if (enclMethod != null && enclMethod.name == Names.init) {
            Tree.Block body = enclMethod.body;
            if (body.statements.getFirst().tag == 18 && ((Tree.ExpressionStatement)body.statements.getFirst()).expression == tree) {
                return true;
            }
        }
        this.errorLog.error(tree.sourcePosition, new StringBuffer().append("call to ").append(TreeInspector.name(tree.method)).append(" must be first statement in constructor").toString());
        return false;
    }

    public Type newMethTemplate(List<Type> argtypes) {
        if (this.methTemplateSupply.isEmpty()) {
            this.methTemplateSupply.insertEnd(new Type.MethodType(null, null, null));
        }
        Type.MethodType mt = this.methTemplateSupply.getFirst();
        this.methTemplateSupply.remove();
        mt.paramTypes = argtypes;
        return mt;
    }

    @Override
    public Type _case(Tree.NewInstance tree, Environment<AnalyzerContext> env) {
        List<Type> rawArgtypes;
        Type expectedType = ((AnalyzerContext)env.context).expectedType;
        int expectedKind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = Type.ERROR_TYPE;
        Tree.ClassDef cdef = tree.anonymousClassDef;
        Type encltype = null;
        Tree clazz = tree._class;
        if (tree.enclosingClassPrefix != null) {
            encltype = this.attributeExpression(tree.enclosingClassPrefix, env);
            if (encltype.tag == 10) {
                clazz = this.treeMaker.at(clazz.sourcePosition).newSelect(this.treeMaker.newType(encltype), ((Tree.Ident)tree._class).name);
            }
        }
        Type clazztype = this.typeChecker.checkClassType(tree._class.sourcePosition, this.attributeType(clazz, env));
        this.typeChecker.validate(clazz);
        if (tree.enclosingClassPrefix != null) {
            tree._class.type = clazztype;
            ((Tree.Ident)tree._class).symbol = TreeInspector.symbol(clazz);
        }
        List<Type> argtypes = rawArgtypes = this.attributeArgs(tree.args, env);
        if (clazztype.tag == 10) {
            Type site = clazztype.typeSymbol.type;
            ListBox<Type> typarams = new ListBox<Type>(clazztype.getTypeParams());
            if (cdef == null && (clazztype.typeSymbol.flags() & 0x600) != 0) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append(clazztype.typeSymbol).append(" is abstract; cannot be instantiated").toString());
            } else if (cdef != null && (clazztype.typeSymbol.flags() & 0x200) != 0) {
                if (rawArgtypes.nonEmpty()) {
                    this.errorLog.error(tree.sourcePosition, "anonymous class implements interface; cannot have arguments");
                    rawArgtypes = argtypes = Type.EMPTY_LIST;
                } else if (tree.enclosingClassPrefix != null) {
                    this.errorLog.error(tree.sourcePosition, "anonymous class implements interface; cannot have qualifier for new");
                }
            } else {
                argtypes = this.constructorArgs(tree.sourcePosition, env, site, encltype, rawArgtypes);
                boolean selectSuperPrev = ((AnalyzerContext)env.context).isSuperSelector;
                if (cdef != null) {
                    ((AnalyzerContext)env.context).isSuperSelector = true;
                }
                tree.constructor = this.nameResolver.resolveConstructor(tree.sourcePosition, env, site, typarams, argtypes);
                ((AnalyzerContext)env.context).isSuperSelector = selectSuperPrev;
            }
            if (cdef != null) {
                if (NameResolver.isStatic(env)) {
                    cdef.flags |= 8;
                }
                Tree clazz1 = this.treeMaker.at(cdef.sourcePosition).newType(clazztype);
                if ((clazztype.typeSymbol.flags() & 0x200) != 0) {
                    cdef.implementedInterfaces = new Cons<Tree>(clazz1);
                } else {
                    cdef.extendedClass = clazz1;
                }
                this.attributeStatement(cdef, env.spawn(tree));
                if (tree.enclosingClassPrefix != null) {
                    tree.args = tree.args.cons(tree.enclosingClassPrefix);
                    rawArgtypes = rawArgtypes.cons(encltype);
                    tree.enclosingClassPrefix = null;
                    encltype = null;
                }
                site = cdef.classSymbol.type;
                typarams = new ListBox();
                argtypes = this.constructorArgs(tree.sourcePosition, env, site, encltype, rawArgtypes);
                tree.constructor = this.nameResolver.resolveConstructor(tree.sourcePosition, env, site, typarams, argtypes);
            }
            if (tree.constructor != null && tree.constructor.kind == 16 && (owntype = this.nameResolver.instantiate(site, tree.constructor, typarams, argtypes)) == null) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("internal error; cannot instantiate ").append(tree.constructor).append(" to (").append(argtypes).append(")").toString());
            }
        }
        return this.check(tree, owntype, 12, expectedKind, expectedType);
    }

    @Override
    public Type _case(Tree.NewArray tree, Environment<AnalyzerContext> env) {
        Type elemtype;
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = Type.ERROR_TYPE;
        if (tree.elementType != null) {
            elemtype = this.attributeType(tree.elementType, env);
            this.typeChecker.validate(tree.elementType);
            owntype = elemtype;
            List<Tree> l = tree.dimensions;
            while (l.nonEmpty()) {
                this.attributeExpression(l.getFirst(), env, Type.INT_TYPE);
                owntype = new Type.ArrayType(owntype);
                l = l.getRest();
            }
        } else if (pt.tag == 11) {
            elemtype = pt.elementType();
        } else {
            if (pt.tag != 18) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("illegal initializer for ").append(pt).toString());
            }
            elemtype = Type.ERROR_TYPE;
        }
        if (tree.elements.nonEmpty()) {
            this.attributeExpressions(tree.elements, env, elemtype);
            owntype = new Type.ArrayType(elemtype);
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Assign tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = this.attributeTerm(tree.lhs, env.spawn(tree), 4, pt);
        this.attributeExpression(tree.rhs, env, owntype);
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.AssignOp tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Cons<Type> argtypes = new Cons<Type>(this.attributeTerm(tree.lhs, env, 4, Type.NO_TYPE)).cons(this.attributeExpression(tree.rhs, env));
        Symbol operator = tree.operator = this.nameResolver.resolveOperator(tree.sourcePosition, tree.tag - 17, env, argtypes);
        Type owntype = (Type)((List)argtypes).getFirst();
        if (operator.kind == 16) {
            if (owntype.tag <= 7) {
                this.typeChecker.checkCastable(tree.rhs.sourcePosition, operator.type.returnType(), owntype);
            } else {
                this.typeChecker.checkType(tree.rhs.sourcePosition, operator.type.returnType(), owntype);
            }
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.Operation tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        List argtypes = 42 <= tree.tag && tree.tag <= 45 ? Type.EMPTY_LIST.cons(this.attributeTerm(tree.args.getFirst(), env, 4, Type.NO_TYPE)) : this.attributeArgs(tree.args, env);
        Symbol operator = tree.operator = this.nameResolver.resolveOperator(tree.sourcePosition, tree.tag, env, argtypes);
        Type owntype = Type.ERROR_TYPE;
        if (operator.kind == 16) {
            Type ctype;
            owntype = operator.type.returnType();
            int opc = ((Symbol.OperatorSymbol)operator).opcode;
            List l = argtypes;
            while (l.nonEmpty() && l.getFirst().constantValue != null) {
                l = l.getRest();
            }
            if (l.isEmpty() && (ctype = this.constantFolder.fold(tree.sourcePosition, opc, argtypes)) != null) {
                owntype = this.constantFolder.coerce(ctype, owntype);
            }
            if (!(opc != 165 && opc != 166 || argtypes.getFirst().erasedIsCastableTo(argtypes.getRest().getFirst().erasure()) || argtypes.getRest().getFirst().erasedIsCastableTo(argtypes.getFirst().erasure()))) {
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("incomparable types: ").append(argtypes.getFirst()).append(" and ").append(argtypes.getRest().getFirst()).toString());
            }
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeCast tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type clazztype = this.attributeType(tree.castType, env);
        Type exprtype = this.attributeExpression(tree.expression, env);
        Type owntype = this.typeChecker.checkCastable(tree.expression.sourcePosition, exprtype, clazztype);
        if (exprtype.constantValue != null) {
            owntype = this.constantFolder.coerce(exprtype, owntype);
        }
        return this.check(tree, owntype, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.InstanceofTest tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type exprtype = this.attributeExpression(tree.expression, env);
        this.typeChecker.checkCastable(tree.expression.sourcePosition, exprtype, this.attributeType(tree.testedType, env));
        return this.check(tree, Type.BOOLEAN_TYPE, 12, pkind, pt);
    }

    @Override
    public Type _case(Tree.IndexedArrayElement tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = Type.ERROR_TYPE;
        Type atype = this.attributeExpression(tree.indexedArray, env);
        this.attributeExpression(tree.index, env, Type.INT_TYPE);
        if (atype.tag == 11) {
            owntype = atype.elementType();
        } else if (atype.tag != 18) {
            this.errorLog.error(tree.sourcePosition, new StringBuffer().append("array required, but ").append(atype).append(" found").toString());
        }
        return this.check(tree, owntype, 4, pkind, pt);
    }

    @Override
    public Type _case(Tree.Ident tree, Environment<AnalyzerContext> env) {
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type pt = ((AnalyzerContext)env.context).expectedType;
        Symbol sym = pt.tag == 12 ? (tree.name == Names._super || tree.name == Names._this ? this.nameResolver.resolveSelfConstructor(tree.sourcePosition, env, tree.name, pt.argTypes()) : this.nameResolver.resolveMethod(tree.sourcePosition, env, tree.name, new ListBox<Type>(), pt.argTypes())) : this.nameResolver.resolveIdent(tree.sourcePosition, env, tree.name, pkind);
        tree.symbol = sym;
        if (env.enclosingClass.classSymbol.owner.kind != 1 && (sym.kind & 0x14) != 0 && sym.owner.kind == 2 && tree.name != Names._super && tree.name != Names._this) {
            Environment<AnalyzerContext> env1 = env;
            while (env1.enclosingClassEnv != null && !env1.enclosingClass.classSymbol.subclass(sym.owner)) {
                env1 = env1.enclosingClassEnv;
            }
            if (env1 != null && env1.enclosingClass.classSymbol != sym.owner) {
                while ((env1 = env1.enclosingClassEnv) != null && (((AnalyzerContext)env1.context).scope == null || this.checkNotHiding(tree.sourcePosition, sym, ((AnalyzerContext)env1.context).scope)) && (env1.enclosingClass == null || this.checkNotHiding(tree.sourcePosition, sym, env1.enclosingClass.classSymbol.members()))) {
                }
            }
        }
        if (sym.kind == 4) {
            Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
            this.checkInit(tree, env, v);
            if (v.owner.kind == 16 && v.owner != ((AnalyzerContext)env.context).scope.owningSymbol && (v.flags_field & 0x40000) == 0) {
                v.flags_field |= 0x40000;
                if ((v.flags_field & 0x10) == 0) {
                    this.errorLog.error(tree.sourcePosition, new StringBuffer().append("local ").append(v).append(" is accessed from within inner class; ").append(" needs to be declared final").toString());
                }
            }
            if (pkind == 4) {
                this.checkAssignable(tree.sourcePosition, v, null, env);
            }
        }
        if (((AnalyzerContext)env.context).isSelfCall && sym.owner != null && sym.owner.kind == 2 && (sym.flags() & 8) == 0 && env.enclosingClass.classSymbol.subclass(sym.owner) && sym.name != Names.init) {
            this.typeChecker.earlyRefError(tree.sourcePosition, sym.kind == 4 ? sym : this.thisSym(env));
        }
        return this.checkId(tree, env.enclosingClass.classSymbol.type, sym, pkind, pt);
    }

    @Override
    public Type _case(Tree.Select tree, Environment<AnalyzerContext> env) {
        Symbol sym;
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        int skind = 0;
        if (tree.name == Names._this || tree.name == Names._class) {
            skind = 2;
        } else {
            if ((pkind & 1) != 0) {
                skind |= 1;
            }
            if ((pkind & 2) != 0) {
                skind = skind | 2 | 1;
            }
            if ((pkind & 0x1C) != 0) {
                skind = skind | 0xC | 2;
            }
        }
        Type site = this.attributeTerm(tree.selected, env, skind, Type.NO_TYPE);
        Symbol sitesym = TreeInspector.symbol(tree.selected);
        boolean selectSuperPrev = ((AnalyzerContext)env.context).isSuperSelector;
        ((AnalyzerContext)env.context).isSuperSelector = sitesym != null && (sitesym.name == Names._super || sitesym.kind == 2);
        tree.symbol = sym = this.selectSym(tree, site, env, pt, pkind);
        if (sym.kind == 4) {
            Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
            this.evalInit(v, env);
            if (pkind == 4) {
                this.checkAssignable(tree.sourcePosition, v, tree.selected, env);
            }
        }
        if (((AnalyzerContext)env.context).isSuperSelector) {
            if ((sym.flags() & 8) == 0 && sym.name != Names._this && sym.name != Names._super) {
                Type site1;
                if (sitesym.name == Names._super) {
                    this.nameResolver.checkNonAbstract(tree.sourcePosition, sym);
                } else if (sym.kind == 4 || sym.kind == 16) {
                    this.nameResolver.access(new NameResolver.StaticError(sym), tree.sourcePosition, site, sym.name);
                }
                if (((AnalyzerContext)env.context).isSelfCall && sym.name != Names.init && tree.name == Names._this && site.typeSymbol == env.enclosingClass.classSymbol) {
                    this.typeChecker.earlyRefError(tree.sourcePosition, sym);
                }
                if ((site1 = env.enclosingClass.classSymbol.type.asSuper(site.typeSymbol)) != null) {
                    site = site1;
                }
            }
            ((AnalyzerContext)env.context).isSuperSelector = selectSuperPrev;
        }
        return this.checkId(tree, site, sym, pkind, pt);
    }

    private Symbol selectSym(Tree.Select tree, Type site, Environment<AnalyzerContext> env, Type pt, int pkind) {
        int pos = tree.sourcePosition;
        Name name = tree.name;
        switch (site.tag) {
            case 13: {
                return this.nameResolver.access(this.nameResolver.findIdentInPackage(env, site.typeSymbol, name, pkind), pos, site, name);
            }
            case 10: 
            case 11: {
                if (pt.tag == 12) {
                    if (name == Names._super) {
                        return this.nameResolver.resolveSelfConstructor(pos, env, name, pt.argTypes());
                    }
                    return this.nameResolver.resolveQualifiedMethod(pos, env, site, name, new ListBox<Type>(), pt.argTypes());
                }
                if (name == Names._this) {
                    return this.nameResolver.resolveSelf(pos, env, site.typeSymbol, name);
                }
                if (name == Names._class) {
                    return new Symbol.VarSymbol(9, Names._class, this.symbolTable.CLASS_TYPE, site.typeSymbol);
                }
                Symbol sym = this.nameResolver.findIdentInType(env, site, name, pkind);
                if (sym.kind >= 256) {
                    Name pname;
                    if ((pkind & 3) != 0 && (pname = TreeInspector.fullName(tree.selected)) != null) {
                        Symbol.PackageSymbol p = this.symbolTable.classReader.enterPackage(pname);
                        Symbol sym1 = this.nameResolver.findIdentInPackage(env, p, name, pkind);
                        if (sym1.kind < sym.kind) {
                            sym = sym1;
                        }
                    }
                    sym = this.nameResolver.access(sym, pos, site, name);
                }
                return sym;
            }
            case 14: {
                return this.selectSym(tree, site.bound(), env, pt, pkind);
            }
            case 18: {
                return Symbol.ERROR_SYMBOL;
            }
        }
        if (name == Names._class) {
            return new Symbol.VarSymbol(9, Names._class, this.symbolTable.CLASS_TYPE, site.typeSymbol);
        }
        this.errorLog.error(pos, new StringBuffer().append(site).append(" cannot be dereferenced").toString());
        return Symbol.ERROR_SYMBOL;
    }

    /*
     * WARNING - void declaration
     */
    Type checkId(Tree tree, Type site, Symbol sym, int pkind, Type pt) {
        void var6_6;
        if ((sym.flags() & 0x20000) != 0) {
            this.warnDeprecated(tree.sourcePosition, sym);
        }
        switch (sym.kind) {
            case 2: {
                Type owntype = sym.type;
                if (owntype.tag != 10) break;
                Type ownOuter = owntype.enclosingType();
                if (ownOuter.tag == 10 && site != ownOuter) {
                    Type normSite = site;
                    if (normSite.tag == 10) {
                        normSite = site.asOuterSuper(ownOuter.typeSymbol);
                    }
                    if (normSite != ownOuter) {
                        owntype = new Type.ClassType(normSite, Type.EMPTY_LIST, owntype.typeSymbol);
                    }
                }
                if (!owntype.getTypeParams().nonEmpty()) break;
                owntype = new Type.ClassType(owntype.enclosingType(), Type.EMPTY_LIST, owntype.typeSymbol);
                break;
            }
            case 4: {
                Type s;
                Type owntype;
                Symbol.VarSymbol v = (Symbol.VarSymbol)sym;
                if (!this.typeChecker.isUnchecked() && pkind == 4 && v.owner.kind == 2 && (v.flags() & 8) == 0 && site.tag == 10 && (s = site.asOuterSuper(v.owner)) != null && s.isRaw() && !v.type.isSameType(v.erasure())) {
                    this.errorLog.warning(tree.sourcePosition, new StringBuffer().append("unchecked assignment to ").append(v).append(" of raw type ").append(site).toString());
                }
                Type type = owntype = sym.owner.kind == 2 ? site.memberType(sym) : sym.type;
                if (v.constantValue == null) break;
                owntype = owntype.constType(v.constantValue);
                break;
            }
            case 16: {
                Type s;
                Type owntype;
                if (!this.typeChecker.isUnchecked() && (sym.flags() & 8) == 0 && site.tag == 10 && (s = site.asOuterSuper(sym.owner)) != null && s.isRaw() && sym.name != Names.init && !Type.sameTypes(sym.type.argTypes(), sym.erasure().argTypes())) {
                    this.errorLog.warning(tree.sourcePosition, new StringBuffer().append("unchecked call to ").append(sym).append(" of raw type ").append(site).toString());
                }
                if (sym.name == Names.init) {
                    owntype = Type.VOID_TYPE;
                    break;
                }
                ListBox<Type> typarams = new ListBox<Type>();
                owntype = this.nameResolver.instantiate(site, sym, typarams, pt.argTypes());
                ((Tree.Polymorphic)((Object)tree)).setTypeArgs(typarams.toList());
                if (owntype != null) break;
                this.errorLog.error(tree.sourcePosition, new StringBuffer().append("internal error; cannot instantiate ").append(sym).append(" at ").append(site).append(" to (").append(pt.argTypes()).append(")").toString());
                break;
            }
            case 1: 
            case 31: {
                Type owntype = sym.type;
                break;
            }
            default: {
                new PrettyPrinter().printExpr(tree);
                throw new InternalError(new StringBuffer().append("unexpected kind: ").append(sym.kind).toString());
            }
        }
        this.typeInferrer.checkSafe(tree.sourcePosition, (Type)var6_6, sym);
        return this.check(tree, (Type)var6_6, sym.kind, pkind, pt);
    }

    private void checkInit(Tree tree, Environment<AnalyzerContext> env, Symbol.VarSymbol v) {
        if (v.position > tree.sourcePosition && v.owner.kind == 2 && this.canOwnInitializer(((AnalyzerContext)env.context).scope.owningSymbol) && v.owner == ((AnalyzerContext)env.context).scope.owningSymbol.enclClass() && (v.flags() & 8) != 0 == NameResolver.isStatic(env)) {
            this.errorLog.error(tree.sourcePosition, "illegal forward reference");
        }
        this.evalInit(v, env);
    }

    private boolean canOwnInitializer(Symbol sym) {
        return (sym.kind & 6) != 0 || sym.kind == 16 && (sym.flags() & 0x80000) != 0;
    }

    void evalInit(Symbol.VarSymbol v, Environment<AnalyzerContext> env) {
        if (v.constantValue instanceof SymbolEnterer.EnvAttrContextBox) {
            Environment<AnalyzerContext> evalEnv = ((SymbolEnterer.EnvAttrContextBox)v.constantValue).env;
            Name prev = this.errorLog.useSource(evalEnv.topLevel.sourcefile);
            v.constantValue = null;
            Type itype = this.attributeExpression(((Tree.VarDef)evalEnv.tree).initialization, evalEnv, v.type);
            if (itype.constantValue != null) {
                v.constantValue = this.constantFolder.coerce((Type)itype, (Type)v.type).constantValue;
            }
            this.errorLog.useSource(prev);
        }
    }

    boolean checkNotHiding(int pos, Symbol sym, Scope scope) {
        Scope.Entry e = scope.lookup(sym.name);
        while (e.scope != null) {
            if (e.symbol.owner != sym.owner && e.symbol.kind == sym.kind && e.symbol.owner == scope.owningSymbol) {
                this.errorLog.error(pos, new StringBuffer().append(sym).append(" is inherited from ").append(sym.owner).append(" and hides a ").append(NameResolver.kindName(sym.kind)).append(" of the same name").append(e.symbol.location()).append(". An explicit `this' qualifier must be used to select the desired instance  ").toString());
                return false;
            }
            e = e.next();
        }
        return true;
    }

    @Override
    public Type _case(Tree.Literal tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        return this.check(tree, this.litType(tree.typeTag).constType(tree.value), 12, pkind, pt);
    }

    Type litType(int tag) {
        return tag == 10 ? this.symbolTable.STRING_TYPE : Type.TYPES_OF_TAGS[tag];
    }

    @Override
    public Type _case(Tree.TypeIdent tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        return this.check(tree, Type.TYPES_OF_TAGS[tree.typeTag], 2, pkind, pt);
    }

    @Override
    public Type _case(Tree.ArrayTypeExpression tree, Environment<AnalyzerContext> env) {
        Type expectedType = ((AnalyzerContext)env.context).expectedType;
        int expectedKind = ((AnalyzerContext)env.context).expectedKind;
        Type elementType = this.attributeType(tree.elementType, env);
        return this.check(tree, new Type.ArrayType(elementType), 2, expectedKind, expectedType);
    }

    @Override
    public Type _case(Tree.TypeApply tree, Environment<AnalyzerContext> env) {
        Type pt = ((AnalyzerContext)env.context).expectedType;
        int pkind = ((AnalyzerContext)env.context).expectedKind;
        Type owntype = Type.ERROR_TYPE;
        Type clazztype = this.typeChecker.checkClassType(tree._class.sourcePosition, this.attributeType(tree._class, env));
        ListBox<Type> actbuf = new ListBox<Type>();
        List<Tree> l = tree.arguments;
        while (l.nonEmpty()) {
            actbuf.insertEnd(this.typeChecker.checkRefType(l.getFirst().sourcePosition, this.attributeType(l.getFirst(), env)));
            l = l.getRest();
        }
        List<Type> actuals = actbuf.toList();
        if (clazztype.tag == 10) {
            List<Type> formals = clazztype.typeSymbol.type.getTypeParams();
            if (actuals.length() == formals.length()) {
                owntype = new Type.ClassType(clazztype.typeSymbol.type.enclosingType(), actuals, clazztype.typeSymbol);
            } else {
                this.errorLog.error(tree.sourcePosition, formals.length() != 0 ? new StringBuffer().append("wrong number of type arguments; required: ").append(formals.length()).toString() : new StringBuffer().append("type ").append(clazztype).append(" does not take parameters").toString());
                owntype = Type.ERROR_TYPE;
            }
        }
        return this.check(tree, owntype, 2, pkind, pt);
    }

    @Override
    public Type _case(Tree.TypeParameter tree, Environment<AnalyzerContext> env) {
        Type.TypeVar a = (Type.TypeVar)tree.type;
        a.bound = tree.extendsBound != null ? this.attributeBaseType(tree.extendsBound, env, 0) : (tree.implementsBound != null ? this.attributeBaseType(tree.implementsBound, env, 512) : this.symbolTable.OBJECT_TYPE);
        return a;
    }

    @Override
    public Type _case(Tree.Erroneous tree, Environment<AnalyzerContext> env) {
        tree.type = Type.ERROR_TYPE;
        return tree.type;
    }

    @Override
    public Type _case(Tree tree, Environment<AnalyzerContext> env) {
        throw new InternalError();
    }

    public void analyzeClass(Symbol.ClassSymbol c) {
        Type superType = c.type.getSuperType();
        if (superType.tag == 10) {
            this.analyzeClass((Symbol.ClassSymbol)superType.typeSymbol);
        }
        if (c.owner.kind == 2) {
            this.analyzeClass((Symbol.ClassSymbol)c.owner);
        }
        if ((c.flags_field & 0x400000) != 0) {
            Name prev = this.errorLog.useSource(c.sourcefile);
            c.flags_field &= 0xFFBFFFFF;
            Environment<AnalyzerContext> env = this.symbolEnterer.classEnvs.get(c);
            this.symbolEnterer.classEnvs.remove(c);
            Tree.ClassDef tree = (Tree.ClassDef)env.tree;
            this.implementInterfaceMethods(c, env);
            this.typeChecker.validateTypeParams(tree.typeParams);
            this.typeChecker.validate(tree.extendedClass);
            this.typeChecker.validate(tree.implementedInterfaces);
            if ((c.flags() & 0x600) == 0) {
                this.typeChecker.checkAllDefined(tree.sourcePosition, c);
            }
            this.typeChecker.checkClassBounds(tree.sourcePosition, c);
            if (tree.typeParams.length() != 0 && c.subclass(this.symbolTable.THROWABLE_TYPE.typeSymbol)) {
                this.errorLog.error(tree.sourcePosition, "subtypes of java.lang.Throwable cannot have arguments");
            }
            tree.type = c.type;
            List<Tree.TypeParameter> l = tree.typeParams;
            while (l.nonEmpty()) {
                ((AnalyzerContext)env.context).scope.addSymbolIfAbsent(l.getFirst().type.typeSymbol);
                l = l.getRest();
            }
            if ((c.flags() & 0x200) == 0) {
                Symbol.VarSymbol thisSym = new Symbol.VarSymbol(16, Names._this, c.type, c);
                thisSym.position = 1025;
                ((AnalyzerContext)env.context).scope.addSymbol(thisSym);
                if (superType.tag == 10) {
                    Symbol.VarSymbol superSym = new Symbol.VarSymbol(16, Names._super, superType, c);
                    superSym.position = 1025;
                    ((AnalyzerContext)env.context).scope.addSymbol(superSym);
                }
                this.typeChecker.checkImplementations(tree.sourcePosition, c);
            } else {
                c.members_field = c.members_field.extend();
                this.implementInterfaceMethods(c, env);
                this.typeChecker.checkImplementations(tree.sourcePosition, c);
                c.members_field = c.members_field.leave();
            }
            this.attributeStatements(tree.members, env);
            tree.type = c.type;
            this.errorLog.useSource(prev);
        }
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Environment<AnalyzerContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }
}

