/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.main.CompilerOptions;
import edu.rice.cs.nextgen.compiler.main.NextGenTestCase;
import edu.rice.cs.nextgen.compiler.util.Name;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class SymbolTableTest
extends NextGenTestCase {
    private SymbolTable symbolTable;
    private SymbolTable symboltable;

    public SymbolTableTest(String name) {
        super(name);
    }

    protected void setUp() {
        this.symbolTable = new SymbolTable(new CompilerOptions());
    }

    protected void tearDown() {
        this.symbolTable = null;
    }

    public void testSymbolTable() {
        String expectedResult = "[SymbolTable  packages:  classes: ]";
        SymbolTableTest.assertEquals((String)"SymbolTable not initialized properly", (String)SymbolTableTest.removeWhiteSpace(expectedResult), (String)SymbolTableTest.removeWhiteSpace(this.symbolTable.longString()));
    }

    public void testEnterClass() {
        String expectedResult = "[SymbolTable   packages:   classes:     TYPE_SYMBOL$TestClass => [ClassSymbol  fullname: TYPE_SYMBOL.TestClass  flatname: TYPE_SYMBOL$TestClass flags: 0                               members (cyclic references have been filtered):]]";
        this.symbolTable.classReader.enterClass(Name.fromString("TestClass"), TYPE_SYMBOL);
        SymbolTableTest.assertEquals((String)"SymbolTable not updated properly.", (String)SymbolTableTest.removeWhiteSpace(expectedResult), (String)SymbolTableTest.removeWhiteSpace(this.symbolTable.longString()));
    }

    public void testEnterPackage() {
        String expectedResult = "[SymbolTable   packages:     TestPackage => [PackageSymbol TestPackage]   classes: ]";
        this.symbolTable.classReader.enterPackage(Name.fromString("TestPackage"));
        SymbolTableTest.assertEquals((String)"SymbolTable not updated properly.", (String)SymbolTableTest.removeWhiteSpace(expectedResult), (String)SymbolTableTest.removeWhiteSpace(this.symbolTable.longString()));
    }

    public static void main(String[] args) {
        TestRunner.run((Test)new TestSuite(1.class$edu$rice$cs$nextgen$compiler$comp$SymbolTableTest == null ? (1.class$edu$rice$cs$nextgen$compiler$comp$SymbolTableTest = 1.class$("edu.rice.cs.nextgen.compiler.comp.SymbolTableTest")) : 1.class$edu$rice$cs$nextgen$compiler$comp$SymbolTableTest));
    }

    static class 1 {
        static /* synthetic */ Class class$edu$rice$cs$nextgen$compiler$comp$SymbolTableTest;
        static /* synthetic */ ClassLoader cl$;

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0, false, cl$ == null ? (cl$ = new 1[0].getClass().getComponentType().getClassLoader()) : cl$);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError().initCause(x1);
            }
        }
    }
}

