/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.comp;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.Hashtable;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferrer
implements Kinds,
Flags,
TypeTags {
    ErrorLog errorLog;
    SymbolTable symbolTable;
    private Hashtable<Type, List<Type>> closureCache = new Hashtable();

    public TypeInferrer(ErrorLog log, SymbolTable syms) {
        this.symbolTable = syms;
        this.errorLog = log;
    }

    public static Constraint genTypeC(Type lo, Type hi, List<Type> tvars, Constraint c) {
        if (lo.tag == 18) {
            return c;
        }
        switch (hi.tag) {
            case 14: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 14 || lo.tag == 11 || lo.tag == 10) {
                    List<Type> l = tvars;
                    while (l.nonEmpty()) {
                        if (hi == l.getFirst()) {
                            return c.addEq(lo, hi);
                        }
                        l = l.getRest();
                    }
                }
                return Constraint.failure("% is different from %", lo, hi);
            }
            case 10: {
                if (lo.tag == 16) {
                    return c;
                }
                if (hi.typeSymbol == lo.typeSymbol) {
                    c = TypeInferrer.genTypeC(lo.enclosingType(), hi.enclosingType(), tvars, c);
                    c = TypeInferrer.genTypeC(lo.getTypeParams(), hi.getTypeParams(), tvars, c);
                    return c;
                }
                return Constraint.failure("% is different from %", lo, hi);
            }
            case 11: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 11) {
                    return TypeInferrer.genTypeC(lo.elementType(), hi.elementType(), tvars, c);
                }
                return Constraint.failure("% is different from %", lo, hi);
            }
        }
        if (lo.genType(hi)) {
            return c;
        }
        return Constraint.failure("% is different from %", lo, hi);
    }

    public static Constraint genTypeC(List<Type> lo, List<Type> hi, List<Type> tvars, Constraint c) {
        List<Type> lo1 = lo;
        List<Type> hi1 = hi;
        while (c != Constraint.FAIL_CONSTRAINT && lo1.nonEmpty() && hi1.nonEmpty()) {
            c = TypeInferrer.genTypeC(lo1.getFirst(), hi1.getFirst(), tvars, c);
            lo1 = lo1.getRest();
            hi1 = hi1.getRest();
        }
        if (lo1.isEmpty() == hi1.isEmpty()) {
            return c;
        }
        return Constraint.failure("different lengths: (%) and (%)", lo, hi);
    }

    public static Constraint subTypeC(Type lo, Type hi, List<Type> tvars, Constraint c) {
        if (lo.tag == 18) {
            return c;
        }
        switch (hi.tag) {
            case 14: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 14 || lo.tag == 11 || lo.tag == 10) {
                    List<Type> l = tvars;
                    while (l.nonEmpty()) {
                        if (hi == l.getFirst()) {
                            return c.addSub(lo, hi);
                        }
                        l = l.getRest();
                    }
                }
                return Constraint.failure("% is not a subtype of %", lo, hi);
            }
            case 10: {
                Constraint c1;
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.typeSymbol == hi.typeSymbol) {
                    return hi.getTypeParams().length() == 0 ? c : TypeInferrer.genTypeC(lo, hi, tvars, c);
                }
                if (lo.tag == 11) {
                    if (lo.isSubType(hi)) {
                        return c;
                    }
                    return Constraint.failure("% is not a subtype of %", lo, hi);
                }
                if (lo.tag == 14) {
                    return TypeInferrer.subTypeC(lo.bound(), hi, tvars, c);
                }
                Type superType = lo.getSuperType();
                if (superType.tag == 10 && (c1 = TypeInferrer.subTypeC(superType, hi, tvars, c)) != Constraint.FAIL_CONSTRAINT) {
                    return c1;
                }
                if ((hi.typeSymbol.flags() & 0x200) != 0) {
                    List<Type> l = lo.getInterfaces();
                    while (l.nonEmpty()) {
                        Constraint c12 = TypeInferrer.subTypeC(l.getFirst(), hi, tvars, c);
                        if (c12 != Constraint.FAIL_CONSTRAINT) {
                            return c12;
                        }
                        l = l.getRest();
                    }
                }
                return Constraint.failure("% is not a subtype of %", lo, hi);
            }
            case 11: {
                if (lo.tag == 16) {
                    return c;
                }
                if (lo.tag == 11) {
                    if (hi.elementType().tag <= 8) {
                        return TypeInferrer.genTypeC(lo.elementType(), hi.elementType(), tvars, c);
                    }
                    return TypeInferrer.subTypeC(lo.elementType(), hi.elementType(), tvars, c);
                }
                return Constraint.failure("% is not a subtype of %", lo, hi);
            }
        }
        if (lo.isSubType(hi)) {
            return c;
        }
        return Constraint.failure("% is not a subtype of %", lo, hi);
    }

    public static Constraint subTypeC(List<Type> lo, List<Type> hi, List<Type> tvars, Constraint c) {
        List<Type> lo1 = lo;
        List<Type> hi1 = hi;
        while (c != Constraint.FAIL_CONSTRAINT && lo1.nonEmpty() && hi1.nonEmpty()) {
            c = TypeInferrer.subTypeC(lo1.getFirst(), hi1.getFirst(), tvars, c);
            lo1 = lo1.getRest();
            hi1 = hi1.getRest();
        }
        if (lo1.isEmpty() == hi1.isEmpty()) {
            return c;
        }
        return Constraint.failure("different lengths: (%) and (%)", lo, hi);
    }

    public static Type join(Type t1, Type t2) {
        if (t1 == t2 || t2.tag == 16) {
            return t1;
        }
        switch (t1.tag) {
            case 16: {
                return t2;
            }
            case 10: {
                if (t1.typeSymbol == t2.typeSymbol) {
                    Type outer1 = t1.enclosingType();
                    Type outer2 = t2.enclosingType();
                    List<Type> typarams1 = t1.getTypeParams();
                    List<Type> typarams2 = t2.getTypeParams();
                    Type outer = TypeInferrer.join(outer1, outer2);
                    List<Type> typarams = TypeInferrer.join(typarams1, typarams2);
                    if (outer == null || typarams == null) {
                        return null;
                    }
                    if (outer == outer1 && typarams == typarams1) {
                        return t1;
                    }
                    if (outer == outer2 && typarams == typarams2) {
                        return t2;
                    }
                    return new Type.ClassType(outer, typarams, t1.typeSymbol);
                }
                return null;
            }
            case 11: {
                if (t2.tag == 11) {
                    Type elemtype2;
                    Type elemtype1 = t1.elementType();
                    Type elemtype = TypeInferrer.join(elemtype1, elemtype2 = t2.elementType());
                    if (elemtype == null) {
                        return null;
                    }
                    if (elemtype == elemtype1) {
                        return t1;
                    }
                    if (elemtype == elemtype2) {
                        return t2;
                    }
                    return new Type.ArrayType(elemtype);
                }
                return null;
            }
        }
        return t1.isSameType(t2) ? t1 : null;
    }

    public static List<Type> join(List<Type> ts1, List<Type> ts2) {
        if (ts1.isEmpty() && ts2.isEmpty()) {
            return Type.EMPTY_LIST;
        }
        if (ts1.nonEmpty() && ts2.nonEmpty()) {
            Type head = TypeInferrer.join(ts1.getFirst(), ts2.getFirst());
            List<Type> tail = TypeInferrer.join(ts1.getRest(), ts2.getRest());
            if (head == null || tail == null) {
                return null;
            }
            if (head == ts1.getFirst() && tail == ts1.getRest()) {
                return ts1;
            }
            if (head == ts2.getFirst() && tail == ts2.getRest()) {
                return ts2;
            }
            return tail.cons(head);
        }
        return null;
    }

    List<Type> closure(Type type) {
        List<Type> cl = this.closureCache.get(type);
        if (cl == null) {
            Type superType = type.getSuperType();
            cl = superType.tag == 10 ? this.insert(this.closure(superType), type) : Type.EMPTY_LIST.cons(type);
            List<Type> l = type.getInterfaces();
            while (l.nonEmpty()) {
                cl = this.union(cl, this.closure(l.getFirst()));
                l = l.getRest();
            }
            this.closureCache.put(type, cl);
        }
        return cl;
    }

    private List<Type> insert(List<Type> cl, Type t) {
        if (cl.isEmpty() || t.typeSymbol.precedes(cl.getFirst().typeSymbol)) {
            return cl.cons(t);
        }
        if (cl.getFirst().typeSymbol.precedes(t.typeSymbol)) {
            return this.insert(cl.getRest(), t).cons(cl.getFirst());
        }
        return cl;
    }

    private List<Type> union(List<Type> cl1, List<Type> cl2) {
        if (cl1.isEmpty()) {
            return cl2;
        }
        if (cl2.isEmpty()) {
            return cl1;
        }
        if (cl1.getFirst().typeSymbol.precedes(cl2.getFirst().typeSymbol)) {
            return this.union(cl1.getRest(), cl2).cons(cl1.getFirst());
        }
        if (cl2.getFirst().typeSymbol.precedes(cl1.getFirst().typeSymbol)) {
            return this.union(cl1, cl2.getRest()).cons(cl2.getFirst());
        }
        return this.union(cl1.getRest(), cl2.getRest()).cons(cl1.getFirst());
    }

    List<Type> intersect(List<Type> cl1, List<Type> cl2) {
        if (cl1 == cl2) {
            return cl1;
        }
        if (cl1.isEmpty() || cl2.isEmpty()) {
            return Type.EMPTY_LIST;
        }
        if (cl1.getFirst().typeSymbol.precedes(cl2.getFirst().typeSymbol)) {
            return this.intersect(cl1.getRest(), cl2);
        }
        if (cl2.getFirst().typeSymbol.precedes(cl1.getFirst().typeSymbol)) {
            return this.intersect(cl1, cl2.getRest());
        }
        Type t = TypeInferrer.join(cl1.getFirst(), cl2.getFirst());
        List<Type> cl = this.intersect(cl1.getRest(), cl2.getRest());
        return t == null ? cl : cl.cons(t);
    }

    Type firstInDiff(List<Type> cl1, List<Type> cl2) {
        while (cl1.nonEmpty() && cl2.nonEmpty() && cl1.getFirst() == cl2.getFirst()) {
            cl1 = cl1.getRest();
            cl2 = cl2.getRest();
        }
        return cl1.nonEmpty() ? cl1.getFirst() : null;
    }

    Type min(List<Type> cl) {
        if (cl.isEmpty()) {
            return Type.ALL_TYPE;
        }
        Type t = this.firstInDiff(cl, this.closure(cl.getFirst()));
        return t == null ? cl.getFirst() : null;
    }

    List<Constraint> distribute(Constraint c, List<Type> tvars) {
        ListBox<Constraint> cs = new ListBox<Constraint>();
        while (c != Constraint.EMPTY_CONSTRAINT) {
            ListBox<Type> _tvars = new ListBox<Type>(tvars);
            while (_tvars.nonEmpty() && _tvars.getFirst() != c.hi) {
                _tvars.remove();
                cs.insertEnd(Constraint.EMPTY_CONSTRAINT);
            }
            if (_tvars.nonEmpty()) {
                cs.insertEnd(new Constraint(c.kind, c.lo, c.hi, Constraint.EMPTY_CONSTRAINT));
            }
            c = c.rest;
        }
        return cs.toList().reverse();
    }

    Type lub(Constraint c) {
        if (c == Constraint.EMPTY_CONSTRAINT) {
            return Type.ALL_TYPE;
        }
        if (c == Constraint.FAIL_CONSTRAINT) {
            return null;
        }
        switch (c.lo.tag) {
            case 16: {
                return this.lub(c.rest);
            }
            case 11: {
                Constraint c2 = Constraint.EMPTY_CONSTRAINT;
                Constraint c1 = c;
                while (c1 != Constraint.EMPTY_CONSTRAINT) {
                    switch (c1.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            c2 = new Constraint(c1.kind, c1.lo.elementType(), c1.hi, c2);
                            break;
                        }
                        case 10: {
                            if (c1.kind == 2) {
                                return null;
                            }
                            return this.lub(new Constraint(1, this.symbolTable.OBJECT_TYPE, c1.hi, c1.rest));
                        }
                        default: {
                            return null;
                        }
                    }
                    c1 = c1.rest;
                }
                Type t = this.lub(c2);
                return t == null ? this.symbolTable.OBJECT_TYPE : new Type.ArrayType(t);
            }
            case 10: {
                List<Type> cl = this.closure(c.lo);
                boolean fixed = false;
                Constraint c1 = c.rest;
                while (c1 != Constraint.EMPTY_CONSTRAINT) {
                    switch (c1.lo.tag) {
                        case 16: {
                            break;
                        }
                        case 11: {
                            if (c1.kind == 2) {
                                return null;
                            }
                            cl = this.intersect(cl, this.closure(this.symbolTable.OBJECT_TYPE));
                            break;
                        }
                        case 10: {
                            if (fixed) {
                                Type t = TypeInferrer.join(cl.getFirst(), c1.lo);
                                if (t == null) {
                                    return t;
                                }
                                cl = cl.updateFirst(t);
                                break;
                            }
                            cl = this.intersect(cl, this.closure(c1.lo));
                            if (c1.kind != 2) break;
                            fixed = true;
                            if (c1.lo.genType(cl.getFirst())) break;
                            return null;
                        }
                        default: {
                            return null;
                        }
                    }
                    c1 = c1.rest;
                }
                return this.min(cl);
            }
        }
        Type t = this.lub(c.rest);
        return t == null ? t : TypeInferrer.join(c.lo, t);
    }

    List<Type> typeParams(List<Type> tvars, List<Type> formals, List<Type> argtypes) {
        Constraint c = TypeInferrer.subTypeC(argtypes, formals, tvars, Constraint.EMPTY_CONSTRAINT);
        if (c == Constraint.FAIL_CONSTRAINT) {
            return null;
        }
        ListBox<Type> buf = new ListBox<Type>();
        List<Constraint> l = this.distribute(c, tvars);
        while (l.nonEmpty()) {
            Type t = this.lub(l.getFirst());
            if (t == null) {
                return null;
            }
            buf.insertEnd(t);
            l = l.getRest();
        }
        List<Type> args = buf.toList();
        return this.withinBounds(tvars, args) ? args : null;
    }

    String substitute(String s, Object[] args) {
        char[] cs = s.toCharArray();
        StringBuffer buf = new StringBuffer();
        int j = 0;
        for (int i = 0; i < cs.length; ++i) {
            if (cs[i] == '%') {
                buf.append(args[j++]);
                continue;
            }
            buf.append(cs[i]);
        }
        return buf.toString();
    }

    boolean withinBounds(List<Type> tvars, List<Type> arguments) {
        List<Type> tvs = tvars;
        List<Type> args = arguments;
        while (tvs.nonEmpty()) {
            if (!args.getFirst().isSubType(tvs.getFirst().bound().substitute(tvars, arguments))) {
                return false;
            }
            tvs = tvs.getRest();
            args = args.getRest();
        }
        return true;
    }

    void checkSafe(int pos, Type t, Symbol sym) {
        if (t.occurrencesCount(Type.ALL_TYPE) >= 2) {
            Type template = sym.type;
            if ((template.tag & 0xF) != 0) {
                template = template.returnType();
            }
            this.checkSafe(pos, sym, t, template, Type.EMPTY_LIST);
        }
    }

    private List<Type> checkSafe(int pos, Symbol sym, Type t, Type template, List<Type> tvars) {
        if (tvars == null) {
            return null;
        }
        switch (template.tag) {
            case 14: {
                if (t.occurrencesCount(Type.ALL_TYPE) > 0) {
                    List<Type> l = tvars;
                    while (l.nonEmpty()) {
                        if (l.getFirst() == template) {
                            this.errorLog.error(pos, new StringBuffer().append("type variable ").append(template).append(" occurs more than once in ").append(sym.kind == 16 ? "result " : "").append("type of ").append(sym).append("; cannot be left uninstantiated").toString());
                            return null;
                        }
                        l = l.getRest();
                    }
                    return tvars.cons(template);
                }
                return tvars;
            }
            case 10: {
                return this.checkSafe(pos, sym, t.enclosingType(), template.enclosingType(), this.checkSafe(pos, sym, t.getTypeParams(), template.getTypeParams(), tvars));
            }
            case 11: {
                return this.checkSafe(pos, sym, t.elementType(), template.elementType(), tvars);
            }
        }
        return tvars;
    }

    private List<Type> checkSafe(int pos, Symbol sym, List<Type> ts, List<Type> templates, List<Type> tvars) {
        List<Type> l = ts;
        List<Type> k = templates;
        while (l.nonEmpty()) {
            tvars = this.checkSafe(pos, sym, l.getFirst(), k.getFirst(), tvars);
            l = l.getRest();
            k = k.getRest();
        }
        return tvars;
    }

    static class Constraint {
        static final int FAIL = -1;
        static final int EMPTY = 0;
        static final int SUB = 1;
        static final int GEN = 2;
        int kind;
        Type lo;
        Type hi;
        Constraint rest;
        static final Constraint EMPTY_CONSTRAINT = new Constraint(0, null, null, null);
        static final Constraint FAIL_CONSTRAINT = new Constraint(-1, null, null, null);
        static String cause;
        static Object arg1;
        static Object arg2;

        public String toString() {
            switch (this.kind) {
                case -1: {
                    return "<fail>";
                }
                case 0: {
                    return "true";
                }
                case 1: {
                    return this.lo + " < " + this.hi + ", " + this.rest;
                }
                case 2: {
                    return this.lo + " = " + this.hi + ", " + this.rest;
                }
            }
            return "?";
        }

        Constraint(int kind, Type lo, Type hi, Constraint rest) {
            this.lo = lo;
            this.hi = hi;
            this.kind = kind;
            this.rest = rest;
        }

        Constraint addSub(Type lo, Type hi) {
            if (this.kind == 0) {
                return new Constraint(1, lo, hi, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == hi) {
                if (lo.isSubType(this.lo)) {
                    return this;
                }
                return Constraint.failure("% is not a subtype of %", lo, this.lo);
            }
            Constraint rest1 = this.rest.addSub(lo, hi);
            if (this.rest == rest1) {
                return this;
            }
            if (rest1.kind == -1) {
                return rest1;
            }
            return new Constraint(this.kind, this.lo, this.hi, rest1);
        }

        Constraint addEq(Type lo, Type hi) {
            if (this.kind == 0) {
                return new Constraint(2, lo, hi, this);
            }
            if (this.kind == -1) {
                return this;
            }
            if (this.kind == 2 && this.hi == hi) {
                if (this.lo.isSameType(lo)) {
                    return this;
                }
                return Constraint.failure("% is different from %", this.lo, lo);
            }
            if (this.kind == 1 && this.hi == hi) {
                if (this.lo.isSubType(lo)) {
                    return this.rest.addEq(lo, hi);
                }
                return Constraint.failure("% is not a subtype of %", this.lo, lo);
            }
            Constraint rest1 = this.rest.addEq(lo, hi);
            if (this.rest == rest1) {
                return this;
            }
            if (rest1.kind == -1) {
                return rest1;
            }
            return new Constraint(this.kind, this.lo, this.hi, rest1);
        }

        static Constraint failure(String cause, Object arg1, Object arg2) {
            Constraint.cause = cause;
            Constraint.arg1 = arg1;
            Constraint.arg2 = arg2;
            return FAIL_CONSTRAINT;
        }
    }
}

