/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Symbol;
import edu.rice.cs.nextgen.compiler.code.Type;
import edu.rice.cs.nextgen.compiler.comp.SymbolTable;
import edu.rice.cs.nextgen.compiler.flatten.SnippetClosure;
import edu.rice.cs.nextgen.compiler.flatten.TypeFlattener;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.ErrorLog;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.ListBox;
import edu.rice.cs.nextgen.compiler.util.ListIterator;

public class SnippetPatcher
implements Flags {
    ErrorLog errorLog;
    SymbolTable symbolTable;
    TypeFlattener typeFlattener;

    public SnippetPatcher(ErrorLog log, SymbolTable syms, TypeFlattener flat) {
        this.errorLog = log;
        this.symbolTable = syms;
        this.typeFlattener = flat;
    }

    public void patch() {
        ListIterator<Tree.ClassDef> classes = this.typeFlattener.getParamClasses().iterator();
        while (classes.hasNext()) {
            this.patchClass(classes.next());
        }
    }

    public void flattenSupertypes() {
        ListIterator<Tree.ClassDef> classes = this.typeFlattener.getUnflattenedClasses().iterator();
        while (classes.hasNext()) {
            this.flattenSupertype(classes.next());
        }
    }

    private void patchClass(Tree.ClassDef cdef) {
        Symbol.ClassSymbol classSym = cdef.classSymbol;
        Tree.ClassDef templateClass = classSym.getTemplateClass();
        if (templateClass == null) {
            throw new InternalError("Parameterized class " + classSym + " has no template class");
        }
        Symbol.ClassSymbol templateClassSym = templateClass.classSymbol;
        List<SnippetClosure> snipClosures = classSym.getSnipClosures();
        ListBox<Tree> snippets = new ListBox<Tree>();
        List<SnippetClosure> scs = snipClosures;
        while (!scs.isEmpty()) {
            SnippetClosure sc = scs.getFirst();
            Tree.MethodDef snippet = sc.genSnippet(templateClassSym);
            snippets.insertEnd(snippet);
            scs = scs.getRest();
        }
        snippets.insertEltsEnd(templateClass.members);
        templateClass.members = snippets.toList();
    }

    private void flattenSupertype(Tree.ClassDef tree) {
        Type.ClassType classType = (Type.ClassType)tree.type;
        Type supertype = classType.getSuperType();
        classType.parentType = supertype.flatten();
    }
}

