/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.nextgen.compiler.flatten;

import edu.rice.cs.nextgen.compiler.code.Flags;
import edu.rice.cs.nextgen.compiler.code.Kinds;
import edu.rice.cs.nextgen.compiler.code.TypeTags;
import edu.rice.cs.nextgen.compiler.comp.Environment;
import edu.rice.cs.nextgen.compiler.comp.VoidContext;
import edu.rice.cs.nextgen.compiler.tree.Tree;
import edu.rice.cs.nextgen.compiler.util.List;
import edu.rice.cs.nextgen.compiler.util.Name;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TargetFixer
extends Tree.Visitor<VoidContext, Environment<VoidContext>>
implements Flags,
Kinds,
TypeTags {
    public static Tree.Visitor<VoidContext, Environment<VoidContext>> ONLY = new TargetFixer();

    private TargetFixer() {
    }

    void fixTargets(List<Tree> trees, Environment<VoidContext> env) {
        List<Tree> l = trees;
        while (l.nonEmpty()) {
            l.getFirst().accept(this, env);
            l = l.getRest();
        }
    }

    Environment<VoidContext> newMethodEnv(Tree.MethodDef tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = env.spawn(tree);
        localEnv.enclosingMethod = tree;
        return localEnv;
    }

    Environment<VoidContext> newClassEnv(Tree.ClassDef tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = env.spawn(tree);
        localEnv.enclosingClass = tree;
        localEnv.enclosingClassEnv = env;
        return localEnv;
    }

    @Override
    public VoidContext _case(Tree.ClassDef tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = this.newClassEnv(tree, env);
        this.fixTargets(tree.members, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.MethodDef tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = this.newMethodEnv(tree, env);
        if (tree.body != null) {
            tree.body.accept(this, localEnv);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.VarDef tree, Environment<VoidContext> env) {
        if (tree.initialization != null) {
            tree.initialization.accept(this, env);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Block tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = env.spawn(tree);
        this.fixTargets(tree.statements, localEnv);
        return null;
    }

    @Override
    public VoidContext _case(Tree.DoLoop tree, Environment<VoidContext> env) {
        Environment<VoidContext> loopEnv = env.spawn(tree);
        tree.body.accept(this, loopEnv);
        tree.cond.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.WhileLoop tree, Environment<VoidContext> env) {
        tree.condition.accept(this, env);
        Environment<VoidContext> loopEnv = env.spawn(tree);
        tree.body.accept(this, loopEnv);
        return null;
    }

    @Override
    public VoidContext _case(Tree.ForLoop tree, Environment<VoidContext> env) {
        this.fixTargets(tree.initializations, env);
        if (tree.conditions != null) {
            tree.conditions.accept(this, env);
        }
        Environment<VoidContext> loopEnv = env.spawn(tree);
        this.fixTargets(tree.incrementations, loopEnv);
        tree.body.accept(this, loopEnv);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Labelled tree, Environment<VoidContext> env) {
        Environment<VoidContext> localEnv = env.spawn(tree);
        tree.body.accept(this, localEnv);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Switch tree, Environment<VoidContext> env) {
        tree.selector.accept(this, env);
        Environment<VoidContext> switchEnv = env.spawn(tree);
        List<Tree.Case> l = tree.cases;
        while (l.nonEmpty()) {
            Tree.Case c = l.getFirst();
            this.fixTargets(c.statements, switchEnv);
            l = l.getRest();
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Synchronized tree, Environment<VoidContext> env) {
        tree.lockedObject.accept(this, env);
        tree.body.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Try tree, Environment<VoidContext> env) {
        Environment<VoidContext> tryEnv = env.spawn(tree);
        List<Tree.Catch> l = tree.catchers;
        while (l.nonEmpty()) {
            Tree.Catch c = l.getFirst();
            Environment<VoidContext> catchEnv = env.spawn(c);
            c.body.accept(this, catchEnv);
            l = l.getRest();
        }
        tree.body.accept(this, tryEnv);
        if (tree.finalizer != null) {
            tree.finalizer.accept(this, env);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Conditional tree, Environment<VoidContext> env) {
        tree.condition.accept(this, env);
        tree.thenClause.accept(this, env);
        if (tree.elseClause != null) {
            tree.elseClause.accept(this, env);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.ExpressionStatement tree, Environment<VoidContext> env) {
        tree.expression.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Break tree, Environment<VoidContext> env) {
        tree.target = this.findJumpTarget(tree.sourcePosition, tree.tag, tree.label, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Continue tree, Environment<VoidContext> env) {
        tree.target = this.findJumpTarget(tree.sourcePosition, tree.tag, tree.label, env);
        return null;
    }

    private Tree findJumpTarget(int pos, int tag, Name label, Environment<VoidContext> env) {
        Environment<VoidContext> env1 = env;
        while (env1 != null) {
            switch (env1.tree.tag) {
                case 10: {
                    Tree.Labelled labelled = (Tree.Labelled)env1.tree;
                    if (label != labelled.label) break;
                    Tree target = labelled.body;
                    while (target.tag == 10) {
                        target = ((Tree.Labelled)target).body;
                    }
                    return target;
                }
                case 7: 
                case 8: 
                case 9: {
                    if (label != null) break;
                    return env1.tree;
                }
                case 11: {
                    if (label != null || tag != 19) break;
                    return env1.tree;
                }
            }
            env1 = env1.enclosingEnv;
        }
        throw new InternalError(new StringBuffer().append("Target of statement with tag ").append(tag).append(" and label ").append(label).append(" not found in env ").append(env).toString());
    }

    @Override
    public VoidContext _case(Tree.Return tree, Environment<VoidContext> env) {
        if (tree.expression != null) {
            tree.expression.accept(this, env);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Throw tree, Environment<VoidContext> env) {
        tree.expression.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Apply tree, Environment<VoidContext> env) {
        this.fixTargets(tree.args, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.NewInstance tree, Environment<VoidContext> env) {
        this.fixTargets(tree.args, env);
        Tree.ClassDef cdef = tree.anonymousClassDef;
        if (cdef != null) {
            Environment<VoidContext> localEnv = env.spawn(tree);
            cdef.accept(this, localEnv);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.NewArray tree, Environment<VoidContext> env) {
        if (tree.dimensions != null) {
            this.fixTargets(tree.dimensions, env);
        }
        if (tree.elements != null) {
            this.fixTargets(tree.elements, env);
        }
        return null;
    }

    @Override
    public VoidContext _case(Tree.Assign tree, Environment<VoidContext> env) {
        tree.lhs.accept(this, env);
        tree.rhs.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.AssignOp tree, Environment<VoidContext> env) {
        tree.lhs.accept(this, env);
        tree.rhs.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Operation tree, Environment<VoidContext> env) {
        this.fixTargets(tree.args, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.TypeCast tree, Environment<VoidContext> env) {
        tree.expression.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.InstanceofTest tree, Environment<VoidContext> env) {
        tree.expression.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.IndexedArrayElement tree, Environment<VoidContext> env) {
        tree.index.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Ident tree, Environment<VoidContext> env) {
        return null;
    }

    @Override
    public VoidContext _case(Tree.Select tree, Environment<VoidContext> env) {
        tree.selected.accept(this, env);
        return null;
    }

    @Override
    public VoidContext _case(Tree.Literal tree, Environment<VoidContext> env) {
        return null;
    }

    @Override
    public VoidContext _case(Tree tree, Environment<VoidContext> env) {
        throw new InternalError(new StringBuffer().append("Missing case for ").append(tree.getClass()).append(" in FixTargets").toString());
    }

    @Override
    public /* synthetic */ Object _case(Tree x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Erroneous x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeParameter x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeApply x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.ArrayTypeExpression x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeIdent x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Literal x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Ident x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Select x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.IndexedArrayElement x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.InstanceofTest x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.TypeCast x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Operation x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.AssignOp x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Assign x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewArray x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.NewInstance x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Apply x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Throw x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Return x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Continue x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Break x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ExpressionStatement x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Conditional x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Catch x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Try x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Synchronized x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Case x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.Switch x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Labelled x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ForLoop x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.WhileLoop x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.DoLoop x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Block x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.VarDef x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.MethodDef x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.ClassDef x0, Object x1) {
        return this._case(x0, (Environment<VoidContext>)((Environment)x1));
    }

    @Override
    public /* synthetic */ Object _case(Tree.Import x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }

    @Override
    public /* synthetic */ Object _case(Tree.TopLevel x0, Object x1) {
        return super._case(x0, (Environment)x1);
    }
}

